/*
 * Decompiled with CFR 0.152.
 */
package sumo.v3d;

import java.nio.FloatBuffer;
import java.util.ArrayList;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.glu.GLU;
import sumo.opengl.FBO;
import sumo.opengl.FBOManager;
import sumo.project.Project;
import sumo.resource.types.Texture;
import sumo.v3d.Camera;
import sumo.v3d.Light;
import sumo.v3d.Node;
import sumo.v3d.Scene;
import sumo.v3d.material.Material;
import sumo.v3d.math.Vec3f;

public class Shadow {
    static FloatBuffer matrixModelView;
    static FloatBuffer matrixProjection;
    static FloatBuffer matrixCameraInverse;
    public Vec3f lightTarget = new Vec3f();
    static FBO shadowfFBO;
    public static Texture shadowTexture;
    public static int SHADOW_WIDTH;
    public static int SHADOW_HEIGHT;
    public float polyOffsetUnits = 2.0f;
    public float polyOffsetFactor = 1.0f;
    float[] mBias = new float[]{0.5f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f, 0.0f, 0.5f, 0.5f, 0.5f, 1.0f};
    FloatBuffer fbBias = null;

    public Shadow(Scene scene) {
        if (shadowTexture == null) {
            shadowTexture = new Texture("", SHADOW_WIDTH, SHADOW_HEIGHT, false, true);
            shadowfFBO = new FBO(null, shadowTexture, 2);
        }
        ArrayList<Material> mats = scene.getMaterials();
        for (Material material : mats) {
            material.settings.shadowMap = shadowTexture;
        }
    }

    public void renderShadow(Scene scene, Node rootnode, float time, Camera cam) {
        FBOManager.bind(shadowfFBO);
        this.storeLightMatrices(scene);
        GL11.glClear(16640);
        GL11.glLoadIdentity();
        GL11.glViewport(0, 0, SHADOW_WIDTH, SHADOW_HEIGHT);
        GL11.glMatrixMode(5889);
        GL11.glPushMatrix();
        GLU.gluPerspective(90.0f, 1.0f, -1000.0f, 99999.0f);
        GL11.glLoadMatrix(matrixProjection);
        GL11.glMatrixMode(5888);
        GL11.glLoadMatrix(matrixModelView);
        GL11.glColorMask(false, false, false, false);
        GL11.glPolygonOffset(this.polyOffsetFactor, this.polyOffsetUnits);
        GL11.glEnable(32823);
        scene.getCam().setEnabled(false);
        cam.setEnabled(false);
        Material.enableMaterials = false;
        rootnode.render(time);
        Material.enableMaterials = true;
        scene.getCam().setEnabled(true);
        FBOManager.unbind();
        GL11.glColorMask(true, true, true, true);
        GL11.glDisable(32823);
        if (FBOManager.isFBOBound()) {
            GL11.glViewport(0, 0, FBOManager.getCurrentFBO().getWidth(), FBOManager.getCurrentFBO().getHeight());
        } else {
            GL11.glViewport(0, 0, Project.getProject().getOpenGLSsettings().getWidth(), Project.getProject().getOpenGLSsettings().getHeight());
        }
        GL11.glMatrixMode(5889);
        GL11.glPopMatrix();
        GL11.glMatrixMode(5888);
        GL11.glClear(256);
        GL11.glLoadIdentity();
        cam.gluLookAt(time);
        matrixCameraInverse = cam.getInverseMatrix(time);
        this.applyShadowMap(rootnode, time);
    }

    public void storeLightMatrices(Scene scene) {
        if (matrixModelView == null) {
            matrixModelView = BufferUtils.createFloatBuffer(16);
            matrixModelView.put(new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}).rewind();
            matrixProjection = BufferUtils.createFloatBuffer(16);
            matrixProjection.put(new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}).rewind();
        }
        GL11.glPushMatrix();
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        Light l = scene.getLight();
        GLU.gluLookAt(l.pos.get(0), l.pos.get(1), l.pos.get(2), this.lightTarget.x, this.lightTarget.y, this.lightTarget.z, 0.0f, 0.0f, 1.0f);
        GL11.glGetFloat(2982, matrixModelView);
        GL11.glPopMatrix();
        GL11.glLoadIdentity();
        Camera cam = scene.getCam(scene.getCamNum());
        GLU.gluPerspective(cam.fov, 1.0f, cam.znear, cam.zfar);
        GL11.glGetFloat(2982, matrixProjection);
        GL11.glPopMatrix();
    }

    void applyShadowMap(Node rootnode, float time) {
        GL11.glEnable(3553);
        GL11.glBindTexture(3553, shadowTexture.getID());
        GL11.glTexParameteri(3553, 34892, 34894);
        GL11.glTexParameteri(3553, 34893, 515);
        if (this.fbBias == null) {
            this.fbBias = BufferUtils.createFloatBuffer(16);
            this.fbBias.put(this.mBias).rewind();
        }
        GL11.glMatrixMode(5890);
        GL11.glLoadMatrix(this.fbBias);
        GL11.glMultMatrix(matrixProjection);
        GL11.glMultMatrix(matrixModelView);
        GL11.glMultMatrix(matrixCameraInverse);
        GL11.glMatrixMode(5888);
        rootnode.render(time);
        GL11.glMatrixMode(5890);
        GL11.glLoadIdentity();
        GL11.glMatrixMode(5888);
    }

    static {
        shadowfFBO = null;
        shadowTexture = null;
        SHADOW_WIDTH = 1024;
        SHADOW_HEIGHT = 1024;
    }
}

