/*
 * Decompiled with CFR 0.152.
 */
package sumo.v3d.loader;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import sumo.logger.Logger;
import sumo.util.stopwatch;
import sumo.v3d.Camera;
import sumo.v3d.Light;
import sumo.v3d.Scene;
import sumo.v3d.material.Material;
import sumo.v3d.math.Vec1i;
import sumo.v3d.math.Vec3f;
import sumo.v3d.math.Vec4s;
import sumo.v3d.mesh.Mesh;
import sumo.v3d.mesh.MeshObject;

public class OBJLoader {
    public Scene load(String path, String filename) {
        stopwatch timer = new stopwatch("obj loading time");
        Scene myscene = new Scene();
        try {
            int i;
            File file = new File(path + filename);
            BufferedReader br = new BufferedReader(new FileReader(file));
            String s = "";
            ArrayList<Vec3f> vertices = new ArrayList<Vec3f>();
            ArrayList<Vec4s> faces = new ArrayList<Vec4s>();
            vertices.add(new Vec3f(0.0f, 0.0f, 0.0f));
            while ((s = br.readLine()) != null) {
                String[] ss = s.split(" ");
                if (ss.length <= 0) continue;
                if (ss[0].equals("v")) {
                    vertices.add(new Vec3f(Float.parseFloat(ss[1]), Float.parseFloat(ss[2]), Float.parseFloat(ss[3])));
                    continue;
                }
                if (ss[0].equals("f")) {
                    if (ss[1].contains("/")) {
                        String[] sss1 = ss[1].split("/");
                        String[] sss2 = ss[2].split("/");
                        String[] sss3 = ss[3].split("/");
                        String[] sss4 = ss[4].split("/");
                        faces.add(new Vec4s(1, Short.parseShort(sss3[0]), Short.parseShort(sss2[0]), Short.parseShort(sss1[0])));
                        faces.add(new Vec4s(1, Short.parseShort(sss1[0]), Short.parseShort(sss4[0]), Short.parseShort(sss3[0])));
                        continue;
                    }
                    faces.add(new Vec4s(1, Short.parseShort(ss[1]), Short.parseShort(ss[2]), Short.parseShort(ss[3])));
                    continue;
                }
                System.out.println("unknown");
            }
            Vec3f max = new Vec3f();
            Mesh m = new Mesh();
            float[] f = new float[vertices.size() * 3];
            for (int i2 = 0; i2 < f.length / 3; ++i2) {
                if (Math.abs(((Vec3f)vertices.get((int)i2)).x) > max.x) {
                    max.x = ((Vec3f)vertices.get((int)i2)).x;
                }
                if (Math.abs(((Vec3f)vertices.get((int)i2)).y) > max.y) {
                    max.y = ((Vec3f)vertices.get((int)i2)).y;
                }
                if (Math.abs(((Vec3f)vertices.get((int)i2)).z) > max.z) {
                    max.z = ((Vec3f)vertices.get((int)i2)).z;
                }
                f[i2 * 3] = ((Vec3f)vertices.get((int)i2)).x;
                f[i2 * 3 + 1] = ((Vec3f)vertices.get((int)i2)).y;
                f[i2 * 3 + 2] = ((Vec3f)vertices.get((int)i2)).z * -1.0f;
            }
            m.setVertices(f);
            System.out.println(vertices.size() + " verts");
            System.out.println(faces.size() + " faces");
            short[] fa = new short[faces.size() * 4];
            for (i = 0; i < faces.size(); ++i) {
                fa[i * 4 + 0] = 1;
                fa[i * 4 + 1] = ((Vec4s)faces.get((int)i)).x;
                fa[i * 4 + 2] = ((Vec4s)faces.get((int)i)).y;
                fa[i * 4 + 3] = ((Vec4s)faces.get((int)i)).z;
            }
            m.setFaces(fa);
            for (i = 0; i < fa.length; ++i) {
                System.out.println(fa[i] + "");
            }
            m.calcNormals();
            MeshObject tempMeshObject = new MeshObject();
            tempMeshObject.addMesh(m);
            myscene.rootnode.addChild(tempMeshObject);
            Camera c = new Camera();
            c.target.x.setValue(((Vec3f)vertices.get((int)0)).x);
            c.target.y.setValue(((Vec3f)vertices.get((int)0)).y);
            c.target.z.setValue(((Vec3f)vertices.get((int)0)).z);
            c.eye.x.setValue(max.x * 2.0f);
            c.eye.y.setValue(max.y * 2.0f);
            c.eye.z.setValue(max.z * 2.0f);
            myscene.rootnode.addChild(c);
            for (int i3 = 0; i3 < 10; ++i3) {
                c = new Camera();
                c.target.x.setValue(((Vec3f)vertices.get((int)0)).x);
                c.target.y.setValue(((Vec3f)vertices.get((int)0)).y);
                c.target.z.setValue(((Vec3f)vertices.get((int)0)).z);
                c.eye.x.setValue((float)Math.random() * max.x * 5.0f);
                c.eye.y.setValue((float)Math.random() * max.y * 5.0f);
                c.eye.z.setValue((float)Math.random() * max.z * 5.0f);
                myscene.rootnode.addChild(c);
            }
            Material ma = new Material();
            ma.id = 1;
            ma.settings.setDiffuse(new float[]{1.0f, 1.0f, 1.0f});
            ma.settings.setAmbient(new float[]{1.0f, 1.0f, 1.0f});
            ma.settings.setSpecular(new float[]{1.0f, 1.0f, 1.0f});
            ma.settings.wireframe = false;
            myscene.materials.add(ma);
            m.materialIDs = new ArrayList();
            m.materialIDs.add(new Vec1i(1));
            m.materials = myscene.materials;
            Light l = new Light();
            l.colorDiffuseFB.put(new float[]{1.0f, 1.0f, 1.0f}).rewind();
            l.pos.put(new float[]{max.x * 21.0f, max.y * 21.0f, max.z * 21.0f}).rewind();
            myscene.rootnode.addChild(l);
            myscene.rootnode.sortChilds();
        }
        catch (Exception e) {
            Logger.log(this.getClass(), e);
        }
        timer.stop();
        return myscene;
    }
}

