/*
 * Decompiled with CFR 0.152.
 */
package sumoTween;

import java.util.Vector;
import sumoTween.Tweener;
import sumoTween.easing.EasingIF;
import sumoTween.events.KeyEvent;

public class KeyFloat {
    private int easingDirection = 2;
    private Tweener tweener;
    private float value = 0.0f;
    private float internalValue = 0.0f;
    private float time = 0.0f;
    private EasingIF easing;
    Vector keyEventListeners = null;

    public String toString() {
        String s = "";
        s = s + this.time + ": " + this.value;
        s = s + this.easing.getClass().getSimpleName() + " (";
        if (this.easingDirection == -1) {
            s = s + "none";
        }
        if (this.easingDirection == 0) {
            s = s + "in";
        }
        if (this.easingDirection == 1) {
            s = s + "out";
        }
        if (this.easingDirection == 2) {
            s = s + "in&out";
        }
        if (this.easingDirection == 3) {
            s = s + "none";
        }
        s = s + ")";
        return s;
    }

    public KeyFloat(Tweener tweener, float time, float value, int dir) {
        this.tweener = tweener;
        this.easingDirection = dir;
        this.value = value;
        this.time = time;
    }

    public float getInternalValue() {
        return this.internalValue;
    }

    public float getTime() {
        return this.time;
    }

    public void setInternalValue(float value) {
        if (Float.isNaN(value)) {
            value = 0.0f;
        }
        this.internalValue = value;
    }

    public void setEasingDirection(int dir) {
        this.easingDirection = dir;
    }

    public int getEasingDirection() {
        return this.easingDirection;
    }

    public void notifyKeyEventListeners() {
        if (this.keyEventListeners != null) {
            for (int i = 0; i < this.keyEventListeners.size(); ++i) {
                KeyEvent ke = (KeyEvent)this.keyEventListeners.elementAt(i);
                ke.KeyEvent(this);
            }
        }
    }

    public void addKeyEventListener(KeyEvent ev) {
        if (ev == null) {
            return;
        }
        if (this.keyEventListeners == null) {
            this.keyEventListeners = new Vector();
        }
        this.keyEventListeners.addElement(ev);
        System.out.println("added " + this.keyEventListeners.size());
    }

    public boolean hasKeyEventListeners() {
        if (this.keyEventListeners == null) {
            return false;
        }
        return this.keyEventListeners.size() != 0;
    }

    public float getValue() {
        return this.value;
    }

    public void setValue(float value) {
        this.value = value;
    }

    public EasingIF getEasing() {
        return this.easing;
    }

    public void setEasing(EasingIF ease) {
        this.easing = ease;
    }

    public void setTime(float f) {
        this.tweener.sort();
        this.time = f;
        this.notifyKeyEventListeners();
    }

    public Tweener getParent() {
        return this.tweener;
    }

    public KeyFloat getCopy() {
        KeyFloat kf = new KeyFloat(this.tweener, this.time, this.internalValue, this.easingDirection);
        return kf;
    }
}

