/*
 * Decompiled with CFR 0.152.
 */
package sumo.app.updater;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Updater {
    String XMLurl = "http://tom.drastic.net/sumoupdate/";
    int newfiles = 0;
    int updatedFiles = 0;
    int okfiles = 0;
    int bytesWritten = 0;

    public static String generateHash(File file) throws NoSuchAlgorithmException, FileNotFoundException, IOException {
        MessageDigest md = MessageDigest.getInstance("SHA");
        String hash = "";
        byte[] data = new byte[(int)file.length()];
        FileInputStream fis = new FileInputStream(file);
        fis.read(data);
        fis.close();
        md.update(data);
        byte[] digest = md.digest();
        for (int i = 0; i < digest.length; ++i) {
            String hex = Integer.toHexString(digest[i]);
            if (hex.length() == 1) {
                hex = "0" + hex;
            }
            hex = hex.substring(hex.length() - 2);
            hash = hash + hex;
        }
        return hash;
    }

    public void downloadFile(String url, String filename) {
        try {
            int c;
            URL urlImage = new URL(url);
            InputStream in = urlImage.openStream();
            FileOutputStream fos = new FileOutputStream(filename);
            while ((c = in.read()) != -1) {
                ++this.bytesWritten;
                fos.write(c);
            }
            fos.close();
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(0);
        }
    }

    public String getHash(File f) {
        try {
            return Updater.generateHash(f);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public void readXMLDir(NodeList nl, String path) {
        for (int i = 0; i < nl.getLength(); ++i) {
            Element e = (Element)nl.item(i);
            if (e.getTagName().equals("dir")) {
                String p = path + e.getAttribute("name") + "/";
                System.out.println("-- " + p);
                this.readXMLDir(e.getChildNodes(), p);
                continue;
            }
            if (e.getTagName().equals("file")) {
                String absoluteFilename = path + e.getAttribute("filename");
                File f = new File(absoluteFilename);
                boolean updateFile = false;
                if (!f.exists()) {
                    System.out.print(absoluteFilename + " : NEW  ");
                    updateFile = true;
                    ++this.newfiles;
                } else {
                    String s = this.getHash(f);
                    if (!s.equals(e.getAttribute("sha1"))) {
                        System.out.print(absoluteFilename + " DIFFERENT ");
                        updateFile = true;
                        ++this.updatedFiles;
                    } else {
                        System.out.println(absoluteFilename + " OK");
                        ++this.okfiles;
                    }
                }
                if (!updateFile) continue;
                String p = this.XMLurl + "data/";
                File fp = new File(path);
                fp.mkdir();
                System.out.print("downloading...");
                this.downloadFile(p + absoluteFilename, absoluteFilename);
                System.out.println("OK");
                continue;
            }
            System.out.println("unknown tagname: " + e.getTagName());
        }
    }

    public Updater(String[] args) {
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            URL url = new URL(this.XMLurl);
            Document doc = docBuilder.parse(url.openStream());
            doc.getDocumentElement().normalize();
            Element d = doc.getDocumentElement();
            if (d == null) {
                System.out.println("NULL!!");
            }
            NodeList nl = d.getChildNodes();
            String path = "";
            String currenttype = doc.getDocumentElement().getAttribute("type");
            this.readXMLDir(nl, "");
            this.bytesWritten /= 1024;
            System.out.println("--------------------------------");
            System.out.println("finished update");
            System.out.println(this.okfiles + " ok files ");
            System.out.println(this.newfiles + " new files ");
            System.out.println(this.updatedFiles + " updated files ");
            System.out.println(this.bytesWritten + "k downloaded");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            Thread.sleep(10000L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

