/*
 * Decompiled with CFR 0.152.
 */
package sumo.audio;

import java.nio.FloatBuffer;
import java.util.HashMap;
import org.lwjgl.Sys;
import org.lwjgl.fmod3.FMOD;
import org.lwjgl.fmod3.FMODException;
import org.lwjgl.fmod3.FSound;
import org.lwjgl.fmod3.FSoundDSPUnit;
import org.lwjgl.fmod3.FSoundStream;
import sumo.audio.AudioSystem;
import sumo.logger.Logger;
import sumo.project.Project;
import sumo.resource.types.AudioFile;

public class AudioSysFMOD
implements AudioSystem {
    HashMap<Integer, FSoundStream> audioStreams = new HashMap();
    static int idCounter = 0;
    boolean inited = false;
    FloatBuffer spectrum = null;

    public void init() {
        try {
            FMOD.create();
        }
        catch (FMODException fmode) {
            Logger.log(this.getClass(), (Exception)((Object)fmode));
            System.exit(1);
        }
        System.out.println("Initializing FMOD");
        if (!FSound.FSOUND_Init((int)44100, (int)32, (int)0)) {
            System.out.println("Failed to initialize FMOD");
            System.out.println("Error: " + FMOD.FMOD_ErrorString((int)FSound.FSOUND_GetError()));
            System.exit(0);
        }
        System.out.println("FMOD init ok!");
        this.inited = true;
    }

    public int loadAudioFile(String filename) {
        if (!this.inited) {
            this.init();
        }
        FSoundStream stream = FSound.FSOUND_Stream_Open((String)filename, (int)0, (int)0, (int)0);
        int length = FSound.FSOUND_Stream_GetLengthMs((FSoundStream)stream);
        System.out.println("length:" + length);
        this.audioStreams.put(++idCounter, stream);
        return idCounter;
    }

    private FSoundStream getStream(AudioFile audioFile) {
        return this.audioStreams.get(audioFile.getID());
    }

    public float getTime(AudioFile audio) {
        FSoundStream stream = this.getStream(audio);
        if (stream != null) {
            return (float)FSound.FSOUND_Stream_GetTime((FSoundStream)stream) / 1000.0f;
        }
        return 0.0f;
    }

    public boolean isPlaying(AudioFile audio) {
        return audio.isPlaying;
    }

    public void pause(AudioFile audio) {
        FSoundStream stream = this.getStream(audio);
        if (stream != null) {
            FSound.FSOUND_Stream_Stop((FSoundStream)stream);
            audio.isPlaying = false;
            System.out.println("pause");
        }
    }

    public void play(AudioFile audio) {
        FSoundStream stream = this.getStream(audio);
        if (stream != null) {
            FSound.FSOUND_Stream_SetTime((FSoundStream)stream, (int)((int)(Project.getProject().getTime() * 1000.0f)));
            audio.starttime = Sys.getTime() - (long)(Project.getProject().getTime() * 1000.0f);
            FSound.FSOUND_DSP_SetActive((FSoundDSPUnit)FSound.FSOUND_DSP_GetFFTUnit(), (boolean)true);
            FSound.FSOUND_Stream_Play((int)0, (FSoundStream)stream);
            FSound.FSOUND_Stream_SetTime((FSoundStream)stream, (int)((int)(Project.getProject().getTime() * 1000.0f)));
            audio.isPlaying = true;
            System.out.println("play");
        }
    }

    public void setTime(AudioFile audio, float f) {
        FSoundStream stream = this.getStream(audio);
        if (stream != null) {
            FSound.FSOUND_Stream_SetTime((FSoundStream)stream, (int)((int)(f * 1000.0f)));
            audio.starttime = Sys.getTime() - (long)(f * 1000.0f);
        }
    }

    public String getName() {
        return "FMOD";
    }

    public FloatBuffer getFFT(AudioFile audio) {
        if (audio == null) {
            return FloatBuffer.allocate(1);
        }
        if (!audio.isPlaying) {
            return null;
        }
        if (!this.inited) {
            this.init();
        }
        FloatBuffer fb = FSound.FSOUND_DSP_GetSpectrum();
        return fb;
    }

    public void stop(AudioFile audioFile) {
        FSoundStream stream = this.getStream(audioFile);
        if (stream != null) {
            FSound.FSOUND_Stream_Stop((FSoundStream)stream);
        }
    }

    public void playSoundEffect(AudioFile audio, float f) {
        FSoundStream stream = this.getStream(audio);
        if (stream != null) {
            FSound.FSOUND_Stream_Stop((FSoundStream)stream);
            FSound.FSOUND_Stream_Play((int)audio.channel, (FSoundStream)stream);
            FSound.FSOUND_SetVolume((int)audio.channel, (int)((int)(255.0f * f)));
        }
    }

    public void close(AudioFile audio) {
        FSoundStream stream = this.getStream(audio);
        if (stream != null) {
            FSound.FSOUND_Stream_Close((FSoundStream)stream);
        }
    }

    public float getLengthSeconds(AudioFile audio) {
        FSoundStream stream = this.getStream(audio);
        if (stream != null) {
            return (float)FSound.FSOUND_Stream_GetLengthMs((FSoundStream)stream) / 1000.0f;
        }
        return 0.0f;
    }

    public void setFrequency(int i) {
        FSound.FSOUND_SetFrequency((int)0, (int)i);
        FSound.FSOUND_SetFrequency((int)1, (int)i);
    }
}

