/*
 * Decompiled with CFR 0.152.
 */
package sumo.gui;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import javax.swing.JPanel;
import org.lwjgl.opengl.GL11;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import sumo.app.guitest;
import sumo.gui.AbstractLine;
import sumo.gui.ScenePanel;
import sumo.gui.Settings;
import sumo.gui.detail.DebugDetail;
import sumo.gui.detail.Elements.PluginButton;
import sumo.gui.detail.KeyDetail;
import sumo.gui.dialogs.exceptionDialog;
import sumo.gui.lineTypeElements.guiBool;
import sumo.gui.lineTypeElements.guiFloat;
import sumo.gui.lineTypeElements.guiInt;
import sumo.gui.lineTypeElements.guiLineTypeIF;
import sumo.gui.lineTypeElements.guiResource;
import sumo.gui.lines.BasicLine;
import sumo.gui.lines.LineIF;
import sumo.gui.timing.KeyFramePanel;
import sumo.gui.timing.KeyFramePanelIF;
import sumo.keyframing.KeyBoolean;
import sumo.keyframing.KeyFramedIF;
import sumo.keyframing.KeyframedBoolean;
import sumo.keyframing.KeyframedResource;
import sumo.logger.Logger;
import sumo.math.vec2i;
import sumo.opengl.FBO;
import sumo.opengl.FBOManager;
import sumo.plugin.PluginConfig;
import sumo.plugin.PluginIF;
import sumo.project.Project;
import sumo.resource.resourceIF;
import sumo.resource.types.AudioFile;
import sumo.resource.types.sShader;
import sumo.resource.types.textureFile;
import sumo.resource.types.v3d;
import sumo.util.stopwatch;
import sumoTween.KeyFloat;
import sumoTween.Tweener;
import sumoTween.easing.None;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginPanel
extends JPanel
implements DropTargetListener {
    private vec2i markedStartPos = null;
    private vec2i markedEndPos = null;
    private ScenePanel sp;
    private ArrayList<AbstractLine> lines = new ArrayList();
    int pluginPos = 0;
    private boolean mousePressed = false;
    private boolean mouseDragging = false;
    protected int markedBaseLine = -1;
    DropTarget dt;
    int lastFramebuffer = -1;
    ArrayList<stopwatch> watches;
    stopwatch watch;
    stopwatch w;
    int currentFB = -1;
    public static boolean renderingPlugins = false;

    public ArrayList<AbstractLine> getAllLines() {
        return this.lines;
    }

    public PluginPanel(ScenePanel scenePanel) {
        this.setLayout(null);
        this.sp = scenePanel;
        this.dt = new DropTarget(this, this);
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D gd = (Graphics2D)g;
        gd.setColor(Settings.windowBackground);
        gd.fillRect(0, 0, this.getWidth(), this.getHeight());
        this.paintComponents(g);
    }

    public void rebuildPluginComponents() {
        this.removeAll();
        int posy = 0;
        for (AbstractLine line : this.lines) {
            if (line == null) {
                this.lines.remove(line);
            }
            posy = line.addToComponent(this, posy, 0);
        }
        this.repaint();
        int count = 0;
        for (AbstractLine line : this.lines) {
            line.drawableLine.getKeyFramePanel().setTempPosition(++count);
            this.addMouseMarkListener(line, count);
            for (AbstractLine c : line.childs) {
                this.addMouseMarkListener(c, ++count);
            }
        }
        if (Project.guimode) {
            guitest.selectScenePanel.repaint();
        }
    }

    private void addMouseMarkListener(AbstractLine c, int count) {
        if (!c.getHasMouseMarkListeners()) {
            c.drawableLine.getKeyFramePanel().setTempPosition(count);
            c.setHasMouseMarkListeners(true);
            c.drawableLine.getKeyFramePanel().addMouseMotionListener(new MouseMotionListener(){

                public void mouseMoved(MouseEvent e) {
                }

                public void mouseDragged(MouseEvent e) {
                    if (!KeyFramePanel.usingMouse) {
                        if (PluginPanel.this.markedEndPos == null) {
                            PluginPanel.this.sp.resetMarkedKeys();
                        }
                        PluginPanel.this.markedEndPos = new vec2i(e.getX(), e.getY());
                        KeyFramePanel.ignoreMouse = true;
                        PluginPanel.this.drawMark();
                    }
                }
            });
            c.drawableLine.getKeyFramePanel().addMouseListener(new MouseListener(){

                public void mouseClicked(MouseEvent e) {
                }

                public void mouseEntered(MouseEvent e) {
                }

                public void mouseExited(MouseEvent e) {
                }

                public void mouseReleased(MouseEvent e) {
                    PluginPanel.this.markedEndPos = null;
                    PluginPanel.this.markedStartPos = null;
                    KeyFramePanel.ignoreMouse = false;
                    PluginPanel.this.resetMark();
                    Project.getProject().setDetailPanel(new KeyDetail(((PluginPanel)PluginPanel.this).sp.markedKeys, PluginPanel.this.sp));
                }

                public void mousePressed(MouseEvent e) {
                    if (!KeyFramePanel.usingMouse) {
                        PluginPanel.this.markedBaseLine = ((KeyFramePanelIF)((Object)e.getComponent())).getTempPosition();
                        if (PluginPanel.this.markedStartPos == null) {
                            PluginPanel.this.markedStartPos = new vec2i(e.getX(), e.getY());
                        }
                    }
                }
            });
        }
    }

    public void parseChilds(PluginIF plugin, NodeList n, AbstractLine parent, PluginConfig cfg) {
        for (int i = 0; i < n.getLength(); ++i) {
            String title;
            Element e;
            Node no = n.item(i);
            if (no.getNodeName().equals("variablegroup")) {
                e = (Element)no;
                title = e.getAttribute("title");
                AbstractLine al = new AbstractLine(parent, this, plugin, 2, title, null);
                parent.childs.add(al);
                this.parseChilds(plugin, no.getChildNodes(), al, cfg);
            }
            if (!no.getNodeName().equals("variable")) continue;
            e = (Element)no;
            title = e.getAttribute("name");
            String defaultv = e.getAttribute("defaultValue");
            Object kf = plugin.getVariable(title);
            if (kf != null) {
                String allowi;
                Object kfi;
                JPanel f = null;
                if (kf instanceof Tweener) {
                    kfi = (Tweener)kf;
                    String defValue = e.getAttribute("defaultValue");
                    String enabledisable = e.getAttribute("enabledisable");
                    String enabled = e.getAttribute("enabled");
                    String isint = e.getAttribute("integer");
                    if (isint != null && isint.equals("true")) {
                        f = new guiInt((Tweener)kfi);
                        ((Tweener)kfi).setEasing(new None());
                    } else {
                        f = new guiFloat((Tweener)kfi);
                    }
                    if (defValue != null && !defValue.equals("")) {
                        f.getKeyframed().set(Float.parseFloat(defValue));
                    }
                    if (!enabledisable.equals("")) {
                        f.setEnableDisableSwitch(Boolean.parseBoolean(enabledisable));
                    }
                    if (!enabled.equals("")) {
                        f.getKeyframed().setEnabled(Boolean.parseBoolean(enabled));
                    }
                    ((Tweener)kfi).clear();
                } else if (kf instanceof KeyframedBoolean) {
                    kfi = (KeyframedBoolean)kf;
                    f = new guiBool((KeyframedBoolean)kfi);
                    if (defaultv != null && !defaultv.equals("")) {
                        ((KeyframedBoolean)kfi).setDefaultKey(new KeyBoolean(0.0f, Boolean.parseBoolean(defaultv), (KeyFramedIF)kfi));
                    }
                    ((KeyframedBoolean)kfi).clear();
                } else if (kf instanceof KeyframedResource) {
                    f = new guiResource((KeyframedResource)kf);
                }
                String defi = e.getAttribute("defaultInterpolation");
                if (defi != null && !defi.equals("") && f.getKeyframed() != null) {
                    f.getKeyframed().clear();
                }
                if ((allowi = e.getAttribute("defaultInterpolation")) == null || !allowi.equals("")) {
                    // empty if block
                }
                if (f != null && f.getKeyframed() != null) {
                    f.getKeyframed().setKeyframed(false);
                }
                if (f != null) {
                    AbstractLine al = new AbstractLine(parent, this, plugin, 0, title, (guiLineTypeIF)((Object)f));
                    f.setAbstractLine(al);
                    parent.childs.add(al);
                    continue;
                }
                Logger.log(this.getClass(), "VARIABLE UNKNOWN guilinetype!!!");
                continue;
            }
            AbstractLine al = new AbstractLine(parent, this, plugin, 2, "!error: " + title, null);
            parent.childs.add(al);
        }
    }

    public void addPluginAfter(AbstractLine old, PluginIF newplug) {
        int index = this.lines.indexOf(old);
        if (index < 0) {
            index = this.lines.indexOf(old.parent);
            if (old.parent == null) {
                System.out.println("PARENT IS NULL!!!!!!!!!!!!!!");
            }
        }
        if (index < 0) {
            index = 0;
        }
        this.addPlugin(newplug, index);
    }

    public void addPlugin(PluginIF plugin) {
        int pos = this.lines.size();
        if (pos < 0) {
            pos = 0;
        }
        this.addPlugin(plugin, pos);
    }

    public void addPlugin(PluginIF plugin, int pos) {
        try {
            NodeList n;
            plugin.init();
            AbstractLine newline = new AbstractLine(null, this, plugin, 1, plugin.getConfig().getName(), null);
            this.lines.add(pos, newline);
            newline.isMinimized = plugin.isMinimized();
            plugin.setAbstractLine(newline);
            if (plugin.getConfig().xml.getElementsByTagName("variables").getLength() != 0) {
                n = plugin.getConfig().xml.getElementsByTagName("variables").item(0).getChildNodes();
                this.parseChilds(plugin, n, newline, plugin.getConfig());
            }
            if (plugin.getConfig().xml.getElementsByTagName("detail").getLength() != 0 && (n = plugin.getConfig().xml.getElementsByTagName("detail").item(0).getChildNodes()).getLength() > 0) {
                for (int i = 0; i < n.getLength(); ++i) {
                    Node no = n.item(i);
                    PluginButton but = new PluginButton();
                    if (no != null && no.getAttributes() != null) {
                        for (int j = 0; j < no.getAttributes().getLength(); ++j) {
                            if (!no.getAttributes().item(j).getNodeName().equals("name")) continue;
                            but.setName(no.getAttributes().item(j).getNodeValue());
                        }
                    }
                    plugin.addPluginButton(but);
                }
            }
            this.rebuildPluginComponents();
        }
        catch (Exception e) {
            new exceptionDialog(e);
        }
    }

    public ScenePanel getScenePanel() {
        return this.sp;
    }

    public void renderPluginsGL() {
        textureFile.disable();
        renderingPlugins = true;
        if (DebugDetail.doDebug) {
            Project.getProject();
            if (Project.guimode) {
                DebugDetail.checkGLError("pluginpanel before all lines");
            }
            this.w = new stopwatch("all");
            this.watches = new ArrayList();
        }
        int count = 0;
        for (AbstractLine line : this.lines) {
            GL11.glClear((int)256);
            if (DebugDetail.doDebug) {
                this.watch = new stopwatch(line.plugin.getName());
                this.watches.add(this.watch);
            }
            ++count;
            if (line.plugin.isVisible()) {
                if (line.plugin.hasEffects()) {
                    this.currentFB = 0;
                    FBOManager.bind(FBO.FBOs[0]);
                    GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    GL11.glClear((int)16640);
                }
                FBOManager.glViewport();
                line.renderGL();
                if (line.plugin.hasEffects()) {
                    this.currentFB = -1;
                    FBOManager.unbind();
                    FBOManager.glViewport();
                    line.plugin.renderShaderEffects(FBO.FBOs[0]);
                }
            }
            if (!DebugDetail.doDebug) continue;
            this.watch.stop();
        }
        if (this.currentFB != -1) {
            FBOManager.unbind();
        }
        if (DebugDetail.doDebug) {
            this.w.stop();
            this.watches.add(this.w);
            Project.getProject();
            if (Project.guimode) {
                DebugDetail.setWatches(this.watches);
            }
            Project.getProject();
            if (Project.guimode) {
                DebugDetail.checkGLError("");
            }
        }
        FBOManager.glViewport();
        textureFile.disable();
        renderingPlugins = false;
    }

    public void repaintTimingsChilds(AbstractLine line) {
        if (line.hasChilds()) {
            for (AbstractLine child : line.childs) {
                child.drawableLine.getKeyFramePanel().repaint();
                child.drawableLine.repaintValueController();
                this.repaintTimingsChilds(child);
            }
        }
    }

    public void repaintTimings() {
        for (AbstractLine line : this.lines) {
            line.drawableLine.getKeyFramePanel().repaint();
            if (line.isMinimized) continue;
            this.repaintTimingsChilds(line);
        }
    }

    public void repaintValueControllersChilds(AbstractLine line) {
        if (line.hasChilds()) {
            for (AbstractLine child : line.childs) {
                if (child.drawableLine.getValueControler() != null) {
                    child.drawableLine.getValueControler().getComponent().repaint();
                }
                this.repaintTimingsChilds(child);
            }
        }
    }

    public void repaintValueControllers() {
        for (AbstractLine line : this.lines) {
            if (line.drawableLine.getValueControler() != null) {
                line.drawableLine.getValueControler().getComponent().repaint();
            }
            if (line.isMinimized) continue;
            this.repaintValueControllersChilds(line);
        }
    }

    public void removeLine(AbstractLine al) {
        this.lines.remove(al);
        this.rebuildPluginComponents();
    }

    public void modeLineDown(AbstractLine l) {
        int p = this.lines.indexOf(l);
        if (p + 1 < this.lines.size()) {
            this.lines.remove(l);
            this.lines.add(++p, l);
            this.rebuildPluginComponents();
        }
    }

    public void modeLineUp(AbstractLine l) {
        int p = this.lines.indexOf(l);
        if (p - 1 >= 0) {
            this.lines.remove(l);
            this.lines.add(--p, l);
        }
        this.rebuildPluginComponents();
    }

    public void resetMark() {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            ((LineIF)((Object)this.getComponent(i))).getKeyFramePanel().resetMarkedArea();
        }
    }

    public void drawMark() {
        int i;
        if (this.markedStartPos == null) {
            return;
        }
        boolean found = false;
        int posy = 0;
        for (i = 0; i < this.getComponentCount(); ++i) {
            KeyFramePanelIF f = ((LineIF)((Object)this.getComponent(i))).getKeyFramePanel();
            if (!found) {
                posy += f.getHeight();
                if (f.getTempPosition() == this.markedBaseLine && !found) {
                    found = true;
                }
            }
            ((LineIF)((Object)this.getComponent(i))).getKeyFramePanel().resetMarkedArea();
        }
        for (i = 0; i < this.getComponentCount(); ++i) {
            if (this.getComponent((int)i).getBounds().y > posy - 34 && this.getComponent((int)i).getBounds().y + 25 <= this.markedEndPos.getY() + posy) {
                ((LineIF)((Object)this.getComponent(i))).getKeyFramePanel().setMarkedArea(this.markedStartPos.getX(), 0, this.markedEndPos.getX() - this.markedStartPos.getX(), 19);
                continue;
            }
            ((LineIF)((Object)this.getComponent(i))).getKeyFramePanel().setMarkedArea(-1, 0, -1, 0);
        }
    }

    public void deleteMarkedKeys(ArrayList<KeyFloat> markedKeys) {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            LineIF l = (LineIF)((Object)this.getComponent(i));
            if (l.getValueControler() == null || l.getValueControler().getKeyframed() == null) continue;
            l.getValueControler().getKeyframed().deleteKeys(markedKeys);
        }
    }

    public int getNumLayers() {
        return this.lines.size();
    }

    public void save(Element root) {
        for (AbstractLine line : this.lines) {
            line.plugin.save(root);
        }
    }

    @Override
    public void dragEnter(DropTargetDragEvent arg0) {
    }

    @Override
    public void dragExit(DropTargetEvent arg0) {
    }

    @Override
    public void dragOver(DropTargetDragEvent arg0) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent arg0) {
    }

    @Override
    public void drop(DropTargetDropEvent ev) {
        try {
            Transferable tr = ev.getTransferable();
            if (tr.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                String data = (String)tr.getTransferData(DataFlavor.stringFlavor);
                Project.getProject();
                Project.setStatus("drag and drop: " + data);
                if (data.startsWith("resource:")) {
                    this.insertDroppedResource(data.split(":")[1]);
                } else if (data.startsWith("plugin:")) {
                    this.insertDroppedPlugin(data.split(":")[1], (int)ev.getLocation().getY());
                } else if (data.startsWith("moveplugin:")) {
                    this.movePlugin(Integer.valueOf(data.split(":")[1]), (int)ev.getLocation().getY());
                } else if (data.startsWith("effect:")) {
                    this.addEffect(data.split(":")[1], (int)ev.getLocation().getY());
                } else {
                    System.out.println("unknown dnd:" + data);
                }
            } else if (tr.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                Project.getProject().getResourceManager().importDragAndDrop(ev, tr);
            }
        }
        catch (Exception e) {
            new exceptionDialog(e);
        }
        System.out.println("drop!!!");
    }

    private void movePlugin(Integer index, int posy) {
        if (index == -1) {
            return;
        }
        AbstractLine al = this.sp.getAllLines().get(index);
        Component c = this.getComponentAt(new Point(10, posy));
        this.lines.remove(al);
        if (c instanceof BasicLine) {
            BasicLine line = (BasicLine)c;
            Project.getProject().getCurrentScene().addLayerAfter(line.getAbstractLine(), al.plugin);
        } else {
            this.lines.add(al);
        }
        this.rebuildPluginComponents();
    }

    private void addEffect(String effectId, int posy) {
        Component c = this.getComponentAt(new Point(10, posy));
        if (c instanceof BasicLine) {
            BasicLine line = (BasicLine)c;
            line.getAbstractLine().plugin.addEffect(Project.getProject().getEffectManager().getEffectConfigById(effectId));
        } else {
            Project.getProject();
            Project.setStatus("cannot add effect here...");
        }
        this.rebuildPluginComponents();
    }

    public void insertDroppedPlugin(String pluginname, int posy) {
        if (Project.getProject().getCurrentScene() == null) {
            System.out.println("scene null");
        } else {
            Component c = this.getComponentAt(new Point(10, posy));
            if (c instanceof PluginPanel) {
                Project.getProject().getCurrentScene().addLayer(Project.getProject().getPluginManager().getPluginInstance(pluginname));
            } else if (c instanceof BasicLine) {
                BasicLine line = (BasicLine)c;
                Project.getProject().getCurrentScene().addLayerAfter(line.getAbstractLine(), Project.getProject().getPluginManager().getPluginInstance(pluginname));
            }
        }
    }

    public void insertDroppedResource(String resourceFilename) {
        resourceIF r = Project.getProject().getResourceManager().getResourceByFileName(resourceFilename);
        if (r instanceof v3d) {
            String s = "sumo.plugins.v3dplayer.Main";
            PluginIF p = Project.getProject().getPluginManager().getPluginInstance(s);
            Project.getProject().getCurrentScene().addLayer(p);
            KeyframedResource kfr = (KeyframedResource)p.getVariable("scene");
            kfr.setResource(r);
        } else if (r instanceof AudioFile) {
            String s = "sumo.plugins.playSound.PlaySound";
            PluginIF p = Project.getProject().getPluginManager().getPluginInstance(s);
            Project.getProject().getCurrentScene().addLayer(p);
            KeyframedResource kfr = (KeyframedResource)p.getVariable("soundFile");
            kfr.setResource(r);
        } else if (r instanceof textureFile) {
            String s = "sumo.plugins.shaderBuilderExample.ShaderBuilderExample";
            PluginIF p = Project.getProject().getPluginManager().getPluginInstance(s);
            Project.getProject().getCurrentScene().addLayer(p);
            KeyframedResource kfr = (KeyframedResource)p.getVariable("rShader");
            sShader sh = new sShader();
            sh.load();
            sh.getSumoShader().addPart("texture");
            sh.setFilename("shader " + System.currentTimeMillis());
            kfr.setResource(sh);
            Project.getProject().getResourceManager().add(sh);
            kfr = (KeyframedResource)p.getVariable("image1");
            kfr.setResource(r);
            Tweener show = (Tweener)p.getVariable("show");
            show.set(1.0f);
        }
    }
}

