/*
 * Decompiled with CFR 0.152.
 */
package sumo.gui.detail.Elements;

import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JPanel;
import sumo.gui.Settings;
import sumo.gui.detail.DetailIF;
import sumo.gui.detail.Elements.DetailButton;
import sumo.gui.detail.Elements.DetailLabel;

public class Area
extends JPanel {
    ArrayList<JComponent> content = new ArrayList();
    private String title = "no title";
    private boolean needsReOrder = false;
    public static int LAYOUT_ONE = 0;
    public static int LAYOUT_TWO = 1;
    public static int LAYOUT_FREE = 2;
    int layout = 0;
    static final int TITLEHEIGHT = 19;
    boolean mouseOverTitle = false;
    boolean minimized = false;
    private int areaHeight = 19;
    DetailIF parent;
    int myHeight = -1;

    public Area(String title, DetailIF _parent, int layout) {
        this.parent = _parent;
        this.layout = layout;
        this.title = title;
        this.addMouseMotionListener(new MouseMotionListener(){

            public void mouseMoved(MouseEvent e) {
                Area.this.mouseOverTitle = e.getY() < 19;
                Area.this.repaint();
            }

            public void mouseDragged(MouseEvent arg0) {
            }
        });
        this.addMouseListener(new MouseListener(){

            public void mouseReleased(MouseEvent arg0) {
            }

            public void mousePressed(MouseEvent arg0) {
            }

            public void mouseExited(MouseEvent arg0) {
                Area.this.mouseOverTitle = false;
                Area.this.repaint();
            }

            public void mouseEntered(MouseEvent arg0) {
            }

            public void mouseClicked(MouseEvent e) {
                if (e.getY() < 19) {
                    Area.this.minimized = !Area.this.minimized;
                    Area.this.reOrder();
                    Area.this.repaint();
                    Area.this.parent.reposition();
                }
            }
        });
    }

    public void paint(Graphics g) {
        if (this.needsReOrder) {
            this.reOrder();
        }
        g.setColor(Settings.SUMO2_DETAILBG);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.mouseOverTitle) {
            g.setColor(Settings.SUMO2_BRIGHTER);
            g.fillRect(0, 0, this.getWidth(), 19);
        }
        g.setFont(Settings.fontBold);
        g.setColor(Settings.SUMO2_BG);
        g.drawLine(0, 0, this.getWidth(), 0);
        g.drawLine(0, 19, this.getWidth(), 19);
        if (this.mouseOverTitle) {
            g.setColor(Settings.SUMO2_DARKER);
        } else {
            g.setColor(Settings.SUMO2_DARK);
        }
        if (this.minimized) {
            Polygon polyClosed = new Polygon();
            polyClosed.addPoint(8, 5);
            polyClosed.addPoint(13, 9);
            polyClosed.addPoint(8, 13);
            g.fillPolygon(polyClosed);
        } else {
            Polygon polyOpened = new Polygon();
            polyOpened.addPoint(6, 9);
            polyOpened.addPoint(14, 9);
            polyOpened.addPoint(10, 13);
            g.fillPolygon(polyOpened);
        }
        g.setColor(Settings.SUMO2_DARKER);
        g.drawString(this.title, 20, 14);
        this.paintComponents(g);
    }

    private void reOrder() {
        if (this.layout == LAYOUT_FREE) {
            return;
        }
        this.removeAll();
        int posy = 26;
        if (this.layout == LAYOUT_ONE) {
            for (JComponent p : this.content) {
                p.setBounds(12, posy, this.getWidth() - 20, p.getHeight());
                posy += p.getHeight() + 5;
                this.add(p);
            }
        } else if (this.layout == LAYOUT_TWO) {
            boolean cycle = false;
            for (JComponent p : this.content) {
                int xx = 10;
                if (cycle) {
                    xx = this.getWidth() / 2;
                }
                p.setBounds(xx, posy, this.getWidth() / 2 - 20, p.getHeight());
                this.add(p);
                if (cycle) {
                    posy += p.getHeight() + 5;
                }
                cycle = !cycle;
            }
            if ((double)(this.content.size() % 2) != 0.0) {
                posy += this.content.get(this.content.size() - 1).getHeight() + 5;
            }
        }
        if (this.layout != LAYOUT_FREE) {
            this.areaHeight = posy + 13;
            if (this.minimized) {
                this.setBounds(this.getBounds().x, this.getBounds().y, this.getWidth(), 19);
            } else {
                this.setBounds(this.getBounds().x, this.getBounds().y, this.getWidth(), this.areaHeight);
            }
        }
    }

    public void addLine(DetailButton b) {
        this.needsReOrder = true;
        this.content.add(b);
    }

    public void addLine(DetailLabel b) {
        this.needsReOrder = true;
        this.content.add(b);
    }

    public int CalcHeight() {
        if (this.myHeight != -1) {
            this.setBounds(this.getBounds().x, this.getBounds().y, this.getBounds().width, this.myHeight);
            return this.myHeight;
        }
        this.reOrder();
        return this.getBounds().height;
    }

    public void setAreaHeight(int i) {
        this.myHeight = i;
        if (!this.minimized) {
            this.areaHeight = this.myHeight;
        }
        this.setBounds(this.getBounds().x, this.getBounds().y, this.getBounds().width, this.myHeight);
    }
}

