/*
 * Decompiled with CFR 0.152.
 */
package sumo.gui.detail.Elements;

import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import sumo.gui.Icons;
import sumo.gui.Settings;
import sumo.gui.detail.DetailButtonPressedListener;

public class DetailButton
extends JPanel {
    public int myData = -1;
    private int iconposy = 1;
    private int iconposx = 2;
    private boolean mouseOver = false;
    private String title = "";
    private int icon = Icons.ICON_QUESTION;
    ArrayList<DetailButtonPressedListener> pressedListeners = new ArrayList();

    public void addDetailButtonPressedListener(DetailButtonPressedListener l) {
        this.pressedListeners.add(l);
    }

    public int getHeight() {
        return 18;
    }

    public DetailButton(int icon, String txt) {
        this.icon = icon;
        this.title = txt;
        this.setLayout(null);
        this.setSize(100, 20);
        JPopupMenu contextMenu = new JPopupMenu("...");
        JMenuItem itemKeyb = new JMenuItem("bind keyboard shortcut");
        JMenuItem itemMidi = new JMenuItem("bind midi shortcut");
        contextMenu.add(itemKeyb);
        contextMenu.add(itemMidi);
        this.setComponentPopupMenu(contextMenu);
        this.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
                DetailButton.this.mouseOver = true;
                DetailButton.this.setCursor(Cursor.getPredefinedCursor(12));
                DetailButton.this.repaint();
            }

            public void mouseExited(MouseEvent e) {
                DetailButton.this.setCursor(Cursor.getPredefinedCursor(0));
                DetailButton.this.mouseOver = false;
                DetailButton.this.repaint();
            }

            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 1) {
                    for (DetailButtonPressedListener l : DetailButton.this.pressedListeners) {
                        l.pressed();
                    }
                }
            }

            public void mouseReleased(MouseEvent e) {
            }
        });
    }

    public void paint(Graphics g) {
        Graphics2D gd = (Graphics2D)g;
        if (this.mouseOver) {
            g.setColor(Settings.SUMO2_BG);
        } else {
            g.setColor(Settings.SUMO2_BRIGHTER);
        }
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.icon != -1) {
            Icons.drawIcon(g, this.icon, this.iconposx, this.iconposy);
        }
        g.setFont(Settings.font);
        g.setColor(Settings.SUMO2_DARKER);
        int x = this.iconposx + 18;
        if (this.icon == -1) {
            x = 10;
        }
        g.drawString(this.title, x, 12);
    }

    public int getIconposy() {
        return this.iconposy;
    }

    public void setIconposy(int iconposy) {
        this.iconposy = iconposy;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
        this.repaint();
    }

    public int getIcon() {
        return this.icon;
    }

    public void setIcon(int icon) {
        this.icon = icon;
        this.repaint();
    }

    public int getIconposx() {
        return this.iconposx;
    }

    public void setIconposx(int iconposx) {
        this.iconposx = iconposx;
    }
}

