/*
 * Decompiled with CFR 0.152.
 */
package sumo.gui.dialogs;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.lwjgl.opengl.DisplayMode;
import sumo.app.demoplayerlogo;
import sumo.gui.Settings;
import sumo.opengl.GLWindow;
import sumo.opengl.OpenGLSettings;

public class GLDisplayMode {
    JFrame myFrame;
    JPanel toppanel = new JPanel();
    JTextField txt;
    String type = "";
    public boolean finished = false;
    public DisplayMode mode = null;
    public OpenGLSettings settings = new OpenGLSettings();
    JLabel lc;
    JList list;
    JLabel l;
    JCheckBox fullscreen;
    JCheckBox vsynch;
    JCheckBox antialias;
    ArrayList<DisplayMode> modes = GLWindow.getDisplayModes();
    int wx = 0;
    int wy = 0;

    public GLDisplayMode() {
        Collections.sort(this.modes, new Comparator(){

            public int compare(Object a, Object b) {
                DisplayMode ia = (DisplayMode)a;
                DisplayMode ib = (DisplayMode)b;
                if (ia.getWidth() > ib.getWidth()) {
                    return 1;
                }
                return 0;
            }
        });
        this.myFrame = new JFrame();
        this.myFrame.setBackground(Settings.iconBackground);
        this.myFrame.setDefaultCloseOperation(3);
        demoplayerlogo l = new demoplayerlogo();
        l.setBounds(0, 5, 300, 87);
        this.myFrame.add(l);
        Object[] ress = new Object[this.modes.size()];
        for (int i = 0; i < this.modes.size(); ++i) {
            ress[i] = this.modes.get(i).getWidth() + "x" + this.modes.get(i).getHeight() + " " + this.modes.get(i).getFrequency() + "hz ";
        }
        this.list = new JList<Object>(ress);
        this.list.setVisibleRowCount(3);
        this.list.addKeyListener(new KeyListener(){

            public void keyTyped(KeyEvent arg0) {
            }

            public void keyReleased(KeyEvent arg0) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    GLDisplayMode.this.myFrame.dispose();
                    GLDisplayMode.this.finished = true;
                }
            }
        });
        JScrollPane js = new JScrollPane(this.list);
        js.setBounds(10, 100, 280, 150);
        this.list.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                GLDisplayMode.this.mode = GLDisplayMode.this.modes.get(GLDisplayMode.this.list.getSelectedIndex());
                System.out.println(GLDisplayMode.this.mode.getWidth() + "x" + GLDisplayMode.this.mode.getHeight() + " " + GLDisplayMode.this.mode.getFrequency() + " hz");
                GLDisplayMode.this.settings.setWidth(GLDisplayMode.this.mode.getWidth());
                GLDisplayMode.this.settings.setHeight(GLDisplayMode.this.mode.getHeight());
                GLDisplayMode.this.settings.setFrequency(GLDisplayMode.this.mode.getFrequency());
            }
        });
        this.myFrame.add(js);
        int defaultindex = 0;
        for (int i = 0; i < this.modes.size(); ++i) {
            if (this.modes.get(i).getWidth() != 1024 || this.modes.get(i).getHeight() != 768 || this.modes.get(i).getFrequency() != 60) continue;
            defaultindex = i;
        }
        this.list.setSelectedIndex(defaultindex);
        this.list.ensureIndexIsVisible(defaultindex);
        int posy = 260;
        this.fullscreen = new JCheckBox("fullscreen");
        this.fullscreen.setSelected(this.settings.isFullScreen());
        this.fullscreen.setBounds(10, posy, 75, 20);
        this.myFrame.add(this.fullscreen);
        this.fullscreen.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                GLDisplayMode.this.settings.setFullScreen(!GLDisplayMode.this.settings.isFullScreen());
                GLDisplayMode.this.fullscreen.setSelected(GLDisplayMode.this.settings.isFullScreen());
            }
        });
        this.vsynch = new JCheckBox("vsynch");
        this.vsynch.setSelected(this.settings.getVsynch());
        this.vsynch.setBounds(85, posy, 60, 20);
        this.myFrame.add(this.vsynch);
        this.vsynch.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                GLDisplayMode.this.settings.setVsynch(!GLDisplayMode.this.settings.getVsynch());
                GLDisplayMode.this.fullscreen.setSelected(GLDisplayMode.this.settings.isFullScreen());
            }
        });
        this.antialias = new JCheckBox("antialias");
        this.antialias.setSelected(this.settings.isFullScreen());
        this.antialias.setBounds(150, posy, 70, 20);
        this.myFrame.add(this.antialias);
        this.updateAntiAlias();
        this.antialias.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                if (GLDisplayMode.this.settings.getFakeMS() == 1.5f) {
                    GLDisplayMode.this.settings.setFakeMS(1.0f);
                } else {
                    GLDisplayMode.this.settings.setFakeMS(1.5f);
                }
                GLDisplayMode.this.updateAntiAlias();
            }
        });
        JButton ok = new JButton("ok");
        this.myFrame.add(ok);
        ok.setBounds(10, posy += 30, 70, 20);
        ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                GLDisplayMode.this.myFrame.dispose();
                GLDisplayMode.this.finished = true;
            }
        });
        JButton cancel = new JButton("cancel");
        this.myFrame.add(cancel);
        cancel.setBounds(90, posy, 70, 20);
        cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                GLDisplayMode.this.myFrame.dispose();
                System.exit(0);
            }
        });
        this.myFrame.add(this.toppanel);
        this.myFrame.addKeyListener(new KeyListener(){

            public void keyTyped(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    GLDisplayMode.this.myFrame.dispose();
                }
            }
        });
        this.myFrame.setBounds(300, 200, 306, posy + 70);
        this.myFrame.setDefaultCloseOperation(2);
        this.myFrame.setResizable(false);
        this.myFrame.setVisible(true);
    }

    protected void updateAntiAlias() {
        if (this.settings.getFakeMS() == 1.5f) {
            this.antialias.setSelected(true);
        } else {
            this.antialias.setSelected(false);
        }
    }
}

