/*
 * Decompiled with CFR 0.152.
 */
package sumo.gui.lines;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.datatransfer.StringSelection;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JPanel;
import sumo.app.main;
import sumo.gui.AbstractLine;
import sumo.gui.Button;
import sumo.gui.Icons;
import sumo.gui.PluginPanel;
import sumo.gui.Settings;
import sumo.gui.debug.guiDebugData;
import sumo.gui.debug.guiStopWatch;
import sumo.gui.detail.PluginDetail;
import sumo.gui.detail.ShaderDetail;
import sumo.gui.lineTypeElements.guiLineTypeIF;
import sumo.gui.lines.LineIF;
import sumo.gui.timing.KeyFramePanel;
import sumo.gui.timing.KeyFramePanelIF;
import sumo.logger.Logger;
import sumo.project.Project;
import sumoTween.events.TweenEvent;

public class BasicLine
extends JPanel
implements LineIF,
DragGestureListener,
DragSourceListener {
    public static int POS_KEYFRAMEPANEL = 280;
    public static int POS_VALUECONTROLER = 170;
    private Button minimize;
    private Button visible;
    private Button buttonFrameBuffer;
    private Button buttonShader;
    private Button btIsKeyFramed;
    private Button resize;
    private Button btKeyNext;
    private Button btKeyPrevious;
    private boolean selected = false;
    private boolean strikeThrough = false;
    AbstractLine abstractLine;
    KeyFramePanelIF keyFramePanel;
    guiLineTypeIF valueController;
    private DragSource dragSource;
    Color bg_keyframepart = Settings.lineBackground;
    Color bg_title = Settings.lineBackground;
    guiStopWatch watch = null;
    private int lineHeight = 19;

    public KeyFramePanelIF getKeyFramePanel() {
        return this.keyFramePanel;
    }

    public BasicLine(AbstractLine a) {
        this.abstractLine = a;
        this.dragSource = new DragSource();
        this.dragSource.createDefaultDragGestureRecognizer(this, 3, this);
        if (a.getType() == 1) {
            this.visible = new Button(Icons.ICON_VISIBLE, "visible");
            this.visible.setBounds(22, 0, 16, 16);
            this.add(this.visible);
            this.buttonShader = new Button(Icons.ICON_NONE, "shader effects");
            this.buttonShader.setBounds(250, 0, 16, 16);
            this.add(this.buttonShader);
            this.buttonFrameBuffer = new Button(Icons.ICON_FRAMEBUFFER_NONE, "renderbuffer");
            this.buttonFrameBuffer.setBounds(6, 0, 16, 16);
            this.add(this.buttonFrameBuffer);
            this.addMouseListener(new MouseListener(){

                public void mouseClicked(MouseEvent e) {
                }

                public void mouseEntered(MouseEvent e) {
                }

                public void mouseExited(MouseEvent e) {
                }

                public void mouseReleased(MouseEvent e) {
                }

                public void mousePressed(MouseEvent e) {
                    Project.getProject().setDetailPanel(new PluginDetail(BasicLine.this.abstractLine));
                    BasicLine.this.repaint();
                    System.out.println("hallo!!!");
                }
            });
        }
        if (this.keyFramePanel == null) {
            this.keyFramePanel = new KeyFramePanel(a.pluginPanel.getScenePanel());
        }
        this.add((JPanel)((Object)this.keyFramePanel));
        this.setLayout(null);
        this.minimize = new Button();
        this.minimize.setIcon(Icons.ICON_FOLDER_OPEN);
        this.minimize.setBounds(34, 0, 16, 16);
        this.add(this.minimize);
        if (this.visible != null) {
            this.visible.addMouseListener(new MouseListener(){

                public void mouseClicked(MouseEvent e) {
                }

                public void mouseEntered(MouseEvent e) {
                }

                public void mouseExited(MouseEvent e) {
                }

                public void mousePressed(MouseEvent e) {
                    if (BasicLine.this.abstractLine.plugin == null) {
                        Logger.log(this.getClass(), "basicline plugin null!!");
                    }
                    BasicLine.this.abstractLine.plugin.setVisible(!BasicLine.this.abstractLine.plugin.isVisible());
                    if (BasicLine.this.abstractLine.plugin.isVisible()) {
                        BasicLine.this.visible.setIcon(Icons.ICON_VISIBLE);
                    } else {
                        BasicLine.this.visible.setIcon(Icons.ICON_VISIBLE_NOT);
                    }
                    BasicLine.this.visible.repaint();
                    BasicLine.this.repaint();
                }

                public void mouseReleased(MouseEvent e) {
                }
            });
        }
        if (this.buttonShader != null) {
            this.buttonShader.addMouseListener(new MouseListener(){

                public void mouseClicked(MouseEvent e) {
                }

                public void mouseEntered(MouseEvent e) {
                }

                public void mouseExited(MouseEvent e) {
                }

                public void mouseReleased(MouseEvent e) {
                }

                public void mousePressed(MouseEvent e) {
                    if (BasicLine.this.abstractLine.plugin.getShaderResource() != null) {
                        Project.getProject().setDetailPanel(new ShaderDetail(BasicLine.this.abstractLine.plugin.getShaderResource()));
                    }
                    System.out.println("HUHU");
                }
            });
        }
        if (this.buttonFrameBuffer != null) {
            this.buttonFrameBuffer.addMouseListener(new MouseListener(){

                public void mouseClicked(MouseEvent e) {
                }

                public void mouseEntered(MouseEvent e) {
                }

                public void mouseExited(MouseEvent e) {
                }

                public void mousePressed(MouseEvent e) {
                    if (!PluginPanel.renderingPlugins) {
                        if (BasicLine.this.abstractLine.plugin == null) {
                            Logger.log(this.getClass(), "basicline plugin null!!");
                        }
                        int f = BasicLine.this.abstractLine.plugin.getFrameBuffer();
                        if (e.getButton() == 1) {
                            ++f;
                        }
                        if (e.getButton() == 3) {
                            --f;
                        }
                        if (f < -1) {
                            f = Project.getProject().getNumFrameBuffers() - 1;
                        }
                        if (f > Project.getProject().getNumFrameBuffers() - 1) {
                            f = -1;
                        }
                        BasicLine.this.buttonFrameBuffer.setIcon(Icons.ICON_FRAMEBUFFER_NONE + f + 1);
                        BasicLine.this.abstractLine.plugin.setFrameBuffer(f);
                        BasicLine.this.abstractLine.pluginPanel.repaint();
                        System.out.println("framebuffer:" + f);
                        BasicLine.this.repaint();
                    }
                }

                public void mouseReleased(MouseEvent e) {
                }
            });
        }
        this.btKeyNext = new Button(Icons.ICON_KEY_NEXT, "next");
        this.btKeyPrevious = new Button(Icons.ICON_KEY_PREVIOUS, "previous");
    }

    public void paint(Graphics g) {
        if (this.abstractLine.getType() == 1) {
            this.updateFrameBufferButton();
        }
        if (this.valueController != null && this.valueController.getKeyframed() != null) {
            boolean bl = this.strikeThrough = !this.valueController.getKeyframed().isEnabled();
        }
        if (guiDebugData.debug) {
            this.watch = new guiStopWatch(1);
        }
        if (this.valueController != null) {
            this.valueController.getComponent().setBounds(POS_VALUECONTROLER, 1, this.valueController.getComponent().getWidth(), this.valueController.getComponent().getHeight());
        }
        this.keyFramePanel.setBounds(POS_KEYFRAMEPANEL, 0, this.getWidth() - POS_KEYFRAMEPANEL, this.getHeight());
        if (this.abstractLine.getType() == 0 || this.abstractLine.getType() == 2) {
            g.setFont(Settings.font);
            this.bg_keyframepart = Settings.lineBackground;
            this.bg_title = Settings.SUMO2_BG;
        }
        if (this.abstractLine.getType() == 1) {
            g.setFont(Settings.fontBold);
            this.bg_keyframepart = Settings.lineTitleBackground;
            this.bg_title = Settings.SUMO2_BRIGHTER;
            if (this.selected) {
                this.bg_title = Settings.SUMO2_DARK;
            }
            this.buttonShader.setBgColor(this.bg_title);
            this.buttonFrameBuffer.setBgColor(this.bg_title);
        }
        this.keyFramePanel.setBg(this.bg_keyframepart);
        if (!this.abstractLine.hasChilds()) {
            this.remove(this.minimize);
        } else {
            this.minimize.setBgColor(this.bg_title);
            this.minimize.setPosition(this.getLevelOffsetX(), 0);
            this.add(this.minimize);
        }
        if (this.visible != null) {
            this.visible.setBgColor(this.bg_title);
        }
        g.setColor(this.bg_title);
        g.fillRect(0, 0, POS_KEYFRAMEPANEL, this.getHeight());
        g.setColor(this.bg_keyframepart);
        g.fillRect(POS_KEYFRAMEPANEL, 0, this.getWidth(), this.getHeight());
        if (this.abstractLine.getType() == 2) {
            g.setFont(Settings.fontBold);
            g.setColor(Settings.SUMO2_BRIGHTER);
            g.fillRect(40, 0, this.getWidth(), this.getHeight());
            this.keyFramePanel.setBg(Settings.lineTitleBackground);
            this.minimize.setBgColor(Settings.SUMO2_BRIGHTER);
        }
        if (this.abstractLine.plugin.getFrameBuffer() != -1) {
            if (this.buttonFrameBuffer != null) {
                this.buttonFrameBuffer.setBgColor(Settings.sceneColors[this.abstractLine.plugin.getFrameBuffer()]);
                this.buttonFrameBuffer.repaint();
            }
            g.setColor(Settings.sceneColors[this.abstractLine.plugin.getFrameBuffer()]);
            g.fillRect(0, 0, 22, this.getHeight());
        }
        g.setColor(Color.WHITE);
        g.drawLine(0, this.getHeight() - 1, this.getWidth(), this.getHeight() - 1);
        g.setColor(Settings.lineTitleColor);
        if (this.btIsKeyFramed != null) {
            this.btIsKeyFramed.setBounds(this.getLevelOffsetX(), 0, 16, 16);
        }
        if (this.resize != null) {
            this.resize.setBounds(this.getLevelOffsetX() - 16, 0, 16, 16);
        }
        if (this.selected) {
            g.setColor(Settings.SUMO2_BG);
        }
        g.drawString(this.abstractLine.getTitle(), this.getLevelOffsetX() + this.minimize.getWidth() + 3, 13);
        if (this.strikeThrough) {
            g.drawLine(this.getLevelOffsetX() + this.minimize.getWidth() + 3, this.getHeight() - 7, this.getLevelOffsetX() + this.minimize.getWidth() + 60, this.getHeight() - 7);
        }
        if (this.abstractLine.getType() == 1) {
            g.setColor(Settings.SUMO2_BG);
        } else {
            g.setColor(Settings.SUMO2_BRIGHTER);
        }
        g.fillRect(0, this.getHeight() - 1, POS_KEYFRAMEPANEL, this.getHeight() - 1);
        if (this.abstractLine.getType() == 2) {
            g.setColor(Settings.SUMO2_BG);
            g.fillRect(40, this.getHeight() - 1, POS_KEYFRAMEPANEL, this.getHeight() - 1);
        }
        this.paintComponents(g);
        if (guiDebugData.debug) {
            this.watch.stop();
        }
    }

    private int getLevelOffsetX() {
        return this.abstractLine.getLevel() * this.minimize.getWidth() + 38;
    }

    public JPanel getComponent() {
        return this;
    }

    public Button getButtonMinimize() {
        return this.minimize;
    }

    public Button getButtonVisible() {
        return this.visible;
    }

    public void setValueControler(guiLineTypeIF c) {
        this.valueController = c;
        if (c != null) {
            if (this.valueController.isKeyframeAble()) {
                this.btIsKeyFramed = new Button(Icons.ICON_BOX, "keyframed?");
                this.btIsKeyFramed.setBounds(this.getLevelOffsetX() + 16, 0, 16, 16);
                this.resize = new Button(Icons.ICON_GRAPH, "graph?");
                this.resize.setBounds(this.getLevelOffsetX(), 0, 16, 16);
                this.updateButtonIsKeyframed();
                if (c.getKeyframed() != null) {
                    c.getKeyframed().addTweenEventListener(new TweenEvent(){

                        public void finished() {
                        }

                        public void keysChanged() {
                            BasicLine.this.strikeThrough = !BasicLine.this.valueController.getKeyframed().isEnabled();
                            BasicLine.this.repaint();
                            BasicLine.this.updateButtonIsKeyframed();
                        }
                    });
                }
                this.resize.addMouseListener(new MouseListener(){

                    public void mouseClicked(MouseEvent arg0) {
                    }

                    public void mouseEntered(MouseEvent arg0) {
                    }

                    public void mouseExited(MouseEvent arg0) {
                    }

                    public void mouseReleased(MouseEvent arg0) {
                    }

                    public void mousePressed(MouseEvent arg0) {
                        BasicLine.this.resize();
                        main.gui.updateResize();
                    }
                });
                this.btIsKeyFramed.addMouseListener(new MouseListener(){

                    public void mouseClicked(MouseEvent arg0) {
                    }

                    public void mouseEntered(MouseEvent arg0) {
                    }

                    public void mouseExited(MouseEvent arg0) {
                    }

                    public void mouseReleased(MouseEvent arg0) {
                    }

                    public void mousePressed(MouseEvent arg0) {
                        BasicLine.this.valueController.setIsKeyFramed(!BasicLine.this.valueController.isKeyFramed());
                        BasicLine.this.updateButtonIsKeyframed();
                    }
                });
                this.add(this.btIsKeyFramed);
                this.add(this.resize);
            }
            this.add(c.getComponent());
        }
    }

    protected void updateButtonIsKeyframed() {
        if (this.valueController.isKeyFramed()) {
            this.btIsKeyFramed.setIcon(Icons.ICON_KEYFRAMED);
        } else {
            this.btIsKeyFramed.setIcon(Icons.ICON_KEYFRAMED_NOT);
        }
        this.btIsKeyFramed.repaint();
    }

    public guiLineTypeIF getValueControler() {
        return this.valueController;
    }

    public void repaintValueController() {
        if (this.valueController != null) {
            this.valueController.getComponent().repaint();
        }
    }

    public void setSelectedR(boolean b) {
        this.selected = b;
        System.out.println("selected=" + this.selected);
        this.repaint();
    }

    public KeyFramePanelIF setKeyFramePanel(KeyFramePanelIF panel) {
        this.remove((JPanel)((Object)this.keyFramePanel));
        this.keyFramePanel = panel;
        this.add((JPanel)((Object)this.keyFramePanel));
        return panel;
    }

    public int getLineHeight() {
        return this.lineHeight;
    }

    public void setLineHeight(int i) {
        this.lineHeight = i;
    }

    public void resize() {
        if (this.getLineHeight() == 100) {
            this.setLineHeight(19);
        } else if (this.getLineHeight() == 50) {
            this.setLineHeight(100);
        } else if (this.getLineHeight() == 19) {
            this.setLineHeight(50);
        }
    }

    public void refresh() {
        this.repaint();
    }

    void updateFrameBufferButton() {
        if (this.abstractLine != null && this.abstractLine.plugin != null && this.buttonFrameBuffer != null && this.buttonFrameBuffer.getIcon() != Icons.ICON_FRAMEBUFFER_NONE + this.abstractLine.plugin.getFrameBuffer() + 1) {
            this.buttonFrameBuffer.setIcon(Icons.ICON_FRAMEBUFFER_NONE + this.abstractLine.plugin.getFrameBuffer() + 1);
        }
        if (this.abstractLine.plugin.getShaderResource() != null && this.buttonShader != null) {
            this.buttonShader.setIcon(Icons.RESOURCE_SHADER);
        } else {
            this.buttonShader.setIcon(Icons.ICON_NONE);
        }
    }

    public AbstractLine getAbstractLine() {
        return this.abstractLine;
    }

    public void dragDropEnd(DragSourceDropEvent arg0) {
    }

    public void dragEnter(DragSourceDragEvent arg0) {
    }

    public void dragExit(DragSourceEvent arg0) {
    }

    public void dragOver(DragSourceDragEvent arg0) {
    }

    public void dropActionChanged(DragSourceDragEvent arg0) {
    }

    public void dragGestureRecognized(DragGestureEvent evt) {
        int in = this.abstractLine.pluginPanel.getAllLines().indexOf(this.abstractLine);
        StringSelection t = new StringSelection("moveplugin:" + in);
        this.dragSource.startDrag(evt, DragSource.DefaultCopyDrop, t, this);
    }
}

