/*
 * Decompiled with CFR 0.152.
 */
package sumo.gui.timing;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import javax.swing.JPanel;
import sumo.app.guitest;
import sumo.gui.Icons;
import sumo.gui.ScenePanel;
import sumo.gui.Settings;
import sumo.gui.debug.guiDebugData;
import sumo.gui.debug.guiStopWatch;
import sumo.math.vec2f;
import sumo.math.vec2i;
import sumo.project.Project;
import sumo.util.MathUtil;

public class TimingPanel
extends JPanel {
    ScenePanel sp;
    private ArrayList<vec2f> timeAreas = new ArrayList();
    final Polygon timeCursor = new Polygon();
    private int currentMouseButton = -1;
    vec2i mousePos = new vec2i();
    int oldDragX = -1;
    boolean isDragged = false;
    private boolean mouseOver = false;
    guiStopWatch watch = null;

    public TimingPanel() {
        this.timeCursor.addPoint(0, 4);
        this.timeCursor.addPoint(15, 4);
        this.timeCursor.addPoint(15, 10);
        this.timeCursor.addPoint(7, 18);
        this.timeCursor.addPoint(8, 18);
        this.timeCursor.addPoint(0, 10);
        this.addMouseWheelListener(new MouseWheelListener(){

            public void mouseWheelMoved(MouseWheelEvent e) {
                if (guitest.shiftPressed) {
                    float t = TimingPanel.this.sp.getTimeFromPixel(20).floatValue() * (float)e.getWheelRotation();
                    TimingPanel.this.sp.getTimingScrollPanel().scrollOffsetTime += t;
                    TimingPanel.this.sp.repaintTimings();
                } else {
                    int v = TimingPanel.this.sp.getZoom() + e.getWheelRotation() * 5;
                    if (v < 1) {
                        v = 1;
                    }
                    TimingPanel.this.sp.setZoom(v);
                }
            }
        });
        this.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
                TimingPanel.this.repaint();
            }

            public void mouseEntered(MouseEvent e) {
                TimingPanel.this.mouseOver = true;
                TimingPanel.this.repaint();
            }

            public void mouseExited(MouseEvent e) {
                TimingPanel.this.mouseOver = false;
                TimingPanel.this.repaint();
            }

            public void mousePressed(MouseEvent e) {
                TimingPanel.this.currentMouseButton = e.getButton();
            }

            public void mouseReleased(MouseEvent e) {
                TimingPanel.this.oldDragX = -1;
                if (TimingPanel.this.isDragged) {
                    TimingPanel.this.isDragged = false;
                }
                if (TimingPanel.this.currentMouseButton == 3) {
                    // empty if block
                }
                TimingPanel.this.sp.repaintTimings(true);
                TimingPanel.this.repaint();
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            public void mouseDragged(MouseEvent e) {
                if (TimingPanel.this.currentMouseButton == 1) {
                    if (guitest.spacePressed) {
                        if (TimingPanel.this.oldDragX != -1) {
                            float t = TimingPanel.this.sp.getTimeFromPixel(TimingPanel.this.oldDragX - e.getX()).floatValue();
                            TimingPanel.this.sp.getTimingScrollPanel().scrollOffsetTime += t;
                            TimingPanel.this.sp.repaintTimings();
                        }
                        TimingPanel.this.oldDragX = e.getX();
                    } else {
                        Project.getProject().setTime(TimingPanel.this.sp.getTimeFromPixelScreen(e.getX()));
                        guitest.glPanel.repaint();
                        TimingPanel.this.sp.repaintTimings(false);
                        TimingPanel.this.repaint();
                    }
                } else if (TimingPanel.this.currentMouseButton == 3) {
                    TimingPanel.this.isDragged = true;
                }
            }

            public void mouseMoved(MouseEvent e) {
                if (guitest.spacePressed) {
                    TimingPanel.this.setCursor(Cursor.getPredefinedCursor(13));
                } else {
                    TimingPanel.this.setCursor(Cursor.getPredefinedCursor(0));
                }
                if (!TimingPanel.this.isDragged) {
                    TimingPanel.this.mousePos.set(e.getX(), e.getY());
                    TimingPanel.this.repaint();
                }
            }
        });
    }

    public void paint(Graphics gd) {
        if (guiDebugData.debug) {
            this.watch = new guiStopWatch(guiDebugData.STOP_TIMINGPANEL);
        }
        gd.setFont(Settings.smallfont);
        gd.setColor(Settings.SUMO2_BG);
        gd.fillRect(0, 0, gd.getClipBounds().width, gd.getClipBounds().height);
        for (int i = 0; i < this.getWidth(); i += 100) {
            Icons.drawIcon(gd, Icons.IMAGE_GRADIENT, i, 0);
        }
        for (vec2f ta : this.timeAreas) {
            gd.setColor(Color.yellow);
            gd.fillRect(this.sp.getTimeInPixelsScreen(ta.getX()), 0, this.sp.getTimeInPixelsScreen(ta.getY()) - this.sp.getTimeInPixelsScreen(ta.getX()), this.getHeight());
        }
        this.drawTimeTicksSeconds(gd, this.sp.timeControll.displayMode);
        int x = this.sp.getTimeInPixelsScreen(Project.getProject().getTime());
        gd.setColor(Settings.SUMO2_DARK);
        gd.translate(x - 7, 6);
        gd.fillPolygon(this.timeCursor);
        gd.translate(-x + 7, -6);
        gd.drawLine(x, 10, x, this.getHeight());
        this.paintComponents(gd);
        if (Project.getProject().debugGUI) {
            gd.setFont(Settings.smallfont);
            gd.setColor(Color.blue);
            gd.drawString(this.getClass().getName(), 10, 15);
        }
        if (guiDebugData.debug) {
            this.watch.stop();
        }
    }

    private void drawTimeTicksSeconds(Graphics gd, int displaymode) {
        String str = "";
        double step = 1.0;
        int p = this.sp.getTimeInPixel(1.0f);
        if (p > 100) {
            step = 0.5;
        }
        if (p > 250) {
            step = 0.2;
        }
        if (p > 350) {
            step = 0.1;
        }
        if (p > 450) {
            step = 0.06666667014360428;
        }
        if (p > 650) {
            step = 0.03333333507180214;
        }
        if (p <= 10) {
            step = 10.0;
        }
        if (p <= 4) {
            step = 15.0;
        }
        if (p <= 3) {
            step = 30.0;
        }
        int x = 0;
        double start = (double)Math.round(this.sp.getTimeFromPixelScreen(0).floatValue()) - 3.0;
        double end = (double)Math.round(this.sp.getTimeFromPixelScreen(this.sp.getWidth()).floatValue()) + 3.0;
        for (double i = start; i <= end; i += step) {
            x = this.sp.getTimeInPixelsScreen((float)i);
            if (x < -20 || x >= this.getWidth() + 20) continue;
            if (i % 1.0 != 0.0 && i > 0.0) {
                if (displaymode == 2) {
                    gd.setColor(Settings.SUMO2_DARK);
                } else {
                    gd.setColor(Settings.SUMO2_BRIGHT);
                }
                if (displaymode == 2) {
                    str = String.valueOf(Math.round(MathUtil.round((float)i, 2) * (float)Project.getProject().getFPS()));
                } else {
                    str = String.valueOf(MathUtil.round((float)i, 2));
                    if (str.length() > 6) {
                        str = str.substring(0, 6);
                    }
                }
            } else if (i >= 0.0) {
                gd.setColor(Settings.SUMO2_DARK);
                str = displaymode == 2 ? String.valueOf(Math.round(i) * (long)Project.getProject().getFPS()) : String.valueOf(Math.round(i));
            }
            if (!(i >= 0.0)) continue;
            gd.drawLine(x, 0, x, 10);
            gd.drawString(str, x + 6, 10);
            gd.drawLine(x, 0, x, 10);
            gd.setColor(Settings.SUMO2_BRIGHT);
            for (int y = 10; y < this.getHeight(); y += 4) {
                gd.drawLine(x, y, x, y + 1);
            }
        }
    }

    public void setScenePanel(ScenePanel scenePanel) {
        this.sp = scenePanel;
    }

    public void clearTimeAreas() {
        this.timeAreas.clear();
    }

    public void addTimeArea(vec2f area) {
        this.timeAreas.add(area);
    }
}

