/*
 * Decompiled with CFR 0.152.
 */
package sumo.keyframing;

import java.util.ArrayList;
import java.util.Comparator;
import sumo.keyframing.KeyBoolean;
import sumo.keyframing.KeyFramedBase;
import sumo.keyframing.KeyFramedIF;
import sumo.keyframing.KeyIF;
import sumo.project.Project;
import sumo.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyframedBoolean
extends KeyFramedBase
implements KeyFramedIF {
    private String name = "";
    short defaultInterpolation = 1;
    private boolean allowInterpolationChange = false;
    KeyIF defaultKey = new KeyBoolean(0.0f, false, this);
    public static String classSimpleName = "KeyframedBoolean";
    boolean waschanged = false;
    private boolean loop = false;
    public int currentkey = 0;
    public KeyBoolean[] keyframes = new KeyBoolean[1];

    @Override
    public void setDefaultKey(KeyIF k) {
        this.defaultKey = k;
    }

    @Override
    public KeyIF getDefaultKey() {
        return this.defaultKey;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void removeAt(float f) {
        this.move(f, 9999999.0f);
        this.keyframes = (KeyBoolean[])Arrays.resizeArray(this.keyframes, this.keyframes.length - 1);
        this.notifyKeysChanged(this);
    }

    public boolean getChanged() {
        boolean w = this.waschanged;
        this.waschanged = false;
        return w;
    }

    @Override
    public KeyIF[] getKeys() {
        return this.keyframes;
    }

    public KeyframedBoolean() {
        this.keyframes[0] = new KeyBoolean(0.0f, false, this);
    }

    @Override
    public void addKey(float t, Object v) {
        this.waschanged = true;
        this.change(t, true);
    }

    public boolean getValue() {
        return this.getValue(Project.getProject().getTime());
    }

    public void setValue(boolean b) {
        this.change(Project.getProject().getTime(), b);
    }

    public void change(KeyBoolean k) {
        this.change(k.time, k.getValue());
    }

    public void sortKeys() {
        int i;
        System.out.println("<--------->");
        for (i = 0; i < this.keyframes.length; ++i) {
            System.out.println(i + " , " + this.keyframes[i].time + " , " + this.keyframes[i].getValue());
        }
        java.util.Arrays.sort(this.keyframes, new Comparator(){

            public int compare(Object a, Object b) {
                KeyBoolean ia = (KeyBoolean)a;
                KeyBoolean ib = (KeyBoolean)b;
                if (ia.time > ib.time) {
                    return 1;
                }
                return 0;
            }
        });
        System.out.println("<--------->");
        for (i = 0; i < this.keyframes.length; ++i) {
            System.out.println(i + " , " + this.keyframes[i].time + " , " + this.keyframes[i].getValue());
        }
        System.out.println("<--------->");
    }

    public void change(float t, boolean v) {
        if (!this.isKeyframed) {
            this.keyframes[0].setValue(v);
        } else {
            boolean found = false;
            for (int i = 0; i < this.keyframes.length; ++i) {
                if (t != this.keyframes[i].time) continue;
                this.keyframes[i].setValue(v);
                found = true;
            }
            if (!found) {
                System.out.println("key not found...");
                this.keyframes = (KeyBoolean[])Arrays.resizeArray(this.keyframes, this.keyframes.length + 1);
                this.keyframes[this.keyframes.length - 1] = new KeyBoolean(t, v, this);
            }
            this.sortKeys();
        }
        this.notifyKeysChanged(this);
    }

    public boolean getKeyframedValue() {
        return this.getValue(Project.getProject().getTime());
    }

    @Override
    public void move(float t, float t2) {
        for (int i = 0; i < this.keyframes.length; ++i) {
            if (t != this.keyframes[i].time) continue;
            this.keyframes[i].time = t2;
            break;
        }
        this.sortKeys();
        this.notifyKeysChanged(this);
    }

    public boolean getValue(float time) {
        return ((KeyBoolean)this.getKey(time)).getValue();
    }

    public KeyIF getKey(float time) {
        if (!this.isKeyframed) {
            return this.keyframes[0];
        }
        int which = -1;
        for (int i = 0; i < this.keyframes.length; ++i) {
            if (!(time >= this.keyframes[i].time)) continue;
            which = i;
        }
        if (which == -1) {
            return this.keyframes[0];
        }
        return this.keyframes[which];
    }

    @Override
    public short getDefaultInterpolationMode() {
        return this.defaultInterpolation;
    }

    @Override
    public void setDefaultInterpolationMode(short m) {
        this.defaultInterpolation = m;
    }

    @Override
    public boolean isAllowInterpolationChange() {
        return this.allowInterpolationChange;
    }

    @Override
    public void setAllowInterpolationChange(boolean allowInterpolationChange) {
        this.allowInterpolationChange = allowInterpolationChange;
    }

    @Override
    public void deleteKeys(ArrayList<KeyIF> markedKeys) {
        for (int i = 0; i < this.keyframes.length; ++i) {
            if (!markedKeys.contains(this.keyframes[i])) continue;
            this.removeAt(this.keyframes[i].getTime());
        }
    }

    @Override
    public String getClassSimpleName() {
        return classSimpleName;
    }

    @Override
    public void insertKey(KeyIF k) {
        this.change(k.getTime(), ((KeyBoolean)k).getValue());
    }

    @Override
    public void clear() {
        this.keyframes = new KeyBoolean[1];
        this.keyframes[0] = new KeyBoolean(this.defaultKey.getTime(), ((KeyBoolean)this.defaultKey).getValue(), this);
        this.notifyKeysChanged(this);
    }

    @Override
    public void invokeChangeListener() {
        this.notifyKeysChanged(this);
    }
}

