/*
 * Decompiled with CFR 0.152.
 */
package sumo.keyframing;

import java.util.ArrayList;
import org.w3c.dom.Element;
import sumo.gui.lineTypeElements.guiResource;
import sumo.keyframing.KeyFloat;
import sumo.keyframing.KeyFramedBase;
import sumo.keyframing.KeyFramedIF;
import sumo.keyframing.KeyFramesChangedListener;
import sumo.keyframing.KeyIF;
import sumo.logger.Logger;
import sumo.resource.ResourceReloadedListener;
import sumo.resource.resourceIF;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyframedResource
extends KeyFramedBase
implements KeyFramedIF {
    private ArrayList<KeyFramesChangedListener> changeListener = new ArrayList();
    public static String classSimpleName = "KeyframedResource";
    private String name = "";
    private resourceIF r;
    public guiResource guiResource;
    ResourceReloadedListener reloadListener = new ResourceReloadedListener(){

        public void wasReloaded() {
            KeyframedResource.this.notifyKeysChanged();
        }
    };
    short defaultInterpolation = 1;
    private boolean allowInterpolationChange = false;

    public KeyframedResource() {
    }

    @Override
    public boolean getKeyframingEnabled() {
        return false;
    }

    public KeyframedResource(String name) {
    }

    public void change(float time, Object v) {
        this.r = (resourceIF)v;
        this.notifyKeysChanged();
        this.r.addResourceReloadedListener(this.reloadListener);
    }

    @Override
    public void addKey(float t, Object v) {
        this.r = (resourceIF)v;
        this.notifyKeysChanged();
        this.r.addResourceReloadedListener(this.reloadListener);
    }

    @Override
    public void removeAt(float f) {
    }

    @Override
    public void move(float t, float t2) {
    }

    public void sortKeys() {
    }

    @Override
    public KeyIF[] getKeys() {
        return null;
    }

    public void setValue(float f) {
    }

    public void addKey(float v) {
    }

    public void change(KeyFloat f) {
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public resourceIF getResource() {
        return this.r;
    }

    @Override
    public void addKeysChangedListener(KeyFramesChangedListener cl) {
        if (this.changeListener.contains(cl)) {
            return;
        }
        this.changeListener.add(cl);
    }

    public void notifyKeysChanged() {
        try {
            for (int x = 0; x < this.changeListener.size(); ++x) {
                KeyFramesChangedListener l = this.changeListener.get(x);
                l.keysChanged(this);
            }
        }
        catch (Exception e) {
            Logger.log(this.getClass(), e);
        }
    }

    @Override
    public void insertKey(KeyIF k) {
        System.out.println("insertkey not implemented in keyframedresource...");
    }

    public void setResource(Object o) {
        this.addKey(0.0f, o);
    }

    public void setGUIMarked(boolean b) {
        this.guiResource.setMarked(b);
    }

    @Override
    public short getDefaultInterpolationMode() {
        return this.defaultInterpolation;
    }

    @Override
    public void setDefaultInterpolationMode(short m) {
        this.defaultInterpolation = m;
    }

    @Override
    public boolean isAllowInterpolationChange() {
        return this.allowInterpolationChange;
    }

    @Override
    public void setAllowInterpolationChange(boolean allowInterpolationChange) {
        this.allowInterpolationChange = allowInterpolationChange;
    }

    @Override
    public void deleteKeys(ArrayList<KeyIF> markedKeys) {
    }

    @Override
    public String getClassSimpleName() {
        return classSimpleName;
    }

    @Override
    public void save(Element root) {
        if (this.r == null) {
            return;
        }
        if (this.r.getFilename().equals("no filename")) {
            return;
        }
        Element xmlPlug = root.getOwnerDocument().createElement("keyframed");
        xmlPlug.setAttribute("name", this.getName());
        if (this.r != null) {
            Element xmlRes = root.getOwnerDocument().createElement("resource");
            xmlRes.setAttribute("filename", this.r.getFilename());
            xmlRes.setAttribute("path", this.r.getPath());
            xmlPlug.appendChild(xmlRes);
        }
        root.appendChild(xmlPlug);
    }

    @Override
    public void clear() {
    }

    @Override
    public void setDefaultKey(KeyIF k) {
    }

    @Override
    public KeyIF getDefaultKey() {
        return null;
    }

    @Override
    public void invokeChangeListener() {
        this.notifyKeysChanged(this);
    }
}

