/*
 * Decompiled with CFR 0.152.
 */
package sumo.plugins.particleTest;

import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import sumo.project.Project;
import sumo.v3d.math.Vec3f;
import sumo.v3d.math.Vec3fkeyframed;
import sumoTween.Tweener;
import sumoTween.easing.Cubic;

public class Particle {
    Vec3fkeyframed pos = new Vec3fkeyframed();
    public float endTime = 0.0f;
    public float size = 1.0f;
    boolean dead = false;
    Tweener alpha;
    static FloatBuffer modelView = BufferUtils.createFloatBuffer((int)16);
    static FloatBuffer projView = BufferUtils.createFloatBuffer((int)16);
    static IntBuffer viewport = BufferUtils.createIntBuffer((int)16);
    static Vec3f Up;
    static Vec3f Right;
    static Vec3f BPos;

    public Particle() {
        this.pos.x.setKeyframingEnabled(true);
        this.pos.y.setKeyframingEnabled(true);
        this.pos.z.setKeyframingEnabled(true);
        this.alpha = new Tweener(new Cubic());
        this.alpha.setName("alpha");
        this.alpha.setKeyframed(true);
        this.alpha.clear(1.0f);
        this.alpha.setTimer(Project.getProject().getTimer());
    }

    public void render(float time) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPointSize((float)(11.0f * this.size));
        GL11.glBegin((int)0);
        this.pos.glVertex(time);
        GL11.glEnd();
        this.checkDead(time);
    }

    private void checkDead(float time) {
        if (this.endTime < time) {
            this.dead = true;
        }
    }

    void drawBillBoard(float time, float textureWidth) {
        GL11.glPushMatrix();
        this.pos.glTranslate(time);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.alpha.getValue(time));
        float resize = 1.0f;
        GL11.glGetFloat((int)2982, (FloatBuffer)modelView);
        GL11.glGetFloat((int)2983, (FloatBuffer)projView);
        GL11.glGetInteger((int)2978, (IntBuffer)viewport);
        Right = new Vec3f(modelView.get(0), modelView.get(4), modelView.get(8));
        Up = new Vec3f(modelView.get(1), modelView.get(5), modelView.get(9));
        GL11.glPushMatrix();
        Particle.Right.x *= resize;
        Particle.Right.y *= resize;
        Particle.Right.z *= resize;
        Particle.Up.x *= resize;
        Particle.Up.y *= resize;
        Particle.Up.z *= resize;
        GL11.glBegin((int)7);
        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        GL11.glVertex3f((float)(Particle.BPos.x + Particle.Right.x + Particle.Up.x), (float)(Particle.BPos.y + Particle.Right.y + Particle.Up.y), (float)(Particle.BPos.z + Particle.Right.z + Particle.Up.z));
        GL11.glTexCoord2f((float)textureWidth, (float)0.0f);
        GL11.glVertex3f((float)(Particle.BPos.x - Particle.Right.x + Particle.Up.x), (float)(Particle.BPos.y - Particle.Right.y + Particle.Up.y), (float)(Particle.BPos.z - Particle.Right.z + Particle.Up.z));
        GL11.glTexCoord2f((float)textureWidth, (float)textureWidth);
        GL11.glVertex3f((float)(Particle.BPos.x - Particle.Right.x - Particle.Up.x), (float)(Particle.BPos.y - Particle.Right.y - Particle.Up.y), (float)(Particle.BPos.z - Particle.Right.z - Particle.Up.z));
        GL11.glTexCoord2f((float)0.0f, (float)textureWidth);
        GL11.glVertex3f((float)(Particle.BPos.x + Particle.Right.x - Particle.Up.x), (float)(Particle.BPos.y + Particle.Right.y - Particle.Up.y), (float)(Particle.BPos.z + Particle.Right.z - Particle.Up.z));
        GL11.glEnd();
        GL11.glPopMatrix();
        GL11.glPopMatrix();
        this.checkDead(time);
    }

    static {
        BPos = new Vec3f(0.0f, 0.0f, 0.0f);
    }
}

