/*
 * Decompiled with CFR 0.152.
 */
package sumo.plugins.superrandomevoke;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.glu.GLU;
import org.w3c.dom.Element;
import sumo.keyframing.KeyFramedIF;
import sumo.keyframing.KeyFramesChangedListener;
import sumo.keyframing.KeyframedBoolean;
import sumo.keyframing.KeyframedFloat;
import sumo.keyframing.KeyframedInt;
import sumo.keyframing.KeyframedResource;
import sumo.plugin.Plugin;
import sumo.plugins.superrandomevoke.RandomParticle;
import sumo.project.Project;
import sumo.resource.types.textureFile;
import sumo.resource.types.v3d;
import sumo.util.freeTimer;
import sumo.v3d.NodeIF;
import sumo.v3d.Scene;
import sumo.v3d.mesh.MeshObject;

public class SuperRandomEvoke
extends Plugin {
    float[] color_1 = new float[]{1.0f, 1.0f, 1.0f};
    float[] color_2 = new float[]{0.8235294f, 0.44705883f, 0.20784314f};
    float[] color_3 = new float[]{0.14509805f, 0.17254902f, 0.3372549f};
    Scene s;
    public KeyframedFloat size;
    public KeyframedFloat fov;
    public KeyframedFloat space;
    public KeyframedResource scene;
    public KeyframedInt randomize;
    public KeyframedInt num;
    public KeyframedInt cam;
    public KeyframedInt colorize;
    public KeyframedInt myactive;
    public KeyframedBoolean background;
    private float scale = 1.0f;
    private textureFile currenTexture = null;
    public static freeTimer frt = new freeTimer();
    ArrayList<RandomParticle> parts = new ArrayList();
    int lastvalue = 0;

    public void init() {
        this.scene.setResource(new v3d());
        this.scene.addKeysChangedListener(new KeyFramesChangedListener(){

            public void keysChanged(KeyFramedIF keyframed) {
                SuperRandomEvoke.this.randomize();
            }
        });
    }

    protected void randomize() {
        this.s = ((v3d)this.scene.getResource()).getScene();
        List<NodeIF> meshes = this.s.rootnode.getChilds(1);
        this.parts.clear();
        System.out.println(meshes.size());
        for (NodeIF nodeIF : meshes) {
            int num = (int)((float)Math.random() * (float)this.num.getValue() * 2.0f);
            for (int i = 0; i < num; ++i) {
                MeshObject m = (MeshObject)nodeIF;
                RandomParticle p = new RandomParticle();
                this.parts.add(p);
                p.setObj(m);
                m.pos.set(0.0f, 0.0f, 0.0f);
            }
        }
        Collections.sort(this.parts, new Comparator<RandomParticle>(){

            @Override
            public int compare(RandomParticle o1, RandomParticle o2) {
                return o1.getObj().meshes.get((int)0).materialIDs.get((int)0).x - o2.getObj().meshes.get((int)0).materialIDs.get((int)0).x;
            }
        });
    }

    public void render() {
        if (this.randomize.getValue() != this.lastvalue) {
            this.lastvalue = this.randomize.getValue();
            this.randomize();
        }
        GL11.glLoadIdentity();
        GL11.glClearColor((float)0.14509805f, (float)0.17254902f, (float)0.3372549f, (float)1.0f);
        GL11.glClearDepth((double)1.0E8);
        GL11.glClear((int)256);
        if (this.background.getValue()) {
            GL11.glClear((int)16384);
        }
        GL11.glDisable((int)2929);
        if (this.fov.getValue() > 0.1f) {
            GL11.glMatrixMode((int)5889);
            GL11.glLoadIdentity();
            GLU.gluPerspective((float)(this.fov.getValue() * 220.0f), (float)1.7777778f, (float)0.02f, (float)2000.0f);
            GL11.glMatrixMode((int)5888);
            GL11.glLoadIdentity();
            int camv = this.cam.getValue();
            if (camv == 0) {
                GLU.gluLookAt((float)0.0f, (float)-114.0f, (float)0.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            } else if (camv == 1) {
                GLU.gluLookAt((float)0.0f, (float)-114.0f, (float)0.0f, (float)1.0f, (float)1.0f, (float)51.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            } else if (camv == 2) {
                GLU.gluLookAt((float)-50.0f, (float)-114.0f, (float)0.0f, (float)31.0f, (float)31.0f, (float)51.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
        } else {
            GL11.glLoadIdentity();
            GL11.glTranslatef((float)0.0f, (float)-114.0f, (float)0.0f);
            GL11.glRotatef((float)270.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        this.scale = this.size.getValue() * 1.3f + 0.02f;
        GL11.glScalef((float)this.scale, (float)this.scale, (float)this.scale);
        if (this.s == null) {
            return;
        }
        float t = frt.getTime();
        int count = 0;
        for (RandomParticle p : this.parts) {
            GL11.glPushMatrix();
            if ((double)(++count) % 3.0 == 0.0) {
                GL11.glRotatef((float)((float)(-Math.sin(Project.getProject().getTime()))), (float)0.0f, (float)0.0f, (float)1.0f);
            }
            if (this.colorize.getValue() == 0) {
                p.getObj().meshes.get((int)0).materials.get((int)0).settings.setDiffuse(this.color_1);
            } else if (this.colorize.getValue() == 1) {
                p.getObj().meshes.get((int)0).materials.get((int)0).settings.setDiffuse(this.color_2);
            } else if (this.colorize.getValue() == 2) {
                p.getObj().meshes.get((int)0).materials.get((int)0).settings.setDiffuse(this.color_3);
            }
            if (this.myactive.getValue() != 0) {
                p.render(t, this.space.getValue());
            }
            GL11.glPopMatrix();
        }
        if (RandomParticle.lastmaterial != null) {
            RandomParticle.lastmaterial.unbind();
        }
        GL11.glEnable((int)2929);
    }

    public String getAuthor() {
        return "tom";
    }

    public float getVersion() {
        return 0.0f;
    }

    public String getName() {
        return "cube";
    }

    public void saveXML(Element root) {
    }

    public void loadXML(Element root) {
    }
}

