/*
 * Decompiled with CFR 0.152.
 */
package sumo.v3d;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.ARBShaderObjects;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import sumo.logger.Logger;
import sumo.v3d.Shader;

public class ShaderProgram {
    public int programObject = -1;
    public int shaderLibType = -1;
    Shader[] shaders = new Shader[8];
    int shadercount = 0;
    public String logstring = "";
    int[] multitexture = new int[]{-1, -1, -1, -1};
    public String title = "";

    public void setUniform4fv(int loc, FloatBuffer fb) {
        ARBShaderObjects.glUniform4ARB((int)loc, (FloatBuffer)fb);
    }

    public void setUniform2f(int loc, float x, float y) {
        ARBShaderObjects.glUniform2fARB((int)loc, (float)x, (float)y);
    }

    public void setUniform1f(int loc, float f) {
        ARBShaderObjects.glUniform1fARB((int)loc, (float)f);
    }

    public void setUniform1i(int loc, int f) {
        ARBShaderObjects.glUniform1iARB((int)loc, (int)f);
    }

    public void setMultiTexture(int multi, int which, String target) {
        this.bind();
        this.multitexture[multi] = which;
        int i = this.setUniformLocation(target);
        ARBShaderObjects.glUniform1iARB((int)i, (int)multi);
        this.unbind();
    }

    public void changeShader(Shader s) {
        boolean found = false;
        for (int i = 0; i < this.shadercount; ++i) {
            if (this.shaders[i] != s) continue;
            found = true;
        }
        if (!found) {
            this.shaders[this.shadercount] = s;
            ++this.shadercount;
        }
    }

    public void bind() {
        int i;
        if (this.multitexture[0] != -1) {
            // empty if block
        }
        for (i = 0; i < this.shadercount; ++i) {
            if (this.shaders[i] == null) {
                Logger.log(this.getClass(), "shader is null!!");
                System.exit(1);
            }
            if (!this.shaders[i].updateProgram) continue;
            Logger.log(this.getClass(), "recompiling...");
            this.recompile();
            this.shaders[i].updateProgram = false;
        }
        if (this.programObject == -1) {
            return;
        }
        for (i = 0; i < this.multitexture.length; ++i) {
            int multi = this.multitexture[i];
            if (multi == -1) continue;
            if (i == 0) {
                GL13.glActiveTexture((int)33984);
            }
            if (i == 1) {
                GL13.glActiveTexture((int)33985);
            }
            if (i == 2) {
                GL13.glActiveTexture((int)33986);
            }
            if (i == 3) {
                GL13.glActiveTexture((int)33987);
            }
            GL11.glEnable((int)34037);
            GL11.glBindTexture((int)34037, (int)multi);
        }
        if (this.programObject == -1) {
            Logger.log(this.getClass(), "HALLO");
        }
        ARBShaderObjects.glUseProgramObjectARB((int)this.programObject);
    }

    public void unbind() {
        if (this.multitexture[0] != -1) {
            for (int i = 0; i < this.multitexture.length; ++i) {
                int multi = this.multitexture[i];
                if (multi == -1) continue;
                GL11.glEnable((int)34037);
                if (i == 0) {
                    GL13.glActiveTexture((int)33984);
                }
                if (i == 1) {
                    GL13.glActiveTexture((int)33985);
                }
                if (i == 2) {
                    GL13.glActiveTexture((int)33986);
                }
                if (i == 3) {
                    GL13.glActiveTexture((int)33987);
                }
                GL11.glBindTexture((int)34037, (int)0);
                GL11.glDisable((int)34037);
                GL13.glActiveTexture((int)33984);
            }
            GL11.glDisable((int)34037);
        }
        ARBShaderObjects.glUseProgramObjectARB((int)0);
    }

    public void recompile() {
        this.logstring = "";
        Logger.log(this.getClass(), "recompiling shaderprogram...");
        if (this.programObject == -1) {
            this.programObject = ARBShaderObjects.glCreateProgramObjectARB();
        }
        for (int i = 0; i < this.shadercount; ++i) {
            if (this.shaders[i].bound) continue;
            this.shaders[i].recompile();
            ARBShaderObjects.glAttachObjectARB((int)this.programObject, (int)this.shaders[i].shaderID);
            int er = GL11.glGetError();
            if (er != 0) {
                if (er == 1281) {
                    Logger.log(this.getClass(), "__ GL_INVALID_VALUE");
                }
                if (er == 1282) {
                    Logger.log(this.getClass(), "__ GL_INVALID_OPERATION");
                }
                Logger.log(this.getClass(), "programObject " + this.programObject);
                Logger.log(this.getClass(), "shaders[i].shaderID " + this.shaders[i].shaderID);
                Logger.log(this.getClass(), "error");
            }
            this.shaders[i].bound = true;
            this.logstring = this.logstring + "attaching shader: " + this.shaders[i].shaderID + "(" + this.shaders[i]._filename + ")" + "\n";
            ShaderProgram.printShaderObjectInfoLog(this.programObject);
        }
        ARBShaderObjects.glLinkProgramARB((int)this.programObject);
        ShaderProgram.printShaderObjectInfoLog(this.programObject);
        ARBShaderObjects.glValidateProgramARB((int)this.programObject);
        ShaderProgram.printShaderObjectInfoLog(this.programObject);
        if (this.logstring.length() > 2) {
            Logger.log(this.getClass(), this.logstring);
        }
    }

    public static void printShaderObjectInfoLog(int ID) {
        IntBuffer programBuffer = BufferUtils.createIntBuffer((int)1);
        ARBShaderObjects.glGetObjectParameterARB((int)ID, (int)35716, (IntBuffer)programBuffer);
        int logLength = programBuffer.get(0);
        if (logLength <= 1) {
            return;
        }
        ByteBuffer log = BufferUtils.createByteBuffer((int)logLength);
        ARBShaderObjects.glGetInfoLogARB((int)ID, null, (ByteBuffer)log);
        byte[] charArray = new byte[logLength];
        log.get(charArray);
        Logger.log(ShaderProgram.class, "shader compiler output:" + new String(charArray, 0, logLength));
    }

    public int setUniformLocation(String which) {
        int l = ARBShaderObjects.glGetUniformLocationARB((int)this.programObject, (ByteBuffer)this.toByteString(which, true));
        return l;
    }

    private ByteBuffer toByteString(String str, boolean isNullTerminated) {
        int length = str.length();
        if (isNullTerminated) {
            ++length;
        }
        ByteBuffer buff = BufferUtils.createByteBuffer((int)length);
        buff.put(str.getBytes());
        if (isNullTerminated) {
            buff.put((byte)0);
        }
        buff.flip();
        return buff;
    }
}

