/*
 * Decompiled with CFR 0.152.
 */
package sumo.v3d.loader;

import java.util.ArrayList;
import sumo.logger.Logger;
import sumo.project.Project;
import sumo.resource.types.textureFile;
import sumo.util.Files;
import sumo.util.stopwatch;
import sumo.v3d.BSpline;
import sumo.v3d.Camera;
import sumo.v3d.Light;
import sumo.v3d.NodeIF;
import sumo.v3d.Scene;
import sumo.v3d.loader.Binarystream;
import sumo.v3d.material.Material;
import sumo.v3d.material.TextureMap;
import sumo.v3d.math.Vec1i;
import sumo.v3d.mesh.AnimVerts;
import sumo.v3d.mesh.Mesh;
import sumo.v3d.mesh.MeshObject;
import sumo.v3d.particleSystem.ParticleSystem;

public class V3dloader {
    public final short CHUNK_VERSION = 1;
    public final short CHUNK_BACKGROUNDCOLOR = (short)5;
    public final short CHUNK_ANIMATION_FPS = (short)10;
    public final short CHUNK_ANIMATION_SAMPLERATE_MESH = (short)11;
    public final short CHUNK_ANIMATION_SAMPLERATE_ANIM = (short)13;
    public final short CHUNK_ANIMATION_LENGTH = (short)12;
    public final short CHUNK_MOBJECT = (short)200;
    public final short CHUNK_MOBJECT_NAME = (short)201;
    public final short CHUNK_MOBJECT_POS = (short)202;
    public final short CHUNK_MOBJECT_ROT = (short)203;
    public final short CHUNK_MOBJECT_SCALE = (short)204;
    public final short CHUNK_MOBJECT_NUMVERTICES = (short)205;
    public final short CHUNK_MOBJECT_NUMFACES = (short)206;
    public final short CHUNK_MOBJECT_WIRECOLOR = (short)215;
    public final short CHUNK_MOBJECT_MESH_NORMALS = (short)216;
    public final short CHUNK_MOBJECT_POS_ANIM = (short)217;
    public final short CHUNK_MOBJECT_ROT_ANIM = (short)218;
    public final short CHUNK_MOBJECT_VISIBILITY = (short)219;
    public final short CHUNK_MOBJECT_SCALE_ANIM = (short)223;
    public static final short CHUNK_MOBJECT_END = 299;
    public static final short CHUNK_MOBJECT_MESH_VERTICES = 301;
    public static final short CHUNK_MOBJECT_MESH_FACES = 302;
    public static final short CHUNK_MOBJECT_MESH_MATERIAL = 303;
    public static final short CHUNK_MOBJECT_MESH_TEXTURE_CHANNEL = 304;
    public static final short CHUNK_MOBJECT_MESH_TEXTURECOORDS = 305;
    public static final short CHUNK_MOBJECT_MESH_TEXTUREFACES = 306;
    public static final short CHUNK_MOBJECT_MESH_ANIM_FRAME = 307;
    public static final short CHUNK_MOBJECT_MESH_MULTIMATERIAL = 308;
    public static final short CHUNK_MOBJECT_MESH_END = 350;
    public static final short CHUNK_CAMERA = 400;
    public static final short CHUNK_CAMERA_POS = 401;
    public static final short CHUNK_CAMERA_TARGET = 402;
    public static final short CHUNK_CAMERA_NAME = 403;
    public static final short CHUNK_CAMERA_ROTATION = 404;
    public static final short CHUNK_CAMERA_FOV = 405;
    public static final short CHUNK_CAMERA_TARGET_ANIM = 407;
    public static final short CHUNK_CAMERA_POS_ANIM = 408;
    public static final short CHUNK_CAMERA_END = 449;
    public static final short CHUNK_LIGHT = 450;
    public static final short CHUNK_LIGHT_NAME = 451;
    public static final short CHUNK_LIGHT_POS = 452;
    public static final short CHUNK_LIGHT_COLOR = 453;
    public static final short CHUNK_LIGHT_MULTIPLIER = 454;
    public static final short CHUNK_LIGHT_POS_ANIM = 455;
    public static final short CHUNK_LIGHT_END = 499;
    public static final short CHUNK_MATERIAL_ID = 600;
    public static final short CHUNK_MATERIAL_NAME = 601;
    public static final short CHUNK_MATERIAL_DIFFUSE = 602;
    public static final short CHUNK_MATERIAL_AMBIENT = 603;
    public static final short CHUNK_MATERIAL_SPECULAR = 604;
    public static final short CHUNK_MATERIAL_OPACITY = 605;
    public static final short CHUNK_MATERIAL_TWOSIDED = 606;
    public static final short CHUNK_MATERIAL_FACETED = 607;
    public static final short CHUNK_MATERIAL_WIRED = 608;
    public static final short CHUNK_MATERIAL_SPECULARLEVEL = 609;
    public static final short CHUNK_MATERIAL_GLOSSINESS = 610;
    public static final short CHUNK_MATERIAL_SELFILLUMINATION = 611;
    public static final short CHUNK_MATERIAL_MAP_AMBIENT = 631;
    public static final short CHUNK_MATERIAL_MAP_DIFFUSE = 632;
    public static final short CHUNK_MATERIAL_MAP_SPECULAR = 633;
    public static final short CHUNK_MATERIAL_MAP_SPECULARLEVEL = 634;
    public static final short CHUNK_MATERIAL_MAP_GLOSSINESS = 635;
    public static final short CHUNK_MATERIAL_MAP_SELFILLUMINATION = 636;
    public static final short CHUNK_MATERIAL_MAP_OPACITY = 637;
    public static final short CHUNK_MATERIAL_MAP_FILTERCOLOR = 638;
    public static final short CHUNK_MATERIAL_MAP_BUMP = 639;
    public static final short CHUNK_MATERIAL_MAP_REFLECTION = 640;
    public static final short CHUNK_MATERIAL_MAP_REFRACTION = 641;
    public static final short CHUNK_MATERIAL_MAP_DISPLACEMENT = 642;
    public static final short CHUNK_MATERIAL_MAP_FILENAME = 645;
    public static final short CHUNK_MATERIAL_MAP_END = 660;
    public static final short CHUNK_MATERIAL_END = 699;
    public static final short CHUNK_SHAPE = 750;
    public static final short CHUNK_SHAPE_NAME = 751;
    public static final short CHUNK_SHAPE_KNOTS = 752;
    public static final short CHUNK_SHAPE_POS = 753;
    public static final short CHUNK_SHAPE_ROT = 754;
    public static final short CHUNK_SHAPE_SCALE = 755;
    public static final short CHUNK_SHAPE_END = 780;
    public static final short CHUNK_EOF = 9000;
    public final byte CHUNKTYPE_FLOAT = 1;
    public final byte CHUNKTYPE_INT = (byte)2;
    public final byte CHUNKTYPE_STRING = (byte)3;
    public final byte CHUNKTYPE_EMPTY = (byte)4;
    public final byte CHUNKTYPE_BYTE = (byte)5;
    public final byte CHUNKTYPE_SHORT = (byte)6;

    public Scene load(String path, String filename) {
        stopwatch timer = new stopwatch("v3d loading time");
        Binarystream bin = new Binarystream(path, filename);
        Logger.log(this.getClass(), "read:" + path + filename);
        int currentframeMeshAnim = -1;
        Scene myscene = new Scene();
        bin.readByte();
        bin.readByte();
        bin.readByte();
        bin.readByte();
        BSpline tempShape = new BSpline();
        Light tempLight = new Light();
        TextureMap tempTextureMap = new TextureMap(0);
        Material tempMaterial = new Material();
        Camera tempCam = new Camera();
        Mesh tempMesh = new Mesh();
        MeshObject tempMeshObject = new MeshObject();
        int fps = 60;
        int samplerate_mesh = 1;
        int samplerate_anim = 1;
        boolean cont = true;
        block72: while (cont) {
            int numElements = -1;
            short chunkID = bin.readShort();
            byte chunkTYPE = bin.readByte();
            int size = bin.readInt();
            if (chunkID == 9000) {
                cont = false;
            }
            switch (chunkTYPE) {
                case 1: {
                    numElements = size / 4;
                    break;
                }
                case 2: {
                    numElements = size / 4;
                    break;
                }
                case 6: {
                    numElements = size / 2;
                    break;
                }
                case 3: {
                    numElements = size - 1;
                    break;
                }
                default: {
                    numElements = size;
                }
            }
            switch (chunkID) {
                case 1: {
                    bin.readFloat();
                    continue block72;
                }
                case 5: {
                    myscene.backgroundcolor = bin.readVec3f();
                    continue block72;
                }
                case 11: {
                    samplerate_anim = samplerate_mesh = bin.readInt();
                    Logger.log(this.getClass(), "samplerate mesh:" + samplerate_mesh);
                    continue block72;
                }
                case 13: {
                    samplerate_anim = bin.readInt();
                    Logger.log(this.getClass(), "samplerate anim:" + samplerate_anim);
                    continue block72;
                }
                case 10: {
                    fps = bin.readInt();
                    continue block72;
                }
                case 12: {
                    int frames = bin.readInt();
                    myscene.animLength = (float)frames / (float)fps;
                    Logger.log(this.getClass(), "frames:" + frames);
                    continue block72;
                }
                case 601: {
                    String temp;
                    tempMaterial.settings.title = temp = bin.readString(numElements);
                    tempMaterial.title = temp;
                    continue block72;
                }
                case 605: {
                    tempMaterial.settings.opacity = bin.readFloat();
                    continue block72;
                }
                case 611: {
                    tempMaterial.settings.selfillumination = bin.readFloat();
                    continue block72;
                }
                case 606: {
                    tempMaterial.settings.twosided = true;
                    continue block72;
                }
                case 607: {
                    tempMaterial.settings.faceted = true;
                    continue block72;
                }
                case 608: {
                    tempMaterial.settings.wireframe = true;
                    continue block72;
                }
                case 602: {
                    tempMaterial.settings.setDiffuse(bin.readFloatArray(numElements));
                    continue block72;
                }
                case 604: {
                    tempMaterial.settings.setSpecular(bin.readFloatArray(numElements));
                    continue block72;
                }
                case 603: {
                    tempMaterial.settings.setAmbient(bin.readFloatArray(numElements));
                    continue block72;
                }
                case 610: {
                    tempMaterial.settings.setGlossiness(bin.readFloatArray(numElements));
                    continue block72;
                }
                case 600: {
                    tempMaterial.id = bin.readInt();
                    continue block72;
                }
                case 632: {
                    tempTextureMap = new TextureMap(632);
                    continue block72;
                }
                case 637: {
                    tempTextureMap = new TextureMap(637);
                    continue block72;
                }
                case 640: {
                    tempTextureMap = new TextureMap(640);
                    continue block72;
                }
                case 645: {
                    String[] s = Files.getPathFilename(bin.readString(numElements));
                    s[0] = s[0].replace("\ufffd", "ue");
                    s[1] = s[1].replace("\ufffd", "ue");
                    tempTextureMap.texture = (textureFile)Project.getProject().getResourceManager().add(s[0], s[1]);
                    continue block72;
                }
                case 660: {
                    if (tempTextureMap.type == 632) {
                        tempMaterial.settings.mapDiffuse = tempTextureMap;
                    }
                    if (tempTextureMap.type == 637) {
                        tempMaterial.settings.mapOpacity = tempTextureMap;
                    }
                    if (tempTextureMap.type != 640) continue block72;
                    tempMaterial.settings.mapReflection = tempTextureMap;
                    continue block72;
                }
                case 699: {
                    myscene.materials.add(tempMaterial);
                    tempMaterial = new Material();
                    continue block72;
                }
                case 403: {
                    tempCam.setName(bin.readString(numElements));
                    continue block72;
                }
                case 401: {
                    float[] f = bin.readFloatArray(numElements);
                    tempCam.eye.x.change(0.0f, Float.valueOf(f[0]));
                    tempCam.eye.y.change(0.0f, Float.valueOf(f[1]));
                    tempCam.eye.z.change(0.0f, Float.valueOf(f[2]));
                    continue block72;
                }
                case 405: {
                    float fov = bin.readFloat();
                    tempCam.fov = fov * 0.5625f * 1.05f;
                    continue block72;
                }
                case 402: {
                    float[] ff = bin.readFloatArray(numElements);
                    tempCam.target.x.change(0.0f, Float.valueOf(ff[0]));
                    tempCam.target.y.change(0.0f, Float.valueOf(ff[1]));
                    tempCam.target.z.change(0.0f, Float.valueOf(ff[2]));
                    continue block72;
                }
                case 449: {
                    Camera n = tempCam;
                    n.setEnabled(false);
                    myscene.rootnode.addChild(tempCam);
                    tempCam = new Camera();
                    continue block72;
                }
                case 407: {
                    tempCam.target = MeshObject.getKeyFramedVertex(samplerate_anim, fps, bin.readFloatArray(numElements));
                    continue block72;
                }
                case 408: {
                    tempCam.eye = MeshObject.getKeyFramedVertex(samplerate_anim, fps, bin.readFloatArray(numElements));
                    continue block72;
                }
                case 451: {
                    tempLight.setName(bin.readString(numElements));
                    continue block72;
                }
                case 453: {
                    tempLight.setColorDiffuse(bin.readFloatArray(numElements));
                    continue block72;
                }
                case 455: {
                    tempLight.posAnim = MeshObject.getKeyFramedVertex(samplerate_anim, fps, bin.readFloatArray(numElements));
                    continue block72;
                }
                case 452: {
                    float[] fff = bin.readFloatArray(numElements);
                    tempLight.pos.put(fff).rewind();
                    continue block72;
                }
                case 499: {
                    myscene.rootnode.addChild(tempLight);
                    tempLight = new Light();
                    continue block72;
                }
                case 750: {
                    tempShape = new BSpline();
                    tempShape.setResolution(5);
                    tempShape.setEnabled(false);
                    continue block72;
                }
                case 752: {
                    System.out.println("numElements" + numElements);
                    tempShape.setPoints(bin.readFloatArray(numElements));
                    continue block72;
                }
                case 751: {
                    tempShape.setName(bin.readString(numElements));
                    continue block72;
                }
                case 754: {
                    tempShape.rotation.set(bin.readFloatArray(numElements));
                    continue block72;
                }
                case 755: {
                    tempShape.scale.set(bin.readFloatArray(numElements));
                    continue block72;
                }
                case 753: {
                    tempShape.pos.set(bin.readFloatArray(numElements));
                    continue block72;
                }
                case 780: {
                    myscene.rootnode.addChild(tempShape);
                    if (tempShape.getName().contains("_psystem")) {
                        ParticleSystem ps = new ParticleSystem();
                        ps.setName(tempShape.getName());
                        ps.emiterStartPos = tempShape.getPoints().get(0);
                        ps.emiterEndPos = tempShape.getPoints().get(1);
                        myscene.rootnode.addChild(ps);
                    }
                    tempShape.closed = false;
                    continue block72;
                }
                case 200: {
                    tempMeshObject = new MeshObject();
                    currentframeMeshAnim = -1;
                    continue block72;
                }
                case 201: {
                    tempMeshObject.setName(bin.readString(numElements));
                    continue block72;
                }
                case 215: {
                    tempMeshObject.wireColor.set(bin.readFloatArray(numElements));
                    continue block72;
                }
                case 307: {
                    currentframeMeshAnim = bin.readInt();
                    continue block72;
                }
                case 301: {
                    if (currentframeMeshAnim == -1) {
                        tempMesh.setVertices(bin.readFloatArray(numElements));
                        continue block72;
                    }
                    AnimVerts v = new AnimVerts();
                    float[] fverts = bin.readFloatArray(numElements);
                    v.setVertices(fverts);
                    tempMesh.setVertices(fverts);
                    tempMesh.animVertices.add(v);
                    tempMesh.animStep.change((float)currentframeMeshAnim / (float)fps, Float.valueOf(tempMesh.animVertices.size() - 1));
                    continue block72;
                }
                case 216: {
                    if (chunkTYPE == 5) {
                        Logger.log(this.getClass(), "normals as bytes not supported");
                        System.exit(1);
                        continue block72;
                    }
                    if (currentframeMeshAnim == -1) {
                        tempMesh.setNormals(bin.readFloatArray(numElements));
                        continue block72;
                    }
                    AnimVerts v = new AnimVerts();
                    float[] fverts = bin.readFloatArray(numElements);
                    v.setVertices(fverts);
                    tempMesh.setNormals(fverts);
                    tempMesh.animNormals.add(v);
                    continue block72;
                }
                case 302: {
                    tempMesh.setFaces(bin.readShortArray(numElements));
                    continue block72;
                }
                case 308: {
                    continue block72;
                }
                case 303: {
                    if (tempMesh.materialIDs == null) {
                        tempMesh.materialIDs = new ArrayList();
                    }
                    tempMesh.materialIDs.add(new Vec1i(bin.readInt()));
                    continue block72;
                }
                case 305: {
                    tempMesh.setTextureCoords(bin.readFloatArray(numElements));
                    continue block72;
                }
                case 306: {
                    tempMesh.setTextureFaces(bin.readShortArray(numElements));
                    continue block72;
                }
                case 223: {
                    tempMeshObject.scaleAnim = MeshObject.getKeyFramedVertex(samplerate_anim, fps, bin.readFloatArray(numElements));
                    continue block72;
                }
                case 217: {
                    tempMeshObject.posAnim = MeshObject.getKeyFramedVertex(samplerate_anim, fps, bin.readFloatArray(numElements));
                    continue block72;
                }
                case 202: {
                    tempMeshObject.pos.set(bin.readFloatArray(numElements));
                    continue block72;
                }
                case 204: {
                    tempMeshObject.scale.set(bin.readFloatArray(numElements));
                    continue block72;
                }
                case 203: {
                    tempMeshObject.rotation.set(bin.readFloatArray(numElements));
                    continue block72;
                }
                case 350: {
                    tempMeshObject.addMesh(tempMesh);
                    tempMesh = new Mesh();
                    continue block72;
                }
                case 299: {
                    myscene.rootnode.addChild(tempMeshObject);
                    continue block72;
                }
                case 219: {
                    float[] fv = bin.readFloatArray(numElements);
                    tempMeshObject.visibilityTrack = MeshObject.getKeyFramedFloat(samplerate_anim, fps, fv);
                    continue block72;
                }
                case 218: {
                    tempMeshObject.rotationAnim = MeshObject.getKeyFramedQuaternion(samplerate_anim, fps, bin.readFloatArray(numElements));
                    continue block72;
                }
            }
            try {
                for (int i = 0; i < size; ++i) {
                    bin.myReadByte();
                }
            }
            catch (Exception e) {
                Logger.log(this.getClass(), e);
            }
        }
        float max = 0.0f;
        float min = 0.0f;
        myscene.setCam(0);
        if (myscene.getLight() == null) {
            myscene.setShadows(false);
        }
        for (NodeIF n : myscene.rootnode.childs) {
            if (n.getNodeType() == 3) {
                Camera c = (Camera)n;
                if (c.eye.x.getValue() > max) {
                    max = c.eye.x.getValue();
                }
                if (c.eye.y.getValue() > max) {
                    max = c.eye.y.getValue();
                }
                if (c.eye.z.getValue() > max) {
                    max = c.eye.z.getValue();
                }
                if (c.target.x.getValue() > max) {
                    max = c.target.x.getValue();
                }
                if (c.target.y.getValue() > max) {
                    max = c.target.y.getValue();
                }
                if (c.target.z.getValue() > max) {
                    max = c.target.z.getValue();
                }
                if (c.eye.x.getValue() < min) {
                    min = c.eye.x.getValue();
                }
                if (c.eye.y.getValue() < min) {
                    min = c.eye.y.getValue();
                }
                if (c.eye.z.getValue() < min) {
                    min = c.eye.z.getValue();
                }
                if (c.target.x.getValue() < min) {
                    min = c.target.x.getValue();
                }
                if (c.target.y.getValue() < min) {
                    min = c.target.y.getValue();
                }
                if (c.target.z.getValue() < min) {
                    min = c.target.z.getValue();
                }
            }
            if (n.getNodeType() != 1) continue;
            MeshObject obj = (MeshObject)n;
            for (Mesh m : obj.meshes) {
                for (int i = 0; i < m.vertices.length; ++i) {
                    if (m.vertices[i].x + obj.pos.x > max) {
                        max = m.vertices[i].x + obj.pos.x;
                    }
                    if (m.vertices[i].y + obj.pos.y > max) {
                        max = m.vertices[i].y + obj.pos.y;
                    }
                    if (m.vertices[i].z + obj.pos.z > max) {
                        max = m.vertices[i].z + obj.pos.z;
                    }
                    if (m.vertices[i].x + obj.pos.x < min) {
                        min = m.vertices[i].x + obj.pos.x;
                    }
                    if (m.vertices[i].y + obj.pos.y < min) {
                        min = m.vertices[i].y + obj.pos.y;
                    }
                    if (!(m.vertices[i].z + obj.pos.z < min)) continue;
                    min = m.vertices[i].z + obj.pos.z;
                }
                boolean foundmaterial = false;
                for (Material mat : myscene.materials) {
                    if (m.materialIDs == null) continue;
                    for (Vec1i materialID : m.materialIDs) {
                        if (materialID.x != mat.id) continue;
                        if (mat.settings.opacity != 1.0f) {
                            obj.setOrder(199);
                        }
                        if (mat.title.contains("_last")) {
                            obj.setOrder(200);
                        }
                        if (mat.title.contains("_last2")) {
                            obj.setOrder(220);
                        }
                        if (m.materials == null) {
                            m.materials = new ArrayList();
                        }
                        m.materials.add(mat);
                        foundmaterial = true;
                    }
                }
                if (foundmaterial) continue;
                Logger.log(this.getClass(), obj.getName() + " material not found!!!!!!!");
            }
        }
        timer.stop();
        float zfar = Math.abs(min) + Math.abs(max);
        zfar += zfar * 0.5f;
        for (NodeIF n : myscene.rootnode.childs) {
            if (n.getNodeType() != 3) continue;
            ((Camera)n).zfar = zfar;
        }
        Logger.log(this.getClass(), "zfar:" + zfar);
        return myscene;
    }
}

