/*
 * Decompiled with CFR 0.152.
 */
package sumo.v3d.mesh;

import org.lwjgl.opengl.GL11;
import sumo.v3d.math.VEC3Tweened;
import sumo.v3d.math.Vec3f;
import sumo.v3d.mesh.Mesh;
import sumo.v3d.mesh.MeshObject;

public class BoundingBoxAA {
    public float maxx = -1.0E9f;
    public float maxy = -1.0E9f;
    public float maxz = -1.0E9f;
    public float miny = 9.999999E7f;
    public float minx = 9.999999E7f;
    public float minz = 1.0E8f;
    String name = "";

    public String getName() {
        return this.name;
    }

    public void calc(MeshObject obj) {
        this.calc(obj, true);
    }

    public void calc(MeshObject obj, boolean absolute) {
        this.maxx = -1.0E9f;
        this.maxy = -1.0E9f;
        this.maxz = -1.0E9f;
        this.miny = 9.999999E7f;
        this.minx = 9.999999E7f;
        this.minz = 1.0E8f;
        this.name = obj.getName();
        float px = 0.0f;
        float py = 0.0f;
        float pz = 0.0f;
        if (absolute) {
            px = obj.pos.x;
            py = obj.pos.y;
            pz = obj.pos.z;
        }
        for (Mesh mesh : obj.meshes) {
            if (mesh.vertices.length == 0) {
                return;
            }
            for (int i = 0; i < mesh.vertices.length; ++i) {
                if (mesh.vertices[i].x * obj.scale.x > this.maxx) {
                    this.maxx = mesh.vertices[i].x * obj.scale.x;
                }
                if (mesh.vertices[i].y * obj.scale.y > this.maxy) {
                    this.maxy = mesh.vertices[i].y * obj.scale.y;
                }
                if (mesh.vertices[i].z * obj.scale.z > this.maxz) {
                    this.maxz = mesh.vertices[i].z * obj.scale.z;
                }
                if (mesh.vertices[i].x * obj.scale.x < this.minx) {
                    this.minx = mesh.vertices[i].x * obj.scale.x;
                }
                if (mesh.vertices[i].y * obj.scale.y < this.miny) {
                    this.miny = mesh.vertices[i].y * obj.scale.y;
                }
                if (!(mesh.vertices[i].z * obj.scale.z < this.minz)) continue;
                this.minz = mesh.vertices[i].z * obj.scale.z;
            }
        }
        this.maxx += px;
        this.minx += px;
        this.maxy += py;
        this.miny += py;
        this.maxz += pz;
        this.minz += pz;
    }

    public void render() {
        this.render(1.0f);
    }

    public void render(float w) {
        GL11.glPointSize((float)10.0f);
        GL11.glColor3f((float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glLineWidth((float)w);
        GL11.glBegin((int)3);
        GL11.glVertex3f((float)this.maxx, (float)this.maxy, (float)this.maxz);
        GL11.glVertex3f((float)this.minx, (float)this.maxy, (float)this.maxz);
        GL11.glVertex3f((float)this.minx, (float)this.miny, (float)this.maxz);
        GL11.glVertex3f((float)this.maxx, (float)this.miny, (float)this.maxz);
        GL11.glVertex3f((float)this.maxx, (float)this.maxy, (float)this.maxz);
        GL11.glEnd();
        GL11.glBegin((int)3);
        GL11.glVertex3f((float)this.maxx, (float)this.maxy, (float)this.minz);
        GL11.glVertex3f((float)this.minx, (float)this.maxy, (float)this.minz);
        GL11.glVertex3f((float)this.minx, (float)this.miny, (float)this.minz);
        GL11.glVertex3f((float)this.maxx, (float)this.miny, (float)this.minz);
        GL11.glVertex3f((float)this.maxx, (float)this.maxy, (float)this.minz);
        GL11.glEnd();
        GL11.glBegin((int)1);
        GL11.glVertex3f((float)this.maxx, (float)this.maxy, (float)this.minz);
        GL11.glVertex3f((float)this.maxx, (float)this.maxy, (float)this.maxz);
        GL11.glVertex3f((float)this.maxx, (float)this.miny, (float)this.minz);
        GL11.glVertex3f((float)this.maxx, (float)this.miny, (float)this.maxz);
        GL11.glVertex3f((float)this.minx, (float)this.maxy, (float)this.minz);
        GL11.glVertex3f((float)this.minx, (float)this.maxy, (float)this.maxz);
        GL11.glVertex3f((float)this.minx, (float)this.miny, (float)this.minz);
        GL11.glVertex3f((float)this.minx, (float)this.miny, (float)this.maxz);
        GL11.glVertex3f((float)this.maxx, (float)this.maxy, (float)this.minz);
        GL11.glVertex3f((float)this.minx, (float)this.maxy, (float)this.maxz);
        GL11.glVertex3f((float)this.maxx, (float)this.miny, (float)this.minz);
        GL11.glVertex3f((float)this.minx, (float)this.miny, (float)this.maxz);
        GL11.glVertex3f((float)this.minx, (float)this.maxy, (float)this.minz);
        GL11.glVertex3f((float)this.maxx, (float)this.maxy, (float)this.maxz);
        GL11.glVertex3f((float)this.minx, (float)this.miny, (float)this.minz);
        GL11.glVertex3f((float)this.maxx, (float)this.miny, (float)this.maxz);
        GL11.glVertex3f((float)this.maxx, (float)this.miny, (float)this.minz);
        GL11.glVertex3f((float)this.maxx, (float)this.maxy, (float)this.maxz);
        GL11.glVertex3f((float)this.maxx, (float)this.maxy, (float)this.minz);
        GL11.glVertex3f((float)this.maxx, (float)this.miny, (float)this.maxz);
        GL11.glVertex3f((float)this.minx, (float)this.miny, (float)this.minz);
        GL11.glVertex3f((float)this.minx, (float)this.maxy, (float)this.maxz);
        GL11.glVertex3f((float)this.minx, (float)this.maxy, (float)this.minz);
        GL11.glVertex3f((float)this.minx, (float)this.miny, (float)this.maxz);
        GL11.glEnd();
    }

    public boolean collisiontestXYZ(VEC3Tweened pos) {
        return pos.x.getValue() > this.minx && pos.x.getValue() < this.maxx && pos.y.getValue() > this.miny && pos.y.getValue() < this.maxy && pos.z.getValue() > this.minz && pos.z.getValue() < this.maxz;
    }

    public boolean collisiontestXYZ(VEC3Tweened pos, Vec3f addPos) {
        return pos.x.getValue() > this.minx + addPos.x && pos.x.getValue() < this.maxx + addPos.x && pos.y.getValue() > this.miny + addPos.y && pos.y.getValue() < this.maxy + addPos.y && pos.z.getValue() > this.minz + addPos.z && pos.z.getValue() < this.maxz + addPos.z;
    }

    public boolean collisiontestXY(VEC3Tweened pos) {
        return pos.x.getValue() > this.minx && pos.x.getValue() < this.maxx && pos.y.getValue() > this.miny && pos.y.getValue() < this.maxy;
    }

    public float getMaxZ() {
        return this.maxz;
    }

    public String toString() {
        return this.minx + "," + this.miny;
    }

    public float getWidth() {
        return this.maxx - this.minx;
    }
}

