/*
 * Decompiled with CFR 0.152.
 */
package sumo.v3d.mesh;

import java.util.ArrayList;
import java.util.List;
import org.lwjgl.opengl.GL11;
import sumo.keyframing.KeyframedFloat;
import sumo.project.Project;
import sumo.v3d.Node;
import sumo.v3d.NodeIF;
import sumo.v3d.math.Matrix4;
import sumo.v3d.math.QuaterionKeyframed;
import sumo.v3d.math.Quaternion;
import sumo.v3d.math.VEC3Tweened;
import sumo.v3d.math.Vec3f;
import sumo.v3d.math.Vec3fkeyframed;
import sumo.v3d.mesh.BoundingBoxAA;
import sumo.v3d.mesh.Mesh;

public class MeshObject
extends Node
implements NodeIF {
    public Vec3f wireColor = new Vec3f(1.0f, 0.0f, 0.0f);
    public Vec3f scale = new Vec3f(1.0f, 1.0f, 1.0f);
    public Vec3f pos = new Vec3f();
    public Vec3fkeyframed posAnim = null;
    public VEC3Tweened posAdd = null;
    public Quaternion rotation = new Quaternion();
    public QuaterionKeyframed rotationAnim = null;
    public List<Mesh> meshes = new ArrayList<Mesh>();
    public KeyframedFloat visibilityTrack;
    public Vec3fkeyframed scaleAnim;
    Matrix4 tempRotMatrix = null;
    public boolean renderBoundingBox = false;
    public BoundingBoxAA boundingBoxAA = null;
    public boolean wildrotate = false;
    public float wildrotateOffset = 0.0f;

    public MeshObject() {
        this.type = 1;
        this.setOrder(100);
    }

    public void addMesh(Mesh m) {
        m.setName(this.getName() + " mesh");
        this.meshes.add(m);
    }

    public void render(float time) {
        if (this.wildrotate) {
            GL11.glPushMatrix();
            GL11.glRotatef((float)(this.wildrotateOffset + time * 30.0f), (float)this.pos.x, (float)this.pos.y, (float)this.pos.z);
        }
        if (this.visibilityTrack != null && this.visibilityTrack.getValue(time) < 1.0f) {
            return;
        }
        GL11.glPushMatrix();
        if (this.posAnim == null) {
            this.pos.glTranslate();
        } else {
            this.posAnim.glTranslate(time);
        }
        if (this.posAdd != null) {
            this.posAdd.glTranslate(Project.getProject().getTime());
        }
        if (this.rotationAnim == null) {
            if (this.tempRotMatrix == null) {
                this.tempRotMatrix = this.rotation.getMatrix();
            }
            this.tempRotMatrix.glMulMatrix();
        } else {
            this.rotationAnim.getMatrix(time).glMulMatrix();
        }
        if (this.scaleAnim == null) {
            if ((double)this.scale.x != 1.0 || (double)this.scale.y != 1.0 || (double)this.scale.z != 1.0) {
                GL11.glScalef((float)this.scale.x, (float)this.scale.y, (float)this.scale.z);
            }
        } else {
            this.scaleAnim.glScale(time);
        }
        for (Mesh m : this.meshes) {
            m.render(time);
        }
        if (this.scaleAnim != null || (double)this.scale.x != 1.0 || (double)this.scale.y != 1.0 || (double)this.scale.z != 1.0) {
            GL11.glScalef((float)1.0f, (float)1.0f, (float)1.0f);
        }
        GL11.glPopMatrix();
        if (this.wildrotate) {
            GL11.glPopMatrix();
        }
    }

    public static QuaterionKeyframed getKeyFramedQuaternion(int samplerate, int fps, float[] f) {
        QuaterionKeyframed anim = new QuaterionKeyframed();
        for (int i = 0; i < f.length / 4; ++i) {
            float time = (float)samplerate * (float)i / (float)fps;
            anim.x.change(time, Float.valueOf(f[i * 4 + 0]));
            anim.y.change(time, Float.valueOf(f[i * 4 + 1]));
            anim.z.change(time, Float.valueOf(f[i * 4 + 2]));
            anim.w.change(time, Float.valueOf(f[i * 4 + 3]));
        }
        return anim;
    }

    public static Vec3fkeyframed getKeyFramedVertex(int samplerate, int fps, float[] f) {
        Vec3fkeyframed anim = new Vec3fkeyframed();
        for (int i = 0; i < f.length / 3; ++i) {
            float time = (float)samplerate * (float)i / (float)fps;
            anim.x.change(time, Float.valueOf(f[i * 3 + 0]));
            anim.y.change(time, Float.valueOf(f[i * 3 + 1]));
            anim.z.change(time, Float.valueOf(f[i * 3 + 2]));
        }
        return anim;
    }

    public static KeyframedFloat getKeyFramedFloat(int samplerate, int fps, float[] f) {
        KeyframedFloat anim = new KeyframedFloat();
        anim.setDefaultInterpolationMode((short)1);
        anim.setKeyframingEnabled(true);
        for (int i = 0; i < f.length; ++i) {
            float time = (float)samplerate * (float)i / (float)fps;
            anim.change(time, Float.valueOf(f[i]));
        }
        return anim;
    }

    public void glScale() {
        this.scale.glScale();
    }

    public MeshObject getInstance() {
        MeshObject newObj = new MeshObject();
        newObj.name = this.name;
        newObj.wireColor = this.wireColor;
        newObj.meshes = this.meshes;
        newObj.scale = new Vec3f(this.scale.x, this.scale.y, this.scale.z);
        newObj.pos = new Vec3f(this.pos.x, this.pos.y, this.pos.z);
        newObj.rotation = new Quaternion(this.rotation.getX(), this.rotation.getY(), this.rotation.getZ(), this.rotation.getW());
        newObj.rotationAnim = this.rotationAnim;
        return newObj;
    }

    public BoundingBoxAA getBoundingBoxAA() {
        return this.boundingBoxAA;
    }

    public void createBoundingBoxAA() {
        if (this.boundingBoxAA == null) {
            this.boundingBoxAA = new BoundingBoxAA();
        }
        this.boundingBoxAA.calc(this, true);
    }
}

