/*
 * Decompiled with CFR 0.152.
 */
package sumo.v3d.particleSystem;

import org.lwjgl.opengl.GL11;
import sumo.resource.types.textureFile;
import sumo.util.freeTimer;
import sumo.v3d.Node;
import sumo.v3d.NodeIF;
import sumo.v3d.math.Vec3f;
import sumo.v3d.particleSystem.Particle;

public class ParticleSystem
extends Node
implements NodeIF {
    Particle[] particles = new Particle[500];
    freeTimer timer = new freeTimer();
    public static final int RENDERMODE_POINTS = 0;
    public static final int RENDERMODE_TEXTUREBILLBOARD = 1;
    float particleSize = 1.0f;
    private int rendermode = 0;
    public Vec3f emiterStartSize = new Vec3f(0.1f, 0.1f, 0.1f);
    public Vec3f emiterEndSize = new Vec3f(4.0f, 4.0f, 4.0f);
    public Vec3f emiterEndPos = new Vec3f(4.0f, 1.0f, 1.0f);
    public Vec3f emiterStartPos = new Vec3f(0.0f, 0.0f, 0.0f);
    float lifetime = 10.0f;
    float speedVariance = 0.8f;
    private float emitFreq;
    public textureFile currenTexture = null;
    private float fadeOut = 0.8f;
    private float alpha;
    private float speed = 10.0f;
    private int rotated = 0;
    private int numParticles = 500;

    public ParticleSystem() {
        this.initParticles();
        this.type = 6;
        this.setOrder(990);
    }

    private void initParticles() {
        for (int i = 0; i < this.particles.length; ++i) {
            this.particles[i] = new Particle();
            this.initParticle(i, 0.0f);
            float f = (float)Math.random();
            float endvaluex = this.particles[i].pos.x.getValue(this.particles[i].pos.x.getKeys()[1].getTime());
            float endvaluey = this.particles[i].pos.x.getValue(this.particles[i].pos.y.getKeys()[1].getTime());
            float endvaluez = this.particles[i].pos.x.getValue(this.particles[i].pos.z.getKeys()[1].getTime());
            float endtime = this.particles[i].pos.x.getKeys()[1].getTime();
            this.particles[i].pos.x.clear();
            this.particles[i].pos.x.setValue(0.0f, endvaluex * f);
            this.particles[i].pos.x.setValue(endtime * f, endvaluex);
            this.particles[i].pos.y.clear();
            this.particles[i].pos.y.setValue(0.0f, endvaluey * f);
            this.particles[i].pos.y.setValue(endtime * f, endvaluey);
            this.particles[i].pos.z.clear();
            this.particles[i].pos.z.setValue(0.0f, endvaluey * f);
            this.particles[i].pos.z.setValue(endtime * f, endvaluey);
        }
    }

    private void initParticle(int i, float startTime) {
        this.particles[i].dead = false;
        this.particles[i].pos.clear();
        this.particles[i].pos.x.setValue(startTime, this.emiterStartPos.x + (float)Math.random() * this.emiterStartSize.x - this.emiterStartSize.x / 2.0f);
        this.particles[i].pos.y.setValue(startTime, this.emiterStartPos.y + (float)Math.random() * this.emiterStartSize.y - this.emiterStartSize.y / 2.0f);
        this.particles[i].pos.z.setValue(startTime, this.emiterStartPos.z + (float)Math.random() * this.emiterStartSize.z - this.emiterStartSize.z / 2.0f);
        float speedy = (float)Math.random() * this.speedVariance;
        float lifeTimeVariance = 0.8f * (float)Math.random();
        this.particles[i].pos.x.setValue(startTime + this.lifetime * this.speed * lifeTimeVariance, this.emiterEndPos.x + speedy * ((float)Math.random() * this.emiterEndSize.x - this.emiterEndSize.x / 2.0f));
        this.particles[i].pos.y.setValue(startTime + this.lifetime * this.speed * lifeTimeVariance, this.emiterEndPos.y + speedy * ((float)Math.random() * this.emiterEndSize.y - this.emiterEndSize.y / 2.0f));
        this.particles[i].pos.z.setValue(startTime + this.lifetime * this.speed * lifeTimeVariance, this.emiterEndPos.z + speedy * ((float)Math.random() * this.emiterEndSize.z - this.emiterEndSize.z / 2.0f));
        this.particles[i].endTime = startTime + this.lifetime * this.speed * lifeTimeVariance;
        this.particles[i].size = this.particleSize * (float)Math.random() + this.particleSize * 0.7f;
        this.particles[i].alpha.clear(this.alpha);
        this.particles[i].alpha.set(startTime, 0.0f, 2);
        this.particles[i].alpha.set(startTime + 1.0f, this.alpha, 2);
        this.particles[i].alpha.set(startTime + this.lifetime * this.speed * lifeTimeVariance * this.fadeOut, this.alpha, 2);
        this.particles[i].alpha.set(startTime + this.lifetime * this.speed * lifeTimeVariance, 0.0f, 2);
    }

    public void render(float time) {
        if (this.rendermode == -1) {
            return;
        }
        time = this.timer.getTime();
        if (this.rendermode == 0) {
            for (int i = 0; i < this.particles.length; ++i) {
                textureFile.enable();
                if (this.currenTexture != null) {
                    GL11.glEnable((int)3553);
                    GL11.glBindTexture((int)3553, (int)this.currenTexture.getID());
                }
                if (this.particles[i].dead) continue;
                this.particles[i].render(time);
            }
        } else if (this.rendermode == 1 && this.currenTexture != null) {
            textureFile.enable();
            this.currenTexture.bind();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2884);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glDepthMask((boolean)false);
            for (int i = 0; i < this.particles.length; ++i) {
                if (this.particles[i].dead) continue;
                this.particles[i].drawBillBoard(time, this.currenTexture.width);
            }
            GL11.glDepthMask((boolean)true);
        }
        this.reInitParticle(time);
    }

    private void reInitParticle(float time) {
        float deadRatio = (float)this.getNumDeadParticles() / (float)this.particles.length;
        int ind = this.getDeadParticle();
        if (ind != -1) {
            this.initParticle(ind, time);
        }
    }

    private int getDeadParticle() {
        for (int i = 0; i < this.particles.length; ++i) {
            if (!this.particles[i].dead) continue;
            return i;
        }
        return -1;
    }

    int getNumDeadParticles() {
        int count = 0;
        for (int i = 0; i < this.particles.length; ++i) {
            if (!this.particles[i].dead) continue;
            ++count;
        }
        return count;
    }

    public void setEmmitFrequency(float emit) {
        this.emitFreq = 1.0f;
        if ((int)((1.0f - emit) * 500.0f) != this.numParticles) {
            this.particles = new Particle[(int)((1.0f - emit) * 500.0f)];
            this.numParticles = (int)((1.0f - emit) * 500.0f);
            this.initParticles();
        }
    }

    public void setSpeedVariance(float speedVar) {
        this.speedVariance = speedVar;
    }

    public void setRenderMode(int intValue) {
        this.rendermode = intValue;
    }

    public void setFadeOut(float value) {
        this.fadeOut = value;
    }

    public void setAlpha(float value) {
        this.alpha = value;
    }

    public void setParticleSize(float f) {
        this.particleSize = f;
    }

    public void setSpeed(float f) {
        this.speed = f;
    }

    public void setRotated(int intValue) {
        this.rotated = intValue;
        for (int i = 0; i < this.particles.length; ++i) {
            this.particles[i].rotated = intValue;
        }
    }
}

