#!/usr/bin/ruby

for i in (1 .. 20)
	iname = 'pic-%02d.scr' % i
	oname = 'pic-%02d.dat' % i

	buf = File.open(iname, 'rb') { |fi| fi.read }
	res = ''

	for y in (0 .. 13)
		addr = (y / 8).to_i * 0x800 + (y % 8) * 32

		for l in (0 .. 7)
			for x in (0 .. 17)
				xor_val = (buf[0x1800 + y * 32 + x] == 0x79 ? 0xFF : 0x00)
				res += (buf[addr + x + l * 0x100] ^ xor_val).chr
			end
		end
	end

	File.open(oname, 'wb') { |fo| fo << res }
end
