#!/usr/bin/ruby

require 'RMagick'

# black
# red
# white
# blue
# green
# yellow
# magenta

class PixFontMaker
	def find_one_path(bx, by, x, y)
		loop do
			@char << (y - by)
			@char << (x - bx)
			brk = (@data[y][x] == 'blue')
			@data[y][x] = ''

			break if brk
			avail = []
			v = 1

			['white', 'yellow', 'blue'].each do |color|
				avail << [y+1, x, v+0] if @data[y+1][x] == color
				avail << [y, x-1, v+1] if @data[y][x-1] == color
				avail << [y-1, x, v+2] if @data[y-1][x] == color
				avail << [y, x+1, v+3] if @data[y][x+1] == color

				avail << [y-1, x-1, v+4] if @data[y-1][x-1] == color
				avail << [y-1, x+1, v+5] if @data[y-1][x+1] == color
				avail << [y+1, x+1, v+6] if @data[y+1][x+1] == color
				avail << [y+1, x-1, v+7] if @data[y+1][x-1] == color

				v += 8
			end

			if avail.empty?
				puts "Error at #{x},#{y}"
				break
			end

			avail.sort! { |a,b| a[2] <=> b[2] }

			y = avail[0][0]
			x = avail[0][1]
		end
	end

	def find_paths(x, y, w, h)
		puts "Making char at #{x},#{y}"
		@char = [w]

		for i in (y ... (y + h))
			for j in (x ... (x + w))
				if @data[i][j] == 'green'
					find_one_path(x, y, j, i)
				end
			end
		end

		for i in (y ... (y + h))
			for j in (x ... (x + w))
				if @data[i][j] == 'magenta'
					find_one_path(x, y, j, i)
				end
			end
		end

		@result << @char
	end

	def make_one_char(x, y)
		h = 1
		h += 1 while ((y+1+h) < @hgt && @data[y+1+h][x+1] != 'red')

		return if (y + 1 + h) >= @hgt

		w = 1
		w += 1 while (@data[y+1][x+1+w] != 'red')

		find_paths(x+1, y+1, w, h)

		for i in (y .. (y + h))
			for j in (x .. (x + w))
				@data[i][j] = ''
			end
		end
	end

	def make_chars
		for y in (0 .. (@hgt - 2))
			for x in (0 .. (@wdt - 2))
				if @data[y][x] == 'red'
					make_one_char(x, y)
				end
			end
		end
	end

	def make_res_data
		data = ''
		offs = []
		off = 0
		chars = []
		chars += @result[26, 11]
		chars += @result[0, 26]
		ltt = '0123456789:ABCDEFGHIJKLMNOPQRSTUVWXYZ'

		data = ''
		offs = Array.new('Z'[0] - '0'[0] + 1) { 0 }
		off = 0

		chars.each_with_index do |char, idx|
			offs[ltt[idx] - '0'[0]] = off + (offs.size * 2)
			off += char.size + 1

			for i in (1 ... char.size)
				data += char[i].chr
			end

			data += 0xFF.chr
			data += char[0].chr
		end

		res = ''

		offs.each do |off|
			res += (off % 0x100).chr
			res += ((off / 0x100).to_i).chr
		end

		res += data
		return res
	end

	def make(image_name)
		img = Magick::ImageList.new(image_name)

		lt = img.columns
		rt = 0
		tp = img.rows
		bt = 0

		img.each_pixel do |pix, col, row|
			cl = pix.to_color

			if cl == 'red'
				lt = col if col < lt
				rt = col if col > rt
				tp = row if row < tp
				bt = row if row > bt
			end
		end

		@data = []
		@hgt = bt - tp + 1
		@wdt = rt - lt + 1

		img.view(0, 0, img.columns, img.rows) do |view|
			for row in (tp .. bt)
				line = []

				for col in (lt .. rt)
					line << view[row][col].to_color
				end

				@data << line
			end
		end

		@result = []
		make_chars

		return make_res_data
	end
end

pfm = PixFontMaker.new
res = pfm.make('pix-font.png')

File.open('pix-font.dat', 'wb') { |fo| fo << res }
