/*
 * Decompiled with CFR 0.152.
 */
package vitamin;

import java.io.File;
import java.util.Vector;
import javax.media.opengl.GL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import vitamin.Shader;
import vitamin.ShaderCG;
import vitamin.ShaderCGFX;
import vitamin.ShaderGLSL;

public class ShaderManager {
    int _activeShaderIdx;
    Shader _activeShader;
    GL _gl;
    int _numShaders;
    Vector<Shader> _shaders;

    public ShaderManager(GL gl) {
        this._gl = gl;
        this._shaders = new Vector();
        this._numShaders = 0;
        this._activeShader = null;
        this._activeShaderIdx = -1;
    }

    public void enable(int idx) {
        if (this._activeShaderIdx == idx) {
            System.err.println("(ShaderManager)  trying to activate same shader. ignore!");
            return;
        }
        this._activeShaderIdx = idx;
        switch (this._shaders.get((int)idx)._type) {
            case 3: {
                this._activeShader = (ShaderGLSL)this._shaders.get(idx);
                break;
            }
            case 1: {
                this._activeShader = (ShaderCG)this._shaders.get(idx);
                break;
            }
            case 2: {
                this._activeShader = (ShaderCGFX)this._shaders.get(idx);
            }
        }
        this._activeShader.enable();
    }

    public void disable() {
        if (this._activeShader == null) {
            return;
        }
        this._activeShaderIdx = -1;
        this._activeShader.disable();
    }

    public Shader getActiveShader() {
        if (this._activeShader != null) {
            return this._activeShader;
        }
        return null;
    }

    public ShaderCGFX getActiveEffect() {
        if (this._activeShader == null) {
            System.err.println("(ShaderManager)  No active effect!");
            return null;
        }
        if (this._activeShader._type == 2) {
            return (ShaderCGFX)this._activeShader;
        }
        System.err.println("(ShaderManager)  Current active shader is not an cg effect");
        return null;
    }

    public Shader getShaderByIdx(int idx) {
        switch (this._shaders.get((int)idx)._type) {
            case 3: {
                return (ShaderGLSL)this._shaders.get(idx);
            }
            case 1: {
                return (ShaderCG)this._shaders.get(idx);
            }
            case 2: {
                return (ShaderCGFX)this._shaders.get(idx);
            }
        }
        return null;
    }

    public int loadShaderFromXML(String filename) {
        int id = -1;
        try {
            File file = new File(filename);
            if (file.exists()) {
                Element element;
                Node node;
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document doc = db.parse(file);
                doc.getDocumentElement().normalize();
                NodeList nodeList = doc.getElementsByTagName("uniform");
                System.out.println("uniforms: " + nodeList.getLength());
                int i = 0;
                while (i < nodeList.getLength()) {
                    node = nodeList.item(i);
                    System.out.println(node.getNodeName());
                    NamedNodeMap attr = node.getAttributes();
                    int k = 0;
                    while (k < attr.getLength()) {
                        System.out.println("    " + attr.item(k).getNodeName() + ": '" + attr.item(k).getNodeValue() + "'");
                        ++k;
                    }
                    ++i;
                }
                nodeList = doc.getElementsByTagName("vertexshader");
                System.out.println("vertex_shader: " + nodeList.getLength());
                i = 0;
                while (i < nodeList.getLength()) {
                    node = nodeList.item(i);
                    element = (Element)node;
                    NodeList elementList = element.getElementsByTagName("source");
                    System.out.println("pixel_shader / source: " + elementList.getLength());
                    ++i;
                }
                nodeList = doc.getElementsByTagName("pixelshader");
                System.out.println("pixel_shader: " + nodeList.getLength());
                i = 0;
                while (i < nodeList.getLength()) {
                    node = nodeList.item(i);
                    element = (Element)node;
                    NodeList elementList = element.getElementsByTagName("source");
                    System.out.println("pixel_shader / source: " + elementList.getLength());
                    ++i;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return id;
    }

    public int addShader(String name, String vfile, String ffile) {
        int id = -1;
        ShaderGLSL shd = new ShaderGLSL(this._gl, name);
        shd.load(vfile, ffile);
        shd.setId(this._numShaders);
        this._shaders.add(shd);
        id = this._numShaders++;
        return id;
    }

    public int addShader(String name, String vfile, String ffile, String gfile, int input, int output) {
        int id = -1;
        ShaderGLSL shd = new ShaderGLSL(this._gl, name);
        shd.load(vfile, ffile, gfile, input, output);
        shd.setId(this._numShaders);
        this._shaders.add(shd);
        id = this._numShaders++;
        return id;
    }

    public int addShader(Shader shd) {
        shd.setId(this._numShaders);
        this._shaders.add(shd);
        int id = this._numShaders++;
        return id;
    }

    public int addEffect(String name, String file) {
        int id = -1;
        ShaderCGFX shd = new ShaderCGFX(this._gl, name);
        shd.load(file);
        shd.setId(this._numShaders);
        this._shaders.add(shd);
        id = this._numShaders++;
        return id;
    }

    public int addEffect(ShaderCGFX shd) {
        shd.setId(this._numShaders);
        this._shaders.add(shd);
        int id = this._numShaders++;
        return id;
    }

    public void setTextureParameter(String param, int x) {
        if (this._activeShader != null) {
            this._activeShader.setTextureParameter(param, x);
        }
    }

    public void setParameter1f(String param, float x) {
        if (this._activeShader != null) {
            this._activeShader.setParameter1f(param, x);
        }
    }

    public void setParameter2f(String param, float x, float y) {
        if (this._activeShader != null) {
            this._activeShader.setParameter2f(param, x, y);
        }
    }

    public void setParameter2i(String param, int x, int y) {
        if (this._activeShader != null) {
            this._activeShader.setParameter2i(param, x, y);
        }
    }

    public void setParameter3f(String param, float x, float y, float z) {
        if (this._activeShader != null) {
            this._activeShader.setParameter3f(param, x, y, z);
        }
    }

    public void setParameter4f(String param, float x, float y, float z, float w) {
        if (this._activeShader != null) {
            this._activeShader.setParameter4f(param, x, y, z, w);
        }
    }

    public void setParameterSemantic(String param, float x) {
        if (this._activeShader != null) {
            this._activeShader.setParameterSemantic(param, x);
        }
    }

    public void setParameterSemantic(String param, float x, float y) {
        if (this._activeShader != null) {
            this._activeShader.setParameterSemantic(param, x, y);
        }
    }

    public void setParameterSemantic(String param, float x, float y, float z) {
        if (this._activeShader != null) {
            this._activeShader.setParameterSemantic(param, x, y, z);
        }
    }

    public void setParameterSemantic(String param, float x, float y, float z, float w) {
        if (this._activeShader != null) {
            this._activeShader.setParameterSemantic(param, x, y, z, w);
        }
    }

    public void setMatrixParameterSemantic(String param, int matrix, int matrixType) {
        if (this._activeShader == null) {
            return;
        }
        int mat = 0;
        int type = 0;
        if (matrix == 12) {
            mat = 7;
        }
        if (matrix == 0) {
            mat = 4;
        }
        if (matrix == 4) {
            mat = 4;
        }
        if (matrixType == 100) {
            type = 0;
        }
        if (matrixType == 103) {
            type = 3;
        }
        if (matrixType == 101) {
            type = 2;
        }
        if (matrixType == 102) {
            type = 1;
        }
        this._activeShader.setParameter4x4fBySemantic(param, mat, type);
    }

    public void setMatrixParameterSemantic(String param, float[] v) {
        if (this._activeShader == null) {
            return;
        }
        this._activeShader.setMatrixParameterSemantic(param, v);
    }

    public void setParameter4x4fBySemantic(String param, int matrix, int matrixType) {
        if (this._activeShader == null) {
            return;
        }
        int mat = 0;
        int type = 0;
        if (matrix == 12) {
            mat = 7;
        }
        if (matrix == 0) {
            mat = 4;
        }
        if (matrix == 4) {
            mat = 4;
        }
        if (matrixType == 100) {
            type = 0;
        }
        if (matrixType == 103) {
            type = 3;
        }
        if (matrixType == 101) {
            type = 2;
        }
        if (matrixType == 102) {
            type = 1;
        }
        this._activeShader.setParameter4x4fBySemantic(param, mat, type);
    }

    public void setParameter4x4f(String param, int matrix, int matrixType) {
        if (this._activeShader == null) {
            return;
        }
        this._activeShader.setParameter4x4f(param, matrix, matrixType);
    }

    public void setParameter4x4f(String param, float[] v) {
        if (this._activeShader == null) {
            return;
        }
        this._activeShader.setParameter4x4f(param, v);
    }

    public int getNumShaders() {
        return this._numShaders;
    }

    public void release() {
        this._numShaders = 0;
        this._shaders.clear();
        this._activeShaderIdx = -1;
        this._activeShader = null;
        this._gl = null;
    }
}

