/*
 * Decompiled with CFR 0.152.
 */
package vitamin.config;

import java.awt.Point;
import vitamin.config.DisplayModeSelector;
import vitamin.config.OpenGLLayer;

public class VDisplayMode {
    public static boolean FULLSCREEN = true;
    public static boolean WINDOWED = false;
    public static boolean VSYNC_ENABLED = true;
    public static boolean VSYNC_DISABLED = false;
    private Object nativeMode;
    private int width;
    private int height;
    private int bpp;
    private int freq;

    public static int getDefaultBPP() {
        return 24;
    }

    public static int getDefaultFrequency() {
        return 75;
    }

    public Object getNativeMode() {
        return this.nativeMode;
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    public Point getSize() {
        return new Point(this.getWidth(), this.getHeight());
    }

    public float getAspect() {
        return (float)this.getWidth() / (float)this.getHeight();
    }

    public final int getBPP() {
        return this.bpp;
    }

    public final int getFrequency() {
        return this.freq;
    }

    public static VDisplayMode parseDisplayMode(OpenGLLayer layer, String value) throws IllegalArgumentException {
        DisplayModeSelector selector = DisplayModeSelector.getImplementation(layer);
        try {
            String[] modeParts = value.split("x");
            int width = Integer.parseInt(modeParts[0]);
            int height = Integer.parseInt(modeParts[1]);
            int bpp = modeParts[2].equals("?") ? 24 : Integer.parseInt(modeParts[2]);
            int freq = modeParts[3].equals("?") ? 75 : Integer.parseInt(modeParts[3]);
            return selector.getBestMode(width, height, bpp, freq);
        }
        catch (Throwable t) {
            throw new IllegalArgumentException("The String could not be parsed to a DisplayMode", t);
        }
    }

    public String toString() {
        String bpp = this.getBPP() <= 0 ? "?" : String.valueOf(this.getBPP());
        String freq = this.getFrequency() <= 0 ? "?" : String.valueOf(this.getFrequency());
        return String.valueOf(this.getClass().getName()) + " ( Width = " + this.getWidth() + ", Height = " + this.getHeight() + ", BPP = " + bpp + ", Frequency = " + freq + ", Native-Mode: " + (this.nativeMode == null ? "invalid" : "valid") + " )";
    }

    public String toLightString() {
        String bpp = this.getBPP() <= 0 ? "?" : String.valueOf(this.getBPP());
        String freq = this.getFrequency() <= 0 ? "?" : String.valueOf(this.getFrequency());
        return String.valueOf(this.getWidth()) + "x" + this.getHeight() + "x" + bpp + "x" + freq;
    }

    public boolean equals(Object other) {
        if (!(other instanceof VDisplayMode)) {
            return false;
        }
        VDisplayMode otherDM = (VDisplayMode)other;
        if (otherDM.width != this.width) {
            return false;
        }
        if (otherDM.height != this.height) {
            return false;
        }
        if (otherDM.bpp != this.bpp) {
            return false;
        }
        return otherDM.freq == this.freq;
    }

    public VDisplayMode(Object nativeMode, int width, int height, int bpp, int freq) {
        this.nativeMode = nativeMode;
        this.width = width;
        this.height = height;
        this.bpp = bpp;
        this.freq = freq;
    }
}

