/*
 * Decompiled with CFR 0.152.
 */
package vitamin.jsr231;

import com.sun.opengl.util.BufferUtil;
import com.sun.opengl.util.FPSAnimator;
import com.sun.opengl.util.Gamma;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.Frame;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.URL;
import java.nio.IntBuffer;
import javax.imageio.ImageIO;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCanvas;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesChooser;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.glu.GLU;
import vitamin.VGL;
import vitamin.VTimer;
import vitamin.config.FSAA;
import vitamin.config.OpenGLLayer;
import vitamin.jsr231.OldStyleGLCapabilitiesChooser;

public class VGLCanvas
implements GLEventListener {
    private static final int DONT_CARE = -1;
    private static final int RENDER_MODE_CLEAR = 1;
    private static final int RENDER_MODE_DESTROY = 2;
    private GLCapabilities gc;
    private GLCapabilitiesChooser gcc;
    private GLCanvas glCanvas;
    private FPSAnimator _animator;
    private GL gl;
    private GLU glu;
    private Frame frame;
    private int maxTextureSize = 128;
    private int maxTextureUnits = 2;
    private int maxVertexAttributes = 8;
    private Rectangle maxViewport = new Rectangle(-1, -1, -1, -1);
    private boolean isFullscreen;
    private boolean vsync;
    private int depthBufferSize;
    private int swapInterval = -1;
    protected boolean swapIntervalChanged = false;
    private float gamma = 1.0f;
    private float brightness = 0.0f;
    private float contrast = 1.0f;
    protected boolean isGammaChanged = false;
    private int renderMode = 0;
    private boolean isRendering = false;
    private boolean initialized = false;
    private Window window;
    private boolean closeRequested = false;
    VGL vgl;
    VTimer timer;

    public void setup() {
        System.out.println("setup()");
        this.gl.glShadeModel(7425);
        this.gl.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        this.gl.glClearDepth(1.0);
        this.gl.glEnable(2929);
        this.gl.glDepthFunc(515);
        this.gl.glHint(3152, 4354);
    }

    public void draw() {
        System.out.println("draw()");
        float time = this.timer.getCurrTime();
        this.timer.update();
        System.out.println("time: " + time);
        this.gl.glClearColor(1.0f, 0.0f, 0.0f, 1.0f);
        this.gl.glClear(16640);
        this.gl.glMatrixMode(5889);
        this.gl.glLoadIdentity();
        this.glu.gluPerspective(45.0, 1.3333333333333333, 1.0, 1000.0);
        this.gl.glMatrixMode(5888);
        this.gl.glLoadIdentity();
        this.glu.gluLookAt(0.0, 0.0, 500.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0);
        this.gl.glRotatef(time * 10.0f, 0.0f, 1.0f, 0.0f);
        this.gl.glBegin(7);
        this.gl.glColor4f(1.0f, 0.0f, 1.0f, 1.0f);
        this.gl.glVertex3f(0.0f, 0.0f, 0.0f);
        this.gl.glVertex3f(100.0f, 0.0f, 0.0f);
        this.gl.glVertex3f(100.0f, 100.0f, 0.0f);
        this.gl.glVertex3f(0.0f, 100.0f, 0.0f);
        this.gl.glEnd();
    }

    public void stop() {
        System.out.println("stop()");
    }

    static void pkgInfo(ClassLoader classLoader, String pkgName, String className) {
        try {
            classLoader.loadClass(String.valueOf(pkgName) + "." + className);
            Package p = Package.getPackage(pkgName);
            if (p == null) {
                System.out.println("WARNING: Package.getPackage(" + pkgName + ") is null");
            } else {
                System.out.println(p);
                System.out.println("Specification Title = " + p.getSpecificationTitle());
                System.out.println("Specification Vendor = " + p.getSpecificationVendor());
                System.out.println("Specification Version = " + p.getSpecificationVersion());
                System.out.println("Implementation Vendor = " + p.getImplementationVendor());
                System.out.println("Implementation Version = " + p.getImplementationVersion());
            }
        }
        catch (ClassNotFoundException e) {
            System.out.println("Unable to load " + pkgName);
        }
        System.out.println();
    }

    public VGLCanvas(Object owner, int width, int height, boolean fullscreen, boolean vsync, FSAA fsaa, int depthBufferSize) {
        ClassLoader classLoader = this.getClass().getClassLoader();
        VGLCanvas.pkgInfo(classLoader, "javax.media.opengl", "GL");
        try {
            System.setProperty("org.xith3d.render.jsr231.displayGLInfos", String.valueOf(false));
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        this.setDepthBufferSize(depthBufferSize);
        this.gc = new GLCapabilities();
        this.gc.setStencilBits(8);
        this.gc.setDepthBits(depthBufferSize);
        if (fsaa != FSAA.OFF) {
            this.gc.setSampleBuffers(true);
        }
        this.gc.setNumSamples(fsaa.getIntValue());
        this.gcc = new OldStyleGLCapabilitiesChooser();
        this.glCanvas = new GLCanvas(this.gc, this.gcc, null, null);
        this.glCanvas.setBounds(0, 0, width, height);
        this.setVSyncEnabled(vsync);
        this.isFullscreen = fullscreen;
        this.glCanvas.setAutoSwapBufferMode(true);
        this.glCanvas.addGLEventListener((GLEventListener)this);
        this.glCanvas.setFocusable(true);
        this.gl = this.glCanvas.getGL();
        this.glu = new GLU();
        this.clear();
        if (owner == null) {
            this.frame = new Frame("Xith3D (JOGL)");
            this.frame.setLayout(null);
            if (fullscreen) {
                this.frame.setBackground(Color.DARK_GRAY);
            }
            this.frame.setUndecorated(fullscreen);
            this.frame.setSize(width, height);
            this.setWindow(this.frame);
            this.frame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    VGLCanvas.this.closeRequested = true;
                }
            });
            boolean exclusive = fullscreen;
            this.frame.add((Component)this.glCanvas);
            this.frame.setVisible(true);
            if (!exclusive) {
                Dimension frameSize;
                Thread.yield();
                if (!fullscreen) {
                    Insets insets = this.frame.getInsets();
                    this.glCanvas.setLocation(insets.left, insets.top);
                    frameSize = new Dimension(width + insets.left + insets.right, height + insets.top + insets.bottom);
                    this.frame.setSize(frameSize);
                } else {
                    frameSize = new Dimension(width, height);
                }
                Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                Point upperLeft = new Point((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
                this.frame.setLocation(upperLeft);
            } else {
                GraphicsDevice graphDev = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
                DisplayMode[] displayModes = graphDev.getDisplayModes();
                int i = 0;
                while (i < displayModes.length) {
                    System.out.println("Device display modes: " + displayModes[i].getWidth() + "x" + displayModes[i].getHeight() + "x" + displayModes[i].getBitDepth() + "x" + displayModes[i].getRefreshRate());
                    ++i;
                }
                DisplayMode awtMode = this.findDisplayMode(displayModes, width, height, graphDev.getDisplayMode().getBitDepth(), graphDev.getDisplayMode().getRefreshRate());
                System.out.println("******* DisplayMode info: " + awtMode.getWidth() + ", " + awtMode.getHeight() + ", " + awtMode.getBitDepth() + ", " + awtMode.getRefreshRate());
                graphDev.setFullScreenWindow(this.frame);
                graphDev.setDisplayMode(awtMode);
            }
        } else {
            this.glCanvas.setBounds(0, 0, width, height);
            ((Container)owner).add((Component)this.glCanvas);
        }
        this._animator = new FPSAnimator((GLAutoDrawable)this.glCanvas, 60, true);
        this._animator.setRunAsFastAsPossible(true);
        this._animator.start();
        this.vgl = new VGL(this.gl, this.glu, width, height);
        this.timer = new VTimer();
        this.timer.start();
    }

    private DisplayMode findDisplayMode(DisplayMode[] displayModes, int requestedWidth, int requestedHeight, int requestedDepth, int requestedRefreshRate) {
        System.out.println("Try to find exact match for displaymode...");
        DisplayMode displayMode = this.findDisplayModeInternal(displayModes, requestedWidth, requestedHeight, requestedDepth, requestedRefreshRate);
        if (displayMode == null) {
            System.out.println("Exact math for displaymode not found.. try ignoring bit depth and refresh rate");
            displayMode = this.findDisplayModeInternal(displayModes, requestedWidth, requestedHeight, -1, -1);
        }
        if (displayMode == null) {
            System.out.println("Exact math for displaymode not found.. try ignoring height, bit depth and refresh rate");
            displayMode = this.findDisplayModeInternal(displayModes, requestedWidth, -1, -1, -1);
        }
        if (displayMode == null) {
            System.out.println("Exact math for displaymode not found.. try ignoring everything. just pick anyone");
            displayMode = this.findDisplayModeInternal(displayModes, -1, -1, -1, -1);
        }
        return displayMode;
    }

    private DisplayMode findDisplayModeInternal(DisplayMode[] displayModes, int requestedWidth, int requestedHeight, int requestedDepth, int requestedRefreshRate) {
        int index = 0;
        DisplayMode displayModeToUse = null;
        int i = 0;
        while (i < displayModes.length) {
            DisplayMode displayMode = displayModes[i];
            if (!(requestedWidth != -1 && displayMode.getWidth() != requestedWidth || requestedHeight != -1 && displayMode.getHeight() != requestedHeight || requestedHeight != -1 && displayMode.getRefreshRate() != requestedRefreshRate || requestedDepth != -1 && displayMode.getBitDepth() != requestedDepth)) {
                displayModeToUse = displayMode;
                index = i;
            }
            ++i;
        }
        System.out.println("Picked displaymode: " + index);
        System.out.println("* DisplayMode info: " + displayModeToUse.getWidth() + ", " + displayModeToUse.getHeight() + ", " + displayModeToUse.getBitDepth() + ", " + displayModeToUse.getRefreshRate());
        return displayModeToUse;
    }

    public final void init(GLAutoDrawable drawable) {
        System.out.println("init()");
        this.gl = this.glCanvas.getGL();
        if (this.glu == null) {
            this.glu = new GLU();
        }
        int[] depth_bits = new int[1];
        this.getGL().glGetIntegerv(3414, depth_bits, 0);
        this.setDepthBufferSize(depth_bits[0]);
        this.getGL().glViewport(0, 0, this.getWidth(), this.getHeight());
        IntBuffer intBuffer = BufferUtil.newIntBuffer((int)2);
        this.getGL().glGetIntegerv(3379, intBuffer);
        this.setMaxTextureSize(intBuffer.get());
        System.out.println("maxTextureSize: " + this.maxTextureSize);
        intBuffer.rewind();
        this.getGL().glGetIntegerv(34018, intBuffer);
        this.setMaxTextureUnits(intBuffer.get());
        System.out.println("maxTextureUnits: " + this.maxTextureUnits);
        intBuffer.rewind();
        this.getGL().glGetIntegerv(3386, intBuffer);
        this.maxViewport.setBounds(0, 0, intBuffer.get(0), intBuffer.get(1));
        System.out.println("maxViewport: " + this.maxViewport.width + ", " + this.maxViewport.height);
        intBuffer.rewind();
        this.getGL().glGetIntegerv(34921, intBuffer);
        this.setMaxVertexAttributes(intBuffer.get());
        System.out.println("maxVertexAttributes: " + this.maxVertexAttributes);
        this.initialized = true;
    }

    public OpenGLLayer getType() {
        return OpenGLLayer.JOGL_AWT;
    }

    protected final void setMaxTextureSize(int size) {
        this.maxTextureSize = size;
    }

    public final int getMaxTextureSize() {
        return this.maxTextureSize;
    }

    protected final void setMaxTextureUnits(int units) {
        this.maxTextureUnits = units;
    }

    public final int getMaxTextureUnits() {
        return this.maxTextureUnits;
    }

    protected final void setMaxVertexAttributes(int num) {
        this.maxVertexAttributes = num;
    }

    public final int getMaxVertexAttributes() {
        return this.maxVertexAttributes;
    }

    protected void setDepthBufferSize(int size) {
        this.depthBufferSize = size;
    }

    public final int getDepthBufferSize() {
        return this.depthBufferSize;
    }

    public void setGammaImpl(float gamma, float brightness, float contrast) {
        if (brightness < -1.0f || brightness > 1.0f) {
            throw new IllegalArgumentException("brightness must be in range [-1.0, +1.0]");
        }
        if (contrast < 0.0f || contrast > 1.0f) {
            throw new IllegalArgumentException("contrast must be in range [0.0, +1.0]");
        }
        this.gamma = gamma;
        this.brightness = brightness;
        this.contrast = contrast;
        this.isGammaChanged = true;
    }

    public float getGamma() {
        return this.gamma;
    }

    public float getBrightness() {
        return this.brightness;
    }

    public float getContrast() {
        return this.contrast;
    }

    public final void setSwapInterval(int swapInterval) {
        this.swapInterval = swapInterval;
        this.swapIntervalChanged = true;
    }

    public final int getSwapInterval() {
        return this.swapInterval;
    }

    public void setVSyncEnabled(boolean vsync) {
        this.setVsync(vsync);
        this.setSwapInterval(vsync ? 1 : 0);
    }

    public void setVsync(boolean vsync) {
        this.vsync = vsync;
    }

    public boolean isVsync() {
        return this.vsync;
    }

    public final GL getGL() {
        return this.gl;
    }

    protected final void setWindow(Window w) {
        this.window = w;
    }

    public final Window getWindow() {
        return this.window;
    }

    public final Component getComponent() {
        return this.glCanvas;
    }

    public void setIcon(URL iconResource) {
        assert (this.window instanceof Frame) : "Window isn't a Frame";
        try {
            ((Frame)this.window).setIconImage(ImageIO.read(iconResource));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public final void setTitle(String title) {
        if (this.window != null) {
            assert (this.window instanceof Frame) : "Window isn't a Frame";
            ((Frame)this.window).setTitle(title);
        }
    }

    public final String getTitle() {
        if (this.window != null) {
            assert (this.window instanceof Frame) : "Window isn't a Frame";
            return ((Frame)this.window).getTitle();
        }
        return "";
    }

    public final boolean setLocation(int x, int y) {
        if (this.window.getLocation().x != x || this.window.getLocation().y != y) {
            this.window.setLocation(x, y);
            return true;
        }
        return false;
    }

    public final int getLeft() {
        return this.glCanvas.getLocationOnScreen().x;
    }

    public final int getTop() {
        return this.glCanvas.getLocationOnScreen().y;
    }

    public final boolean setSize(int width, int height) {
        if (this.glCanvas.getSize().width != width || this.glCanvas.getSize().height != height) {
            this.glCanvas.setSize(width, height);
            if (this.getWindow() != null) {
                Insets insets = this.getWindow().getInsets();
                this.glCanvas.setLocation(insets.left, insets.top);
                Dimension frameSize = new Dimension(width + insets.left + insets.right, height + insets.top + insets.bottom);
                this.getWindow().setSize(frameSize);
            }
            return true;
        }
        return false;
    }

    public final int getWidth() {
        return this.glCanvas.getWidth();
    }

    public final int getHeight() {
        return this.glCanvas.getHeight();
    }

    protected boolean setDisplayModeImpl(DisplayMode displayMode) {
        boolean result = true;
        this.setSize(displayMode.getWidth(), displayMode.getHeight());
        return true;
    }

    void setupGL(GL gl) {
    }

    public final void reshape(GLAutoDrawable drawable, int x, int y, int width, int height) {
        System.out.println("reshape()");
        this.initialized = false;
        this.gl = drawable.getGL();
        if (this.glu == null) {
            this.glu = new GLU();
        }
        ((GLCanvas)drawable).repaint();
        this.gl.glViewport(0, 0, width, height);
        this.gl.glMatrixMode(5889);
        this.gl.glLoadIdentity();
        this.glu.gluPerspective(45.0, (double)((float)width / (float)height), 1.0, 2000.0);
        this.gl.glMatrixMode(5888);
        this.gl.glLoadIdentity();
        this.setup();
        this.initialized = true;
    }

    public void setGamma(float gamma, float brightness, float contrast) {
        this.setGammaImpl(gamma, brightness, contrast);
        try {
            Gamma.setDisplayGamma((float)gamma, (float)brightness, (float)contrast);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public final void displayChanged(GLAutoDrawable drawable, boolean modeChanged, boolean deviceChanged) {
        System.out.println("displayChanged()");
    }

    protected void setAutoSwapBufferMode(boolean mode) {
        this.glCanvas.setAutoSwapBufferMode(mode);
    }

    public final boolean isRendering() {
        return this.isRendering;
    }

    public void beforeThreadChanged() {
    }

    public final void display(GLAutoDrawable drawable) {
        if (!this.initialized) {
            return;
        }
        this.isRendering = true;
        if (this.closeRequested) {
            this.closeRequested = false;
            this.closeAndDestroy();
        }
        this.gl = drawable.getGL();
        if (this.swapIntervalChanged) {
            this.swapIntervalChanged = false;
            this.gl.setSwapInterval(this.getSwapInterval());
        }
        this.draw();
        this.isRendering = false;
    }

    public void clear() {
        System.out.println("clear()");
        this.renderMode |= 1;
        this.glCanvas.display();
    }

    public void destroy() {
        System.out.println("destroy()");
        if ((this.renderMode & 2) == 0) {
            this.renderMode |= 3;
            if (this.isGammaChanged) {
                try {
                    Gamma.resetDisplayGamma();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            this.glCanvas.display();
        } else if (this.getWindow() != null) {
            this.getWindow().dispose();
        }
        this.stop();
    }

    public void closeAndDestroy() {
        try {
            try {
                this._animator.stop();
                if (this.isFullscreen) {
                    GraphicsDevice graphDev = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
                    graphDev.setFullScreenWindow(null);
                }
                this.frame.dispose();
            }
            catch (Exception e) {
                System.err.println("(VGLCanvas)  " + e);
                System.exit(0);
            }
        }
        finally {
            System.exit(0);
        }
    }

    public void dispose(GLAutoDrawable arg0) {
    }
}

