/*
 * Decompiled with CFR 0.152.
 */
package vitamin.math;

public class WaveFunction {
    static final int SINE = 0;
    static final int TRIANGLE = 1;
    static final int SQUARE = 2;
    static final int SAWTOOTH = 3;
    public int _type;
    public float _amplitude;
    public float _frequency;
    public float _phase;
    public float _offset;
    public float _result;

    public WaveFunction() {
        this._type = 0;
        this._amplitude = 1.0f;
        this._frequency = 1.0f;
        this._phase = 0.0f;
        this._offset = 0.0f;
        this._result = 0.0f;
    }

    public WaveFunction(int type, float amp, float freq, float phase, float offset) {
        this._type = type;
        this._amplitude = amp;
        this._frequency = freq;
        this._phase = phase;
        this._offset = offset;
        this._result = 0.0f;
    }

    public float update(float time) {
        float timeFact = this._frequency * (time - this._phase);
        timeFact -= (float)((int)timeFact);
        switch (this._type) {
            case 0: {
                this._result = (float)Math.sin(Math.PI * 2 * (double)timeFact);
                break;
            }
            case 1: {
                if (timeFact < 0.25f) {
                    this._result = 4.0f * timeFact;
                    break;
                }
                if (timeFact < 0.75f) {
                    this._result = 2.0f - 4.0f * timeFact;
                    break;
                }
                this._result = 4.0f * timeFact - 4.0f;
                break;
            }
            case 2: {
                if (timeFact < 0.5f) {
                    this._result = 1.0f;
                    break;
                }
                this._result = -1.0f;
                break;
            }
            case 3: {
                this._result = 2.0f * timeFact - 1.0f;
                break;
            }
            default: {
                this._result = 1.0f;
            }
        }
        this._result = this._amplitude * this._result + this._offset;
        return this._result;
    }

    public void setParams(float amp, float freq, float phase, float offset) {
        this._amplitude = amp;
        this._frequency = freq;
        this._phase = phase;
        this._offset = offset;
    }

    public float getResult() {
        return this._result;
    }

    public int getType() {
        return this._type;
    }
}

