import java.nio.*;
import javax.media.opengl.*;
//import com.sun.opengl.util.*;
import processing.opengl.*;


//
// based on article: http://ogltotd.blogspot.com/2006/12/render-to-texture.html
//

class FBO
{
  FBO( int wid, int hei )
  {
    _gl = vgl.gl();

/*    int[] maxAttach = new int[1];
    maxAttach[0] = 0;
    _gl.glGetIntegerv( GL.GL_MAX_RENDERBUFFER_SIZE_EXT, maxAttach, 0 );
    println( "maxattach: " + maxAttach[0] );
    int[] colorBufferCount = new int[1];
    colorBufferCount[0] = 0;
    _gl.glGetIntegerv( GL.GL_MAX_COLOR_ATTACHMENTS_EXT, colorBufferCount, 0 );
    println( "max colorbuffers attachments: " + colorBufferCount[0] );*/
   
    _width = wid;
    _height = hei;
  }
  
  FBO( int wid, int hei, int texTarget, int colorAttachment, int depthAttachment, int texId )
  {
    _gl = vgl.gl();
    
    _width = wid;
    _height = hei;
    
    init();
    bind();
    attachTexture( colorAttachment, texTarget, texId );
    if( depthAttachment != 0 ) attachRenderBuffer( depthAttachment );
    drawBuffer( 0 );
    validate();
    disable();
  }

  FBO( XTexture tex, int texTarget, int colorAttachment, int depthAttachment )
  {
    _gl = vgl.gl();
    
    _width = tex.getWidth();
    _height = tex.getHeight();
    
    init();
    bind();
    attachTexture( colorAttachment, texTarget, tex.getId() );
    if( depthAttachment != 0 ) attachRenderBuffer( depthAttachment );
    drawBuffer( 0 );
    validate();
    disable();
  }


  FBO( VTexture2D tex, int texTarget, int colorAttachment, int depthAttachment )
  {
    _gl = vgl.gl();
    
    _width = tex.getWidth();
    _height = tex.getHeight();
    
    init();
    bind();
    attachTexture( colorAttachment, texTarget, tex.getId() );
    if( depthAttachment != 0 ) attachRenderBuffer( depthAttachment );
    drawBuffer( 0 );
    validate();
    disable();
  }
  
  void init()
  {
    FBO = new int[1];
    FBO[0] = 0;
    
    _gl.glGenFramebuffersEXT( 1, FBO, 0 );   
    errcheck();
    println( "FBO id: " + FBO[0] );
    //bind();
    //errcheck();    
  }

  void bind()
  { 
    _gl.glBindFramebufferEXT( GL.GL_FRAMEBUFFER_EXT, FBO[0] );
    errcheck();
  }

  void unbind()
  {
    _gl.glBindFramebufferEXT( GL.GL_FRAMEBUFFER_EXT, 0 );
    errcheck();
  }

  void disable()
  {
    _gl.glBindFramebufferEXT( GL.GL_FRAMEBUFFER_EXT, 0 );
    errcheck();
  }

  void attachTexture( int attachment, int texTarget, int texId )
  {
    _gl.glFramebufferTexture2DEXT( GL.GL_FRAMEBUFFER_EXT, attachment, texTarget, texId, 0 ); 
    errcheck();
  }

  void attachRenderBuffer( int attachment )
  {
    depthStencilBuffer = new int[1];
    depthStencilBuffer[0] = 0; 

    // initialize depth+stencil renderbuffer
    _gl.glGenRenderbuffersEXT( 1, depthStencilBuffer, 0 );    
    errcheck();
    println( "RB id: " + depthStencilBuffer[0] );

    _gl.glBindRenderbufferEXT( GL.GL_RENDERBUFFER_EXT, depthStencilBuffer[0] );
    errcheck();
    _gl.glRenderbufferStorageEXT( GL.GL_RENDERBUFFER_EXT, attachment, _width, _height );
    errcheck();
    _gl.glFramebufferRenderbufferEXT( GL.GL_FRAMEBUFFER_EXT, GL.GL_DEPTH_ATTACHMENT_EXT, GL.GL_RENDERBUFFER_EXT, depthStencilBuffer[0] );
    errcheck();

    // Shader id with stencil buffer
//    _gl.glBindRenderbufferEXT( GL.GL_RENDERBUFFER_EXT, depthStencilBuffer[0] );
//    _gl.glFramebufferRenderbufferEXT( GL.GL_FRAMEBUFFER_EXT, GL.GL_STENCIL_ATTACHMENT_EXT, GL.GL_RENDERBUFFER_EXT, depthStencilBuffer[0] );
  }

  void validate()
  {
/*    // Enable both attachments as draw buffers
    int[] drawbuffers = { GL.GL_COLOR_ATTACHMENT0_EXT, GL.GL_COLOR_ATTACHMENT1_EXT };
    _gl.glDrawBuffers( 2, drawbuffers, 0 );
*/
    int stat = _gl.glCheckFramebufferStatusEXT( GL.GL_FRAMEBUFFER_EXT );
    switch( stat )
    {
      case GL.GL_FRAMEBUFFER_COMPLETE_EXT:
        println( "GL_FRAMEBUFFER_COMPLETE_EXT" );
        break;
      case GL.GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT_EXT:
        println( "GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT_EXT" );
        break;
      case GL.GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT_EXT:
        println( "GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT_EXT" );
        break;
      case GL.GL_FRAMEBUFFER_INCOMPLETE_DIMENSIONS_EXT:
        println( "GL_FRAMEBUFFER_INCOMPLETE_DIMENSIONS_EXT" );
        break;
      case GL.GL_FRAMEBUFFER_INCOMPLETE_FORMATS_EXT:
        println( "GL_FRAMEBUFFER_INCOMPLETE_FORMATS_EXT" );
        break;
      case GL.GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER_EXT:
        println( "GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER_EXT" );
        break;
      case GL.GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER_EXT:
        println( "GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER_EXT" );
        break;
      case GL.GL_FRAMEBUFFER_UNSUPPORTED_EXT:
        println( "GL_FRAMEBUFFER_UNSUPPORTED_EXT" );
        break;
      default:
        println( "Unknown" );
        break;
    }
    
    println( "FBO created: " + _width + " x " + _height );
  }

  void drawBuffer( int idx )
  {
    if( idx == -1 )
    {
      // No color buffer to draw to or read from
      _gl.glDrawBuffer( GL.GL_NONE );
      _gl.glReadBuffer( GL.GL_NONE );
    }
    else if( idx == 0 )
    {
      _gl.glDrawBuffer( GL.GL_COLOR_ATTACHMENT0_EXT );			 // Draw into the first texture     
    }
    else if( idx == 1 )
    {
      _gl.glDrawBuffer( GL.GL_COLOR_ATTACHMENT1_EXT );			 // Draw into the second texture     
    }
  }

  void restoreDrawBuffer()
  {
      _gl.glReadBuffer( GL.GL_BACK );
      _gl.glDrawBuffer( GL.GL_BACK );
//      _gl.glDrawBuffer( GL.GL_FRONT );
//      _gl.glReadBuffer( GL.GL_FRONT );
  }

  void delete()
  {
//    if( _fboID )
      _gl.glDeleteFramebuffersEXT( 1, FBO, 0 );
    
//    if( _depthBufferID )
      _gl.glDeleteRenderbuffersEXT( 1, depthStencilBuffer, 0 );
  }

  int getWidth()
  {
    return _width;
  }
  
  int getHeight()
  {
    return _width;
  }

  void errcheck()
  {
    int errCode = vgl.gl().glGetError();
    if( errCode != GL.GL_NO_ERROR ) 
    {
      String errString = vgl.glu().gluErrorString( errCode );
      //fprintf (stderr, "OpenGL Error: %s\n", errString);
      println( errString );
      exit();
    }
  }


  //
  // Members
  //
  private GL _gl; 
  
  private int[] FBO;
  private int[] depthStencilBuffer;   
  
  private int _width;
  private int _height;  
};
