import vitamin.math.*;


class GroundQuad
{
  GroundQuad( Vector3 center, float rad, int texIdx, float startTime )
  {
      
      _startTime = startTime;
      
    _radius = rad;
    
    _fftIndex = (int)random(numOfBands);
    
    _texIdx = texIdx;
    
    _center = center.clone();
    
    
    float ybias = 0.2;
    _vertices = new Vector3[4];
//    for( int i=0; i<4; i++ )
//      _vertices[i] = new Vector3();
    _vertices[0] = new Vector3();    //_center.clone();
    _vertices[0].add( -rad, 0+ybias, -rad );
    _vertices[1] = new Vector3();    //_center.clone();
    _vertices[1].add( rad, 0+ybias, -rad );
    _vertices[2] = new Vector3();    //_center.clone();
    _vertices[2].add( rad, 0+ybias, rad );
    _vertices[3] = new Vector3();    //_center.clone();
    _vertices[3].add( -rad, 0+ybias, rad );
    
    _texcoords = new Vector2[4];
    
    int rand = (int)random(0, 100 );
    if( rand > 50 )
    {
        _texcoords[0] = new Vector2( 0, 0 );
        _texcoords[1] = new Vector2( 1, 0 );
        _texcoords[2] = new Vector2( 1, 1 );
        _texcoords[3] = new Vector2( 0, 1 );
    }
    else
    {
        _texcoords[0] = new Vector2( 1, 0 );
        _texcoords[1] = new Vector2( 1, 1 );
        _texcoords[2] = new Vector2( 0, 1 );
        _texcoords[3] = new Vector2( 0, 0 );
    }
    
//    int rnd = (int)random( _colors.size() );
//    _color = (Color4)_colors.get( rnd );
    _color = new Color4( random(0.15, 1), random(0.15, 1), random(0.15, 1), 0.1 );    // 0.85 );
    _origColor = _color.copy();
    
    _angle = 0;//random( 0, 360 );
  }


  void draw( float time )
  {
/*    vgl.fill( _color.r, _color.g, _color.b, _color.a );

    vgl.beginShape( eFaceType.QUADS );
    vgl.setColor( _color.r, _color.g, _color.b, _color.a );
//    vgl.setColor( vgl._r, vgl._g, vgl._b, vgl._a );
//    vgl.texcoord( 0, 0 );
    vgl.vertex( _vertices[0] );
//    vgl.texcoord( 1, 0 );
    vgl.vertex( _vertices[1] );
//    vgl.texcoord( 1, 1 );
    vgl.vertex( _vertices[2] );
//    vgl.texcoord( 0, 1 );
    vgl.vertex( _vertices[3] );
    vgl.endShape();     */

    float texCoordScale = 1;
//    float texCoordScale = 14*4;

//    float s = 0.8 + random(-0.1, 0.2);
//    _angle += timer.getFrameTime() * 30;
//    if( _angle >= 360.0 ) _angle = 0;

    vgl.pushMatrix();
//    vgl.translate( -_center.x, -_center.y, -_center.z );
    vgl.translate( _center.x, _center.y, _center.z );
    vgl.rotateY( _angle );


    // Whitening the quads on the camera zoom out effect
    float camZoomTime = ((3*60)+9);
    if( time > camZoomTime )
    {
        _color.r += timer.getFrameTime() * 0.2;
        _color.g += timer.getFrameTime() * 0.2;
        _color.b += timer.getFrameTime() * 0.2;
        _color.a += timer.getFrameTime() * 0.02;
    }
    else
    {
        float tt = MathUtils.clamp( ((time-_startTime)*0.5), 0, 1 );
        _color.a = (_origColor.a + sq(ffthelper.bandmax[(_fftIndex%numOfBands)])*2500.0) * tt;
    }


    vgl.gl().glBegin( GL.GL_QUADS );
    vgl.gl().glTexCoord2f( _texcoords[0].x*texCoordScale, _texcoords[0].y*texCoordScale );
    vgl.gl().glColor4f( _color.r, _color.g, _color.b, _color.a );    
    vgl.gl().glVertex3f( _vertices[0].x, _vertices[0].y, _vertices[0].z );

    vgl.gl().glTexCoord2f( _texcoords[1].x*texCoordScale, _texcoords[1].y*texCoordScale );
    vgl.gl().glColor4f( _color.r, _color.g, _color.b, _color.a );    
    vgl.gl().glVertex3f( _vertices[1].x, _vertices[1].y, _vertices[1].z );

    vgl.gl().glTexCoord2f( _texcoords[2].x*texCoordScale, _texcoords[2].y*texCoordScale );
    vgl.gl().glColor4f( _color.r, _color.g, _color.b, _color.a );    
    vgl.gl().glVertex3f( _vertices[2].x, _vertices[2].y, _vertices[2].z );

    vgl.gl().glTexCoord2f( _texcoords[3].x*texCoordScale, _texcoords[3].y*texCoordScale );
    vgl.gl().glColor4f( _color.r, _color.g, _color.b, _color.a );    
    vgl.gl().glVertex3f( _vertices[3].x, _vertices[3].y, _vertices[3].z );
    vgl.gl().glEnd();
    
    vgl.popMatrix();
  }
  
  
  
    //
    // Members
    //
    
    float _startTime;
  
    Color4 _origColor;
    Color4 _color;
    
    Vector3 _center;
    float _radius;
    Vector3[] _vertices;
    Vector2[] _texcoords;
    int _texIdx;
    float _angle;
    
    int _fftIndex;
}
