import vitamin.scenesimple.*;

public class MeshShatterProcessor
{

    MeshShatterProcessor( Mesh mesh )
    {
        _triangleCenters = new ArrayList();
        _triangleVelocities = new ArrayList();
//        _triangleList = new ArrayList();
        _vertexList = new ArrayList();
        _normalList = new ArrayList();
        _tangentList = new ArrayList();
        _texCoordList = new ArrayList();

        // Get triangle list
//        _triangleList = mesh.getTriList();


        //
        // Create new shatter mesh
        //
        StandardMaterial smat = new StandardMaterial( "mat1" );
        
        _mesh = new Mesh( "shattermesh" );
        _mesh.setMaterial( smat );
        _mesh.processChunks();

        
        // anything below this base value is not added to shatter mesh.
        // I do it so the base of the mesh isn't part of the shatter effect when i make the box shatter+float
        float base = 1.0;
        
        // Grab all vertices (per triangle) into new mesh list
        int index = 0;
        for( int ti=0; ti<mesh.getTriangleCount(); ti++ )
        {
            Triangle tri = (Triangle)mesh.getTriangle( ti );

            Vertex vert0 = mesh.getVertex( tri.getIdx( 0 ) ).copy();
            Vertex vert1 = mesh.getVertex( tri.getIdx( 1 ) ).copy();
            Vertex vert2 = mesh.getVertex( tri.getIdx( 2 ) ).copy();


            //
            // Create a new mesh where each triangle has its own vertices (not shared)
            // To really shatter an object we can't share vertices as each tri must have its own
            //
            //if( vert0.getPosition().y >= base && vert1.getPosition().y >= base && vert1.getPosition().y >= base )
            {
                _mesh.addVertex( vert0 );
                _mesh.addVertex( vert1 );
                _mesh.addVertex( vert2 );
                _mesh.addTriangle( index*3+0, index*3+1, index*3+2 );
                index++;

                //
                // Save data to buffers
                //
                // vertex position
                _vertexList.add( vert0.getPosition().copy() );
                _vertexList.add( vert1.getPosition().copy() );
                _vertexList.add( vert2.getPosition().copy() );
                // normal
                _normalList.add( vert0.getNormal().copy() );
                _normalList.add( vert1.getNormal().copy() );
                _normalList.add( vert2.getNormal().copy() );
                // tangent
                _tangentList.add( vert0.getTangent().copy() );
                _tangentList.add( vert1.getTangent().copy() );
                _tangentList.add( vert2.getTangent().copy() );
            }
        }
        
        
        //
        // Compute center points (pivot) for each triangle
        // This could be the center point of each triangle, but i choose to add some random offset for some un-centered rotation
        //
        for( int ti=0; ti<_mesh.getTriangleCount(); ti++ )
        {
            Triangle tri = (Triangle)_mesh.getTriangle( ti );


            //
            // Compute center for triangle
            //            
            // some random offset
            Vector3 randOffset = Vector3.randomVector();
            randOffset.mul( random(1, 10) );

            Vector3 center = _mesh.getVertex( tri.getIdx( 0 ) ).getPosition().copy();
            center.add( _mesh.getVertex( tri.getIdx( 1 ) ).getPosition() );
            center.add( _mesh.getVertex( tri.getIdx( 2 ) ).getPosition() );
            center.add( randOffset );
            center.div( 3.0 );
            
            
            //
            // Compute velocity vector
            //
            Vector3 randVel = Vector3.randomVector();
            randVel.mul( center.length() * random(10));


            //
            // We need this center point for each vertex of the triangle, hence save 3 copies
            //
            _triangleCenters.add( center );
            _triangleCenters.add( center );
            _triangleCenters.add( center );


            //
            // We need this velocity vector for each vertex of the triangle, hence save 3 copies
            //
            _triangleVelocities.add( randVel );
            _triangleVelocities.add( randVel );
            _triangleVelocities.add( randVel );
        }
    }



	public void render( GL gl )
	{
		// Assign material
		if( _mesh._mat != null )
		{
                                    boolean hasTex = true;
			            int i = 0;
				    gl.glBegin( GL.GL_TRIANGLES );

                                    int count = 0;
				    for( i=0; i<_mesh.getTriangleCount(); i++ )
				    {
				    	    Triangle t = (Triangle)_mesh.getTriangle( i );

				    	    Vertex v0 = (Vertex)_mesh.getVertex( t.getIdx(0) );
					    Vertex v1 = (Vertex)_mesh.getVertex( t.getIdx(1) );
					    Vertex v2 = (Vertex)_mesh.getVertex( t.getIdx(2) );

                                            Vector3 center0 = (Vector3)_triangleCenters.get( count+0 );
                                            Vector3 center1 = (Vector3)_triangleCenters.get( count+1 );
                                            Vector3 center2 = (Vector3)_triangleCenters.get( count+2 );
                                            Vector3 vel0 = (Vector3)_triangleVelocities.get( count+0 );
                                            Vector3 vel1 = (Vector3)_triangleVelocities.get( count+1 );
                                            Vector3 vel2 = (Vector3)_triangleVelocities.get( count+2 );

					    gl.glColor4f( v0.getColor().x, v0.getColor().y, v0.getColor().z, v0.getColor().w );
					    gl.glNormal3f( v0.getNormal().x, v0.getNormal().y, v0.getNormal().z );
					    if( hasTex ) gl.glTexCoord2f( v0.getTexCoord().x, v0.getTexCoord().y );
					    gl.glMultiTexCoord3f( GL.GL_TEXTURE1, v0.getTangent().x, v0.getTangent().y, v0.getTangent().z ); 
					    gl.glMultiTexCoord3f( GL.GL_TEXTURE2, center0.x, center0.y, center0.z ); 
					    gl.glMultiTexCoord3f( GL.GL_TEXTURE3, vel0.x, vel0.y, vel0.z ); 
					    gl.glVertex3f( v0.getPosition().x, v0.getPosition().y, v0.getPosition().z );

					    gl.glColor4f( v1.getColor().x, v1.getColor().y, v1.getColor().z, v1.getColor().w );
					    gl.glNormal3f( v1.getNormal().x, v1.getNormal().y, v1.getNormal().z );
					    if( hasTex ) gl.glTexCoord2f( v1.getTexCoord().x, v1.getTexCoord().y );
					    gl.glMultiTexCoord3f( GL.GL_TEXTURE1, v1.getTangent().x, v1.getTangent().y, v1.getTangent().z ); 
					    gl.glMultiTexCoord3f( GL.GL_TEXTURE2, center1.x, center1.y, center1.z ); 
					    gl.glMultiTexCoord3f( GL.GL_TEXTURE3, vel1.x, vel1.y, vel1.z );
					    gl.glVertex3f( v1.getPosition().x, v1.getPosition().y, v1.getPosition().z );

					    gl.glColor4f( v2.getColor().x, v2.getColor().y, v2.getColor().z, v2.getColor().w );
					    gl.glNormal3f( v2.getNormal().x, v2.getNormal().y, v2.getNormal().z );
					    if( hasTex ) gl.glTexCoord2f( v2.getTexCoord().x, v2.getTexCoord().y );
					    gl.glMultiTexCoord3f( GL.GL_TEXTURE1, v2.getTangent().x, v2.getTangent().y, v2.getTangent().z ); 
					    gl.glMultiTexCoord3f( GL.GL_TEXTURE2, center2.x, center2.y, center2.z ); 
					    gl.glMultiTexCoord3f( GL.GL_TEXTURE3, vel2.x, vel2.y, vel2.z );
					    gl.glVertex3f( v2.getPosition().x, v2.getPosition().y, v2.getPosition().z );

                                            count +=3;
				    }
				    gl.glEnd();	
		}
	} 


    //
    // Members
    //
    Mesh _mesh;

//    ArrayList _triangleList;
    ArrayList _triangleCenters;
    ArrayList _triangleVelocities;
    ArrayList _vertexList;
    ArrayList _normalList;
    ArrayList _tangentList;
    ArrayList _texCoordList;
}

