/*
    Invtro for Inércia Demoparty 2010

    http://creativecommons.org/licenses/by-nc-sa/2.5/
    
    Victor Martins
    www.pixelnerve.com
*/


class Particle
{
/*    Particle( int index, float timeToLive )
    {
        _index = index;
        reset( timeToLive );
    }
*/

    Particle( int index, Vector3 emitter, float timeToLive, Color4 col )
    {
        _index = index;
        reset( emitter, timeToLive, col );
    }

/*
    void reset( float timeToLive )
    {
        _age = 0;
        _timeToLive = timeToLive;
        _size = random( 1, 6 );
        _originSize = _size;
        _speed = random( 1, 6 );

        _isDead = false;

        if( _pos == null ) _pos = new Vector3( random(-300, 300), random(-0, 50), random(-500, 500) );
        else _pos.set( random(-300, 300), random(-300, 300), random(-300, 300) );
//        else _pos = _followPath.getPointOnPath( 0 );
        
        _oldPos = _pos.copy();
        _origin = _pos.copy();


        if( _vel == null ) _vel = new Vector3();
        else _vel.reset();

        _tailSize = 8;
        _tailRenderSegments = 0;
        if( _tailList == null ) _tailList = new ArrayList();
        else _tailList.clear();
        _tailList.add( _pos );
        for( int i=0; i<_tailSize; i++ )
        {
            _tailList.add( _pos.copy() );
            _tailRenderSegments++;
        }


        int rnd = (int)random(_colors.size());
        _color = ((Color4)_colors.get( rnd )).copy();
        _originColor = ((Color4)_colors.get( rnd )).copy();

        float radius = 5;
        float u = random(0, PI );
        float v = random(0, 2*PI );
	float x = sin(u) * cos(v);
	float y = sin(u) * sin(v);
	float z = cos(u);        
        if( _offset == null ) _offset = new Vector3( x*radius, y*radius, z*radius );
        _offset.set( x*radius, y*radius, z*radius );
        
        
        _vel.set( random(-1, 1), random(-1, 1), random(-1, 1) );
        _vel.mul( _speed * 0.02 );


        _startTime = timer.getCurrTime();
    }
*/

    void reset( Vector3 pos, float timeToLive, Color4 col )
    {
        _age = 0;
        _timeToLive = timeToLive;
        _size = random( 1, 6 );
        _originSize = _size;
        _speed = random( 1, 6 );

        _girth = _speed * 1;

        _isDead = false;

        _pos = pos.copy();
        // Add some offset to position
        float off = scene._cubeRadius * 0.63;
        _pos.add( new Vector3( random(-off, off), 0, random(-off, off)) );

        _oldPos = _pos.copy();
        _origin = _pos.copy();
        _savedPos = _pos.copy();

        _damp = 0.995;

        if( _vel == null ) _vel = new Vector3();
        else _vel.reset();

        _tailSize = 10 * ((int)_girth/2);
//        _tailRenderSegments = 0;
        if( _tailList == null ) _tailList = new ArrayList();
        else _tailList.clear();
        _tailList.add( _pos );
        for( int i=0; i<_tailSize; i++ )
        {
            float per = i / (float)_tailSize;
            float angle = 4 * PI * per;
            float x = _pos.x+cos(angle)*_girth;
            float z = _pos.z+sin(angle)*_girth;
            _tailList.add( new Vector3(x, _pos.y, z) );
//            _tailList.add( new Vector3(_pos.x, _pos.y-3, _pos.z) );
//            _tailRenderSegments++;
        }
        
        // Fill data for the plant's vertex quads
        _quadTailListPos = new ArrayList();
        for( int i=0; i<_tailList.size()*4; i++ )
        {
            _quadTailListPos.add( new Vector3() );
        }
        _quadTailListTexCoord = new ArrayList();
        for( int i=0; i<_tailList.size(); i++ )
        {
            _quadTailListTexCoord.add( new Vector2( 0, 0 ) );
            _quadTailListTexCoord.add( new Vector2( 1, 0 ) );
            _quadTailListTexCoord.add( new Vector2( 1, 1 ) );
            _quadTailListTexCoord.add( new Vector2( 0, 1 ) );
        }


        _color = col.copy();
        _originColor = _color.copy();

//        int rnd = (int)random(_colors.size());
//        _color = ((Color4)_colors.get( rnd )).copy();
//        _originColor = _color.copy();

/*        float radius = 0;
        float u = random(0, PI );
        float v = random(0, 2*PI );
	float x = sin(u) * cos(v);
	float y = sin(u) * sin(v);
	float z = cos(u);        
        if( _offset == null ) _offset = new Vector3( x*radius, y*radius, z*radius );
        _offset.set( x*radius, y*radius, z*radius );
        
        
        _vel.set( random(-1, 1), random(-1, 1), random(-1, 1) );
        _vel.mul( _speed * 0.02 );*/
        _vel.set( 0, 1, 0 );
        _vel.mul( _speed*0.2 );

        _startTime = timer.getCurrTime();
        
        
        // update a first time
        update( 0 );
    }




    void update( float time )
    {
        float t = MathUtils.clamp( (time - _startTime)*0.5, 0, 1 );

        _size = _originSize * t;

        if(t < 1.0 )    _color = Color4.mul( _originColor, t );

        // fade out
        float timeToFade = 4.0;
        if( _age > (_timeToLive-timeToFade) )
        {
            _color.a -= (1.0 / (60.0));
            if( _color.a < 0.0 )
            {    
                _color.a = 0.0;
                _isDead = true;
            }
        }


//        if( ffthelper != null )
        {
            _vel.set( 10*ffthelper.band[4]*noise( time*0.001, _pos.x*0.001, time*0.1), 1*timer.getFrameTime()*20, 10*ffthelper.band[8]*noise( time*0.001, _pos.y*0.001, time*0.1) );
            _vel.add( 0.30*sin(time*2.3), 0, 0.30*cos(-time*2.1) );
            _vel.mul( _speed*0.2 );
        }

        if( _pos.y < (_tailList.size()-5)*_speed )
        {
            _oldPos = _pos.copy();
            _pos.add( _vel );
            _savedPos = _pos.copy();
            _growthStopTime = time;
        }
        else
        {
            _pos.x =_savedPos.x+sin((time-_growthStopTime)*1)*10;
            _pos.z = _savedPos.z+cos((time-_growthStopTime)*.1)*3;
        }
        _vel.mul( _damp );



        Vector3 head = (Vector3)_tailList.get(0);
        head.set( _pos );
        for( int i=1; i<_tailList.size(); i++ )    // make sure the tail stays put (anchor) BUG!
//        for( int i=1; i<_tailList.size(); i++ )
        {
            Vector3 curr = (Vector3)_tailList.get(i);
            Vector3 prev = (Vector3)_tailList.get(i-1);
            float dx = curr.x - prev.x;
            float dy = curr.y - prev.y;
            float dz = curr.z - prev.z;
            float d = sqrt( dx*dx + dy*dy + dz*dz );
            float invD = 1.0 / d;
            curr.x = (prev.x + ((dx * _girth) * invD));
            curr.y = (prev.y + ((dy * _girth) * invD));
            curr.z = (prev.z + ((dz * _girth) * invD));                 
        }


        // clear list before filling it back again.
        _quadTailListPos.clear();
        for( int i=0; i<_tailList.size()-1; i++ )
        { 
            float per = 1 - (i / (float)_tailList.size());
            Vector3 curr = (Vector3)_tailList.get(i);
            UpdateBillboard( 3*per, curr, null, scene._glMatView );
        }


        // Constraint to floor level
//        constraintToFloor( 0 );
        

        //
        // time to die
        //
        if( _age > _timeToLive )
        {
            _isDead = true;
        }


        //
        // Increase age
        //
        _age += timer.getFrameTime();//(1.0/60.0f);
    }



    void renderLines( float time )
    {
        vgl.beginShape( VGL.LINE_STRIP );
        for( int i=0; i<_tailList.size(); i++ )
        { 
            float per = 1.0 - (i / (float)_tailList.size());
            Vector3 curr = (Vector3)_tailList.get(i);
//            Vector3 prev = (Vector3)_tailList.get(i-1);
//            vgl.vertex( prev.x, prev.y, prev.z );
            vgl.color4( _color.r, _color.g, _color.b, _color.a*per );
            vgl.vertex( curr.x, curr.y, curr.z );
        }        
        vgl.endShape();
    }


    void renderParticles( float time )
    {
        for( int i=0; i<_tailList.size(); i+=1 )
        {
            float per = 1 - (i / (float)_tailList.size());
//            Vector3 curr = (Vector3)_tailList.get(i);
//            vgl.fill( 1, 0.5*per );
            vgl.fill( _color.r, _color.g, _color.b, _color.a*per*2 );
//            vgl.rect( curr.x, curr.y, curr.z, 2*per, 2*per );
            RenderBillboard( i );// 2*per, curr, null, scene._glMatView );
        }
    }



  public void UpdateBillboard( float siz, Vector3 pos, Color4 col, Matrix matView )
  {
    // Get right and up vector from modelview matrix
    // Used for billboarding the particles
    Vector3 vx = new Vector3( matView.getArray()[0], matView.getArray()[4], matView.getArray()[8] );
    Vector3 vy = new Vector3( matView.getArray()[1], matView.getArray()[5], matView.getArray()[9] );	 

    // corner1 = -vx - vy
    Vector3 corner1 = vx.clone();
    corner1.mul( -1 );
    corner1.sub( vy );

    // corner2 = vx - vy
    Vector3 corner2 = vx.clone();
    corner2.sub( vy );

    // corner3 = vx + vy
    Vector3 corner3 = vx.clone();
    corner3.add( vy );

    // corner4 = vy - vx
    Vector3 corner4 = vy.clone();
    corner4.sub( vx );

      Vector3 corn1 = corner1.clone();
      corn1.mul( siz );
      Vector3 corn2 = corner2.clone();
      corn2.mul( siz );
      Vector3 corn3 = corner3.clone();
      corn3.mul( siz );
      Vector3 corn4 = corner4.clone();
      corn4.mul( siz );

/*      Matrix ry = new Matrix();
      ry.rotateX( sin(time+pos.x) );
      corn1 = ry.transform( corn1 );
      corn2 = ry.transform( corn2 );
      corn3 = ry.transform( corn3 );
      corn4 = ry.transform( corn4 );*/
      
      
      Vector3 p0 = Vector3.add( pos, corn1 );
      Vector3 p1 = Vector3.add( pos, corn2 );
      Vector3 p2 = Vector3.add( pos, corn3 );
      Vector3 p3 = Vector3.add( pos, corn4 );

      _quadTailListPos.add( p0.copy() );
      _quadTailListPos.add( p1.copy() );
      _quadTailListPos.add( p2.copy() );
      _quadTailListPos.add( p3.copy() );
/*      
      vgl.gl().glBegin( GL.GL_QUADS );  
      vgl.gl().glColor4f( vgl._r, vgl._g, vgl._b, vgl._a );
//      vgl.gl().glColor4f( col.r, col.g, col.b, col.a );
      vgl.gl().glTexCoord2f( 0, 0 );
      vgl.gl().glVertex3f( p0.x, p0.y, p0.z );

      vgl.gl().glTexCoord2f( 1, 0 );
      vgl.gl().glVertex3f( p1.x, p1.y, p1.z );

      vgl.gl().glTexCoord2f( 1, 1 );
      vgl.gl().glVertex3f( p2.x, p2.y, p2.z );

      vgl.gl().glTexCoord2f( 0, 1 );
      vgl.gl().glVertex3f( p3.x, p3.y, p3.z );
      vgl.gl().glEnd();*/
  } 


  public void RenderBillboard( int i )
  {
      Vector3 p0 = (Vector3)_quadTailListPos.get( i*4+0 );
      Vector3 p1 = (Vector3)_quadTailListPos.get( i*4+1 );
      Vector3 p2 = (Vector3)_quadTailListPos.get( i*4+2 );
      Vector3 p3 = (Vector3)_quadTailListPos.get( i*4+3 );
      
      vgl.gl().glBegin( GL.GL_QUADS );  
      vgl.gl().glColor4f( vgl._r, vgl._g, vgl._b, vgl._a );
//      vgl.gl().glColor4f( col.r, col.g, col.b, col.a );
      vgl.gl().glTexCoord2f( 0, 0 );
      vgl.gl().glVertex3f( p0.x, p0.y, p0.z );

      vgl.gl().glTexCoord2f( 1, 0 );
      vgl.gl().glVertex3f( p1.x, p1.y, p1.z );

      vgl.gl().glTexCoord2f( 1, 1 );
      vgl.gl().glVertex3f( p2.x, p2.y, p2.z );

      vgl.gl().glTexCoord2f( 0, 1 );
      vgl.gl().glVertex3f( p3.x, p3.y, p3.z );
      vgl.gl().glEnd();
  } 
  
  
/***
    void update( float time )
    {
        float t = MathUtils.clamp( (time - _startTime), 0, 1 );

        _size = _originSize * t;

        if(t < 1.0 )
            _color = Color4.mul( _originColor, t );

        Vector3 tmp = _followPath.getPointOnPath( (time-_startTime)*_speed );
        if( tmp != null )
        {
            _vel = Vector3.sub( _oldPos, _pos );
            _vel.normalize();
            _vel.mul( _speed );

            _oldPos = _pos.copy();
            _pos.set( tmp );


            Vector3 offTmp = _offset.copy();
            offTmp.mul( t );
            _pos.add( offTmp );


            Vector3 noi = new Vector3();
            noi.x = 2*noise( time*0.1, _pos.x*0.01, time*0.1+_index ) - 1;
            noi.y = 2*noise( time*0.01, _pos.y*0.01, time*0.1+_index ) - 1;
            noi.z = 2*noise( time*0.1, _pos.z*0.01, time*0.1+_index ) - 1;
            noi.mul( _speed*55, _speed*15, _speed*55 );
            _pos.add( noi );

            // Constraint to floor level
            constraintToFloor( 0 );
            
//            _vel.mul( noi );

//            float girth = _vel.length();
            float girth = _speed * 3;
            Vector3 head = ((Vector3)_tailList.get(0));
            head.set( _pos );
            for( int i=1; i<_tailSize; i++ )
            { 
                Vector3 curr = ((Vector3)_tailList.get(i));
                Vector3 prev = ((Vector3)_tailList.get(i-1));
                float dx = curr.x - prev.x;
                float dy = curr.y - prev.y;
                float dz = curr.z - prev.z;
                float d = sqrt( dx*dx + dy*dy + dz*dz );
                float invD = 1.0 / d;
                curr.x = (prev.x + ((dx * girth) * invD));
                curr.y = (prev.y + ((dy * girth) * invD));
                curr.z = (prev.z + ((dz * girth) * invD));                 
            }
        }
        else
        {
            _isDead = true;
        }


        //
        // time to die
        //
        if( _age > _timeToLive )
        {
            _isDead = true;
        }


        //
        // Increase age
        //
        _age += (1.0/60.0f);
    }
***/


    boolean isDead()
    {
        return _isDead;
    }
    
    
    void constraintToFloor( float height )
    {
        if( _pos.y < height ) _pos.y = height;
    }
    
    

    //
    // Members
    //

    int _index;

    float _startTime;
    float _growthStopTime;

    float _speed;


    boolean _isDead;
    float _age;
    float _timeToLive;

    float _size;
    float _originSize;

    Vector3 _offset;
    Vector3 _origin, _oldPos, _pos, _savedPos;
    Vector3 _vel;
    float _damp;

    float _girth;
//    int  _tailRenderSegments;    // counts number of tail segments to render  
    int  _tailSize; 
    ArrayList _tailList;    
    ArrayList _quadTailListPos;
    ArrayList _quadTailListTexCoord;
  
    Color4 _color;
    Color4 _originColor;
}
    
