/*
    Invtro for Inércia Demoparty 2010

    http://creativecommons.org/licenses/by-nc-sa/2.5/
    
    Victor Martins
    www.pixelnerve.com
    
    Handle the line particles in the background
*/

import java.nio.*;
import vitamin.utils.BufferUtils;



  class ParticleComparator implements Comparator
  {
    public final int compare( Object a, Object b )
    {
       float z1 = ((Particle)a)._pos.z;
       float z2 = ((Particle)b)._pos.z;
  
      if( z1 > z2 )  return 1;
      else return -1;
    }
  } 



class ParticleSystem
{
    int MAX_PARTICLES = 400*2;

    ParticleSystem( ArrayList paths )
    {
//        _paths = paths;

        _positionBuffer = BufferUtils.createFloatBuffer( MAX_PARTICLES*30*3 );
        _colorBuffer = BufferUtils.createFloatBuffer( MAX_PARTICLES*30*4 );
        
        _positionSegBuffer = BufferUtils.createFloatBuffer( MAX_PARTICLES*4*30*3 );
        _texcoordSegBuffer = BufferUtils.createFloatBuffer( MAX_PARTICLES*4*30*2 );
        _colorSegBuffer = BufferUtils.createFloatBuffer( MAX_PARTICLES*4*30*4 );

/*        _vboID = new int[1];
        vgl.gl().glGenBuffersARB( 1, _vboID, 0 );
        vgl.gl().glBindBufferARB( GL.GL_ARRAY_BUFFER_ARB, _vboID[0] );
        vgl.gl().glBufferDataARB( GL.GL_ARRAY_BUFFER_ARB, xyz.length, vertexBuffer, GL.GL_STREAM_DRAW_ARB );
        vgl.gl().glBindBufferARB( GL.GL_ARRAY_BUFFER_ARB, 0 ); 
*/

        _particleJointCount = 0;
        _particleSegCount = 0;
        
        _particleCount = 0;
        _particleList = new ArrayList();
        
        _comparator = new ParticleComparator();
        
        
        particleAddTime = 0.1;
        particleCountTime = 0;
        

        _emitter = new Vector3();
    }
    
    
    void init()
    {
    }


    void render()
    {
        renderVA();
//        renderImmediateMode();
    }



    void renderVA()
    {
        vgl.enableTexture( false );
        updateBuffers();
        renderBuffers();
    }


    void renderImmediateMode()
    {
        vgl.enableTexture( false );
/*
        vgl.beginShape( VGL.LINES );
        for( int i=0; i<_particleList.size(); i++ )
        {
            Particle p = (Particle)_particleList.get( i );
            if( p._pos != null )
            {
                //
                // Draw a line for particle
                //
                vgl.color4( p._color.r, p._color.g, p._color.b, p._color.a );
                vgl.vertex( p._origin.x, p._origin.y, p._origin.z );
//                vgl.color4( p._color.r, p._color.g, p._color.b, 0 );
                vgl.vertex( p._pos.x, p._pos.y, p._pos.z );
            }
        }
        vgl.endShape();     
*/
        
/****
        //
        // Render plant lines
        //
        for( int i=0; i<_particleList.size(); i++ )
        {
            Particle p = (Particle)_particleList.get( i );
            if( p._pos != null )
            {
                // only render if inside view frustum
                boolean visible = true;
                int count = 0;
                for( int ii=0; ii<p._tailList.size(); ii++ )
                {
                    if( scene._frustum.isPointVisible( ((Vector3)p._tailList.get(ii)) ) )
                        count++;
                }
                if( count < (p._tailList.size()*0.1) )
                    visible = false;
                    
                if( visible )
                {
                    p.renderLines( 0 );
                }
            }
        }
****/
        
        //
        // Render plant segment particles
        //
        scene._particleTex.enable();
        for( int i=0; i<_particleList.size(); i++ )
        {
            Particle p = (Particle)_particleList.get( i );
            if( p._pos != null )
            {
                // only render if inside view frustum
                boolean visible = true;
                int count = 0;
                for( int ii=0; ii<p._tailList.size(); ii++ )
                {
                    if( scene._frustum.isPointVisible( ((Vector3)p._tailList.get(ii)) ) )
                        count++;
                }
                if( count < (p._tailList.size()*0.1) )
                    visible = false;

                if( visible )
                {
                    p.renderParticles( 0 );
                }
            }
        }
        scene._particleTex.disable();        
    }
    
    

    void update( float time, boolean allowGrowth )
    {
//        _emitter.set( sin(time*0.52)*200, -200, 0 );
//        _emitter.x += 250 * (2*noise( time*0.001, time * 0.001+_emitter.x*0.003, _emitter.y*0.0001 )-1);
//        _emitter.y += 100 * (2*noise( time * 0.001, +_emitter.z*0.003, time*0.1 )-1);
//        _emitter.z += 145 * (2*noise( time*0.001, time * 0.01 +_emitter.z*0.0003 )-1);
//        _emitter = ((Path)_paths.get(0)).getPointOnPath( time*8 );
        
        
        //
        // Add more particles until it reaches MAX count
        //
        if( allowGrowth && (time-particleCountTime) > particleAddTime && _particleList.size() < MAX_PARTICLES )
        {
            particleCountTime = time;

/*            int rnd = (int)random(_paths.size() );
            Particle p = new Particle( _particleCount, (Path)_paths.get(rnd), random(6, 10) );
            _particleList.add( p );
*/

//            float off = 0;
//            Vector3 offtmp = new Vector3( random(-off, off), random(-off, off), random(-off, off) );
//            Vector3 tmp = Vector3.add( _emitter, offtmp );
            
            Color4 pcolor;
            if( scene._lastQuad != null )
                pcolor = scene._lastQuad._color.copy();
            else
                pcolor = new Color4( 1, 1, 1, 1 );

            int amount = (int)random(1, 14);
            for( int ii=0; ii<amount; ii++ )
            {                
                Particle p = new Particle( _particleCount, _emitter, random(20, 30), pcolor );
                _particleList.add( p );
                _particleCount++;
            }

        }
        while( _particleList.size() > MAX_PARTICLES )
        {
            _particleList.remove( _particleList.size()-1 );
        }


        //
        // Update particles
        //
        for( int i=0; i<_particleList.size(); i++ )
        {
            Particle p = (Particle)_particleList.get( i );
            p.update( time );

            if( p.isDead() )
            {
                _particleList.remove( p );
/*                
//                int rnd = (int)random(_paths.size() );
//                p.reset( (Path)_paths.get(rnd), random(14, 30) );
                p.reset( _emitter, random(13, 20) );
                
                if( random(100) > 50 )
                {
                    int amount = (int)random(1, 5 );
                    for( int ii=0; ii<amount; ii++ )
                    {
                        Particle pp = (Particle)_particleList.get( ii );
                        pp.reset( _emitter, random(13, 20) );
                    }
                }
*/
            }
        }
        
        
        //
        // Sort particles
        //
        Collections.sort( _particleList, _comparator );  
    }


    void renderBuffers()
    {
        //
        // render plant's body lines
        //
        vgl.gl().glEnableClientState( GL.GL_VERTEX_ARRAY );
        vgl.gl().glEnableClientState( GL.GL_COLOR_ARRAY );
        vgl.gl().glVertexPointer( 3, GL.GL_FLOAT, 0, _positionBuffer );
        vgl.gl().glColorPointer( 4, GL.GL_FLOAT, 0, _colorBuffer );

        vgl.gl().glDrawArrays( GL.GL_LINES, 0, _particleSegCount );//_particleList.size()*2 );

        vgl.gl().glDisableClientState( GL.GL_VERTEX_ARRAY );
        vgl.gl().glDisableClientState( GL.GL_COLOR_ARRAY );
        

        //
        // Now render plant's vertex quads (billboard junctions)
        //
        scene._particleTex.enable();
        
        vgl.gl().glEnableClientState( GL.GL_VERTEX_ARRAY );
        vgl.gl().glEnableClientState( GL.GL_TEXTURE_COORD_ARRAY );
        vgl.gl().glEnableClientState( GL.GL_COLOR_ARRAY );
        vgl.gl().glVertexPointer( 3, GL.GL_FLOAT, 0, _positionSegBuffer );
        vgl.gl().glTexCoordPointer( 2, GL.GL_FLOAT, 0, _texcoordSegBuffer );
        vgl.gl().glColorPointer( 4, GL.GL_FLOAT, 0, _colorSegBuffer );

        vgl.gl().glDrawArrays( GL.GL_QUADS, 0, _particleJointCount );

        vgl.gl().glDisableClientState( GL.GL_VERTEX_ARRAY );
        vgl.gl().glDisableClientState( GL.GL_TEXTURE_COORD_ARRAY );
        vgl.gl().glDisableClientState( GL.GL_COLOR_ARRAY );
        
        scene._particleTex.disable();

    }


    void updateBuffers()
    {
        _particleSegCount = 0;
        _particleJointCount = 0;
        
        _positionBuffer.clear();
        _colorBuffer.clear();
        _positionSegBuffer.clear();
        _texcoordSegBuffer.clear();
        _colorSegBuffer.clear();

        Color4 c2 = Color4.WHITE;
        
        int pi = 0;
        int ci = 0;
        int pi2 = 0;
        int ti2 = 0;
        int ci2 = 0;
        for( int i=0; i<_particleList.size(); i++ )
        {
            Particle p = (Particle)_particleList.get( i );

            Color4 c1 = p._color;
            
            //
            // Create buffer for lines
            //
            for( int ti=0; ti<p._tailList.size()-1; ti++ )
            {
                float per = (ti / (float)p._tailList.size());
             
                Color4 c = Color4.lerp( c1, c2, per );
                
                Vector3 v0 = (Vector3)p._tailList.get(ti);
                Vector3 v1 = (Vector3)p._tailList.get(ti+1);
                // positions
                _positionBuffer.put( pi++, v0.x );
                _positionBuffer.put( pi++, v0.y );
                _positionBuffer.put( pi++, v0.z );
                _positionBuffer.put( pi++, v1.x );
                _positionBuffer.put( pi++, v1.y );
                _positionBuffer.put( pi++, v1.z );

                // colors
                _colorBuffer.put( ci++, c.r );
                _colorBuffer.put( ci++, c.g );
                _colorBuffer.put( ci++, c.b );
                _colorBuffer.put( ci++, c.a*per );
                _colorBuffer.put( ci++, c.r );
                _colorBuffer.put( ci++, c.g );
                _colorBuffer.put( ci++, c.b );
                _colorBuffer.put( ci++, c.a*per );
                
                _particleSegCount += 2;
            }

            //
            // Create buffer for plant joints
            //
            for( int ti=0; ti<p._quadTailListPos.size(); ti++ )
            {
                float per = (ti / (float)p._tailList.size());
                
                Color4 c = Color4.lerp( c1, c2, 1-per );
                
                Vector3 v0 = (Vector3)p._quadTailListPos.get(ti);
                Vector2 t0 = (Vector2)p._quadTailListTexCoord.get(ti);

                // positions
                _positionSegBuffer.put( pi2++, v0.x );
                _positionSegBuffer.put( pi2++, v0.y );
                _positionSegBuffer.put( pi2++, v0.z );

                // texcoords
                _texcoordSegBuffer.put( ti2++, t0.x );
                _texcoordSegBuffer.put( ti2++, t0.y );

                // colors
                _colorSegBuffer.put( ci2++, c.r );
                _colorSegBuffer.put( ci2++, c.g );
                _colorSegBuffer.put( ci2++, c.b );
                _colorSegBuffer.put( ci2++, c.a*per );
                
                _particleJointCount++;
            }

        }

        _positionBuffer.rewind();
        _colorBuffer.rewind();
        _positionSegBuffer.rewind();
        _texcoordSegBuffer.rewind();
        _colorSegBuffer.rewind();
    }



    //
    // Members
    //
    
//    ArrayList _paths;

    float particleAddTime;
    float particleCountTime;
    
    Vector3 _emitter;
    
    int _particleJointCount;
    int _particleSegCount;
    
    int _particleCount;
    ArrayList _particleList;
    
    ParticleComparator _comparator;
    
    int[] _vboID;
    FloatBuffer _positionBuffer;
    FloatBuffer _colorBuffer;
    
    FloatBuffer _positionSegBuffer;
    FloatBuffer _texcoordSegBuffer;
    FloatBuffer _colorSegBuffer;    
}
