import java.io.*;
import java.nio.*;
import java.nio.channels.*; 




void readQuadShapePositions( String filename, ArrayList q, boolean reverseList )
{
  println( "** Looking for the area file. load if it exists" );
  
  // Create an input stream and file channel
  // Using first arguemnt as file name to read in
  FileInputStream fis = null;
  FileChannel fc;
  ByteBuffer bb;
  String content = "";
  
  try 
  {
    println( "open file: " + filename );
    fis = new FileInputStream( filename );
  } catch(IOException e)
  {
    println( "cant open positions file. bail out!" );
    return;
  }
  fc = fis.getChannel();  

  try 
  {
    bb = ByteBuffer.allocate((int)fc.size());
    fc.read( bb );
    
    content = new String( bb.array() );
//    println( "content: " + content );

  } catch(IOException e){
     println( "cant read file" );
 }


  String delimiters = ",\n\r";
  StringTokenizer tokenizer = new StringTokenizer( content, delimiters );

  ArrayList valuesList = new ArrayList();
  
  while( tokenizer.hasMoreTokens() )
  {
    String token = tokenizer.nextToken();
    valuesList.add( token );
  }

  if( valuesList.size() <= 0 )
  {
    System.err.println( "this area file is empty. bail out" );
    return;
  }
  
  
  ArrayList qqq = new ArrayList();
  
  int index = 0;
  int step = 4;    // x, y, z, radius
  for( int i=0; i<(valuesList.size()/4)-0; i++ )
  {
    float x = Float.parseFloat( (String)valuesList.get(index+0) );
    float y = Float.parseFloat( (String)valuesList.get(index+1) );
    float z = Float.parseFloat( (String)valuesList.get(index+2) );
    int dirIdx = Integer.parseInt( (String)valuesList.get(index+3) );
    
    Vector4 tmp = new Vector4( x, y, z, dirIdx );
//    tmp.debug();
    qqq.add( tmp );
    
    index += step;
  }
  
  if( reverseList )
  {
      // Reverse the list. end to start
      for( int i=(valuesList.size()/4)-1; i>=0; i-- )
      {
          Vector4 ttt = (Vector4)qqq.get( i );
          q.add( ttt );
      }
  }
  else
  {
      // Reverse the list. end to start
      for( int i=0; i<(valuesList.size()/4); i++ )
      {
          Vector4 ttt = (Vector4)qqq.get( i );
          q.add( ttt );
      }
  }


  try {  
    fc.close();
  } catch(IOException e) {}
} 
