import vitamin.math.*;
import vitamin.scenesimple.*;
import vitamin.interpolation.*;
import vitamin.math.Frustum;  

boolean USE_DESTRUCTABLE = false;


// Camera Index, Camera Trigger Time
int cameraChangeIndex = 0;
float[] cameraChangeData = 
{
    0, 28.0,
    2, 2.8214655,
    0, 6.732208,
    0, 9.69586,
    2, 6.5496144,
    2, 7.1299934,
    1, 5.1396646,
    3, 7.592841,
    3, 7.2927604,
    3, 7.1371403,
    1, 2.9877567,
    0, 7.7301497,
    3, 7.530132,
    3, 6.798438,
    2, 2.3314877,
    3, 6.64499,
    2, 5.7769294,
    1, 4.0375786,
    3, 6.240207,
    0, 2.4565172,
    1, 2.2590766,
    1, 9.285179,
    1, 2.8290544,
    3, 9.196049,

    3, 4.564855,
    3, 8.42886,
    3, 9.184864,
    3, 6.73158,

    // not used from here on
    3, 6.602188,
    3, 9.358845

/*    0, 4.564855,
    0, 8.42886,
    3, 9.184864,
    1, 6.73158,

    // not used from here on
    1, 6.602188,
    1, 9.358845 */
};

class CustomScene extends vitamin.fx.Effect
{
  final boolean _isAutoMode = true;
  final boolean _savePositionsToFile = false;
  
  final float nearPlane = 1.0;
  final float farPlane = 5000.0;

  float _timeOfAnim = 0.6;    // time it takes for the anim interpolation
  float _animSpeedInSecs = (_timeOfAnim+0.1);    // 1.465;    // time it takes to trigger a new animation
  float _animSpeedFirstTimeDelay = _animSpeedInSecs*2;

  PrintWriter _fileWriter;

  int _currDirectionIdx;
  // Array of positions, loaded from file
  ArrayList groundQuadPositions;

  float _cubeRadius;
  float _cubeAngle;
//  float _cubeAngleAdd;
//  float _cubeAngleChange;
  float _lastAngleTime;

  Vector3 _cubePos;
  Vector3 _lastCubePos;
  Vector3 _cubePivot;

    Scene _chamfer;
    Mesh _mesh;
    MeshShatterProcessor _meshShatter;
    // Bounding box
    Vector3 vmin;
    Vector3 vmax;
      
  
//  XTexture cubemapTex; 
  HDRCubeMapLoader _hdrCubeMap;  
  RenderTargetCubeMap _cubeMapRT; 

  VTexture2D[] _cubeTex; 
  VTexture2D _groundTex;
  VTexture2D _glacierTex;
  VTexture2D _particleTex;

  VTexture2D[] _quadTex;

  Vector3 _eye, _target, _up;
  Vector3 _eye2, _target2, _up2;
  Vector3 _eyeOffset;
  Vector3 _tarOffset;
  
  Matrix _matWorld, _matView, _matProj;
  Matrix _glMatView;
  
  int _blackNoTextureID;
  int _diffSpecNoTextureID;
  int _onlyTextureID;

  Vector3 _dirdir;

    ParticleSystem _pSystem;

    Frustum _frustum; 

  final static int POSITIVE_X = 0;
  final static int NEGATIVE_X = 1;
  final static int POSITIVE_Z = 2;
  final static int NEGATIVE_Z = 3;

  int _numOfDirections;  
  Vector3[] _possibleDirections;
  int _directionIdx;  // index that tells us which direction its about to take
  int _lastDirectionIdx;  // index that tells us which direction its about to take

  int _lerpMode = 0;
  
  boolean _isAnimPlaying;
  
  GroundQuad _lastQuad;
  ArrayList _quadList;
  float _quadRadius;
  

//  int _radialBlurId;
  int _blurID;
  int _normalMapID;
  int _normalMapTitleID;
  int _normalMapShatterID;

  
  int sizeX, sizeY; 
  XTexture _blurTex, _blurTexV, _blurTexH;
  FBO _blurFBO, _blurVFBO, _blurHFBO;
//  XTexture _sceneMapTex;
//  FBO _sceneFBO;   
  XTexture _radialMapTex;
  FBO _radialFBO;   
  boolean usePowerOfTwo = true;    


    RenderTarget2D _offScreenRT;
    RenderTarget2D _gaussianHRT, _gaussianVRT, _gaussianRT;    // 2-pass gaussian blur filter    


  float camRandomAdd = 28;
  float lastCamChangeTime = 0; 
  int camIdx = 0;


    float logoAlphaValue = 0;
    float logoScrollValue = 0;
    float logoTimeValue = 54.5;
    
    float plantsTimeValue = 84;
    float plantsEndTimeValue = (60*2)+37;    //(60*2)+38;
    float shatterTimeValue = (3*60)+6;    //2.59min

  /// ______________________________________________________________________________________________

  // Abstract methods. to implement!
  public boolean Init( GL gl )
  {
    _gl = gl;


    if( _savePositionsToFile )
    {
        try {
            _fileWriter = new PrintWriter( dataPath("positions.txt") );
        } catch( Exception e ) {}
    }
    else
    {
        // read positions+direction index from file
        groundQuadPositions = new ArrayList();
        readQuadShapePositions( dataPath("positions.txt"), groundQuadPositions, false );
    }


//    if( usePowerOfTwo )
//    {
//        sizeX = WIDTH/2;
//        sizeY = HEIGHT/2;
        sizeX = sizeY = 256;
      
      
        VSamplerState samp1 = new VSamplerState( GL.GL_LINEAR, GL.GL_LINEAR, GL.GL_CLAMP_TO_EDGE, GL.GL_CLAMP_TO_EDGE );
        VSamplerState samp2 = new VSamplerState( GL.GL_NEAREST, GL.GL_NEAREST, GL.GL_CLAMP_TO_EDGE, GL.GL_CLAMP_TO_EDGE ); 
        
        VRenderBuffer rbo = new VRenderBuffer( _gl, WIDTH, HEIGHT, SurfaceFormat.DEPTH ); 

	// RenderTarget2D( GL gl, int targetID, int width, int height, int format, VSamplerState samp, VRenderBuffer renderBuffer, boolean depthAttachment )
        _offScreenRT = new RenderTarget2D( _gl, GL.GL_TEXTURE_2D, sizeX, sizeY, SurfaceFormat.RGBA, samp1, rbo, false );
//        _gaussianVRT = new RenderTarget2D( _gl, GL.GL_TEXTURE_2D, sizeX/2, sizeY/2, SurfaceFormat.RGBA, samp1, null, false );
//        _gaussianHRT = new RenderTarget2D( _gl, GL.GL_TEXTURE_2D, sizeX/2, sizeY/2, SurfaceFormat.RGBA, samp1, null, false );
//        _gaussianRT = new RenderTarget2D( _gl, GL.GL_TEXTURE_2D, WIDTH, HEIGHT, SurfaceFormat.RGBA, samp1, null, false );
        
/*        _offScreenRT = new RenderTarget2D( _gl, sizeX, sizeY, SurfaceFormat.RGBA );
        _gaussianVRT = new RenderTarget2D( _gl, sizeX/2, sizeY/2, SurfaceFormat.RGBA );
        _gaussianHRT = new RenderTarget2D( _gl, sizeX/2, sizeY/2, SurfaceFormat.RGBA );
        _gaussianRT = new RenderTarget2D( _gl, WIDTH, HEIGHT, SurfaceFormat.RGBA );  */
        

//      _sceneMapTex = new XTexture( GL.GL_TEXTURE_2D );
//      _sceneMapTex.createGL( sizeX, sizeY );
//      _sceneFBO = new FBO( _sceneMapTex, GL.GL_TEXTURE_2D, GL.GL_COLOR_ATTACHMENT0_EXT, GL.GL_DEPTH_COMPONENT );

//      _radialMapTex = new XTexture( GL.GL_TEXTURE_2D );
//      _radialMapTex.createGL( sizeX/2, sizeY/2 );
//      _radialFBO = new FBO( _radialMapTex, GL.GL_TEXTURE_2D, GL.GL_COLOR_ATTACHMENT0_EXT, GL.GL_DEPTH_COMPONENT );       
      
      _blurTexV = new XTexture( GL.GL_TEXTURE_2D );
      _blurTexV.createGL( sizeX/2, sizeY/2 );
//      _blurTexV = new VTexture2D( _gl );
//      _blurTexV.create( sizeX/2, sizeY/2, SurfaceFormat.RGBA );
      _blurVFBO = new FBO( _blurTexV, GL.GL_TEXTURE_2D, GL.GL_COLOR_ATTACHMENT0_EXT, 0 );    //GL.GL_DEPTH_COMPONENT );             

      _blurTexH = new XTexture( GL.GL_TEXTURE_2D );
      _blurTexH.createGL( sizeX/2, sizeY/2 );
//      _blurTexH = new VTexture2D( _gl );
//      _blurTexH.create( sizeX/2, sizeY/2, SurfaceFormat.RGBA );
      _blurHFBO = new FBO( _blurTexH, GL.GL_TEXTURE_2D, GL.GL_COLOR_ATTACHMENT0_EXT, 0 );    //GL.GL_DEPTH_COMPONENT );       

//      _blurTex = new XTexture( GL.GL_TEXTURE_2D );
//      _blurTex.createGL( WIDTH, HEIGHT );
//      _blurTex = new VTexture2D( _gl );
//      _blurTex.create( WIDTH, HEIGHT, SurfaceFormat.RGBA );
//      _blurFBO = new FBO( _blurTex, GL.GL_TEXTURE_2D, GL.GL_COLOR_ATTACHMENT0_EXT, 0 );    //GL.GL_DEPTH_COMPONENT );       

/*    }
    else
    {
        sizeX = WIDTH;
        sizeY = HEIGHT;
      
        _offScreenRT = new RenderTarget2D( vgl.gl(), sizeX, sizeY, SurfaceFormat.RGBA );
        _gaussianHRT = new RenderTarget2D( vgl.gl(), sizeX/2, sizeY/2, SurfaceFormat.RGBA );
        _gaussianVRT = new RenderTarget2D( vgl.gl(), sizeX/2, sizeY/2, SurfaceFormat.RGBA );
        _gaussianRT = new RenderTarget2D( vgl.gl(), WIDTH, HEIGHT, SurfaceFormat.RGBA );  
*/
/*
      _sceneMapTex = new XTexture( GL.GL_TEXTURE_RECTANGLE_ARB ); 
      _sceneMapTex.createGL( sizeX, sizeY );
      _sceneFBO = new FBO( _sceneMapTex, GL.GL_TEXTURE_RECTANGLE_ARB, GL.GL_COLOR_ATTACHMENT0_EXT, GL.GL_DEPTH_COMPONENT ); 

      _radialMapTex = new XTexture( GL.GL_TEXTURE_RECTANGLE_ARB );
      _radialMapTex.createGL( sizeX, sizeY );
      _radialFBO = new FBO( _radialMapTex, GL.GL_TEXTURE_RECTANGLE_ARB, GL.GL_COLOR_ATTACHMENT0_EXT, GL.GL_DEPTH_COMPONENT ); 
**/
//    }

    // Ground texture
    _groundTex = new VTexture2D( vgl.gl() );
    _groundTex.loadFromFile( dataPath("floortex.png"), true );

    _glacierTex = new VTexture2D( vgl.gl(), dataPath("glacier.png"), true );
    _particleTex = new VTexture2D( vgl.gl(), dataPath("particle.png"), true );

    _quadTex = new VTexture2D[2];
    _quadTex[0] = new VTexture2D( vgl.gl(), dataPath("groundtex.png"), true );
    _quadTex[1] = new VTexture2D( vgl.gl(), dataPath("groundtex2.png"), true );
//    _quadTex[2] = new VTexture2D( vgl.gl(), dataPath("asterisk.png"), true );


    _cubeTex = new VTexture2D[3];
    _cubeTex[0] = new VTexture2D( vgl.gl(), dataPath("groundtex.png"), true );
    _cubeTex[1] = new VTexture2D( vgl.gl(), dataPath("1-normal.png"), true );
    _cubeTex[2] = new VTexture2D( vgl.gl(), dataPath("1-diffuse.jpg"), true );


/*  cubemapTex = new XTexture();
  boolean res = cubemapTex.loadCubeMap( dataPath(cubemapPath), "negx.jpg", 
                          "posx.jpg", 
                          "negy.jpg", 
                          "posy.jpg", 
                          "negz.jpg", 
                          "posz.jpg" );
  if( res ) println( "Cubemap has been loaded" );
  else System.err.println( "Cubemap has not been loaded" ); */


    //
    // Load HDR cubemap
    //
    _hdrCubeMap = new HDRCubeMapLoader( dataPath("hdr/grace_cubemap.hdr"), 1.1, 1.2 );//0.86f, 1.2f );  
    

    // Create cubemap texture
//    _cubeMapRT = new RenderTargetCubeMap( _gl );
//    _cubeMapRT.createCubeMap( 1024, 1024, true );   
    
    
    // Load chamfer box from file
    if( USE_DESTRUCTABLE )    _chamfer = vgl.loadScene( dataPath("chamferbox_deconstructed.mm"), false );
    else    _chamfer = vgl.loadScene( dataPath("chamferbox.mm"), false );
    if( _chamfer == null )
    {
        System.err.println( "Failed to load scene. exit" );
        System.exit( 0 );
    }
    

    //
    // Find min and max for the object Bounding Box
    //
    vmin = new Vector3( 99999, 99999, 99999 );
    vmax = new Vector3( -99999, -99999, -99999 );

    // compute bounding box
    for( int j=0; j<_chamfer.getNumOfMeshes(); j++ )
    {
        for( int vi=0; vi<_chamfer.getMeshByIdx(j).getVertexCount(); vi++ )
        {
          Vertex v = _chamfer.getMeshByIdx(j).getVertex( vi );
    
          // get max
          if( v.getPosition().x < vmin.x )
          vmin.x = v.getPosition().x;
          if( v.getPosition().y < vmin.y )
          vmin.y = v.getPosition().y;
          if( v.getPosition().y < vmin.z )
          vmin.z = v.getPosition().z;
          
          // get max
          if( v.getPosition().x > vmax.x )
          vmax.x = v.getPosition().x;
          if( v.getPosition().y > vmax.y )
          vmax.y = v.getPosition().y;
          if( v.getPosition().y > vmax.z )
          vmax.z = v.getPosition().z;
        }
    }
    _cubeRadius = vmax.y;// - 1.0;
    println( "Cube Radius: " + _cubeRadius );


    // Set pivot of box to its center
    for( int j=0; j<_chamfer.getNumOfMeshes(); j++ )
    {
        ArrayList vert = _chamfer.getMeshByIdx(j).getVertexList();
        
        for( int i=0; i<vert.size(); i++ )
        {
          Vertex v = (Vertex)vert.get(i);
          Vector3 pos = v.getPosition();
          if( USE_DESTRUCTABLE )    pos.z -= 15;
          else    pos.z -= _cubeRadius;
          v.setPosition( pos.x, pos.y, pos.z );
        }
    }


    _mesh = _chamfer.getMeshByIdx( 0 );
    _meshShatter = new MeshShatterProcessor( _mesh );



//    _cube = new Cubic();
//    _cube.resize( _cubeRadius );

    _cubePos = new Vector3( 0, _cubeRadius, 0 );
    _lastCubePos = _cubePos.copy();


    _cubePivot = new Vector3( _cubePos.x+_cubeRadius, 0, _cubePos.z+_cubeRadius );
    _cubeAngle = 90.0;
//    _cubeAngleAdd = 0.0;
//    _cubeAngleChange = 0.0;
    _lastAngleTime = 0.0;

    _isAnimPlaying = false;

    _numOfDirections = 4;
    _possibleDirections = new Vector3[_numOfDirections];
    _possibleDirections[0] = new Vector3( 1, 0, 0 );
    _possibleDirections[1] = new Vector3( -1, 0, 0 );
    _possibleDirections[2] = new Vector3( 0, 0, 1 );
    _possibleDirections[3] = new Vector3( 0, 0, -1 );
    _lastDirectionIdx = 0;
    _directionIdx = 0;
    
    _dirdir = new Vector3( 1, 0, 0 );


    _quadRadius = _cubeRadius - 1;
    _quadList = new ArrayList();


    _eye = new Vector3( 0, 50, 200 );
    _target = new Vector3( 0, -80, 0 );
    _up = new Vector3( 0, 1, 0 );

    _eye2 = _eye.copy();
    _target2 = _target.copy();

    _eyeOffset = new Vector3( 0, 0, 0 );
    _tarOffset = new Vector3( 0, 0, 0 );


    _blackNoTextureID = vgl.addEffectFromFile( dataPath("black_notexture.cgfx") );
    _diffSpecNoTextureID = vgl.addEffectFromFile( dataPath("diffusespecular_notexture.cgfx") );
//    _radialBlurId = vgl.addEffectFromFile( dataPath("radialblur.cgfx") );  
    _blurID = vgl.addEffectFromFile( dataPath("blur.cgfx") );
    _onlyTextureID = vgl.addEffectFromFile( dataPath("only_texture.cgfx") );
    _normalMapID = vgl.addEffectFromFile( dataPath("cube_normalmapping.cgfx") );
    _normalMapTitleID = vgl.addEffectFromFile( dataPath("cube_normalmapping_title.cgfx") );
    _normalMapShatterID = vgl.addEffectFromFile( dataPath("cube_normalmapping_shatter.cgfx") );


    _matWorld = new Matrix();
    
/*
    //
    // based on positions get the direction vectors and compute the index for the cube animation
    //
    if( groundQuadPositions.size() > 0 )
    {
        Vector3 startPos = new Vector3( 0, 0, 0 );
        
        // compute the list of directions the cube takes for each position of the animation
        // and save it to an array. later this is used to move the cube on the plane
        Vector3 dir = null;
                
        Vector3 PX = new Vector3( 1, 0, 0 );
        Vector3 NX = new Vector3( -1, 0, 0 );
        Vector3 PZ = new Vector3( 0, 0, 1 );
        Vector3 NZ = new Vector3( 0, 0, -1 );
        
        for( int i=0; i<groundQuadPositions.size()-1; i++ )
        {
            Vector3 v0 = (Vector3)groundQuadPositions.get(i);
            Vector3 v1 = (Vector3)groundQuadPositions.get(i+1);
            
            dir = Vector3.sub( v0, v1 );
            dir.normalize();

            if( Vector3.dot(dir, PX) == 1.0 )    groundQuadDirections.add( POSITIVE_X );
            else if( Vector3.dot(dir, NX) == -1.0 )    groundQuadDirections.add( NEGATIVE_X );
            else if( Vector3.dot(dir, PZ) == 1.0 )    groundQuadDirections.add( POSITIVE_Z );
            else if( Vector3.dot(dir, NZ) == -1.0 )    groundQuadDirections.add( NEGATIVE_Z );

//            println( "DIR: " + groundQuadDirections.get(i) );
        }
    }
    _currDirectionIdx = (Integer)groundQuadDirections.get(0);
*/

        _pSystem = new ParticleSystem( null );  

        _frustum = new Frustum();  

    return true;
  }

	

  public void Render( float time )
  {
    //
    // Render scene to texture
    //
    
//    renderSceneMap( time ); 
    renderSceneToTexture( time );


    //
    // Apply radial blur shader
    // 

    blurSceneMap( time );
//    applyGaussianFilter();



/**
    //
    // Render to cube map surface
    //
    vgl.viewport( _cubeMapRT._width, _cubeMapRT._height );
    _cubeMapRT.bind();
    for( int i=0; i<6; i++ )
    {
      _cubeMapRT.bindFace( i );
      vgl.background( 1 ); //0.085 );
      vgl.perspective( 90, 1.0, 1, 5000 ); 

      vgl.identity( VGL.MODELVIEW );
      Matrix viewMat = getCubeMapViewMatrix( i );
      _gl.glMultMatrixf( viewMat.getFloatBuffer() );
      matView = vgl.getTransposeViewMatrix();

      renderToCubeMap( time );
    }
    _cubeMapRT.unbind();   
***/



    //
    // Back to main framebuffer    
    //

    vgl.viewport( WIDTH, HEIGHT );


/*    // Debug cameras
    if( keyPressed && key == '0' )
    {
        camIdx = 0;
        println( "change camera: " + camIdx + ", " + time );
    }
    if( keyPressed && key == '1' )
    {
        camIdx = 1;
        println( "change camera: " + camIdx + ", " + time );
    }
    if( keyPressed && key == '2' )
    {
        camIdx = 2;
        println( "change camera: " + camIdx + ", " + time );
    }
    if( keyPressed && key == '3' )
    {
        camIdx = 3;
        println( "change camera: " + camIdx + ", " + time );
    }
    if( keyPressed && key == '4' )
    {
        camIdx = 4;
        println( "change camera: " + camIdx + ", " + time );
    }
*/


/*    if( (time) > cameraChangeData[cameraChangeIndex*2+1] )
    {
        cameraChangeIndex++;
        camIdx = (int)cameraChangeData[cameraChangeIndex*2+0];
    }*/
    

    if( (time - lastCamChangeTime) > (cameraChangeData[cameraChangeIndex*2+1]) )
    {
        lastCamChangeTime = time;

        cameraChangeIndex++;
        if( cameraChangeIndex >= (cameraChangeData.length/2) ) cameraChangeIndex = (cameraChangeData.length/2)-1;
        camIdx = (int)cameraChangeData[cameraChangeIndex*2+0];
        camRandomAdd = cameraChangeData[cameraChangeIndex*2+1];
        
        println( "change camera: " + camIdx + ", " + camRandomAdd );
    }

/***    if( (time - lastCamChangeTime) > camRandomAdd )
    {
        lastCamChangeTime = time;// - ((time-lastCamChangeTime)%camRandomAdd);
        camIdx = (int)random(4);
//        camIdx = (camIdx+1)%4;

        camRandomAdd = 2+random(8);

        println( "change camera: " + camIdx + ", " + camRandomAdd );
    }***/


    float camStringSpeed = 1.0;
    switch( camIdx )
    {
      case 0:
//        _eyeOffset = new Vector3( cos(time*.13)*250, 60, sin(time*.13)*250 );
        _eyeOffset = new Vector3( sin(time*.13)*250, 60, cos(time*.13)*250 );
        _tarOffset = new Vector3( 0, 0, 0 );
        camStringSpeed = 1.0;
        break;
      case 1:
        _eyeOffset = new Vector3( sin(time*.13)*350, 60+sin(time*.13)*40, cos(time*.13)*350 );
//        _eyeOffset = new Vector3( sin(time*.13)*550, 60+sin(time*.13)*40, cos(time*.13)*550 );
        _tarOffset = new Vector3( 0, 0, 0 );
        camStringSpeed = 1.0;
        break;
      case 3:
        _eyeOffset = new Vector3( sin(-time*.2)*350, 5, cos(-time*.2)*350 );
        _tarOffset = new Vector3( 0, 15, 0 );
        camStringSpeed = 1.0;
        break;
      case 4:
        _eyeOffset = new Vector3( cos(time*.3)*400, 100, sin(time*.3)*400 );
//        _eyeOffset = new Vector3( cos(time*.3)*450, 100, sin(-time*.3)*450 );
        _tarOffset = new Vector3( 0, 0, 0 );
        camStringSpeed = 1.0;
        break;
/*      default:
        _eyeOffset = new Vector3( sin(time*.13)*250, 60, cos(time*.131)*250 );
        _tarOffset = new Vector3( 0, 0, 0 );
        camStringSpeed = 1.0;
        break;*/
    }

    float eyeSpeed = 1;
    if( time > (2*60)+39 ) eyeSpeed = 2;


    // at 3min and 9 seconds, zoom out camera to view the all thing
    float camZoomTime = ((60*3)+9);
    if( time < camZoomTime )
    {
      _eye.x += ( (_cubePos.x+_eyeOffset.x) - _eye.x ) * 0.001 * camStringSpeed * eyeSpeed;
      _eye.y += ( (_cubePos.y+_eyeOffset.y) - _eye.y ) * 0.001 * camStringSpeed * eyeSpeed;
      _eye.z += ( (_cubePos.z+_eyeOffset.z) - _eye.z ) * 0.001 * camStringSpeed * eyeSpeed;
      _target.x += ( (_cubePos.x+_tarOffset.x) - _target.x ) * 0.0083 * camStringSpeed;
      _target.y += ( (_cubePos.y+_tarOffset.y) - _target.y ) * 0.0083 * camStringSpeed;
      _target.z += ( (_cubePos.z+_tarOffset.z) - _target.z ) * 0.0083 * camStringSpeed;
      
      _eye2 = _eye.copy();
      _target2 = _target.copy();
    }
    else
    {
        // Interpolate between last point and the zoom out camera point
        float t = Expo.easeInOut( time-camZoomTime, 0, 1, 10 );

        Vector3 eyeTarget = new Vector3( 0, 3500, 400 );
        eyeTarget.add( _cubePos );
        
        float x = _eye2.x*(1-t) + eyeTarget.x*t;
        float y = _eye2.y*(1-t) + eyeTarget.y*t;
        float z = _eye2.z*(1-t) + eyeTarget.z*t;
        float tx = _target2.x*(1-t) + _cubePos.x*t;
        float ty = _target2.y*(1-t) + _cubePos.y*t;
        float tz = _target2.z*(1-t) + _cubePos.z*t;
        _eye.set( x, y, z );
        _target.set( tx, ty, tz );

/**      Vector3 eyetmp = new Vector3( 0, 3500, 400 );
//      Vector3 eyetmp = new Vector3( 340.79782, 1164.59, 426.43747 );
      Vector3 lookattmp = _cubePos.clone();    
      eyetmp.add( lookattmp );
      
      _eye.x += ( eyetmp.x - _eye.x ) * 0.0081;
      _eye.y += ( eyetmp.y - _eye.y ) * 0.0081;
      _eye.z += ( eyetmp.z - _eye.z ) * 0.0081;
      _target.x += ( lookattmp.x - _target.x ) * 0.007;
      _target.y += ( lookattmp.y - _target.y ) * 0.006;
      _target.z += ( lookattmp.z - _target.z ) * 0.007;*/
    }
    
    
    // Control camera with mouse for some debugging
    if( mousePressed && !offlineRenderSequence ) 
    {
        _eye.set( cam.getPosition() );
        _target.set( cam.getTarget() );
    }
    
//    lightPos.set( _eye, 1.0 );
    
    //
    // Update camera frustum
    //
    _frustum.setProjectionParams( 45, aspectRatio, nearPlane, farPlane ); 
    _frustum.setCameraParams( _eye, _target, _up );
    _frustum.update();  


    vgl.perspective( 45, aspectRatio, nearPlane, farPlane );
    vgl.camera( _eye, _target, _up );
    _matProj = vgl.getTransposeProjMatrix();
    _matView = vgl.getTransposeViewMatrix();
    _glMatView = vgl.getViewMatrix();

//    setupPointLight( lightPos.xyz() );




    vgl.setAlphaBlend();
//    vgl.enableLighting( true );
//    vgl.enableTexture( false );
    if( time < shatterTimeValue )
        renderCubeNormalMap( time );
    else
        renderCubeNormalMapShatter( time-shatterTimeValue );



    //
    // Render logo
    //
//    if( time >= 3 && time < 58.5 )
    if( time >= logoTimeValue && time < logoTimeValue+4 )
    {
//        float logoTime = time-3;
        float logoTime = time-logoTimeValue;

//        vgl.setAlphaBlend();
        vgl.setAdditiveBlend();
        float t = Sine.easeInOut( logoTime, -1, 1, 4 );
        float tt = t*t;

        logoAlphaValue = 1-tt;
        logoScrollValue = logoTime*10;
/*
        _glacierTex.enable();

        vgl.pushMatrix();
        vgl.translate( (_cubePos.x-_cubeRadius*1.5)-logoTime*10, _cubePos.y, _cubePos.z-(_cubeRadius*1.01) );
        vgl.fill( 1, 1-tt );
        vgl.rect( -_cubeRadius*0.5, -_cubeRadius*0.75*0.25 );
        vgl.popMatrix();
        
        _glacierTex.disable();*/
    }
    else
    {
        logoAlphaValue = 0;
        logoScrollValue = 0;
    }




    //
    // Draw floor
    //
    vgl.setAlphaBlend();
//    vgl.enableLighting( false );

/***
    _groundTex.enable();
    vgl.pushMatrix();
    vgl.translate( _eye.x, _cubePos.y-_cubeRadius, _eye.z ); //_cubePos.x, _cubePos.y-_cubeRadius, _cubePos.z );
//    vgl.fill( 1, 0.88 );
    vgl.fill( 0.95, 1 );
    vgl.texCoordScale( 800, 800 );
    vgl.rectXZ( 2000, 2000 );
    vgl.texCoordScale( 1, 1 );
    vgl.popMatrix();
***/

    _matWorld.identity();
//    matWorld.transpose();

    vgl.setShader( _onlyTextureID );
    vgl.setTextureParameter( "ColorSampler", _groundTex.getId() );
    vgl.setParameter3f( "cameraPos", _eye );
    vgl.setParameter1f( "nearPlane", nearPlane );
    vgl.setParameter1f( "farPlane", farPlane );
    vgl.setParameter4f( "fogColor", 0.025, 0.0025, 0.0025, 1.0 );
    vgl.setParameter1f( "fogStart", 200 );
    vgl.setParameter1f( "fogEnd", 1000 );
    vgl.setParameter1f( "fogDensity", 0.0002 );
    vgl.setMatrixParameterSemantic( "WORLDVIEWPROJECTION", ShaderSemantics.WORLDVIEWPROJECTION_MATRIX, ShaderSemantics.IDENTITY_MATRIX ); 
    vgl.setMatrixParameterSemantic( "WORLDMATRIX", _matWorld.getArray() ); 
    vgl.setMatrixParameterSemantic( "VIEWMATRIX", _matView.getArray() ); 
    vgl.getActiveEffect().setTechnique( "Technique_Decal" );
    vgl.getActiveEffect().setPass();  

    vgl.fill( 0.25, 1 );
//    vgl.fill( 0.1, 0.1, 0.1, .35 );
    vgl.texCoordScale( 4*301, 4*301 );//401.0, 401.0 );
    vgl.rectXZ( 4*700, 4*700 );
//    vgl.drawGridXZ( 0, 0, 0, 700, 700, 7, 7 );
    vgl.texCoordScale( 1, 1 );

    vgl.getActiveEffect().resetPass();  
    vgl.disableShader();



/****
    //
    // Draw rolling box
    //
    vgl.setAlphaBlend();
//    vgl.enableLighting( true );
    vgl.enableTexture( false );


    //
    // compute world matrix
    //
    vgl.pushMatrix();
    vgl.identity();
    vgl.translate( _cubePivot.x, _cubePivot.y, _cubePivot.z );

    if( _dirdir.x != 0 )
      vgl.rotateZ( -_cubeAngle );
//    if( _dirdir.y > 0 )
//      vgl.rotateY( -_cubeAngle );
    if( _dirdir.z != 0 )
      vgl.rotateX( -_cubeAngle );

    vgl.translate( -_cubePivot.x, -_cubePivot.y, -_cubePivot.z );
    vgl.translate( _cubePos.x, _cubePos.y, _cubePos.z );
    matWorld = vgl.getTransposeViewMatrix();
    vgl.popMatrix();    


    //
    // Do actual render
    //
    vgl.pushMatrix();
    vgl.translate( _cubePivot.x, _cubePivot.y, _cubePivot.z );

    if( _dirdir.x != 0 )
      vgl.rotateZ( -_cubeAngle );
//    if( _dirdir.y > 0 )
//      vgl.rotateY( -_cubeAngle );
    if( _dirdir.z != 0 )
      vgl.rotateX( -_cubeAngle );

    vgl.translate( -_cubePivot.x, -_cubePivot.y, -_cubePivot.z );
    vgl.translate( _cubePos.x, _cubePos.y, _cubePos.z );


    //
    // Set shader
    //
    vgl.setShader( _diffSpecNoTextureID );
    vgl.setParameter4f( "lightPos", lightPos );
    vgl.setParameter3f( "cameraPos", _eye );
    vgl.setParameter1f( "kC", 0 );
    vgl.setParameter1f( "kL", 0 );
    vgl.setParameter1f( "kQ", 0 );
    vgl.setParameter1f( "fogDensity", 0 );
    vgl.setParameter1f( "useSpecular", 1 );
    vgl.setParameter1f( "specularLevel", 10 );  
    vgl.setMatrixParameterSemantic( "WORLDVIEWPROJECTION", ShaderSemantics.WORLDVIEWPROJECTION_MATRIX, ShaderSemantics.IDENTITY_MATRIX ); 
    vgl.setMatrixParameterSemantic( "VIEWINVERSETRANSPOSE", ShaderSemantics.VIEW_MATRIX, ShaderSemantics.INVERSE_TRANSPOSE_MATRIX ); 
    vgl.setMatrixParameterSemantic( "WORLDMATRIX", matWorld.getArray() ); 
    vgl.setMatrixParameterSemantic( "VIEWMATRIX", matView.getArray() ); 
    vgl.setMatrixParameterSemantic( "MODELVIEWMATRIX", ShaderSemantics.VIEW_MATRIX, ShaderSemantics.IDENTITY_MATRIX );
//    vgl.getActiveEffect().setFirstTechnique();
    vgl.getActiveEffect().setTechnique( "Technique_DiffuseSpecularWrap" );
    vgl.getActiveEffect().setPass();  

    vgl.fill( 168/255.0, 198/255.0, 1.0 );
    //_cube.draw(); 
    //_chamfer.renderRawData();
//    ((StandardMaterial)_mesh._mat).setDiffuse( 1, 1, 1, 1 );
//    vgl.fill( 0.13, 1.0 );
//    _chamfer.renderRawData();
    _mesh.renderChunksNoMaterial( _gl );

    vgl.getActiveEffect().resetPass();
    vgl.disableShader();

    vgl.popMatrix();
***/



    //
    // Draw ground quads (Render)
    //
    vgl.setAdditiveBlend();
//    vgl.setAlphaBlend();
    vgl.setDepthMask( true );
    vgl.enableTexture( false );
//    vgl.enableLighting( false );
//    vgl.gl().glEnable( GL.GL_POLYGON_OFFSET_FILL );
//    vgl.gl().glPolygonOffset( -10, 10 );    
    for( int i=0; i<_quadList.size(); i++ )
    {
      GroundQuad q = (GroundQuad)_quadList.get(i);
      if( _frustum.isBoxVisible( q._center.x, q._center.y, q._center.z, q._radius*2, 1, q._radius*2 ) )
      {
          _quadTex[q._texIdx].enable();
          q.draw( time );
      }
    }
//    vgl.gl().glDisable( GL.GL_POLYGON_OFFSET_FILL );
    vgl.setDepthMask( true );
    vgl.setAlphaBlend();




    //
    // Draw rolling box shadow
    //
    vgl.setAlphaBlend();
//    vgl.setDepthMask( false );
    vgl.enableTexture( false );
    drawCubeShadow();
    vgl.setDepthMask( true );



    //
    // Render particles
    //
    if( time > plantsTimeValue )//&& time < plantsEndTimeValue )
    {
        vgl.setDepthWrite( true );
        vgl.setDepthMask( false );
        vgl.enableBlend();
        vgl.setAlphaBlend();
    //    vgl.setAdditiveBlend();
        _gl.glLineWidth( 1 );
        _pSystem.render();          
        vgl.setDepthMask( true );
    }

/*
    //
    // draw pivot (DEBUG)
    //
    
    vgl.gl().glEnable( GL.GL_POLYGON_OFFSET_FILL );
    vgl.gl().glPolygonOffset( -1, 1 );    
    vgl.setDepthMask( false );
    vgl.enableTexture( false );
    vgl.setAdditiveBlend();
    vgl.pushMatrix();
    vgl.translate( _cubePos.x, 0, _cubePos.z );
//    vgl.translate( _cubePivot );
//    vgl.fill( 0, 0, 1, 0.75 );
    vgl.fill( 255/255.0, 1/255.0, 255/255.0, 0.75 );
    vgl.rectXZ( 25, 25 );
    vgl.popMatrix();
    vgl.setAlphaBlend();
    vgl.setDepthMask( true );
    vgl.gl().glDisable( GL.GL_POLYGON_OFFSET_FILL );
*/



    //
    // Render post processing (blur overlay)
    //
    vgl.ortho();

    vgl.setDepthWrite( false );
//    vgl.setDepthMask( false );
    vgl.enableTexture( true );
    vgl.enableBlend();
    vgl.setAdditiveBlend();
//    vgl.setOneBlend();
    _blurTexH.enable();
//    _gaussianHRT.getTexture().enable();
//    _offScreenRT.getTexture().enable();
    vgl.fill( 1, 1 );    //0.85 );
//    if( !usePowerOfTwo ) vgl.texCoordScale( width, height );
    vgl.rect( 1, -1 );
//    if( !usePowerOfTwo ) vgl.texCoordScale( 1, 1 );
    _blurTexH.disable();
//    _gaussianHRT.getTexture().disable();
//    _offScreenRT.getTexture().disable();


/**
    //
    // Render logo as overlay
    //
//    if( time >= 3 && time < 58.5 )
    if( time >= 54.5 && time < 58.5 )
    {
//        float logoTime = time-3;
        float logoTime = time-54.5;

        vgl.setAlphaBlend();
        float t = Sine.easeInOut( logoTime, -1, 1, 4 );
        _glacierTex.enable();

        vgl.pushMatrix();
        vgl.translate( 0.4+logoTime*0.05, 0.0, 0 );
//        vgl.rotateZ( 5 );
//        vgl.rotateY( 30 );
        vgl.fill( 1, 1-(t*t) );
        vgl.rect( (_glacierTex.getWidth()*0.5)/(float)WIDTH, (_glacierTex.getHeight()*0.5)/(float)HEIGHT );
        
        vgl.popMatrix();
        
        _glacierTex.disable();
    }
***/

    vgl.setDepthWrite( true );


/*
    //
    // Render overlay image
    //
    vgl.ortho();
    //vgl.setAlphaBlend();
    vgl.gl().glDisable( GL.GL_CULL_FACE );
    vgl.setDepthWrite( false );
    vgl.setDepthMask( false );
    vgl.enableTexture( false );
    rectTex.enable();
    vgl.fill( 1 );
    vgl.setFlipV( true );
    if( rectTex._targetID == GL.GL_TEXTURE_RECTANGLE_ARB )
      vgl.texCoordScale( width, height );
    vgl.rect( 1, 1 );
    vgl.texCoordScale( 1, 1 );
    rectTex.disable(); // must turn off gl_texture_rectangle
    vgl.setFlipV( false );
    vgl.setDepthWrite( true );
    vgl.setDepthMask( true );
*/
  }



    void renderToCubeMap( float time )
    {
//        vgl.perspective( 45, aspectRatio, 1, 5000 );
//        vgl.camera( _eye, _target, _up );

//        matView = vgl.getTransposeViewMatrix();


        //
        // Draw floor
        //
        vgl.setAlphaBlend();
    //    vgl.enableLighting( false );

        _matWorld.identity();

        vgl.setShader( _onlyTextureID );
        vgl.setTextureParameter( "ColorSampler", _groundTex.getId() );
        vgl.setParameter3f( "cameraPos", _eye );
        vgl.setParameter4f( "fogColor", 0.9, 0.9, 0.9, 1.0 );
        vgl.setParameter1f( "fogStart", 1000 );
        vgl.setParameter1f( "fogEnd", 4200 );
        vgl.setParameter1f( "fogDensity", 0.0005 );
        vgl.setMatrixParameterSemantic( "WORLDVIEWPROJECTION", ShaderSemantics.WORLDVIEWPROJECTION_MATRIX, ShaderSemantics.IDENTITY_MATRIX ); 
        vgl.setMatrixParameterSemantic( "WORLDMATRIX", _matWorld.getArray() ); 
        vgl.setMatrixParameterSemantic( "VIEWMATRIX", _matView.getArray() ); 
        vgl.getActiveEffect().setTechnique( "Technique_Decal" );
        vgl.getActiveEffect().setPass();  

        vgl.fill( 0.25, 1 ); 
    //    vgl.fill( 0.1, 0.1, 0.1, .35 );
        vgl.texCoordScale( 301, 301 );//401.0, 401.0 );
        vgl.rectXZ( 700, 700 );
    //    vgl.drawGridXZ( 0, 0, 0, 700, 700, 7, 7 );
        vgl.texCoordScale( 1, 1 );

        vgl.getActiveEffect().resetPass();  
        vgl.disableShader();





        //
        // Draw ground quads (renderToCubeMap)
        //
    //    vgl.setAdditiveBlend();
        vgl.setAlphaBlend();
        vgl.setDepthMask( true );
        vgl.enableTexture( false );
    //    vgl.enableLighting( false );
//        vgl.gl().glEnable( GL.GL_POLYGON_OFFSET_FILL );
//        vgl.gl().glPolygonOffset( -1, 1 );    
        for( int i=0; i<_quadList.size(); i++ )
        {
          GroundQuad q = (GroundQuad)_quadList.get(i);
          _quadTex[q._texIdx].enable();
          q.draw( time );
        }
//        vgl.gl().glDisable( GL.GL_POLYGON_OFFSET_FILL );
        vgl.setDepthMask( true );
        vgl.setAlphaBlend();
    
    
    
/***
        //
        // Draw rolling box shadow
        //
        vgl.setAlphaBlend();
        vgl.setDepthMask( false );
        vgl.enableTexture( false );
        drawCubeShadow();
        vgl.setDepthMask( true );
***/
    
    
        
/*
        //
        // Render post processing
        //
        vgl.ortho();
        
        vgl.enableTexture( true );
        vgl.setAdditiveBlend();
    //    vgl.setOneBlend();
        vgl.setDepthWrite( false );
    //    _radialMapTex.enable();
        _blurTex.enable();
        vgl.fill( 1, 0.85 );
        if( !usePowerOfTwo ) vgl.texCoordScale( width, height );
    
        vgl.rect( 1, -1 );
    
        if( !usePowerOfTwo ) vgl.texCoordScale( 1, 1 );
        _blurTex.disable();
    //    _sceneMapTex.disable();
        vgl.setDepthWrite( true );
*/
    }
  
  
  
  void drawCubeShadow()
  {
    //
    // Draw planar shadow
    //
    vgl.enableTexture( false );
//    vgl.enableLighting( false );
    vgl.setDepthMask( false );
    
    Plane plane = new Plane( new Vector3(0, .3, 0), new Vector3(0, 1, 0) );
    float[] P = { 0, .3, 0, 1 };
    float[] P2 = { plane._normal.x, plane._normal.y, plane._normal.z, plane._d };
    float[] L2 = { lightPos.x, lightPos.y, lightPos.z, 1 };
  
    vgl.gl().glEnable( GL.GL_POLYGON_OFFSET_FILL );
    vgl.gl().glPolygonOffset( -1, 1 );
  
    vgl.pushMatrix();
    CreateShadowProjection( L2, P, P2 );

    vgl.translate( _cubePivot.x, _cubePivot.y, _cubePivot.z );

    if( _dirdir.x != 0 )
      vgl.rotateZ( -_cubeAngle );
//    if( _dirdir.y > 0 )
//      vgl.rotateY( -_cubeAngle );
    if( _dirdir.z != 0 )
      vgl.rotateX( -_cubeAngle );

    vgl.translate( -_cubePivot.x, -_cubePivot.y, -_cubePivot.z );
    vgl.translate( _cubePos.x, _cubePos.y, _cubePos.z );


    //
    // Set shader
    //
    vgl.setShader( _blackNoTextureID );
    vgl.setParameter1f( "alpha", 0.53 );
    vgl.setMatrixParameterSemantic( "WORLDVIEWPROJECTION", ShaderSemantics.WORLDVIEWPROJECTION_MATRIX, ShaderSemantics.IDENTITY_MATRIX );  
    ((ShaderCGFX)vgl.getActiveShader()).setTechnique( "Technique_BlackNoTexture" );
    ((ShaderCGFX)vgl.getActiveShader()).setPass();    
    
    //vgl.fill( 0.0, 0.2 );
    //_cube.draw(); 
    _chamfer.renderRawData();
//    ((StandardMaterial)_mesh._mat).setDiffuse( 0, 0, 0, 1 );
//    _mesh.renderChunksNoMaterial( _gl );

    vgl.getActiveEffect().resetPass(); 
    vgl.disableShader(); 
    
    vgl.popMatrix();
    vgl.setDepthMask( true );
    vgl.gl().glDisable( GL.GL_POLYGON_OFFSET_FILL );    
  }



  /// ___________________________________________________________________________________________
  
  void renderQuadsAndBox( float time )
  {
    vgl.perspective( 45, aspectRatio, nearPlane, farPlane );
    vgl.camera( _eye, _target, _up );
    _matProj = vgl.getTransposeProjMatrix();
    _matView = vgl.getTransposeViewMatrix();


/****
    //
    // Draw floor
    //
    vgl.setAlphaBlend();
//    vgl.enableLighting( false );

    matWorld.identity();
    matWorld.transpose();

    vgl.setShader( _onlyTextureID );
    vgl.setTextureParameter( "ColorSampler", _groundTex.getId() );
    vgl.setParameter3f( "cameraPos", _eye );
    vgl.setParameter4f( "fogColor", 0.9, 0.9, 0.9, 1.0 );
    vgl.setParameter1f( "fogStart", 1000 );
    vgl.setParameter1f( "fogEnd", 4200 );
    vgl.setParameter1f( "fogDensity", 0.0005 );
    vgl.setMatrixParameterSemantic( "WORLDVIEWPROJECTION", ShaderSemantics.WORLDVIEWPROJECTION_MATRIX, ShaderSemantics.IDENTITY_MATRIX ); 
    vgl.setMatrixParameterSemantic( "WORLDMATRIX", matWorld.getArray() ); 
    vgl.setMatrixParameterSemantic( "VIEWMATRIX", matView.getArray() ); 
    vgl.getActiveEffect().setTechnique( "Technique_Decal" );
    vgl.getActiveEffect().setPass();  

    vgl.fill( 0.1, 0.1, 0.1, .35 );
    vgl.texCoordScale( 800.0, 800.0 );
    vgl.rectXZ( 2000, 2000 );
//    vgl.drawGridXZ( 0, 0, 0, 2000, 2000, 100, 100 );
    vgl.texCoordScale( 1, 1 );

    vgl.getActiveEffect().resetPass();  
    vgl.disableShader();
***/




    //
    // Draw ground quads  (for blur)
    //
//    vgl.setAlphaBlend();
    vgl.setAdditiveBlend();
    vgl.setDepthWrite( true );
    vgl.setDepthMask( true );
    vgl.enableTexture( false );
//    vgl.enableLighting( false );
//    vgl.gl().glEnable( GL.GL_POLYGON_OFFSET_FILL );
//    vgl.gl().glPolygonOffset( -1, 1 );    
    for( int i=0; i<_quadList.size(); i++ )
    {
      GroundQuad q = (GroundQuad)_quadList.get(i);

      if( _frustum.isBoxVisible( q._center.x, q._center.y, q._center.z, q._radius*2, 1, q._radius*2 ) )
      {
//          _quadTex[q._texIdx].enable();
          q.draw( time );
      }
    }
//    vgl.gl().glDisable( GL.GL_POLYGON_OFFSET_FILL );
    vgl.setDepthWrite( true );
    vgl.setDepthMask( true );
    vgl.setAlphaBlend();
    _groundTex.disable();



    //
    // Render particles
    //
    if( time > plantsTimeValue )//&& time < plantsEndTimeValue )
    {
        vgl.setDepthWrite( true );
        vgl.setDepthMask( false );
        vgl.enableBlend();
        vgl.setAlphaBlend();
        _gl.glLineWidth( 1 );
        _pSystem.render();          
        vgl.setDepthMask( true );
    }


    //
    // Draw rolling box shadow for blur
    //
    vgl.setAlphaBlend();
//    vgl.setDepthMask( false );
    vgl.enableTexture( false );
    drawCubeShadow();
    vgl.setDepthMask( true );




    //
    // Draw cube in black over the ground quads.
    //
//    vgl.gl().glEnable( GL.GL_POLYGON_OFFSET_FILL );
//    vgl.gl().glPolygonOffset( -10, 10 );

    vgl.setAlphaBlend();
    vgl.setDepthWrite( true );
    vgl.setDepthMask( true );

    vgl.pushMatrix();
    vgl.translate( _cubePivot.x, _cubePivot.y, _cubePivot.z );

    if( _dirdir.x != 0 )
      vgl.rotateZ( -_cubeAngle );
//    if( _dirdir.y > 0 )
//      vgl.rotateY( -_cubeAngle );
    if( _dirdir.z != 0 )
      vgl.rotateX( -_cubeAngle );

    vgl.translate( -_cubePivot.x, -_cubePivot.y, -_cubePivot.z );
    vgl.translate( _cubePos.x, _cubePos.y, _cubePos.z );


    //
    // Set shader
    //
    vgl.setShader( _blackNoTextureID );
    vgl.setParameter1f( "alpha", 1 );
    vgl.setMatrixParameterSemantic( "WORLDVIEWPROJECTION", ShaderSemantics.WORLDVIEWPROJECTION_MATRIX, ShaderSemantics.IDENTITY_MATRIX );  
    ((ShaderCGFX)vgl.getActiveShader()).setTechnique( "Technique_BlackNoTexture" );
    ((ShaderCGFX)vgl.getActiveShader()).setPass();    
    
    //vgl.fill( 0.0, 0.2 );
    //_cube.draw(); 
    _chamfer.renderRawData();
//    ((StandardMaterial)_mesh._mat).setDiffuse( 0, 0, 0, 1 );
//    _mesh.renderChunksNoMaterial( vgl.gl() );

    vgl.getActiveEffect().resetPass(); 
    vgl.disableShader(); 

    vgl.popMatrix();
    vgl.setDepthMask( true );
//    vgl.gl().glDisable( GL.GL_POLYGON_OFFSET_FILL );    

  }



/*
  void renderSceneMap( float time )
  {
    vgl.viewport( sizeX, sizeY );
    
    _sceneFBO.bind();
    vgl.background( 0 );

    renderQuadsAndBox( time );


    _sceneFBO.unbind();    

    vgl.viewport( width, height );
  }  */

    void renderSceneToTexture( float time )
    {
        _offScreenRT.bind();
        vgl.background( 0 );

        renderQuadsAndBox( time );

        _offScreenRT.unbind(); 
    } 
    


/**
  void radialBlurSceneMap( float time )
  {
    //
    // Apply radial blur shader
    //
    vgl.viewport( sizeX, sizeY );

    _radialFBO.bind();
    vgl.background( 0 );
    vgl.ortho();

    vgl.setShader( _radialBlurId );
    vgl.setTextureParameter( "GlowSampler", _sceneMapTex.getId() );
    vgl.setMatrixParameterSemantic( "WORLDVIEWPROJECTION", ShaderSemantics.WORLDVIEWPROJECTION_MATRIX, ShaderSemantics.IDENTITY_MATRIX );  
    ((ShaderCGFX)vgl.getActiveShader()).setTechnique( "RadialBlur" );
    ((ShaderCGFX)vgl.getActiveShader()).setPass();
    // draw screen aligned quad
    vgl.fill( 1 );
    vgl.rect( 1, 1 );
    ((ShaderCGFX)vgl.getActiveShader()).resetPass();
    vgl.disableShader();

    _radialFBO.unbind(); 

    vgl.viewport( width, height );
  }
**/


  void blurSceneMap( float time )
  {
    // Vertical BLUR
    _blurVFBO.bind();
    vgl.background( 0 );
    vgl.ortho();
    vgl.viewport( 0, 0, _blurTexV.getWidth(), _blurTexV.getHeight() );
    vgl.fill( 1 );
    vgl.setShader( _blurID );   
    vgl.setParameter2f( "texSize", _blurTexV.getWidth(), _blurTexV.getHeight() );
    vgl.setTextureParameter( "ScnMap", _offScreenRT.getTexture().getID() );
//    vgl.setMatrixParameterSemantic( "WORLDVIEWPROJECTION", ShaderSemantics.WORLDVIEWPROJECTION_MATRIX, ShaderSemantics.IDENTITY_MATRIX );  
    ((ShaderCGFX)vgl.getActiveEffect()).setFirstPass( "Technique_GuassianBlurV" );
    ((ShaderCGFX)vgl.getActiveEffect()).setPass();
    vgl.rect( 1, 1 );
    ((ShaderCGFX)vgl.getActiveEffect()).resetPass();
    vgl.disableShader();  
    _blurVFBO.disable();     
  
  
    // Horizontal BLUR
    _blurHFBO.bind();
    vgl.background( 0 );
    vgl.ortho();
    vgl.viewport( 0, 0, _blurTexH.getWidth(), _blurTexH.getHeight() );
    vgl.fill( 1 );
    vgl.setShader( _blurID );   
    vgl.setParameter2f( "texSize", _blurTexH.getWidth(), _blurTexH.getHeight() );
    vgl.setTextureParameter( "ScnMap", _blurTexV.getId() );
//    vgl.setMatrixParameterSemantic( "WORLDVIEWPROJECTION", ShaderSemantics.WORLDVIEWPROJECTION_MATRIX, ShaderSemantics.IDENTITY_MATRIX );  
    ((ShaderCGFX)vgl.getActiveEffect()).setFirstPass( "Technique_GuassianBlurH" );
    ((ShaderCGFX)vgl.getActiveEffect()).setPass();
    vgl.rect( 1, 1 );
    ((ShaderCGFX)vgl.getActiveEffect()).resetPass();
    vgl.disableShader();  
    _blurHFBO.disable(); 

/*
    // BLUR
    _blurFBO.bind();
    vgl.background( 0 );
    vgl.ortho();
    vgl.viewport( 0, 0, _blurTex.getWidth(), _blurTex.getHeight() );
    vgl.fill( 1 );
    vgl.setShader( _blurID );   
    vgl.setParameter2f( "texSize", _blurTex.getWidth(), _blurTex.getHeight() );
    vgl.setTextureParameter( "ScnMap", _blurTexH.getId() );
    ((ShaderCGFX)vgl.getActiveEffect()).setFirstPass( "Technique_Copy" );
    ((ShaderCGFX)vgl.getActiveEffect()).setPass();
    vgl.rect( 1, 1 );
    ((ShaderCGFX)vgl.getActiveEffect()).resetPass();
    vgl.disableShader();  
    _blurFBO.disable(); 
*/

    vgl.viewport( width, height );    
  }



    void applyGaussianFilter()
    { 
        // First pass.. vertical sampling
        _gaussianVRT.bind();
        vgl.background( 0 );
        vgl.ortho();     
        vgl.setShader( _blurID );   
        vgl.setParameter2f( "texSize", _gaussianVRT.getWidth(), _gaussianVRT.getHeight() );     
        vgl.setTextureParameter( "ScnMap", _offScreenRT.getTexture().getID() ); 
        vgl.getActiveEffect().setFirstPass( "Technique_GuassianBlurV" );
        vgl.getActiveEffect().setPass(); 
        vgl.rect( 1, 1 );
        vgl.getActiveEffect().resetPass();
        vgl.disableShader();   
        _gaussianVRT.unbind();
    
    
        // Second pass.. horizontal sampling
        _gaussianHRT.bind();
        vgl.background( 0 );
        vgl.ortho();
        vgl.setShader( _blurID );
        vgl.setParameter2f( "texSize", _gaussianHRT.getWidth(), _gaussianHRT.getHeight() );
        vgl.setTextureParameter( "ScnMap", _gaussianVRT.getTexture().getID() );
        vgl.getActiveEffect().setFirstPass( "Technique_GuassianBlurH" );
        vgl.getActiveEffect().setPass();
        vgl.rect( 1, 1 );
        vgl.getActiveEffect().resetPass();
        vgl.disableShader();
        _gaussianHRT.unbind();
        
        
        // Upscale blurred texture
        _gaussianRT.bind();
        vgl.background( 0 );
        vgl.ortho();
        vgl.setShader( _blurID );
        vgl.setParameter2f( "texSize", _gaussianRT.getWidth(), _gaussianRT.getHeight() );
        vgl.setTextureParameter( "ScnMap", _gaussianHRT.getTexture().getID() );
        vgl.getActiveEffect().setFirstPass( "Technique_Copy" );
        vgl.getActiveEffect().setPass();
        vgl.rect( 1, 1 );
        vgl.getActiveEffect().resetPass();
        vgl.disableShader();
        _gaussianRT.unbind();
    }    




  public void Update( float time )
  {
/*    if( time > 28.0 )
    {        
        _timeOfAnim = 0.5;    // time it takes for the anim interpolation
        _animSpeedInSecs = (_timeOfAnim+0.1);    // 1.465;    // time it takes to trigger a new animation
    }*/

    if( time > plantsTimeValue )//&& time < plantsEndTimeValue )
    {
        if( time < plantsEndTimeValue ) _pSystem.update( time, true );
        else _pSystem.update( time, false );
//        _pSystem._emitter.set( _cubePos.x, 1, _cubePos.z );
        _pSystem._emitter.set( _lastCubePos.x, 0, _lastCubePos.z );
//        _pSystem._emitter.add( new Vector3( random(-_cubeRadius*0.5, _cubeRadius*0.5), 0, random(-_cubeRadius*0.5, _cubeRadius*0.5) ) );
    }

    if( _quadList != null && _quadList.size()>1 )
        _lastQuad = (GroundQuad)_quadList.get( _quadList.size()-2 );


    if( _isAutoMode )
    {


        float clickOffset = 0.4;
        float clickTime = (Float)clickList.get(currClick%clickList.size());

        if( (time >= _animSpeedFirstTimeDelay) && (time >= (clickTime-clickOffset)) && (time <= (clickTime+clickOffset)) )
/***        
        // Move box based on output level (last version works with this)
        float level = fft.getLevel(ffthelper.spectrum, 0, numOfBands) * 1.25;
        println( level );
      if( ((time-_lastAngleTime) > (_animSpeedInSecs+_animSpeedFirstTimeDelay)) && (level > 0.2) )
//      if( ((time-_lastAngleTime) > (_animSpeedInSecs+_animSpeedFirstTimeDelay)) && (ffthelper.band[numOfBands/2]*300 > 0.3) )
        // Move box every n'th seconds    
//      if( (time-_lastAngleTime) > (_animSpeedInSecs+_animSpeedFirstTimeDelay)  )
***/
        {
//            println( "Click info: " + currClick + " -- " + clickTime );

            currClick++;
            _animSpeedFirstTimeDelay = 0.0;  // only delay the first time

            if( _currDirectionIdx < groundQuadPositions.size() )
            {
                int idx = (int)((Vector4)groundQuadPositions.get(_currDirectionIdx)).w;
                moveBox( time, idx );

                _currDirectionIdx ++;
            }
            else
            {
                _currDirectionIdx = groundQuadPositions.size();
            }
        
//            moveBox( time, (int)random( 0, 4 ) );
        }
    }


    //
    // Update cube angle and pivot offset
    //
//    println( _cubeAngle + " -- " + _isAnimPlaying + " -- " + _lerpMode );
    
    if( _directionIdx == POSITIVE_X || _directionIdx == POSITIVE_Z )
    {
      //println( "positive dir" );
      if( _cubeAngle >= 90.0 )
      {
        _isAnimPlaying = false;
        _cubeAngle = 90.0;
        return;
      }
    }
    if( _directionIdx == NEGATIVE_X || _directionIdx == NEGATIVE_Z )
    {
      //println( "negative dir" );
      if( _cubeAngle <= -90.0 )
      {
        _isAnimPlaying = false;
        _cubeAngle = -90.0;
        return;
      }
    }

    if( !_isAnimPlaying ) return;

    float count = 0.0;

    switch( _lerpMode )
    {
      case 0:
      count = Quad.easeIn( (time - _lastAngleTime), 0, 90, _timeOfAnim );
      break;
      case 1:
      count = Quad.easeIn( (time - _lastAngleTime), 0, 90, _timeOfAnim );
//      count = Bounce.easeOut( (time - _lastAngleTime), 0, 90, timeOfAnim );
      break;
      case 2:
      count = Quart.easeIn( (time - _lastAngleTime), 0, 90, _timeOfAnim );
      break;
      case 3:
      count = Quint.easeIn( (time - _lastAngleTime), 0, 90, _timeOfAnim );
      break;
      case 4:
      count = Sine.easeIn( (time - _lastAngleTime), 0, 90, _timeOfAnim );
      break;
      case 5:
      count = Sine.easeIn( (time - _lastAngleTime), 0, 90, _timeOfAnim );
      break;
      case 6:
      count = Expo.easeIn( (time - _lastAngleTime), 0, 90, _timeOfAnim );
      break;
      case 7:
      count = Expo.easeIn( (time - _lastAngleTime), 0, 90, _timeOfAnim );
//      count = Bounce.easeOut( (time - _lastAngleTime), 0, 90, _timeOfAnim );
      break;
      default:
      count = Sine.easeIn( (time - _lastAngleTime), 0, 90, _timeOfAnim );
      break;
    }  
    
//    float count = Elastic.easeOut( (time - _lastAngleTime), 0, 90, timeOfAnim );
//    float count = Quad.easeInOut( (time - _lastAngleTime), 0, 90, timeOfAnim );
    if( _directionIdx == 0 ) _cubeAngle = count;
    else if( _directionIdx == 1 ) _cubeAngle = -count;
    else if( _directionIdx == 2 ) _cubeAngle = count;
    else if( _directionIdx == 3 ) _cubeAngle = -count;
  }



  void moveBox( float time, int newDir )
  {
      if( _isAnimPlaying ) return;
      
      _lastAngleTime = time;
//      if( !_isAutoMode )  _lastAngleTime = time;
//      else _lastAngleTime = time - ((time-_lastAngleTime)%_animSpeedInSecs);

      
      _isAnimPlaying = true;
      
      _lerpMode = (int)random( 0, 8 );

//      _cubeAngleAdd = 0.0;
      _cubeAngle = 0.0;

        // save last cube position
        _lastCubePos.set( _cubePos );

      if( _directionIdx == 0 )
      {
        _cubePos.add( _cubeRadius*2, 0, 0 );
//        _cubePivot.add( _cubeRadius*2, 0, 0 );
      }
      else if( _directionIdx == 1 )
      {
        _cubePos.sub( _cubeRadius*2.0, 0.0, 0.0 );
//        _cubePivot.sub( _cubeRadius*2, 0, 0 );
      }
      else if( _directionIdx == 2 )
      {
        _cubePos.sub( 0, 0, _cubeRadius*2 );
//        _cubePivot.sub( 0, 0, _cubeRadius*2 );
      }
      else if( _directionIdx == 3 )
      {
        _cubePos.add( 0, 0, _cubeRadius*2 );
//        _cubePivot.add( 0, 0, _cubeRadius*2 );
      }


      // save last direction
      _lastDirectionIdx = _directionIdx;
      
      // find new direction randomly
      _directionIdx = newDir;
      _dirdir = _possibleDirections[_directionIdx].clone();
      
      if( _directionIdx == 0 )//&& _directionIdx != _lastDirectionIdx )
      {
        _cubePivot.set( _cubePos.x+_cubeRadius, 0, _cubePos.z );
      }
      else if( _directionIdx == 1 )//&& _directionIdx != _lastDirectionIdx )
      {
        _cubePivot.set( _cubePos.x-_cubeRadius, 0, _cubePos.z );
      }
      else if( _directionIdx == 2 )//&& _directionIdx != _lastDirectionIdx )
      {
        _cubePivot.set( _cubePos.x, 0, _cubePos.z-_cubeRadius );
      }
      else if( _directionIdx == 3 )//&& _directionIdx != _lastDirectionIdx )
      {
        _cubePivot.set( _cubePos.x, 0, _cubePos.z+_cubeRadius );
      }

/*      _cubePos.debug();
      _cubePivot.debug();
      if( idx == 0 ) println( "next move..  positive X" );
      else if( idx == 1 ) println( "next move..  negative X" );
      else if( idx == 2 ) println( "next move..  positive Z" );
      else if( idx == 3 ) println( "next move..  negative Z" );*/


      //
      // Add new ground quad to the list
      //
      GroundQuad q = new GroundQuad( new Vector3(_cubePos.x, 0, _cubePos.z), _quadRadius, (int)random(0, _quadTex.length), timer.getCurrTime() );
      _quadList.add( q );      
//      println( "new disco quad added" );

        if( _savePositionsToFile )
        {
            _fileWriter.println( _cubePos.x + "," + "0.0" + "," + _cubePos.z + "," + _directionIdx );
            println( _directionIdx );
        }
  }



  void keyPressed()
  {
    if( _isAutoMode ) return;

    if( _isAnimPlaying ) return;

    if( key == 'l' )    //keyCode == RIGHT )
    {
//      _lastAngleTime = timer.getCurrTime();
      moveBox( timer.getCurrTime(), POSITIVE_X );
    }
    else if( key == 'j' )    //keyCode == LEFT )
    {
//      _lastAngleTime = timer.getCurrTime();
      moveBox( timer.getCurrTime(), NEGATIVE_X );
    }
    else if( key == 'i' )    //keyCode == UP )
    {
//      _lastAngleTime = timer.getCurrTime();
      moveBox( timer.getCurrTime(), POSITIVE_Z );
    }
    else if( key == 'k' )    //keyCode == DOWN )
    {
//      _lastAngleTime = timer.getCurrTime();
      moveBox( timer.getCurrTime(), NEGATIVE_Z );
    }
  }


  public void Release()
  {
    if( _savePositionsToFile )
        _fileWriter.close();
    // empty
  }



  /*
   * This is where the "magic" is done:
   *
   * Multiply the current ModelView-Matrix with a shadow-projetion
   * matrix.
   *
   * l is the position of the light source
   * e is a point on within the plane on which the shadow is to be
   *   projected.  
   * n is the normal vector of the plane.
   *
   * Everything that is drawn after this call is "squashed" down
   * to the plane. Hint: Gray or black color and no lighting 
   * looks good for shadows *g*
   */
  void CreateShadowProjection( float[] l, float[] e, float[] n )
  {
    float d, c;
    float[] mat = new float[16];
  
    // These are c and d (corresponding to the tutorial)
  
    d = n[0]*l[0] + n[1]*l[1] + n[2]*l[2];
    c = e[0]*n[0] + e[1]*n[1] + e[2]*n[2] - d;
  
    // Create the matrix. OpenGL uses column by column
    // ordering
    mat[0]  = l[0]*n[0]+c; 
    mat[4]  = n[1]*l[0]; 
    mat[8]  = n[2]*l[0]; 
    mat[12] = -l[0]*c-l[0]*d;
  
    mat[1]  = n[0]*l[1];        
    mat[5]  = l[1]*n[1]+c;
    mat[9]  = n[2]*l[1]; 
    mat[13] = -l[1]*c-l[1]*d;
  
    mat[2]  = n[0]*l[2];        
    mat[6]  = n[1]*l[2]; 
    mat[10] = l[2]*n[2]+c; 
    mat[14] = -l[2]*c-l[2]*d;
  
    mat[3]  = n[0];        
    mat[7]  = n[1]; 
    mat[11] = n[2]; 
    mat[15] = -d;
  
    // Finally multiply the matrices together *plonk*
    vgl.gl().glMultMatrixf( mat, 0 );
  }  




    void renderCubeNormalMap( float time )
    {
        //
        // compute world matrix for the whole cube object
        //
        vgl.pushMatrix();
        vgl.identity();
        // Transform around a pivot point (which is not the center of the object)
        vgl.translate( _cubePivot.x, _cubePivot.y, _cubePivot.z );
        if( _dirdir.x != 0 )
          vgl.rotateZ( -_cubeAngle );
    //    if( _dirdir.y > 0 )
    //      vgl.rotateY( -_cubeAngle );
        if( _dirdir.z != 0 )
          vgl.rotateX( -_cubeAngle );
        vgl.translate( -_cubePivot.x, -_cubePivot.y, -_cubePivot.z );
        vgl.translate( _cubePos.x, _cubePos.y, _cubePos.z );
        _matWorld = vgl.getTransposeViewMatrix();
        vgl.popMatrix();    



        //
        // Apply matrix to opengl
        //
        vgl.pushMatrix();
        // Use matworld and just transpose back (to column major) for opengl transformations
        Matrix tmp = _matWorld.copy();
        tmp.transpose();
        vgl.multMatrix( _matWorld.getTranspose() );
/*        vgl.translate( _cubePivot.x, _cubePivot.y, _cubePivot.z );
    
        if( _dirdir.x != 0 )
          vgl.rotateZ( -_cubeAngle );
    //    if( _dirdir.y > 0 )
    //      vgl.rotateY( -_cubeAngle );
        if( _dirdir.z != 0 )
          vgl.rotateX( -_cubeAngle );

        vgl.translate( -_cubePivot.x, -_cubePivot.y, -_cubePivot.z );
        vgl.translate( _cubePos.x, _cubePos.y, _cubePos.z );*/



        vgl.setShader( _normalMapTitleID );
        vgl.setTextureParameter( "DecalSampler", _cubeTex[0].getId() );
        vgl.setTextureParameter( "TitleSampler", _glacierTex.getId() );
        vgl.setTextureParameter( "NormalSampler", _cubeTex[1].getId() );
//          vgl.setTextureParameter( "HDRCubeSampler", _cubeMapRT.getID() ); 
//          vgl.setTextureParameter( "HDRCubeSampler", cubemapTex.getId() ); 
        vgl.setTextureParameter( "HDRCubeSampler", _hdrCubeMap._CubemapHDR.getId() ); 

        vgl.setParameter1f( "logoAlphaValue", logoAlphaValue );
        vgl.setParameter1f( "logoScrollValue", logoScrollValue );
        vgl.setParameter1f( "logoTimeValue", logoTimeValue );
        vgl.setParameter4f( "lightPos", lightPos );
        vgl.setParameter3f( "cameraPos", _eye );
      //    vgl.setParameter1f( "kC", kC );
      //    vgl.setParameter1f( "kL", kL );
      //    vgl.setParameter1f( "kQ", kQ );
          vgl.setParameter1f( "time", time );
          if( _hdrCubeMap != null )
          {
              vgl.setParameter1f( "exposure", _hdrCubeMap._exposure );
              vgl.setParameter1f( "brightThreshold", _hdrCubeMap._brightThreshold );
          }
          else
          {
              vgl.setParameter1f( "exposure", 1.0 );
              vgl.setParameter1f( "brightThreshold", 1.1 );
          }


            //
            // Set technique and pass needed stuff
            //
            ((ShaderCGFX)vgl.getActiveShader()).setTechnique( "Technique_IceBall" );
            vgl.setMatrixParameterSemantic( "PROJECTIONMATRIX", _matProj.getArray() ); 
            vgl.setMatrixParameterSemantic( "VIEWMATRIX", _matView.getArray() ); 
//            vgl.setMatrixParameterSemantic( "VIEWINVERSETRANSPOSE", ShaderSemantics.VIEW_MATRIX, ShaderSemantics.INVERSE_TRANSPOSE_MATRIX );
//            vgl.setMatrixParameterSemantic( "WORLDVIEWPROJECTION", ShaderSemantics.WORLDVIEWPROJECTION_MATRIX, ShaderSemantics.IDENTITY_MATRIX );

            for( int i=0; i<_chamfer.getNumOfMeshes(); i++ )
            {
                Mesh m = _chamfer.getMeshByIdx( i );

                vgl.setMatrixParameterSemantic( "WORLDMATRIX", _matWorld.getArray() );

                ((ShaderCGFX)vgl.getActiveShader()).setPass(); 

                m.renderChunksNoMaterial( _gl );
//                _meshShatter.render( _gl );

                ((ShaderCGFX)vgl.getActiveShader()).resetPass();
            }
//          _chamfer.renderRawData();
//          _mesh.renderChunksNoMaterial( _gl );

          vgl.disableShader();              
          

        vgl.popMatrix();
    }



    void renderCubeNormalMapShatter( float time )
    {
        //
        // compute world matrix for the whole cube object
        //
        vgl.pushMatrix();
        vgl.identity();
        // Transform around a pivot point (which is not the center of the object)
        vgl.translate( _cubePivot.x, _cubePivot.y, _cubePivot.z );
        if( _dirdir.x != 0 )
          vgl.rotateZ( -_cubeAngle );
    //    if( _dirdir.y > 0 )
    //      vgl.rotateY( -_cubeAngle );
        if( _dirdir.z != 0 )
          vgl.rotateX( -_cubeAngle );
        vgl.translate( -_cubePivot.x, -_cubePivot.y, -_cubePivot.z );
        vgl.translate( _cubePos.x, _cubePos.y, _cubePos.z );
        _matWorld = vgl.getTransposeViewMatrix();
        vgl.scale( 0.99 );
        Matrix matWorldScaled = vgl.getTransposeViewMatrix();
        vgl.popMatrix();    



        //
        // Apply matrix to opengl
        //
        vgl.pushMatrix();
        // Use matworld and just transpose back (to column major) for opengl transformations
        Matrix tmp = _matWorld.copy();
        tmp.transpose();
        vgl.multMatrix( _matWorld.getTranspose() );
/*        vgl.translate( _cubePivot.x, _cubePivot.y, _cubePivot.z );
    
        if( _dirdir.x != 0 )
          vgl.rotateZ( -_cubeAngle );
    //    if( _dirdir.y > 0 )
    //      vgl.rotateY( -_cubeAngle );
        if( _dirdir.z != 0 )
          vgl.rotateX( -_cubeAngle );

        vgl.translate( -_cubePivot.x, -_cubePivot.y, -_cubePivot.z );
        vgl.translate( _cubePos.x, _cubePos.y, _cubePos.z );*/



        vgl.setShader( _normalMapID );
        vgl.setTextureParameter( "DecalSampler", _cubeTex[2].getId() );
        vgl.setTextureParameter( "NormalSampler", _cubeTex[1].getId() );
//          vgl.setTextureParameter( "HDRCubeSampler", _cubeMapRT.getID() ); 
//          vgl.setTextureParameter( "HDRCubeSampler", cubemapTex.getId() ); 
        vgl.setTextureParameter( "HDRCubeSampler", _hdrCubeMap._CubemapHDR.getId() ); 


        vgl.setParameter1f( "logoAlphaValue", logoAlphaValue );
        vgl.setParameter1f( "logoScrollValue", logoScrollValue );
        vgl.setParameter1f( "logoTimeValue", logoTimeValue );
        vgl.setParameter4f( "lightPos", lightPos );
        vgl.setParameter3f( "cameraPos", _eye );
      //    vgl.setParameter1f( "kC", kC );
      //    vgl.setParameter1f( "kL", kL );
      //    vgl.setParameter1f( "kQ", kQ );
        vgl.setParameter1f( "alpha", MathUtils.clamp( Cubic.easeIn( time, 0, 1, 1), 0, 1 ) );
          vgl.setParameter1f( "time", time );
          if( _hdrCubeMap != null )
          {
              vgl.setParameter1f( "exposure", _hdrCubeMap._exposure );
              vgl.setParameter1f( "brightThreshold", _hdrCubeMap._brightThreshold );
          }
          else
          {
              vgl.setParameter1f( "exposure", 1.0 );
              vgl.setParameter1f( "brightThreshold", 1.1 );
          }


            //
            // Set technique and pass needed stuff
            //
            ((ShaderCGFX)vgl.getActiveShader()).setTechnique( "Technique_IceBall" );
            vgl.setMatrixParameterSemantic( "PROJECTIONMATRIX", _matProj.getArray() ); 
            vgl.setMatrixParameterSemantic( "VIEWMATRIX", _matView.getArray() ); 
//            vgl.setMatrixParameterSemantic( "VIEWINVERSETRANSPOSE", ShaderSemantics.VIEW_MATRIX, ShaderSemantics.INVERSE_TRANSPOSE_MATRIX );
//            vgl.setMatrixParameterSemantic( "WORLDVIEWPROJECTION", ShaderSemantics.WORLDVIEWPROJECTION_MATRIX, ShaderSemantics.IDENTITY_MATRIX );

            for( int i=0; i<_chamfer.getNumOfMeshes(); i++ )
            {
                Mesh m = _chamfer.getMeshByIdx( i );

                vgl.setMatrixParameterSemantic( "WORLDMATRIX", matWorldScaled.getArray() );

                ((ShaderCGFX)vgl.getActiveShader()).setPass(); 

                m.renderChunksNoMaterial( _gl );
//                _meshShatter.render( _gl );

                ((ShaderCGFX)vgl.getActiveShader()).resetPass();
            }
//          _chamfer.renderRawData();
//          _mesh.renderChunksNoMaterial( _gl );

          vgl.disableShader();              



          //
          // Render shattered cube 
          //
        vgl.setShader( _normalMapShatterID );
        vgl.setTextureParameter( "DecalSampler", _cubeTex[0].getId() );
//        vgl.setTextureParameter( "TitleSampler", _glacierTex.getId() );
        vgl.setTextureParameter( "NormalSampler", _cubeTex[1].getId() );
//          vgl.setTextureParameter( "HDRCubeSampler", _cubeMapRT.getID() ); 
//          vgl.setTextureParameter( "HDRCubeSampler", cubemapTex.getId() ); 
        vgl.setTextureParameter( "HDRCubeSampler", _hdrCubeMap._CubemapHDR.getId() ); 

        vgl.setParameter1f( "translationRate", time*2 );
        vgl.setParameter1f( "rotationRate", MathUtils.clamp(Cubic.easeIn(time, 0, 1, 10), 0, 1)*time*0.1 );

        vgl.setParameter1f( "logoAlphaValue", logoAlphaValue );
        vgl.setParameter1f( "logoScrollValue", logoScrollValue );
        vgl.setParameter1f( "logoTimeValue", logoTimeValue );
        vgl.setParameter4f( "lightPos", lightPos );
        vgl.setParameter3f( "cameraPos", _eye );
      //    vgl.setParameter1f( "kC", kC );
      //    vgl.setParameter1f( "kL", kL );
      //    vgl.setParameter1f( "kQ", kQ );
          vgl.setParameter1f( "time", time );
          if( _hdrCubeMap != null )
          {
              vgl.setParameter1f( "exposure", _hdrCubeMap._exposure );
              vgl.setParameter1f( "brightThreshold", _hdrCubeMap._brightThreshold );
          }
          else
          {
              vgl.setParameter1f( "exposure", 1.0 );
              vgl.setParameter1f( "brightThreshold", 1.1 );
          }


            //
            // Set technique and pass needed stuff
            //
            ((ShaderCGFX)vgl.getActiveShader()).setTechnique( "Technique_IceBall" );
            vgl.setMatrixParameterSemantic( "PROJECTIONMATRIX", _matProj.getArray() ); 
            vgl.setMatrixParameterSemantic( "VIEWMATRIX", _matView.getArray() ); 
//            vgl.setMatrixParameterSemantic( "VIEWINVERSETRANSPOSE", ShaderSemantics.VIEW_MATRIX, ShaderSemantics.INVERSE_TRANSPOSE_MATRIX );
//            vgl.setMatrixParameterSemantic( "WORLDVIEWPROJECTION", ShaderSemantics.WORLDVIEWPROJECTION_MATRIX, ShaderSemantics.IDENTITY_MATRIX );

            for( int i=0; i<_chamfer.getNumOfMeshes(); i++ )
            {
                Mesh m = _chamfer.getMeshByIdx( i );

                vgl.setMatrixParameterSemantic( "WORLDMATRIX", _matWorld.getArray() );

                ((ShaderCGFX)vgl.getActiveShader()).setPass(); 

                _meshShatter.render( _gl );

                ((ShaderCGFX)vgl.getActiveShader()).resetPass();
            }
//          _chamfer.renderRawData();
//          _mesh.renderChunksNoMaterial( _gl );

          vgl.disableShader();              
          

        vgl.popMatrix();
    }




  // ------------------------------------------------------------------------------------------------
  Matrix getCubeMapViewMatrix( int idx )
  {
	Vector3 vEyePt = new Vector3( 0.0f, 0.0f, 0.0f );
	Vector3 vLookDir = new Vector3( 0.0f, 0.0f, 0.0f );
	Vector3 vUpDir = new Vector3( 0.0f, 1.0f, 0.0f );

        float dirUp = -1.0;

	switch( idx )
	{
	case RenderTargetCubeMap.CUBE_FACE_POSITIVE_X:
		vLookDir.set( 1.0f, 0.0f, 0.0f );
		vUpDir.set( 0.0f, dirUp*1.0f, 0.0f );
		break;
	case RenderTargetCubeMap.CUBE_FACE_NEGATIVE_X:
		vLookDir.set( -1.0f, 0.0f, 0.0f );
		vUpDir.set( 0.0f, dirUp*1.0f, 0.0f );
		break;
	case RenderTargetCubeMap.CUBE_FACE_POSITIVE_Y:
		vLookDir.set( 0.0f, 1.0f, 0.0f );
		vUpDir.set( 0.0f, 0.0f, 1.0f );
		break;
	case RenderTargetCubeMap.CUBE_FACE_NEGATIVE_Y:
		vLookDir.set( 0.0f, -1.0f, 0.0f );
		vUpDir.set( 0.0f, 0.0f, -1.0f );
		break;
	case RenderTargetCubeMap.CUBE_FACE_POSITIVE_Z:
		vLookDir.set( 0.0f, 0.0f, 1.0f );
		vUpDir.set( 0.0f, dirUp*1.0f, 0.0f );
		break;
	case RenderTargetCubeMap.CUBE_FACE_NEGATIVE_Z:
		vLookDir.set( 0.0f, 0.0f, -1.0f );
		vUpDir.set( 0.0f, dirUp*1.0f, 0.0f );
		break;
	}

//        vEyePt.add( cam.getPosition() );
//        vLookDir.add( cam.getPosition() );
        vEyePt.add( _cubePos );
        vLookDir.add( _cubePos );


	// Set the view transform for this cubemap surface
	Matrix mView;

        vgl.pushMatrix();
        vgl.identity( VGL.MODELVIEW );
        vgl.camera( vEyePt.x, vEyePt.y, vEyePt.z, vLookDir.x, vLookDir.y, vLookDir.z, vUpDir.x, vUpDir.y, vUpDir.z );
        mView = vgl.getViewMatrix();
        vgl.popMatrix();

	return mView;
  } 
  
  // __________________________________________________________
  // Members

  GL _gl;
}

