import javax.media.opengl.*;
import processing.opengl.*;
import vitamin.*;
import vitamin.math.*;
import vitamin.fx.*;

int WIDTH = 512;
int HEIGHT = 512;
float aspectRatio = WIDTH/(float)HEIGHT; 

VTimer timer;
VGL vgl;
EffectManager fxMan;
CustomScene scene;
VCamera cam; 



///___________________________________________________________
void setup()
{
    size( WIDTH, HEIGHT, OPENGL );
    hint( ENABLE_OPENGL_4X_SMOOTH ); 
    //hint( DISABLE_OPENGL_ERROR_REPORT ); 
  
    frameRate( 1000 ); 

    aspectRatio = width / (float)height; 

    vgl = new VGL( this );
    vgl.setVSync( true );
  

    cam = new VCamera( this, 0, 100, 200, 0, 100, 0, 0, 1, 0 ); 
    cam.setToCenter();
  
    fxMan = new EffectManager( vgl.gl() );
  
    scene = new CustomScene();
    scene.Init( vgl.gl() );
//  fxMan.AddEffect( scene );
  
    // Process all effects now!
//  fxMan.process();
  
    timer = new VTimer();
    timer.start();
}



///___________________________________________________________
void draw()
{
//  println( frameRate );
    float time = timer.getCurrTime();
    timer.update();
  
    vgl.begin();
    if( frameCount < 4 ) vgl.background( 0 );
  
    scene.Render( time );
    scene.Update( time );


    vgl.end();
  
  
    //
    // Update Camera
    //
//    updateCamera( 10.0 );
}

// ---------------------------------------------------------------------------------
// Update camera input
//
void updateCamera( float s )
{
    // Get input
    if( keyPressed && keyCode == LEFT )
        cam.strafe( -s );
    else if( keyPressed && keyCode == RIGHT )
        cam.strafe( s );
    if( keyPressed && keyCode == UP )
        cam.move( s );
    else if( keyPressed && keyCode == DOWN )
        cam.move( -s );
    if( keyPressed && key == 'q' )
        cam.lift( s );
    else if( keyPressed && key == 'a' )
        cam.lift( -s );
        
    cam.rotateByMouse( mouseX, mouseY, width/2, height/2 ); 
} 



void keyPressed()
{
    if( key == ' ' )
    {
        vgl.background( 0 );
        scene.mousePressCount = 0;
        scene._pointsV.clear();
        scene._pointsStar.clear();
    }
    
    if( key == 'o' )
    {
        for( int i=0; i<scene._pointsV.size(); i++ )
        {
            Vector3 p = (Vector3)scene._pointsV.get(i);
            scene.writeString( ""+p.x + ","+p.y+","+p.z+"\n" );
        }
        for( int i=0; i<scene._pointsStar.size(); i++ )
        {
            Vector3 p = (Vector3)scene._pointsStar.get(i);
            scene.writeString( ""+p.x + ","+p.y+","+p.z+"\n" );
        }
        try {
            scene.out.close();
        } catch(IOException e) {}         
    }
    
    if( key == 'c' )
    {
        println( "CamPos: " + cam.getPosition().toString() );
        println( "CamTarget: " + cam.getTarget().toString() );
        println( "CamRight: " + cam.getRight().toString() );
    }
}

void mousePressed()
{
    timer.reset();
}

void mouseReleased()
{
    scene.mousePressCount++;
}




///___________________________________________________________
void stop()
{
    scene.Release();
    vgl.release();
  
    super.stop();
}
