import krister.Ess.*; 



FFTHelper ffthelper;

int spectrumLength = 2048; // Needs to be power of 2

int numOfBands = 20;
float frequencyScale = 50; //40; 
float damperval;
AudioChannel chn;
FFT fft; 
int frameNumber = 0; 

//float fpsFudgeFactor = 30.0 / 29.97; // normally 1.0f
//float framesPerSecond = 30.0 * fpsFudgeFactor; 
int framesPerSecond = 30;

float level;  // channel level

float[] fftbuffer;

float lastTime;
float currentTime;


void init_sound( int spectrumLength, String filename ) 
{
  lastTime = 0.0;
  currentTime = 0.0;
  
  //
  // ESS
  //
  Ess.start( this ); 
  Ess.masterVolume( 1.0 );

  println( "loading " + filename );
  chn = new AudioChannel( filename ); 
  //println( "channel sample rate:  " + chn.sampleRate );

  fft = new FFT( spectrumLength*2 ); 

//  fft.equalizer( true );
  fft.limits();

  //
  // HELPER
  // 
  ffthelper = new FFTHelper( spectrumLength, numOfBands, false );
  ffthelper.setMaxLimits( 200, 2000 );
  damperval = 0.2f;
  ffthelper.setDamper( damperval );

  fftbuffer = new float[spectrumLength];
}


void play_sound()
{
  chn.volume( 1.0 );
  chn.play();
}


void analyze( float freq_scale, boolean renderToVideo ) 
{
    float[] data = null;
    
  if( renderToVideo )
  {
    // offline
    int pos = (int)(frameNumber * chn.sampleRate / framesPerSecond);
    //println( "pos: " + pos );
    if( pos >= chn.size )
    {
      System.exit( 0 );
    }
  
    try 
    {
      fft.getSpectrum( chn.samples, pos );
    }
    catch( ArrayIndexOutOfBoundsException e )
    {
      println("exploded ess: " + e);
    }  
  }
  else
  {
      if( useBASS )
      {
          data = getSpectrum( 1 );
      }
      else
      {
        // realtime
        try 
        {
          fft.getSpectrum( chn );
        }
        catch( ArrayIndexOutOfBoundsException e )
        {
          println("exploded ess: " + e);
        }
      }
  }
  
  if( useBASS )
  {
      // scale spectrum
      if( data != null )
      {
          for( int i=0; i<spectrumLength; i++ )
            fftbuffer[i] = data[i] * freq_scale;
      }
      else System.err.println( "BASS: spectrum data is null" );
  }
  else
  {
      // scale spectrum
      for( int i=0; i<fft.spectrum.length; i++ )
        fftbuffer[i] = fft.spectrum[i] * freq_scale;
  }

  // update spetrum helper
  ffthelper.update( fftbuffer );



  // intensify freq bands
//  for( int i=0; i<ffthelper.band.length; i++ )
//  {
//    ffthelper.band[i] *= freq_scale; 
//    ffthelper.bandmax[i] *= freq_scale; 
//  }
}



void store( String demoName, String directory, String extension ) 
{ 
  saveFrame( directory + "/" + demoName + "_" + nf(frameNumber, 7) + "." + extension ); 
}



void advance() 
{ 
  if ((frameNumber%framesPerSecond) == 0) 
  {
     lastTime = currentTime;
     currentTime = timer.getCurrTime();
    println( "Frame: " + frameNumber 
             + " | time: " + ((currentTime/60.0)/60.0) + "h"
             + " | average time per frame: " + ((currentTime-lastTime)/(float)framesPerSecond) + " secs" );
  }

  frameNumber++; 
}



void volume(float value)
{
    Ess.masterVolume(value);
}


void stop_sound()
{
  chn.stop();
  Ess.stop();
}  

