
//
// Chromatic Lens Aberration Filter
//

// Projection View Model Matrix
float4x4	gphProjectionModelViewMatrix;

// Source texture
sampler		gphTexture0:register(s0);

// Filter configuration parameters
// x - screen width
// y - screen height
// z - lens distortion
float4 Settings;

// Color aberration factors
static float3 ColorAberration = float3(0.9,0.8,0.7);

struct VS_INPUT
{
	float3 pos		: POSITION;
	float3 nor		: NORMAL;
	float2 uv		: TEXCOORD0;
};

struct VS_OUTPUT
{
	float4 pos		: POSITION;
	float2 uv		: TEXCOORD0;
	float2 coords	: TEXCOORD1;
};

// Vertex Shader
VS_OUTPUT gphMainVSH( VS_INPUT IN )
{
	VS_OUTPUT OUT;

	OUT.pos = mul(float4(IN.pos.xyz,1.0),gphProjectionModelViewMatrix);

	OUT.uv = IN.uv;
	OUT.coords = IN.pos.xy;
	return OUT;
}

// Fragment Shader
float4 gphMainFSH(VS_OUTPUT IN):COLOR
{
	float2 weight = IN.coords.xy/Settings.xy;
	weight = 1-pow(abs(1-weight*2),2);

	float2 final_weight = normalize(Settings.xy/2.0-IN.coords)*Settings.z*(1-weight.y* weight.x);

	float r = tex2D(gphTexture0,IN.uv+final_weight*ColorAberration.r).r;
	float g = tex2D(gphTexture0,IN.uv+final_weight*ColorAberration.g).g;
	float b = tex2D(gphTexture0,IN.uv+final_weight*ColorAberration.b).b;

	return float4(r,g,b,1.0);
}
