/*
 * Decompiled with CFR 0.152.
 */
package vitamin.fx;

import java.util.Vector;
import javax.media.opengl.GL;
import vitamin.fx.TimeSegment;

public abstract class Effect {
    protected float _currentTime;
    protected String _name;
    protected boolean _isActive;
    protected int _currTimeSegmentIdx;
    protected TimeSegment _activeTimeSegment = null;
    protected Vector<TimeSegment> _timeSegmentList;
    protected GL _gl = null;

    public Effect() {
        this._timeSegmentList = new Vector();
        this._isActive = false;
        this._name = Integer.toString((int)(Math.random() * 100000.0));
    }

    public Effect(float startTime, float endTime) {
        this.addTimeSegment(startTime, endTime);
        this._isActive = false;
        this._name = Integer.toString((int)(Math.random() * 100000.0));
    }

    public abstract boolean Init(GL var1);

    public abstract void Render(float var1);

    public void InnerRender(float time) {
        this._currentTime = this._activeTimeSegment.doResetTime() ? time - this.getStartTime() : time;
        this.Render(this._currentTime);
    }

    public abstract void Update(float var1);

    public abstract void Release();

    boolean checkActivity(float time) {
        for (TimeSegment ts : this._timeSegmentList) {
            if (!(time >= ts._startTime) || !(time <= ts._endTime)) continue;
            this.setActive(true);
            this._activeTimeSegment = ts;
            return true;
        }
        this.setActive(false);
        this._activeTimeSegment = null;
        return false;
    }

    public void addTimeSegment(float startTime, float endTime) {
        this.addTimeSegment(startTime, endTime, true);
    }

    public void addTimeSegment(float startTime, float endTime, boolean reset) {
        if (this._timeSegmentList == null) {
            this._timeSegmentList = new Vector();
        }
        TimeSegment TS = null;
        TS = startTime > endTime ? new TimeSegment(endTime, startTime, reset) : new TimeSegment(startTime, endTime, reset);
        this._timeSegmentList.add(TS);
        this._currTimeSegmentIdx = this._timeSegmentList.size() - 1;
        this._activeTimeSegment = null;
    }

    public void addTimeSegment(TimeSegment seg) {
        if (this._timeSegmentList.size() > 0) {
            System.err.println("not possible to add multiple time segments at the moment");
            return;
        }
        if (this._timeSegmentList == null) {
            this._timeSegmentList = new Vector();
        }
        this._timeSegmentList.add(seg);
        this._currTimeSegmentIdx = this._timeSegmentList.size() - 1;
        this._activeTimeSegment = null;
    }

    public TimeSegment getTimeSegment() {
        return this._timeSegmentList.get(this._currTimeSegmentIdx);
    }

    public float getStartTime() {
        return this._activeTimeSegment._startTime;
    }

    public float getEndTime() {
        return this._activeTimeSegment._endTime;
    }

    public void setActive(boolean f) {
        this._isActive = f;
    }

    public boolean isActive() {
        return this._isActive;
    }
}

