/*
 * Decompiled with CFR 0.152.
 */
package vitamin.math;

import vitamin.math.Matrix;
import vitamin.math.Vector3;

public class MatrixUtils {
    public static Matrix createViewMatrixLH(Vector3 pos, Vector3 target, Vector3 up) {
        Matrix m = new Matrix();
        Vector3 uAxis = Vector3.ZERO;
        Vector3 vAxis = Vector3.ZERO;
        Vector3 nAxis = Vector3.ZERO;
        nAxis = Vector3.sub(target, pos);
        nAxis.normalize();
        float dot = Vector3.dot(up, nAxis);
        Vector3 tmp = Vector3.mul(nAxis, dot);
        vAxis = Vector3.sub(up, tmp);
        if (vAxis.length() < 1.0E-5f) {
            vAxis.x = -nAxis.y * nAxis.x;
            vAxis.y = 1.0f - nAxis.y * nAxis.y;
            vAxis.z = -nAxis.y * nAxis.z;
            if (vAxis.length() < 1.0E-5f) {
                vAxis.x = -nAxis.z * nAxis.x;
                vAxis.y = -nAxis.z * nAxis.y;
                vAxis.z = 1.0f - nAxis.z * nAxis.z;
                if (vAxis.length() < 1.0E-5f) {
                    return null;
                }
            }
        }
        vAxis.normalize();
        uAxis = Vector3.cross(vAxis, nAxis);
        m._M[0] = uAxis.x;
        m._M[4] = vAxis.x;
        m._M[8] = nAxis.x;
        m._M[12] = 0.0f;
        m._M[1] = uAxis.y;
        m._M[5] = vAxis.y;
        m._M[9] = nAxis.y;
        m._M[13] = 0.0f;
        m._M[2] = uAxis.z;
        m._M[6] = vAxis.z;
        m._M[10] = nAxis.z;
        m._M[14] = 0.0f;
        m._M[3] = -Vector3.dot(pos, uAxis);
        m._M[7] = -Vector3.dot(pos, vAxis);
        m._M[11] = -Vector3.dot(pos, nAxis);
        m._M[15] = 1.0f;
        return m;
    }

    public static Matrix createViewMatrixRH(Vector3 pos, Vector3 target, Vector3 up) {
        Matrix m = new Matrix();
        Vector3 uAxis = Vector3.ZERO;
        Vector3 vAxis = Vector3.ZERO;
        Vector3 nAxis = Vector3.ZERO;
        nAxis = Vector3.sub(target, pos);
        nAxis.mul(-1.0f);
        nAxis.normalize();
        float dot = Vector3.dot(up, nAxis);
        Vector3 tmp = Vector3.mul(nAxis, dot);
        vAxis = Vector3.sub(up, tmp);
        if (vAxis.length() < 1.0E-5f) {
            vAxis.x = -nAxis.y * nAxis.x;
            vAxis.y = 1.0f - nAxis.y * nAxis.y;
            vAxis.z = -nAxis.y * nAxis.z;
            if (vAxis.length() < 1.0E-5f) {
                vAxis.x = -nAxis.z * nAxis.x;
                vAxis.y = -nAxis.z * nAxis.y;
                vAxis.z = 1.0f - nAxis.z * nAxis.z;
                if (vAxis.length() < 1.0E-5f) {
                    return null;
                }
            }
        }
        vAxis.normalize();
        uAxis = Vector3.cross(vAxis, nAxis);
        m._M[0] = uAxis.x;
        m._M[4] = vAxis.x;
        m._M[8] = nAxis.x;
        m._M[12] = 0.0f;
        m._M[1] = uAxis.y;
        m._M[5] = vAxis.y;
        m._M[9] = nAxis.y;
        m._M[13] = 0.0f;
        m._M[2] = uAxis.z;
        m._M[6] = vAxis.z;
        m._M[10] = nAxis.z;
        m._M[14] = 0.0f;
        m._M[3] = -Vector3.dot(pos, uAxis);
        m._M[7] = -Vector3.dot(pos, vAxis);
        m._M[11] = -Vector3.dot(pos, nAxis);
        m._M[15] = 1.0f;
        return m;
    }

    Matrix getCubemapMatrix(int side) {
        Matrix m = new Matrix();
        switch (side) {
            case 0: {
                m._M[0] = 0.0f;
                m._M[4] = 0.0f;
                m._M[8] = 1.0f;
                m._M[12] = 0.0f;
                m._M[1] = 0.0f;
                m._M[5] = 1.0f;
                m._M[9] = 0.0f;
                m._M[13] = 0.0f;
                m._M[2] = -1.0f;
                m._M[6] = 0.0f;
                m._M[10] = 0.0f;
                m._M[14] = 0.0f;
                m._M[3] = 0.0f;
                m._M[7] = 0.0f;
                m._M[11] = 0.0f;
                m._M[15] = 1.0f;
                return m;
            }
            case 1: {
                m._M[0] = 0.0f;
                m._M[4] = 0.0f;
                m._M[8] = -1.0f;
                m._M[12] = 0.0f;
                m._M[1] = 0.0f;
                m._M[5] = 1.0f;
                m._M[9] = 0.0f;
                m._M[13] = 0.0f;
                m._M[2] = 1.0f;
                m._M[6] = 0.0f;
                m._M[10] = 0.0f;
                m._M[14] = 0.0f;
                m._M[3] = 0.0f;
                m._M[7] = 0.0f;
                m._M[11] = 0.0f;
                m._M[15] = 1.0f;
                return m;
            }
            case 2: {
                m._M[0] = 1.0f;
                m._M[4] = 0.0f;
                m._M[8] = 0.0f;
                m._M[12] = 0.0f;
                m._M[1] = 0.0f;
                m._M[5] = 0.0f;
                m._M[9] = 1.0f;
                m._M[13] = 0.0f;
                m._M[2] = 0.0f;
                m._M[6] = -1.0f;
                m._M[10] = 0.0f;
                m._M[14] = 0.0f;
                m._M[3] = 0.0f;
                m._M[7] = 0.0f;
                m._M[11] = 0.0f;
                m._M[15] = 1.0f;
                return m;
            }
            case 3: {
                m._M[0] = 1.0f;
                m._M[4] = 0.0f;
                m._M[8] = 0.0f;
                m._M[12] = 0.0f;
                m._M[1] = 0.0f;
                m._M[5] = 0.0f;
                m._M[9] = -1.0f;
                m._M[13] = 0.0f;
                m._M[2] = 0.0f;
                m._M[6] = 1.0f;
                m._M[10] = 0.0f;
                m._M[14] = 0.0f;
                m._M[3] = 0.0f;
                m._M[7] = 0.0f;
                m._M[11] = 0.0f;
                m._M[15] = 1.0f;
                return m;
            }
            case 4: {
                m._M[0] = 1.0f;
                m._M[4] = 0.0f;
                m._M[8] = 0.0f;
                m._M[12] = 0.0f;
                m._M[1] = 0.0f;
                m._M[5] = 1.0f;
                m._M[9] = 0.0f;
                m._M[13] = 0.0f;
                m._M[2] = 0.0f;
                m._M[6] = 0.0f;
                m._M[10] = 1.0f;
                m._M[14] = 0.0f;
                m._M[3] = 0.0f;
                m._M[7] = 0.0f;
                m._M[11] = 0.0f;
                m._M[15] = 1.0f;
                return m;
            }
            case 5: {
                m._M[0] = -1.0f;
                m._M[4] = 0.0f;
                m._M[8] = 0.0f;
                m._M[12] = 0.0f;
                m._M[1] = 0.0f;
                m._M[5] = 1.0f;
                m._M[9] = 0.0f;
                m._M[13] = 0.0f;
                m._M[2] = 0.0f;
                m._M[6] = 0.0f;
                m._M[10] = -1.0f;
                m._M[14] = 0.0f;
                m._M[3] = 0.0f;
                m._M[7] = 0.0f;
                m._M[11] = 0.0f;
                m._M[15] = 1.0f;
                return m;
            }
        }
        return null;
    }
}

