/*
 * Decompiled with CFR 0.152.
 */
package vitamin.scenesimple;

import java.util.ArrayList;
import java.util.Vector;
import javax.media.opengl.GL;
import processing.core.PApplet;
import vitamin.VTexture;
import vitamin.math.Matrix;
import vitamin.math.Vector3;
import vitamin.scenesimple.Camera;
import vitamin.scenesimple.Helper;
import vitamin.scenesimple.Light;
import vitamin.scenesimple.Material;
import vitamin.scenesimple.Mesh;
import vitamin.scenesimple.MeshCylinder;
import vitamin.scenesimple.MeshSphere;
import vitamin.scenesimple.MultiMaterial;
import vitamin.scenesimple.Object;
import vitamin.scenesimple.StandardMaterial;
import vitamin.utils.VStringUtils;

public class Scene {
    Vector<Object> _objList;
    ArrayList<Material> _materials;
    Vector<Mesh> _meshes;
    Vector<Helper> _helpers;
    Vector<Camera> _cameras;
    Vector<Light> _lights;
    Vector<VTexture> _textures;
    GL _gl;
    PApplet _papplet;

    public Scene(GL gl) {
        this._papplet = null;
        this._gl = gl;
        this._materials = null;
        this._meshes = null;
        this._helpers = null;
        this._cameras = null;
        this._lights = null;
        this._textures = null;
        this._objList = null;
    }

    public Scene(PApplet p, GL gl) {
        this._papplet = p;
        this._gl = gl;
        this._materials = null;
        this._meshes = null;
        this._helpers = null;
        this._cameras = null;
        this._lights = null;
        this._textures = null;
        this._objList = null;
    }

    public void addMaterial(Material m) {
        assert (m != null);
        if (this._materials == null) {
            this._materials = new ArrayList();
        }
        this._materials.add(m);
    }

    public void addMesh(Mesh m) {
        assert (m != null);
        if (this._meshes == null) {
            this._meshes = new Vector();
        }
        this._meshes.add(m);
        if (this._objList == null) {
            this._objList = new Vector();
        }
        this._objList.add(m);
    }

    public void addHelper(Helper h) {
        assert (h != null);
        if (this._helpers == null) {
            this._helpers = new Vector();
        }
        this._helpers.add(h);
        if (this._objList == null) {
            this._objList = new Vector();
        }
        this._objList.add(h);
    }

    public void addCamera(Camera c) {
        assert (c != null);
        if (this._cameras == null) {
            this._cameras = new Vector();
        }
        this._cameras.add(c);
    }

    public void addLight(Light l) {
        assert (l != null);
        if (this._lights == null) {
            this._lights = new Vector();
        }
        this._lights.add(l);
    }

    public void addTexture(VTexture t) {
        assert (t != null);
        if (this._textures == null) {
            this._textures = new Vector();
        }
        this._textures.add(t);
    }

    public void generateBox(Vector3 pos, float size) {
        this.generateBox(pos, size, size, size);
    }

    public void generateBox(Vector3 pos, float w, float h, float d) {
        Mesh mesh = new Mesh();
        Vector3 pmin = new Vector3(-w, -h, -d);
        Vector3 pmax = new Vector3(w, h, d);
        mesh.addVertex(pmin.x, pmin.y, pmin.z);
        mesh.addVertex(pmin.x, pmax.y, pmin.z);
        mesh.addVertex(pmin.x, pmax.y, pmax.z);
        mesh.addVertex(pmin.x, pmin.y, pmax.z);
        mesh.addVertex(pmax.x, pmin.y, pmin.z);
        mesh.addVertex(pmax.x, pmax.y, pmin.z);
        mesh.addVertex(pmax.x, pmax.y, pmax.z);
        mesh.addVertex(pmax.x, pmin.y, pmax.z);
        mesh.addTriangle(0, 1, 2);
        mesh.addTriangle(3, 2, 3);
        mesh.addTriangle(4, 5, 7);
        mesh.addTriangle(7, 5, 6);
        mesh.addTriangle(7, 5, 6);
        this.addMesh(mesh);
    }

    public void generateSphere(String name, Vector3 pos, float radius, int detail) {
        MeshSphere s = new MeshSphere(name, pos, radius, detail);
        this.addMesh(s);
    }

    public void generateCylinder(String name, Vector3 pos, float radius, float len, int detail) {
        MeshCylinder c = new MeshCylinder(name, pos, radius, len, detail);
        this.addMesh(c);
    }

    public void process() {
        Mesh m;
        Material mat;
        if (this._meshes == null) {
            System.err.println("(Scene)  There are no meshes in the scene. abort!");
            return;
        }
        if (this._materials == null) {
            System.err.println("(Scene)  There are no materials in the scene. abort!");
            return;
        }
        if (this._materials != null) {
            System.out.println("(Scene)  Process Materials: " + this._materials.size());
        }
        int i = 0;
        while (i < this._materials.size()) {
            mat = this._materials.get(i);
            System.out.println("(Scene)  \tMaterial Name: " + mat._name);
            if (mat._type == 0) {
                StandardMaterial std = (StandardMaterial)mat;
                int numTextures = std._texNames.size();
                int ti = 0;
                while (ti < numTextures) {
                    String tmp = std._texNames.get(ti);
                    VTexture tex = this.getTextureByName(tmp);
                    if (tex != null) {
                        System.out.println("(Scene)  Idx: '" + i + "' Material: '" + mat._name + "' -- Texture: " + tmp + " has already been loaded!");
                        std._texList.add(tex);
                    } else {
                        System.err.println("(Scene)  Idx: '" + i + "' Material: '" + mat._name + "' -- Texture: " + tmp + " has not been found in the pool. Add it!!! ");
                        tex = new VTexture(this._gl, 3553);
                        tex._name = tmp;
                        if (this._papplet != null) {
                            tex.loadFromFile(this._papplet.dataPath(tmp), true, null);
                        } else {
                            tex.loadFromFile(VStringUtils.dataPath(tmp), true, null);
                        }
                        std._texList.add(tex);
                        this.addTexture(tex);
                    }
                    ++ti;
                }
            } else {
                System.out.println("(Scene)  Idx: '" + i + "' Material: '" + mat._name + "' must be a multi-material.");
            }
            ++i;
        }
        System.out.println("(Scene)  Now, Multi Materials");
        i = 0;
        while (i < this._materials.size()) {
            mat = this._materials.get(i);
            if (mat._type == 1) {
                System.out.println("(Scene)    '" + mat._name + "' is a multimaterial: ");
                MultiMaterial mmat = (MultiMaterial)this._materials.get(i);
                int mi = 0;
                while (mi < mmat._numSubMaterials) {
                    System.out.println("  (Scene)  # " + mmat._nameList.get(mi));
                    mmat._matList.add((StandardMaterial)this.getMatByName(mmat._nameList.get(mi)));
                    ++mi;
                }
            }
            ++i;
        }
        if (this._textures != null) {
            System.out.println("Size of Texture Pool: " + this._textures.size());
        }
        if (this._meshes != null) {
            System.out.println("Process meshes: " + this._meshes.size());
        }
        i = 0;
        while (i < this._meshes.size()) {
            m = this._meshes.get(i);
            if (m._mat == null) {
                m._mat = this.getMatByName(m._matName);
            }
            ++i;
        }
        i = 0;
        while (i < this._meshes.size()) {
            m = this._meshes.get(i);
            m.processChunks();
            m.computeNormals(false);
            m.computeTangents(false);
            ++i;
        }
        i = 0;
        while (i < this._meshes.size()) {
            m = this._meshes.get(i);
            if (m._parentName == null) {
                m._parent = null;
            } else {
                m._parent = this.getMeshByName(m._parentName);
                if (m._parent != null) {
                    m._parent._children.add(m);
                }
            }
            ++i;
        }
        if (this._cameras != null) {
            System.out.println("Process cameras: " + this._cameras.size());
        }
        if (this._cameras != null) {
            i = 0;
            while (i < this._cameras.size()) {
                Camera cam = this._cameras.get(i);
                System.out.println("(Scene)  \tCamera Name: " + cam._name);
                cam._position = cam._localMatrix.transform(cam._position);
                cam._target = cam._targetLocalMatrix.transform(cam._target);
                ++i;
            }
        }
        if (this._lights != null) {
            System.out.println("Process lights: " + this._lights.size());
        }
        if (this._lights != null) {
            i = 0;
            while (i < this._lights.size()) {
                Light lit = this._lights.get(i);
                System.out.println("(Scene)  \tLight Name: " + lit._name);
                Vector3 pos = lit._position.xyz();
                pos = lit._localMatrix.transform(pos);
                lit._position.set(pos, lit._position.w);
                ++i;
            }
        }
    }

    public void update(float time) {
        int i = 0;
        while (i < this._meshes.size()) {
            Mesh m = this._meshes.get(i);
            Object omp = m._parent;
            Matrix matLocal = m._localMatrix.copy();
            matLocal.debug();
            if (omp == null) {
                System.err.println("no parent");
            }
            while (omp != null) {
                matLocal = matLocal.mulColumnMajor(omp._localMatrix);
                omp = omp._parent;
            }
            this._gl.glMultMatrixf(matLocal.getFloatBuffer());
            ++i;
        }
    }

    public void render() {
        int i = 0;
        while (i < this._meshes.size()) {
            Mesh m = this._meshes.get(i);
            this._gl.glPushMatrix();
            Object omp = m._parent;
            Matrix matLocal = m._localMatrix.copy();
            while (omp != null) {
                matLocal = matLocal.mulColumnMajor(omp._localMatrix);
                omp = omp._parent;
            }
            this._gl.glMultMatrixf(matLocal.getFloatBuffer());
            m.renderChunks(this._gl, null);
            this._gl.glPopMatrix();
            ++i;
        }
    }

    public void renderNoMaterial() {
        int i = 0;
        while (i < this._meshes.size()) {
            Mesh m = this._meshes.get(i);
            this._gl.glPushMatrix();
            Object omp = m._parent;
            Matrix matLocal = m._localMatrix.copy();
            while (omp != null) {
                matLocal = matLocal.mulColumnMajor(omp._localMatrix);
                omp = omp._parent;
            }
            this._gl.glMultMatrixf(matLocal.getFloatBuffer());
            m.renderChunksNoMaterial(this._gl);
            this._gl.glPopMatrix();
            ++i;
        }
    }

    public void renderCustom() {
        int i = 0;
        while (i < this._meshes.size()) {
            Mesh m = this._meshes.get(i);
            m.renderChunksNoMaterial(this._gl);
            ++i;
        }
    }

    public void renderMeshByName(String name) {
        Mesh m = this.getMeshByName(name);
        if (m == null) {
            return;
        }
        m.renderChunks(this._gl, null);
    }

    public void renderVertexNormals(float scale) {
        int i = 0;
        while (i < this._meshes.size()) {
            Mesh m = this._meshes.get(i);
            this._gl.glPushMatrix();
            Object omp = m._parent;
            Matrix matLocal = m._localMatrix.copy();
            while (omp != null) {
                matLocal = matLocal.mulColumnMajor(omp._localMatrix);
                omp = omp._parent;
            }
            this._gl.glMultMatrixf(matLocal.getFloatBuffer());
            m.renderVertexNormals(this._gl, scale);
            this._gl.glPopMatrix();
            ++i;
        }
    }

    public void renderRawData() {
        int i = 0;
        while (i < this._meshes.size()) {
            Mesh m = this._meshes.get(i);
            m.renderChunksNoMaterial(this._gl);
            ++i;
        }
    }

    public Camera getCamera(int i) {
        if (this._cameras == null) {
            return null;
        }
        return this._cameras.get(i);
    }

    public Camera getCameraByName(String name) {
        int i = 0;
        while (i < this._cameras.size()) {
            Camera m = this._cameras.get(i);
            if (m._name.equals(name)) {
                return m;
            }
            ++i;
        }
        return null;
    }

    public Light getLight(int i) {
        if (this._lights == null) {
            return null;
        }
        return this._lights.get(i);
    }

    public Light getLightByName(String name) {
        int i = 0;
        while (i < this._lights.size()) {
            Light m = this._lights.get(i);
            if (m._name.equals(name)) {
                return m;
            }
            ++i;
        }
        return null;
    }

    public Mesh getMeshByIdx(int i) {
        if (this._meshes == null) {
            return null;
        }
        if (i >= this._meshes.size()) {
            System.err.println("(Scene)  Error! Mesh index is out of bounds.");
            return null;
        }
        return this._meshes.get(i);
    }

    public Mesh getMeshByName(String name) {
        int i = 0;
        while (i < this._meshes.size()) {
            Mesh m = this._meshes.get(i);
            if (m._name.equals(name)) {
                return m;
            }
            ++i;
        }
        return null;
    }

    public Material getMaterial(int i) {
        if (this._materials == null) {
            return null;
        }
        if (i >= this._materials.size()) {
            System.err.println("(Scene)  Error! Material index is out of bounds.");
            return null;
        }
        return this._materials.get(i);
    }

    public Material getMatByName(String name) {
        int mi = 0;
        while (mi < this._materials.size()) {
            Material mm = this._materials.get(mi);
            if (name.equals(mm._name)) {
                return mm;
            }
            ++mi;
        }
        return null;
    }

    public int getMatIdxByName(String name) {
        int mi = 0;
        while (mi < this._materials.size()) {
            Material mm = this._materials.get(mi);
            if (name.equals(mm._name)) {
                return mi;
            }
            ++mi;
        }
        return -1;
    }

    public VTexture getTextureByName(String name) {
        if (this._textures == null) {
            return null;
        }
        if (this._textures.size() == 0) {
            return null;
        }
        int mi = 0;
        while (mi < this._textures.size()) {
            VTexture tex = this._textures.get(mi);
            if (tex != null && tex._name != null && name.equals(tex._name)) {
                return tex;
            }
            ++mi;
        }
        return null;
    }

    public int getNumOfMeshes() {
        return this._meshes.size();
    }

    public void debug() {
        if (this._meshes == null) {
            System.err.println("(Scene)  There are no meshes in this scene for debug information. Abort!");
            return;
        }
        System.out.println("(Scene)  ----------------------------");
        System.out.println("(Scene)  num of meshes: " + this._meshes.size());
        if (this._helpers != null) {
            System.out.println("(Scene)  num of helpers: " + this._helpers.size());
        }
        if (this._cameras != null) {
            System.out.println("(Scene)  num of cameras: " + this._cameras.size());
        }
        if (this._lights != null) {
            System.out.println("(Scene)  num of lights: " + this._lights.size());
        }
        if (this._materials != null) {
            System.out.println("(Scene)  num of materials: " + this._materials.size());
        }
        if (this._textures != null) {
            System.out.println("(Scene)  num of textures: " + this._textures.size());
        }
        int i = 0;
        while (i < this._meshes.size()) {
            Mesh m = this._meshes.get(i);
            m.debug();
            ++i;
        }
    }
}

