/*
 * Decompiled with CFR 0.152.
 */
package crayolon.portamod;

import crayolon.portamod.FastTracker2;
import crayolon.portamod.IBXM;
import crayolon.portamod.Module;
import crayolon.portamod.ProTracker;
import crayolon.portamod.ScreamTracker3;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;

public class Player {
    private Thread play_thread;
    public IBXM ibxm;
    public Module module;
    public int song_duration;
    public int play_position;
    public boolean running;
    public boolean loop;
    public byte[] output_buffer;
    public SourceDataLine output_line;
    public SourceDataLine source;
    public int receivedbuffersize;
    public int rate = 1024;
    public AudioFormat af;
    Mixer.Info[] brenmix;
    Line.Info[] brenlines;
    Mixer brenmixer;

    public static Module load_module(InputStream input) throws IllegalArgumentException, IOException {
        DataInputStream data_input_stream = new DataInputStream(input);
        byte[] xm_header = new byte[60];
        data_input_stream.readFully(xm_header);
        if (FastTracker2.is_xm(xm_header)) {
            return FastTracker2.load_xm(xm_header, data_input_stream);
        }
        byte[] s3m_header = new byte[96];
        System.arraycopy(xm_header, 0, s3m_header, 0, 60);
        data_input_stream.readFully(s3m_header, 60, 36);
        if (ScreamTracker3.is_s3m(s3m_header)) {
            return ScreamTracker3.load_s3m(s3m_header, data_input_stream);
        }
        byte[] mod_header = new byte[1084];
        System.arraycopy(s3m_header, 0, mod_header, 0, 96);
        data_input_stream.readFully(mod_header, 96, 988);
        return ProTracker.load_mod(mod_header, data_input_stream);
    }

    public Player(int interp) throws LineUnavailableException {
        this.ibxm = new IBXM(48000, interp);
        this.set_loop(true);
        System.out.println(AudioSystem.getMixerInfo());
        this.brenmix = AudioSystem.getMixerInfo();
        this.brenmixer = AudioSystem.getMixer(this.brenmix[0]);
        this.brenlines = this.brenmixer.getSourceLineInfo();
        this.af = new AudioFormat(48000.0f, 16, 2, true, true);
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, this.af);
        this.output_line = AudioSystem.getSourceDataLine(new AudioFormat(48000.0f, 16, 2, true, true), this.brenmixer.getMixerInfo());
        this.output_buffer = new byte[this.rate * 4];
    }

    public void set_module(Module m) {
        if (m != null) {
            this.module = m;
        }
        this.stop();
        this.ibxm.set_module(this.module);
        this.song_duration = this.ibxm.calculate_song_duration();
    }

    public void seek(int s) {
        int sample_position = s;
        this.ibxm.seek(sample_position);
        this.play_position = sample_position;
    }

    public int get_seek_return() {
        return this.play_position;
    }

    public int get_bpm() {
        return this.module.default_tempo;
    }

    public void set_global_volume(int vol) {
        int volume = vol;
        this.ibxm.set_global_volume(volume);
    }

    public void set_speed(int speed) {
        if (speed > 0 && speed < 256) {
            this.ibxm.set_speed(speed);
        }
    }

    public void set_tempo(int bpm) {
        if (bpm > 31 && bpm < 256) {
            this.ibxm.set_tempo(bpm);
        }
    }

    public int get_num_channels() {
        int num_channels = this.module.get_num_channels();
        return num_channels;
    }

    public int get_sequence_length() {
        return this.module.get_sequence_length();
    }

    public void set_sequence(int sequence_index, int pattern_index) {
        if (sequence_index >= 0 && sequence_index < this.module.get_sequence_length()) {
            this.module.set_sequence(sequence_index, pattern_index);
        }
    }

    public String get_title() {
        return this.module.song_title;
    }

    public int get_num_instruments() {
        int numinst = this.module.get_num_instruments();
        return numinst;
    }

    public String[] infotext() {
        String[] infotext = null;
        int i = 0;
        while (i < this.module.get_num_instruments() - 1) {
            try {
                infotext[i] = this.module.instruments[i].name == null ? "" : this.module.instruments[i].name;
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
        return infotext;
    }

    public String ins_name(int ins_num) {
        String first_ins_name = this.module.instruments[ins_num].name;
        return first_ins_name;
    }

    public void set_loop(boolean loop) {
        this.loop = loop;
    }

    public void receivebuffer(int buffersize) {
        this.receivedbuffersize = buffersize;
    }

    public void play() {
        this.stop();
        this.play_thread = new Thread(new Driver());
        this.play_thread.start();
    }

    public void stop() {
        this.running = false;
        if (this.play_thread != null) {
            try {
                this.play_thread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public class Driver
    implements Runnable {
        @Override
        public void run() {
            if (Player.this.running) {
                return;
            }
            try {
                Player.this.output_line.open(new AudioFormat(48000.0f, 16, 2, true, true), 11025);
                Player.this.output_line.start();
                Player.this.play_position = 0;
                Player.this.running = true;
                while (Player.this.running) {
                    int frames = Player.this.song_duration - Player.this.play_position;
                    if (frames > Player.this.rate) {
                        frames = Player.this.rate;
                    }
                    Player.this.ibxm.get_audio(Player.this.output_buffer, frames);
                    Player.this.output_line.write(Player.this.output_buffer, 0, frames * 4);
                    Player.this.play_position += frames;
                    if (Player.this.play_position < Player.this.song_duration) continue;
                    Player.this.play_position = 0;
                    if (Player.this.loop) continue;
                    Player.this.running = false;
                }
                Player.this.output_line.flush();
                Player.this.output_line.close();
            }
            catch (LineUnavailableException lue) {
                lue.printStackTrace();
            }
        }
    }
}

