/*
 * Decompiled with CFR 0.152.
 */
package vitamin.math;

public class FastMath {
    private static final double ONE_SIXTH = 0.16666666666666666;
    private static final int FRAC_EXP = 8;
    private static final int LUT_SIZE = 257;
    private static final double FRAC_BIAS = Double.longBitsToDouble(4805340802404319232L);
    private static final double[] ASIN_TAB = new double[257];
    private static final double[] COS_TAB = new double[257];

    static {
        int ind = 0;
        while (ind < 257) {
            double v = (double)ind / 256.0;
            double asinv = Math.asin(v);
            FastMath.COS_TAB[ind] = Math.cos(asinv);
            FastMath.ASIN_TAB[ind] = asinv;
            ++ind;
        }
    }

    public static double invSqrt(double x) {
        double xhalf = 0.5 * x;
        long i = Double.doubleToRawLongBits(x);
        i = 6910469410427058090L - (i >> 1);
        x = Double.longBitsToDouble(i);
        x *= 1.5 - xhalf * x * x;
        return x;
    }

    public static float atan2Fast(float y, float x) {
        float angle;
        float coeff_1 = 0.7853982f;
        float coeff_2 = 3.0f * coeff_1;
        float abs_y = Math.abs(y);
        if (x >= 0.0f) {
            float r = (x - abs_y) / (x + abs_y);
            angle = coeff_1 - coeff_1 * r;
        } else {
            float r = (x + abs_y) / (abs_y - x);
            angle = coeff_2 - coeff_1 * r;
        }
        return y < 0.0f ? -angle : angle;
    }

    public static double fast_atan2(double y, double x) {
        boolean steep;
        boolean negX;
        boolean negY;
        double d2 = x * x + y * y;
        if (Double.isNaN(d2) || Double.doubleToRawLongBits(d2) < 0x10000000000000L) {
            return Double.NaN;
        }
        boolean bl = negY = y < 0.0;
        if (negY) {
            y = -y;
        }
        boolean bl2 = negX = x < 0.0;
        if (negX) {
            x = -x;
        }
        boolean bl3 = steep = y > x;
        if (steep) {
            double t = x;
            x = y;
            y = t;
        }
        double rinv = FastMath.invSqrt(d2);
        x *= rinv;
        double yp = FRAC_BIAS + (y *= rinv);
        int ind = (int)Double.doubleToRawLongBits(yp);
        double o = ASIN_TAB[ind];
        double co = COS_TAB[ind];
        double so = yp - FRAC_BIAS;
        double sd = y * co - x * so;
        double d = (6.0 + sd * sd) * sd * 0.16666666666666666;
        double be = o + d;
        if (steep) {
            be = 1.5707963267948966 - be;
        }
        if (negX) {
            be = Math.PI - be;
        }
        if (negY) {
            be = -be;
        }
        return be;
    }
}

