/*
 * Decompiled with CFR 0.152.
 */
package vitamin.utils;

import vitamin.math.Vector3;

public class ImageUtils {
    public static void ComputeHeightfieldNormals(int xsize, int ysize, float[] heightmap, Vector3[] Normalmap) {
        int x = 0;
        int y = 0;
        int xsm = xsize - 1;
        int ysm = ysize - 1;
        y = 0;
        while (y < ysize) {
            x = 0;
            while (x < xsize) {
                Vector3 N = Normalmap[y * xsize + x];
                N.x = heightmap[y * xsize + (x == 0 ? 0 : x - 1)] - heightmap[y * xsize + (x == xsm ? xsm : x + 1)];
                N.y = heightmap[(y == 0 ? 0 : y - 1) * xsize + x] - heightmap[(y == ysm ? ysm : y + 1) * xsize + x];
                N.z = 2.0f / (float)xsize + 2.0f / (float)ysize;
                float l = (float)Math.sqrt(N.x * N.x + N.y * N.y + N.z * N.z);
                if (l != 0.0f) {
                    N.x /= l;
                    N.y /= l;
                    N.z /= l;
                } else {
                    N.z = 0.0f;
                    N.y = 0.0f;
                    N.x = 0.0f;
                }
                ++x;
            }
            ++y;
        }
    }
}

