/*
 * Decompiled with CFR 0.152.
 */
package vitamin;

import java.nio.IntBuffer;
import java.util.ArrayList;
import javax.media.opengl.GL;
import vitamin.SurfaceFormat;
import vitamin.VLogger;
import vitamin.VSamplerState;
import vitamin.VTexture;
import vitamin.VTexture2D;
import vitamin.VTextureRECT;

public class MultiRenderTarget2D {
    private int[] _appViewport = null;
    GL _gl;
    int _numOfTargets;
    ArrayList<VTexture> _texList;
    ArrayList<Integer> _texFormats;
    ArrayList<VSamplerState> _texSamplerStates;
    private int[] _fboID;
    private int[] _depthStencilBufferID;
    VTexture _depthTex;
    int _targetID;
    int _width;
    int _height;
    VSamplerState _samplerState;

    public MultiRenderTarget2D(GL gl, int numOfTargets, int width, int height, int format) {
        this(gl, numOfTargets, 3553, width, height, format, new VSamplerState());
    }

    public MultiRenderTarget2D(GL gl, int numOfTargets, int width, int height, int format, VSamplerState samp) {
        this(gl, numOfTargets, 3553, width, height, format, samp);
    }

    public MultiRenderTarget2D(GL gl, int numOfTargets, int targetID, int width, int height, int format, VSamplerState samp) {
        VTexture tmp;
        int i;
        this._gl = gl;
        this._numOfTargets = numOfTargets;
        this._width = width;
        this._height = height;
        this._appViewport = null;
        this._targetID = targetID;
        this._samplerState = samp;
        switch (targetID) {
            case 3553: {
                this._texList = new ArrayList();
                i = 0;
                while (i < this._numOfTargets) {
                    tmp = new VTexture2D(this._gl);
                    this._texList.add(tmp);
                    ++i;
                }
                break;
            }
            case 34037: {
                this._texList = new ArrayList();
                i = 0;
                while (i < this._numOfTargets) {
                    tmp = new VTextureRECT(this._gl);
                    this._texList.add(tmp);
                    ++i;
                }
                break;
            }
        }
        switch (SurfaceFormat.getValue(format)) {
            case 5: {
                i = 0;
                while (i < this._numOfTargets) {
                    tmp = this._texList.get(i);
                    tmp.create(this._targetID, this._width, this._height, 5, samp);
                    ++i;
                }
                break;
            }
            case 6: {
                i = 0;
                while (i < this._numOfTargets) {
                    tmp = this._texList.get(i);
                    tmp.create(this._targetID, this._width, this._height, 6, samp);
                    ++i;
                }
                break;
            }
            case 4: {
                i = 0;
                while (i < this._numOfTargets) {
                    tmp = this._texList.get(i);
                    tmp.create(this._targetID, this._width, this._height, 4, samp);
                    ++i;
                }
                break;
            }
            case 7: {
                i = 0;
                while (i < this._numOfTargets) {
                    tmp = this._texList.get(i);
                    tmp.create(this._targetID, this._width, this._height, 7, samp);
                    ++i;
                }
                break;
            }
            case 8: {
                i = 0;
                while (i < this._numOfTargets) {
                    tmp = this._texList.get(i);
                    tmp.create(this._targetID, this._width, this._height, 8, samp);
                    ++i;
                }
                break;
            }
            case 9: {
                i = 0;
                while (i < this._numOfTargets) {
                    tmp = this._texList.get(i);
                    tmp.create(this._targetID, this._width, this._height, 9, samp);
                    ++i;
                }
                break;
            }
            case 10: {
                i = 0;
                while (i < this._numOfTargets) {
                    tmp = this._texList.get(i);
                    tmp.create(this._targetID, this._width, this._height, 10, samp);
                    ++i;
                }
                break;
            }
            case 11: {
                i = 0;
                while (i < this._numOfTargets) {
                    tmp = this._texList.get(i);
                    tmp.create(this._targetID, this._width, this._height, 11, samp);
                    ++i;
                }
                break;
            }
            case 12: {
                i = 0;
                while (i < this._numOfTargets) {
                    tmp = this._texList.get(i);
                    tmp.create(this._targetID, this._width, this._height, 12, samp);
                    ++i;
                }
                break;
            }
            case 13: {
                i = 0;
                while (i < this._numOfTargets) {
                    tmp = this._texList.get(i);
                    tmp.create(this._targetID, this._width, this._height, 13, samp);
                    ++i;
                }
                break;
            }
            case 14: {
                i = 0;
                while (i < this._numOfTargets) {
                    tmp = this._texList.get(i);
                    tmp.create(this._targetID, this._width, this._height, 14, samp);
                    ++i;
                }
                break;
            }
            case 15: {
                i = 0;
                while (i < this._numOfTargets) {
                    tmp = this._texList.get(i);
                    tmp.create(this._targetID, this._width, this._height, 15, samp);
                    ++i;
                }
                break;
            }
            default: {
                System.err.println("Surface Format not yet implemented");
            }
        }
        this._fboID = new int[1];
        this._depthStencilBufferID = new int[1];
        this._gl.glGenFramebuffersEXT(1, this._fboID, 0);
        this._gl.glBindFramebufferEXT(36160, this._fboID[0]);
        this.attachRenderBuffer(6402);
        ArrayList<Integer> attachments = new ArrayList<Integer>();
        int i2 = 0;
        while (i2 < this._numOfTargets) {
            VTexture tmp2 = this._texList.get(i2);
            this.attachTexture(36064 + i2, this._targetID, tmp2.getID());
            attachments.add(36064 + i2);
            ++i2;
        }
        System.out.println("Multi Render Target with '" + attachments.size() + "' buffers.");
        int[] buf = new int[attachments.size()];
        int i3 = 0;
        while (i3 < buf.length) {
            buf[i3] = (Integer)attachments.get(i3);
            ++i3;
        }
        this._gl.glDrawBuffers(attachments.size(), IntBuffer.wrap(buf));
        this.validate();
        this._gl.glBindFramebufferEXT(36160, 0);
    }

    public MultiRenderTarget2D(GL gl, int targetID, int width, int height) {
        this._gl = gl;
        this._appViewport = null;
        this._targetID = targetID;
        this._width = width;
        this._height = height;
        this._texFormats = new ArrayList();
        this._texSamplerStates = new ArrayList();
    }

    public void release() {
        this._gl.glDeleteTextures(1, this._fboID, 0);
        this._gl.glDeleteTextures(1, this._depthStencilBufferID, 0);
    }

    public void addRenderTarget(int format) {
        this.addRenderTarget(format, null);
    }

    public void addRenderTarget(int format, VSamplerState samp) {
        this._texFormats.add(format);
        this._texSamplerStates.add(samp);
        ++this._numOfTargets;
    }

    public void process() {
        int i;
        switch (this._targetID) {
            case 3553: {
                VTexture tmp;
                this._texList = new ArrayList();
                i = 0;
                while (i < this._numOfTargets) {
                    tmp = new VTexture2D(this._gl);
                    this._texList.add(tmp);
                    ++i;
                }
                break;
            }
            case 34037: {
                VTexture tmp;
                this._texList = new ArrayList();
                i = 0;
                while (i < this._numOfTargets) {
                    tmp = new VTextureRECT(this._gl);
                    this._texList.add(tmp);
                    ++i;
                }
                break;
            }
        }
        i = 0;
        while (i < this._numOfTargets) {
            int sf = this._texFormats.get(i);
            VSamplerState ss = this._texSamplerStates.get(i);
            VTexture tmp = this._texList.get(i);
            tmp.create(this._targetID, this._width, this._height, sf, ss);
            ++i;
        }
        this._fboID = new int[1];
        this._depthTex = new VTexture(this._gl, 36161);
        this._depthTex.createDepthRT(this._width, this._height, 16);
        this._gl.glGenFramebuffersEXT(1, this._fboID, 0);
        this._gl.glBindFramebufferEXT(36160, this._fboID[0]);
        ArrayList<Integer> attachments = new ArrayList<Integer>();
        int i2 = 0;
        while (i2 < this._numOfTargets) {
            VTexture tmp = this._texList.get(i2);
            this.attachTexture(36064 + i2, this._targetID, tmp.getID());
            attachments.add(36064 + i2);
            ++i2;
        }
        this._gl.glFramebufferRenderbufferEXT(36160, 36096, 36161, this._depthTex.getID());
        if (this._depthTex._format == 16) {
            this._gl.glFramebufferRenderbufferEXT(36160, 36128, 36161, this._depthTex.getID());
        } else {
            this._gl.glFramebufferRenderbufferEXT(36160, 36128, 36161, 0);
        }
        System.out.println("Multi Render Target with '" + attachments.size() + "' buffers.");
        int[] buf = new int[attachments.size()];
        int i3 = 0;
        while (i3 < buf.length) {
            buf[i3] = (Integer)attachments.get(i3);
            ++i3;
        }
        this._gl.glDrawBuffers(attachments.size(), IntBuffer.wrap(buf));
        this._gl.glReadBuffer(36064);
        this.validate();
        this._gl.glBindFramebufferEXT(36160, 0);
    }

    public void bind() {
        if (this._appViewport == null) {
            this._appViewport = new int[4];
            this._gl.glGetIntegerv(2978, this._appViewport, 0);
        }
        this._gl.glViewport(0, 0, this._width, this._height);
        this._gl.glBindFramebufferEXT(36160, this._fboID[0]);
    }

    public void unbind() {
        this._gl.glBindFramebufferEXT(36160, 0);
        if (this._appViewport != null) {
            this._gl.glViewport(this._appViewport[0], this._appViewport[1], this._appViewport[2], this._appViewport[3]);
        }
    }

    public void enable() {
        this.bind();
    }

    public void disable() {
        this.unbind();
    }

    public void attachTexture(int attachment, int texTarget, int texId) {
        this._gl.glFramebufferTexture2DEXT(36160, attachment, texTarget, texId, 0);
    }

    public void attachRenderBuffer(int attachment) {
        this._gl.glGenRenderbuffersEXT(1, this._depthStencilBufferID, 0);
        this._gl.glBindRenderbufferEXT(36161, this._depthStencilBufferID[0]);
        this._gl.glRenderbufferStorageEXT(36161, attachment, this._width, this._height);
        this._gl.glFramebufferRenderbufferEXT(36160, 36096, 36161, this._depthStencilBufferID[0]);
    }

    public void setDrawBuffer(int idx) {
        switch (idx) {
            case -1: {
                this._gl.glDrawBuffer(0);
                this._gl.glReadBuffer(0);
                break;
            }
            case 0: {
                this._gl.glDrawBuffer(36064);
                break;
            }
            case 1: {
                this._gl.glDrawBuffer(36065);
                break;
            }
            case 2: {
                this._gl.glDrawBuffer(36066);
                break;
            }
            case 3: {
                this._gl.glDrawBuffer(36067);
                break;
            }
            case 4: {
                this._gl.glDrawBuffer(36068);
                break;
            }
            case 5: {
                this._gl.glDrawBuffer(36069);
                break;
            }
            case 6: {
                this._gl.glDrawBuffer(36070);
                break;
            }
            case 7: {
                this._gl.glDrawBuffer(36071);
                break;
            }
            case 8: {
                this._gl.glDrawBuffer(36072);
                break;
            }
            default: {
                System.err.println("(MultiRenderTarget2D)  setDrawBuffer: no default");
            }
        }
    }

    public void restoreDrawBuffer() {
        this._gl.glDrawBuffer(1029);
        this._gl.glReadBuffer(1029);
    }

    private void validate() {
        int stat = this._gl.glCheckFramebufferStatusEXT(36160);
        switch (stat) {
            case 36053: {
                VLogger.getSingleton().log("(MultiRenderTarget2D)  GL_FRAMEBUFFER_COMPLETE_EXT");
                System.out.println("(MultiRenderTarget2D)  GL_FRAMEBUFFER_COMPLETE_EXT");
                break;
            }
            case 36054: {
                VLogger.getSingleton().log("(MultiRenderTarget2D)  GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT_EXT");
                System.err.println("(MultiRenderTarget2D)  GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT_EXT");
                break;
            }
            case 36055: {
                VLogger.getSingleton().log("(MultiRenderTarget2D)  GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT_EXT");
                System.err.println("(MultiRenderTarget2D)  GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT_EXT");
                break;
            }
            case 36057: {
                VLogger.getSingleton().log("(MultiRenderTarget2D)  GL_FRAMEBUFFER_INCOMPLETE_DIMENSIONS_EXT");
                System.err.println("(MultiRenderTarget2D)  GL_FRAMEBUFFER_INCOMPLETE_DIMENSIONS_EXT");
                break;
            }
            case 36058: {
                VLogger.getSingleton().log("(MultiRenderTarget2D)  GL_FRAMEBUFFER_INCOMPLETE_FORMATS_EXT");
                System.err.println("(MultiRenderTarget2D)  GL_FRAMEBUFFER_INCOMPLETE_FORMATS_EXT");
                break;
            }
            case 36059: {
                VLogger.getSingleton().log("(MultiRenderTarget2D)  GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER_EXT");
                System.err.println("(MultiRenderTarget2D)  GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER_EXT");
                break;
            }
            case 36060: {
                VLogger.getSingleton().log("(MultiRenderTarget2D)  GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER_EXT");
                System.err.println("(MultiRenderTarget2D)  GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER_EXT");
                break;
            }
            case 36061: {
                VLogger.getSingleton().log("(MultiRenderTarget2D)  GL_FRAMEBUFFER_UNSUPPORTED_EXT");
                System.err.println("(MultiRenderTarget2D)  GL_FRAMEBUFFER_UNSUPPORTED_EXT");
                break;
            }
            default: {
                VLogger.getSingleton().log("(MultiRenderTarget2D)  Unknown");
                System.err.println("(MultiRenderTarget2D)  Unknown");
            }
        }
    }

    public void delete() {
        this._gl.glDeleteFramebuffersEXT(1, this._fboID, 0);
        this._gl.glDeleteRenderbuffersEXT(1, this._depthStencilBufferID, 0);
    }

    public int getWidth() {
        return this._width;
    }

    public int getHeight() {
        return this._width;
    }

    public int getFBOID() {
        return this._fboID[0];
    }

    public VTexture getDepthTexture() {
        return this._depthTex;
    }

    public int getDepthTextureID() {
        return this._depthTex.getID();
    }

    public VTexture getTexture(int idx) {
        return this._texList.get(idx);
    }

    public int getTextureID(int idx) {
        return this._texList.get(idx).getID();
    }
}

