/*
 * Decompiled with CFR 0.152.
 */
package vitamin.interpolation;

import vitamin.interpolation.Interpolator;

public class Elastic
implements Interpolator {
    public static float easeIn(float t, float b, float c, float d) {
        if (t > d) {
            return c;
        }
        if (t == 0.0f) {
            return b;
        }
        float dist = c - b;
        if ((t /= d) == 1.0f) {
            return b + dist;
        }
        float p = d * 0.3f;
        float a = dist;
        float s = p / 4.0f;
        return -(a * (float)Math.pow(2.0, 10.0f * (t -= 1.0f)) * (float)Math.sin((t * d - s) * ((float)Math.PI * 2) / p)) + b;
    }

    public static float easeIn(float t, float b, float c, float d, float a, float p) {
        float s;
        if (t > d) {
            return c;
        }
        if (t == 0.0f) {
            return b;
        }
        float dist = c - b;
        if ((t /= d) == 1.0f) {
            return b + dist;
        }
        if (a < Math.abs(c)) {
            a = dist;
            s = p / 4.0f;
        } else {
            s = p / ((float)Math.PI * 2) * (float)Math.asin(dist / a);
        }
        return -(a * (float)Math.pow(2.0, 10.0f * (t -= 1.0f)) * (float)Math.sin((double)(t * d - s) * (Math.PI * 2) / (double)p)) + b;
    }

    public static float easeOut(float t, float b, float c, float d) {
        if (t > d) {
            return c;
        }
        if (t == 0.0f) {
            return b;
        }
        float dist = c - b;
        if ((t /= d) == 1.0f) {
            return b + dist;
        }
        float p = d * 0.3f;
        float a = dist;
        float s = p / 4.0f;
        return a * (float)Math.pow(2.0, -10.0f * t) * (float)Math.sin((t * d - s) * ((float)Math.PI * 2) / p) + dist + b;
    }

    public static float easeOut(float t, float b, float c, float d, float a, float p) {
        float s;
        if (t > d) {
            return c;
        }
        if (t == 0.0f) {
            return b;
        }
        float dist = c - b;
        if ((t /= d) == 1.0f) {
            return b + dist;
        }
        if (a < Math.abs(c)) {
            a = dist;
            s = p / 4.0f;
        } else {
            s = p / ((float)Math.PI * 2) * (float)Math.asin(dist / a);
        }
        return a * (float)Math.pow(2.0, -10.0f * t) * (float)Math.sin((t * d - s) * ((float)Math.PI * 2) / p) + dist + b;
    }

    public static float easeInOut(float t, float b, float c, float d) {
        if (t > d) {
            return c;
        }
        if (t == 0.0f) {
            return b;
        }
        float dist = c - b;
        if ((t /= d * 0.5f) == 2.0f) {
            return b + dist;
        }
        float p = d * 0.45000002f;
        float a = dist;
        float s = p / 4.0f;
        if (t < 1.0f) {
            return -0.5f * (a * (float)Math.pow(2.0, 10.0f * (t -= 1.0f)) * (float)Math.sin((t * d - s) * ((float)Math.PI * 2) / p)) + b;
        }
        return a * (float)Math.pow(2.0, -10.0f * (t -= 1.0f)) * (float)Math.sin((t * d - s) * ((float)Math.PI * 2) / p) * 0.5f + dist + b;
    }

    public static float easeInOut(float t, float b, float c, float d, float a, float p) {
        float s;
        if (t > d) {
            return c;
        }
        if (t == 0.0f) {
            return b;
        }
        float dist = c - b;
        if ((t /= d * 0.5f) == 2.0f) {
            return b + dist;
        }
        if (a < Math.abs(c)) {
            a = dist;
            s = p / 4.0f;
        } else {
            s = p / ((float)Math.PI * 2) * (float)Math.asin(dist / a);
        }
        if (t < 1.0f) {
            return -0.5f * (a * (float)Math.pow(2.0, 10.0f * (t -= 1.0f)) * (float)Math.sin((t * d - s) * ((float)Math.PI * 2) / p)) + b;
        }
        return a * (float)Math.pow(2.0, -10.0f * (t -= 1.0f)) * (float)Math.sin((t * d - s) * ((float)Math.PI * 2) / p) * 0.5f + dist + b;
    }
}

