/*
 * Decompiled with CFR 0.152.
 */
package vitamin.scenesimple;

import vitamin.math.Vector3;
import vitamin.scenesimple.Mesh;
import vitamin.scenesimple.Vertex;

public class BoundingBox {
    public Vector3 _min;
    public Vector3 _max;
    public Vector3 _center;

    BoundingBox() {
        this._min = new Vector3();
        this._max = new Vector3();
        this._center = new Vector3();
    }

    BoundingBox(BoundingBox aabb) {
        this._min = aabb._min.clone();
        this._max = aabb._max.clone();
        this._center = aabb._center.clone();
    }

    public BoundingBox clone() {
        BoundingBox b = new BoundingBox();
        b._min = this._min.clone();
        b._max = this._max.clone();
        b._center = this._center.clone();
        return b;
    }

    public void calculate(Mesh m) {
        int numOfPoints = m.getVertexCount();
        int i = 0;
        while (i < numOfPoints) {
            Vertex v = m.getVertexList().get(i);
            if (v.getPosition().x < this._min.x) {
                this._min.x = v.getPosition().x;
            }
            if (v.getPosition().x > this._max.x) {
                this._max.x = v.getPosition().x;
            }
            if (v.getPosition().y < this._min.y) {
                this._min.y = v.getPosition().y;
            }
            if (v.getPosition().y > this._max.y) {
                this._max.y = v.getPosition().y;
            }
            if (v.getPosition().z < this._min.z) {
                this._min.z = v.getPosition().z;
            }
            if (v.getPosition().z > this._max.z) {
                this._max.z = v.getPosition().z;
            }
            ++i;
        }
        this._center.x = (this._min.x + this._max.x) * 0.5f;
        this._center.y = (this._min.y + this._max.y) * 0.5f;
        this._center.z = (this._min.z + this._max.z) * 0.5f;
    }

    void expand(float amt) {
        this._max.x += amt;
        this._min.x -= amt;
        this._max.y += amt;
        this._min.y -= amt;
        this._max.z += amt;
        this._min.z -= amt;
        this._center.x = (this._min.x + this._max.x) * 0.5f;
        this._center.y = (this._min.y + this._max.y) * 0.5f;
        this._center.z = (this._min.z + this._max.z) * 0.5f;
    }

    void translate(Vector3 v) {
        this._min.add(v);
        this._max.add(v);
        this._center.add(v);
    }

    boolean collisionCheck(BoundingBox aabb) {
        Vector3 b = new Vector3(aabb._min.x, aabb._max.y, aabb._min.z);
        Vector3 c = new Vector3(aabb._max.x, aabb._max.y, aabb._min.z);
        Vector3 d = new Vector3(aabb._max.x, aabb._min.y, aabb._min.z);
        Vector3 e = new Vector3(aabb._min.x, aabb._min.y, aabb._max.z);
        Vector3 f = new Vector3(aabb._min.x, aabb._max.y, aabb._max.z);
        Vector3 h = new Vector3(aabb._max.x, aabb._min.y, aabb._max.z);
        if (this.collisionCheck(aabb._min)) {
            return true;
        }
        if (this.collisionCheck(b)) {
            return true;
        }
        if (this.collisionCheck(c)) {
            return true;
        }
        if (this.collisionCheck(d)) {
            return true;
        }
        if (this.collisionCheck(e)) {
            return true;
        }
        if (this.collisionCheck(f)) {
            return true;
        }
        if (this.collisionCheck(aabb._max)) {
            return true;
        }
        return this.collisionCheck(h);
    }

    boolean collisionCheck(Vector3 v) {
        if (this._max.x <= v.x) {
            return false;
        }
        if (this._min.x >= v.x) {
            return false;
        }
        if (this._max.y <= v.y) {
            return false;
        }
        if (this._min.y >= v.y) {
            return false;
        }
        if (this._max.z <= v.z) {
            return false;
        }
        return !(this._min.z >= v.z);
    }
}

