/*
 * Decompiled with CFR 0.152.
 */
package vitamin.math;

import vitamin.math.Matrix;
import vitamin.math.Vector3;

public class Quaternion {
    public float x;
    public float y;
    public float z;
    public float w;

    public Quaternion() {
        this.z = 0.0f;
        this.y = 0.0f;
        this.x = 0.0f;
        this.w = 1.0f;
    }

    public Quaternion(float xx, float yy, float zz, float ww) {
        this.x = xx;
        this.y = yy;
        this.z = zz;
        this.w = ww;
    }

    public Quaternion(Vector3 v, float ww) {
        this.x = v.x;
        this.y = v.y;
        this.z = v.z;
        this.w = ww;
    }

    public Vector3 xyz() {
        return new Vector3(this.x, this.y, this.z);
    }

    public Quaternion clone() {
        return new Quaternion(this.x, this.y, this.z, this.w);
    }

    public void reset() {
        this.x = 0.0f;
        this.y = 0.0f;
        this.z = 0.0f;
        this.w = 0.0f;
    }

    public void setIdentity() {
        this.x = 0.0f;
        this.y = 0.0f;
        this.z = 0.0f;
        this.w = 1.0f;
    }

    public void set(Quaternion q) {
        this.w = q.w;
        this.x = q.x;
        this.y = q.y;
        this.z = q.z;
    }

    public void set(Vector3 v, float w) {
        this.x = v.x;
        this.y = v.y;
        this.z = v.z;
        this.w = w;
    }

    public void set(float x, float y, float z, float w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    public Quaternion add(Quaternion q) {
        Quaternion tmp = new Quaternion();
        tmp.w = this.w + q.w;
        tmp.x = this.x + q.x;
        tmp.y = this.y + q.y;
        tmp.z = this.z + q.z;
        return tmp;
    }

    public Quaternion sub(Quaternion q) {
        Quaternion tmp = new Quaternion();
        tmp.w = this.w - q.w;
        tmp.x = this.x - q.x;
        tmp.y = this.y - q.y;
        tmp.z = this.z - q.z;
        return tmp;
    }

    public Quaternion mul(float s) {
        Quaternion tmp = new Quaternion();
        tmp.w = this.w * s;
        tmp.x = this.x * s;
        tmp.y = this.y * s;
        tmp.z = this.z * s;
        return tmp;
    }

    public void normalize() {
        float ilen = 1.0f / this.length();
        if (ilen > 0.0f) {
            this.x *= ilen;
            this.y *= ilen;
            this.z *= ilen;
            this.w *= ilen;
        }
    }

    public float length() {
        return (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w);
    }

    public void conjugate() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
    }

    public Quaternion mul(Quaternion q2) {
        Quaternion q = new Quaternion();
        q.w = this.w * q2.w - this.x * q2.x - this.y * q2.y - this.z * q2.z;
        q.x = this.w * q2.x + this.x * q2.w + this.y * q2.z - this.z * q2.y;
        q.y = this.w * q2.y - this.x * q2.z + this.y * q2.w + this.z * q2.x;
        q.z = this.w * q2.z + this.x * q2.y - this.y * q2.x + this.z * q2.w;
        return q;
    }

    public void fromMatrix(Matrix m) {
        float trace = 0.0f;
        trace = m._M[0] + m._M[5] + m._M[10] + m._M[15] + 1.0f;
        if (trace > 1.0E-4f) {
            float s = 0.5f / (float)Math.sqrt(trace);
            this.w = 0.25f / s;
            this.x = (m._M[6] - m._M[9]) * s;
            this.y = (m._M[8] - m._M[2]) * s;
            this.z = (m._M[1] - m._M[4]) * s;
        } else if (m._M[0] > m._M[5] && m._M[0] > m._M[10]) {
            float s = 2.0f * (float)Math.sqrt(1.0f + m._M[0] - m._M[5] - m._M[10]);
            float is = 1.0f / s;
            this.w = (m._M[8] - m._M[5]) * is;
            this.x = 0.25f * s;
            this.y = (m._M[4] + m._M[1]) * is;
            this.z = (m._M[8] + m._M[2]) * is;
        } else if (m._M[5] > m._M[10]) {
            float s = 2.0f * (float)Math.sqrt(1.0f + m._M[5] - m._M[0] - m._M[10]);
            float is = 1.0f / s;
            this.w = (m._M[8] - m._M[2]) * is;
            this.x = (m._M[4] + m._M[1]) * is;
            this.y = 0.25f * s;
            this.z = (m._M[9] + m._M[6]) * is;
        } else {
            float s = 2.0f * (float)Math.sqrt(1.0f + m._M[10] - m._M[0] - m._M[5]);
            float is = 1.0f / s;
            this.w = (m._M[4] - m._M[0]) * is;
            this.x = (m._M[8] + m._M[2]) * is;
            this.y = (m._M[6] + m._M[9]) * is;
            this.z = 0.25f * s;
        }
    }

    public void rotateAxis(Vector3 axis, float angle) {
        float halfAngle = angle * 0.5f;
        float sina = (float)Math.sin(halfAngle);
        this.w = (float)Math.cos(halfAngle);
        this.x = axis.x * sina;
        this.y = axis.y * sina;
        this.z = axis.z * sina;
    }

    public Matrix toRotationMatrix2() {
        Matrix m = new Matrix();
        m.identity();
        m._M[0] = 1.0f - 2.0f * this.y * this.y - 2.0f * this.z * this.z;
        m._M[1] = 2.0f * this.x * this.y + 2.0f * this.w * this.z;
        m._M[2] = 2.0f * this.x * this.z - 2.0f * this.w * this.y;
        m._M[3] = 0.0f;
        m._M[4] = 2.0f * this.x * this.y - 2.0f * this.w * this.z;
        m._M[5] = 1.0f - 2.0f * this.x * this.x - 2.0f * this.z * this.z;
        m._M[6] = 2.0f * this.y * this.z + 2.0f * this.w * this.x;
        m._M[7] = 0.0f;
        m._M[8] = 2.0f * this.x * this.z + 2.0f * this.w * this.y;
        m._M[9] = 2.0f * this.y * this.z - 2.0f * this.w * this.x;
        m._M[10] = 1.0f - 2.0f * this.x * this.x - 2.0f * this.y * this.y;
        m._M[11] = 0.0f;
        m._M[12] = 0.0f;
        m._M[13] = 0.0f;
        m._M[14] = 0.0f;
        m._M[15] = 1.0f;
        return m;
    }

    public Matrix toRotationMatrix() {
        Matrix m = new Matrix();
        float x2 = this.x + this.x;
        float y2 = this.y + this.y;
        float z2 = this.z + this.z;
        float xx = this.x * x2;
        float xy = this.x * y2;
        float xz = this.x * z2;
        float yy = this.y * y2;
        float yz = this.y * z2;
        float zz = this.z * z2;
        float wx = this.w * x2;
        float wy = this.w * y2;
        float wz = this.w * z2;
        m._M[0] = 1.0f - (yy + zz);
        m._M[1] = xy + wz;
        m._M[2] = xz - wy;
        m._M[3] = 0.0f;
        m._M[4] = xy - wz;
        m._M[5] = 1.0f - (xx + zz);
        m._M[6] = yz + wx;
        m._M[7] = 0.0f;
        m._M[8] = xz + wy;
        m._M[9] = yz - wx;
        m._M[10] = 1.0f - (xx + yy);
        m._M[11] = 0.0f;
        m._M[12] = 0.0f;
        m._M[13] = 0.0f;
        m._M[14] = 0.0f;
        m._M[15] = 1.0f;
        return m;
    }

    public Vector3 mul(Vector3 v) {
        Vector3 uv = new Vector3();
        Vector3 uuv = new Vector3();
        Vector3 qvec = new Vector3(this.x, this.y, this.z);
        uv = qvec.cross(v);
        uuv = qvec.cross(uv);
        uv.mul(2.0f * this.w);
        uuv.mul(2.0f);
        Vector3 result = v.copy();
        result.add(uv);
        result.add(uuv);
        return result;
    }

    public static float dot(Quaternion q1, Quaternion q2) {
        return q1.x * q2.x + q1.y * q2.y + q1.z * q2.z + q1.w * q2.w;
    }

    public static Quaternion mul(Quaternion q1, Quaternion q2) {
        Quaternion q = new Quaternion();
        q.w = q1.w * q2.w - q1.x * q2.x - q1.y * q2.y - q1.z * q2.z;
        q.x = q1.w * q2.x + q1.x * q2.w + q1.y * q2.z - q1.z * q2.y;
        q.y = q1.w * q2.y - q1.x * q2.z + q1.y * q2.w + q1.z * q2.x;
        q.z = q1.w * q2.z + q1.x * q2.y - q1.y * q2.x + q1.z * q2.w;
        return q;
    }

    public static Quaternion mul2(Quaternion q1, Quaternion q2) {
        Quaternion out = new Quaternion();
        out.w = q1.w * q2.w - q1.x * q2.x - q1.y * q2.y - q1.z * q2.z;
        out.x = q1.x * q2.w + q1.w * q2.x + q1.y * q2.z - q1.z * q2.y;
        out.y = q1.y * q2.w + q1.w * q2.y + q1.z * q2.x - q1.x * q2.z;
        out.z = q1.z * q2.w + q1.w * q2.z + q1.x * q2.y - q1.y * q2.x;
        return out;
    }

    public static Quaternion mul(Quaternion q, float s) {
        Quaternion tq = new Quaternion();
        tq.w = q.w * s;
        tq.x = q.x * s;
        tq.y = q.y * s;
        tq.z = q.z * s;
        return tq;
    }

    public static Vector3 transformVector(Quaternion q, Vector3 v) {
        Matrix m = q.toRotationMatrix();
        Vector3 vt = v.copy();
        vt.transform(m);
        return vt;
    }

    public Quaternion mulVec(Vector3 v) {
        Quaternion out = new Quaternion();
        out.w = -(this.x * v.x) - this.y * v.y - this.z * v.z;
        out.x = this.w * v.x + this.y * v.z - this.z * v.y;
        out.y = this.w * v.y + this.z * v.x - this.x * v.z;
        out.z = this.w * v.z + this.x * v.y - this.y * v.x;
        return out;
    }

    public Vector3 rotatePoint(Vector3 v) {
        Quaternion tmp = new Quaternion();
        Quaternion _final = new Quaternion();
        Quaternion qv = new Quaternion();
        qv.x = v.x;
        qv.y = v.y;
        qv.z = v.z;
        qv.w = 0.0f;
        Quaternion inv = this.clone();
        inv.conjugate();
        tmp = Quaternion.mul(this, qv);
        _final = Quaternion.mul(tmp, inv);
        Vector3 out = new Vector3(_final.x, _final.y, _final.z);
        return out;
    }

    public static Quaternion lerp(Quaternion from, Quaternion to, float t) {
        Quaternion q = new Quaternion();
        float onet = 1.0f - t;
        q.w = onet * from.w + t * to.w;
        q.x = onet * from.x + t * to.x;
        q.y = onet * from.y + t * to.y;
        q.z = onet * from.z + t * to.z;
        return q;
    }

    public static Quaternion slerp(Quaternion from, Quaternion to, float t) {
        Quaternion q = new Quaternion();
        Quaternion to2 = new Quaternion();
        float omega = 0.0f;
        float sinom = 0.0f;
        float scale0 = 1.0f;
        float scale1 = 0.0f;
        float dot = from.x * to.x + from.y * to.y + from.z * to.z + from.w * to.w;
        if (dot < 0.0f) {
            dot = -dot;
            to2.w = -to.w;
            to2.x = -to.x;
            to2.y = -to.y;
            to2.z = -to.z;
        } else {
            to2.w = to.w;
            to2.x = to.x;
            to2.y = to.y;
            to2.z = to.z;
        }
        float DELTA = 1.0E-7f;
        if (1.0 - (double)dot > (double)DELTA) {
            omega = (float)Math.acos(dot);
            sinom = (float)Math.sin(omega);
            float isinom = 1.0f / sinom;
            scale0 = (float)Math.sin((1.0f - t) * omega) * isinom;
            scale1 = (float)Math.sin(t * omega) * isinom;
        } else {
            scale0 = 1.0f - t;
            scale1 = t;
        }
        q.w = scale0 * from.w + scale1 * to2.w;
        q.x = scale0 * from.x + scale1 * to2.x;
        q.y = scale0 * from.y + scale1 * to2.y;
        q.z = scale0 * from.z + scale1 * to2.z;
        return q;
    }

    public float[] getValue() {
        float[] res = new float[4];
        float sa = (float)Math.sqrt(1.0f - this.w * this.w);
        if (sa < 1.0E-6f) {
            sa = 1.0f;
        }
        res[0] = (float)Math.acos(this.w) * 2.0f;
        res[1] = this.x / sa;
        res[2] = this.y / sa;
        res[3] = this.z / sa;
        return res;
    }

    public Vector3 getForwardVector() {
        Vector3 dir = new Vector3(2.0f * this.x * this.z - 2.0f * this.w * this.y, 2.0f * this.y * this.z + 2.0f * this.w * this.x, 1.0f - 2.0f * this.x * this.x - 2.0f * this.y * this.y);
        return dir;
    }

    public void debug() {
        System.out.println(String.valueOf(this.x) + ", " + this.y + ", " + this.z + ", " + this.w);
    }

    public String toString() {
        return new String(String.valueOf(this.x) + ", " + this.y + ", " + this.z + ", " + this.w);
    }
}

