/*
 * Decompiled with CFR 0.152.
 */
package vitamin.utils;

import vitamin.math.Matrix;
import vitamin.math.Quaternion;
import vitamin.math.Vector3;

public class VArcball {
    static float Epsilon = 1.0E-6f;
    Vector3 circlePointStart = new Vector3();
    Vector3 circlePointEnd = new Vector3();
    Vector3 spherePointStart = new Vector3();
    Vector3 spherePointEnd = new Vector3();
    Quaternion clickQuat = new Quaternion();
    Quaternion dragQuat = new Quaternion();
    Quaternion orientation = new Quaternion();
    Matrix matrix = new Matrix();
    float _radius;
    Vector3 _sphereCenter;

    public VArcball(Vector3 sphereCenter, float radius) {
        this.matrix.identity();
        this._radius = radius;
        this._sphereCenter = sphereCenter;
    }

    public Vector3 getPointSphere(float mx, float my) {
        Vector3 result = new Vector3();
        float radius = this._radius;
        Vector3 center = this._sphereCenter;
        result.x = (mx - center.x) / radius;
        result.y = (my - center.y) / radius;
        float mag = result.x * result.x + result.y * result.y;
        if (mag > 1.0f) {
            float isr = 1.0f / (float)Math.sqrt(mag);
            result.x *= isr;
            result.y *= isr;
            result.z = 0.0f;
        } else {
            result.z = (float)Math.sqrt(1.0f - mag);
        }
        return result;
    }

    public Vector3 getPointSphere(Vector3 P) {
        float len = P.x * P.x + P.y * P.y;
        Vector3 result = new Vector3();
        result.x = P.x;
        result.y = P.y;
        result.z = P.z;
        result.x = P.x;
        result.y = P.y;
        result.z = (float)Math.sqrt(1.0f - len);
        return result;
    }

    public Quaternion getQuat(Vector3 pStartPoint, Vector3 pEndPoint) {
        Quaternion result = new Quaternion();
        Vector3 crossResult = Vector3.cross(pStartPoint, pEndPoint);
        float len = crossResult.length();
        if (len > Epsilon) {
            float dotResult = Vector3.dot(pStartPoint, pEndPoint);
            result.set(crossResult, dotResult);
        } else {
            result.set(new Vector3(0.0f, 0.0f, 0.0f), 0.0f);
        }
        return result;
    }

    public void mousePressed(float mouseX, float mouseY) {
        this.circlePointStart.x = (mouseX - this._sphereCenter.x) / this._radius;
        this.circlePointStart.y = -(mouseY - this._sphereCenter.y) / this._radius;
        this.spherePointStart = this.getPointSphere(this.circlePointStart);
        this.clickQuat.set(this.orientation);
        this.dragQuat.setIdentity();
    }

    public void mouseDragged(float mouseX, float mouseY) {
        this.circlePointEnd.x = (mouseX - this._sphereCenter.x) / this._radius;
        this.circlePointEnd.y = -(mouseY - this._sphereCenter.y) / this._radius;
        this.spherePointEnd = this.getPointSphere(this.circlePointEnd);
        this.dragQuat = this.getQuat(this.spherePointStart, this.spherePointEnd);
    }

    public void run() {
        this.orientation = Quaternion.mul(this.dragQuat, this.clickQuat);
        this.orientation.normalize();
        this.matrix = this.orientation.toRotationMatrix();
    }
}

