/*
  suIHQlhde 
  koodi kipe sotku :I
*/

#include<iostream>
#include<math.h>
#include<cstdlib> 
#include<SDL/SDL.h>
#include<SDL/SDL_opengl.h>
#include<SDL/SDL_mixer.h>

#define WATER_DROPLETS 800

#define START_EFFECT 0
#define MAX_EFFECTS  20


Uint32 duration;
Uint32 totaltime;
float r=0.0f;
float spora=0.0f;
int effect_running;
Mix_Music *music = NULL;

GLuint		texture[6];


int effect_runtimes[] = {1000,  1500,  2000,  2500,  7500, 7500, 2500, 5000,  2500,
                         2500,  5000,  2500,  7500,  7500, 5000, 5000, 5000,  1000,
                         2500,  2500,  5000,  500};

int effect_wait[]     = {0,     0,      0,     0,     1,     0,     1,      1,      1,
                         0,     0,      0,     0,     1,     1,     0,      0,      0,
                         0,     0,      0,     0};


class cParticle {
public:
  float x,y,z;
  float vx,vy,vz;
  void draw();
  void init(int _id);
  void init();
  void doframe();
  int id;
  float idF;
  int effect_id;
};

cParticle particles[WATER_DROPLETS];

float randfloat(float a, float b)
{
  return ((b-a)*((float)rand()/RAND_MAX))+a;
}

void cParticle::init(int _id)
{
  id = _id;
  idF = (float)_id; // This is used to calculate the starting velocities
}

void cParticle::init() {
  effect_id = effect_running;

  x = 0.0f;
  y = 0.0f;
  z = 0.0f; 

  switch (effect_id) {
    case 0:
      if (id < 20) {
        vx = randfloat(-0.03,0.03);
        vz = randfloat(-0.03,0.03); 
        vy = randfloat(0.0, 0.25);
      }
      break;

    case 1:
      if (id < 50) {
        vx = randfloat(-0.03,0.03);
        vz = randfloat(-0.03,0.03); 
        vy = randfloat(0.0, 0.25);
      }
      break;

    case 2:
      if (id < 400) {
        vx = randfloat(-0.03,0.03);
        vz = randfloat(-0.03,0.03); 
        vy = randfloat(0.0, 0.25);
      }
      break;

    case 3:
      if (id < 800) {
        vx = randfloat(-0.03,0.03);
        vz = randfloat(-0.03,0.03); 
        vy = randfloat(0.0, 0.25);
      }
      break;
    case 4:
      vx = sin(idF/WATER_DROPLETS*6.3)/35.0;
      vy = (id % 9)/500.0f+0.2f;
      vz = cos(idF/WATER_DROPLETS*6.3)/35.0;
      break;
    case 5:
      vx = -sin(idF/WATER_DROPLETS*6.3)/25.0;
      vy = 0.2f + sin(idF/WATER_DROPLETS*6.3)/50.0 + (id % 9)/500.0f;
      vz = cos(idF/WATER_DROPLETS*6.3)/25.0;
      break;
    case 6:
      vx = sin(idF/WATER_DROPLETS*6.3)/25.0;
      vy = 0.2f + sin(idF/WATER_DROPLETS*6.3)/50.0 + (id % 9)/500.0f;
      vz = cos(idF/WATER_DROPLETS*6.3)/25.0;
      break;
    case 7:
      vx = sin(idF/WATER_DROPLETS*6.3)/25.0;
      vy = 0.2f + sin(idF/WATER_DROPLETS*6.3)/50.0 + (id % 9)/500.0f;
      vz = cos(idF/WATER_DROPLETS*6.3)/25.0;
      break;
    case 8:
      vx = sin(idF/WATER_DROPLETS*6.3)/25.0;
      vy = 0.2f + idF/WATER_DROPLETS/50.0 + (id % 9)/500.0f;
      vz = cos(idF/WATER_DROPLETS*6.3)/25.0;
      break;
    case 9:
      if ( id < WATER_DROPLETS / 2)
        vx = -sin(idF/WATER_DROPLETS*6.3)/25.0;
      else
        vx = sin(idF/WATER_DROPLETS*6.3)/25.0;
      vy = 0.2f + sin(idF/WATER_DROPLETS*6.3)/50.0 + (id % 9)/500.0f;
      vz = -cos(idF/WATER_DROPLETS*6.3)/25.0;
      break;
    case 10:
      if ( id > WATER_DROPLETS / 2)
        vx = -sin(idF/WATER_DROPLETS*6.3)/25.0;
      else
        vx = sin(idF/WATER_DROPLETS*6.3)/25.0;
      vy = 0.2f + sin(idF/WATER_DROPLETS*6.3)/50.0 + (id % 9)/500.0f;
      vz = -cos(idF/WATER_DROPLETS*6.3)/25.0;
      break;
    case 11:
      vx = sin(idF/WATER_DROPLETS*6.3)/25.0;
      vy = 0.2f + sin(idF/WATER_DROPLETS*6.3)/50.0 + (id % 9)/500.0f;
      vz = cos(idF/WATER_DROPLETS*6.3)/25.0;
      break;
    case 12:
      vx = cos(idF/WATER_DROPLETS*6.3)/25.0;
      vy = 0.2f + sin(idF/WATER_DROPLETS*6.3)/50.0 + (id % 9)/500.0f;
      vz = sin(idF/WATER_DROPLETS*6.3)/25.0;
      break;
    case 13:
      vx = sin(idF/WATER_DROPLETS*6.3+3.141)/25.0;
      vy = 0.2f + sin(idF/WATER_DROPLETS*6.3)/50.0 + (id % 9)/500.0f;
      vz = cos(idF/WATER_DROPLETS*6.3)/25.0;
      break;
    case 14:
      vx = 0; vz=0;
      x = sin(idF/WATER_DROPLETS*6.3) + (id % 20)/500.0f ;
      vy = 0.2f + sin(idF/WATER_DROPLETS*6.3)/50.0;
      z = cos(idF/WATER_DROPLETS*6.3);
      break;
    case 15: // SINE WAVE
      vx = 0; vz=0;
      x = sin(idF/WATER_DROPLETS*6.3);
      vy = 0.2f + sin(idF/WATER_DROPLETS*6.3)/50.0 + (id % 15)/500.0f;
      z = cos(idF/WATER_DROPLETS*6.3);
      break;
    case 16: // HUGE EXPLOSION
      if (id < 800) {
        vx = randfloat(-0.03,0.03);
        vz = randfloat(-0.03,0.03); 
        vy = randfloat(0.0, 0.25);
      }
      break;
    case 17: // BIG EXPLOSION
      if (id < 500) {
        vx = randfloat(-0.03,0.03);
        vz = randfloat(-0.03,0.03); 
        vy = randfloat(0.0, 0.25);
      }
      break;
    case 18: // MEDIUM EXPLOSION
      if (id < 150) {
        vx = randfloat(-0.03,0.03);
        vz = randfloat(-0.03,0.03); 
        vy = randfloat(0.0, 0.25);
      }
      break;

    case 19: // SMALL EXPLOSION
      if (id < 60) {
      vx = sin(idF/WATER_DROPLETS*6.3)/35.0;
      vy = (id % 9)/500.0f+0.2f;
      vz = cos(idF/WATER_DROPLETS*6.3)/35.0;
      }
      break;

    case 20:
      vy = 0;
      vx = 0;
      vz = 0;
      break;
  }
}

void cParticle::draw() {
  if (y > 0) {
    glBegin(GL_QUADS);
      glTexCoord2d(0,0); 
      glVertex3f(x-0.05f, y-0.05f, z);
      glTexCoord2d(0,1); 
      glVertex3f(x-0.05f, y+0.05f, z);
      glTexCoord2d(1,1); 
      glVertex3f(x+0.05f, y+0.05f, z);
      glTexCoord2d(1,0); 
      glVertex3f(x+0.05f, y-0.05f, z);
    glEnd();
  }
}

void cParticle::doframe() {
  float dt = duration/40.0f;
  vy = vy - 0.01f*dt;
  y = y + vy*dt;
  x = x + vx*dt;
  z = z + vz*dt;
}

int doEvents(void)
{
  SDL_Event event;

  while (SDL_PollEvent(&event)) {
    if (event.type == SDL_QUIT) {
			return -1;
		}
		if (event.type == SDL_KEYDOWN && event.key.keysym.sym == SDLK_ESCAPE) {
			return -1;
		}
  }

  totaltime += duration;


  // If we are running overtime
  if (totaltime > effect_runtimes[effect_running]) {

    if ( effect_wait[effect_running] == 1) {
      bool done = true;


      for (int i = 0; i<WATER_DROPLETS ; i++) {
        if (particles[i].y > 0)
          done = false;
      }

      if (done == true) {

        if (effect_running < MAX_EFFECTS + 1)
          effect_running++;

        for (int i = 0; i<WATER_DROPLETS ; i++) 
          particles[i].init();

        totaltime = 0;
      } else {
        for (int i = 0; i<WATER_DROPLETS ; i++)
          particles[i].doframe();
      }

    } else {
      if (effect_running < MAX_EFFECTS + 1)
        effect_running++;

      totaltime = 0;
    }

  // If the effect is running
  } else {
    // Move all paricles 
    for (int i = 0; i<WATER_DROPLETS ; i++) {
      particles[i].doframe();

      if (particles[i].y < 0)
        particles[i].init();
    }
  }
 
  if (effect_running == MAX_EFFECTS) {
    Mix_FadeOutMusic(3000);
  }

	return 0;
}

void getDt(void)
{
  static Uint32 oldtime, newtime;
  oldtime = newtime;

  while (oldtime == newtime)
    newtime = SDL_GetTicks();

  duration = newtime - oldtime;
}

int MySDL_glTexImage2D(SDL_Surface *surface, int index)
{
  GLint nOfColors = surface->format->BytesPerPixel;
  GLenum texture_format;
  texture_format = GL_BGR;

  glGenTextures(1, &texture[index] );
  glBindTexture( GL_TEXTURE_2D, texture[index] );
  glTexImage2D( GL_TEXTURE_2D, 0, nOfColors, surface->w, surface->h, 0, texture_format, GL_UNSIGNED_BYTE, surface->pixels );
  glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR );
  glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR );

  return 0;
} 

void draw(void)
{
  glClear(GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT);
  glLoadIdentity();



  // Rotate the camera to show the whole fountain
  glTranslatef(0.0f,0.0f, -9.0f);
  glRotatef(20.0f, 1.0f,0.0f,0.0f);

  if (effect_running < 4) {
  glPushMatrix();
    glMatrixMode(GL_TEXTURE);
      glBindTexture(GL_TEXTURE_2D, texture[4]);

    glBegin(GL_QUADS);
      glTexCoord2d(0,0); 
      glVertex3f(-4.0f, -4.0f, -4.5f+1.1*cos(r/5.0f));
      glTexCoord2d(0,1); 
      glVertex3f(-4.0f, +4.0f, -4.5f+1.1*cos(r/5.0f));
      glTexCoord2d(1,1); 
      glVertex3f(+4.0f, +4.0f, -4.5f+1.1*sin(r/5.0f));
      glTexCoord2d(1,0); 
      glVertex3f(+4.0f, -4.0f, -4.5f+1.1*sin(r/5.0f));
    glEnd();

    glMatrixMode(GL_MODELVIEW);
  glPopMatrix();
  }
  else if (effect_running < 5) {
    spora += duration/100.0f;
    if ( spora < 3.141/2.0 ) {

    glPushMatrix();
      glMatrixMode(GL_TEXTURE);  
      glBindTexture(GL_TEXTURE_2D, texture[4]);

    glBegin(GL_QUADS);
      glTexCoord2d(0,0); 
      glVertex3f(-4.0f, -4.0f, -4.5-tan(spora));
      glTexCoord2d(0,1); 
      glVertex3f(-4.0f, +4.0f, -4.5-tan(spora));
      glTexCoord2d(1,1); 
      glVertex3f(+4.0f, +4.0f, -4.5f-tan(spora));
      glTexCoord2d(1,0); 
      glVertex3f(+4.0f, -4.0f, -4.5f-tan(spora));
    glEnd();

    glMatrixMode(GL_MODELVIEW);
  glPopMatrix();
    }
  } 

  // Drops 
  glPushMatrix();
    glMatrixMode(GL_TEXTURE);
      glBindTexture(GL_TEXTURE_2D, texture[2]);

      for (int i = 0; i<WATER_DROPLETS ; i++) 
        particles[i].draw();

    glMatrixMode(GL_MODELVIEW);
  glPopMatrix();



  // Rotate around the fountain
  glRotatef(r,0.0f,0.1f,0.0f);
  glTranslatef(-2.0,0.0,-2.0);

  // Fountain
  glPushMatrix();
    glMatrixMode(GL_TEXTURE);

    glBindTexture(GL_TEXTURE_2D, texture[0]);

    glBegin(GL_QUADS);
      glNormal3f( 0.0f, 0.0f, -1.0f);
      glTexCoord2f(0, 0); glVertex3f( 0.0f, 0.0f, 0.0f);
      glTexCoord2f(0, 1); glVertex3f( 0.0f, 1.0f, 0.0f);
      glTexCoord2f(1, 1); glVertex3f( 4.0f, 1.0f, 0.0f);
      glTexCoord2f(1, 0); glVertex3f( 4.0f, 0.0f, 0.0f);
      
      glNormal3f( 1.0f, 0.0f, 0.0f);
      glTexCoord2f(0, 0); glVertex3f( 4.0f, 0.0f, 0.0f);
      glTexCoord2f(0, 1); glVertex3f( 4.0f, 1.0f, 0.0f);
      glTexCoord2f(1, 1); glVertex3f( 4.0f, 1.0f, 4.0f);
      glTexCoord2f(1, 0); glVertex3f( 4.0f, 0.0f, 4.0f);

      glNormal3f( 0.0f, 0.0f, 1.0f);	
      glTexCoord2f(0, 0); glVertex3f( 4.0f, 0.0f, 4.0f);
      glTexCoord2f(0, 1); glVertex3f( 4.0f, 1.0f, 4.0f);
      glTexCoord2f(1, 1); glVertex3f( 0.0f, 1.0f, 4.0f);
      glTexCoord2f(1, 0); glVertex3f( 0.0f, 0.0f, 4.0f);

      glNormal3f( -1.0f, 0.0f, 0.0f);
      glTexCoord2f(0, 0); glVertex3f( 0.0f, 0.0f, 4.0f);
      glTexCoord2f(0, 1); glVertex3f( 0.0f, 1.0f, 4.0f);
      glTexCoord2f(1, 1); glVertex3f( 0.0f, 1.0f, 0.0f);
      glTexCoord2f(1, 0); glVertex3f( 0.0f, 0.0f, 0.0f);
    glEnd();

    glMatrixMode(GL_MODELVIEW);
  glPopMatrix();

  // Ground
  glTranslatef(2.0,0.0,2.0);

  glPushMatrix();
    glMatrixMode(GL_TEXTURE);

    glBindTexture(GL_TEXTURE_2D, texture[1]);
    glBegin(GL_QUADS);
      glNormal3f(0.0, 1.0, 0.0);
      glTexCoord2f(0.0f, 1.0f);
      glVertex3f(-4.0, 0.0, 0.0);
      glTexCoord2f(0.0f, 0.0f);
      glVertex3f(-4.0, 0.0, 4.0);
      glTexCoord2f(1.0f, 0.0f);
      glVertex3f( 0.0f, 0.0, 4.0f);	
      glTexCoord2f(1.0f, 1.0f);
      glVertex3f( 0.0, 0.0, 0.0);

      glNormal3f(0.0, 1.0, 0.0);
      glTexCoord2f(0.0f, 1.0f);
      glVertex3f(0.0, 0.0, 0.0);
      glTexCoord2f(0.0f, 0.0f);
      glVertex3f(0.0, 0.0, 4.0);
      glTexCoord2f(1.0f, 0.0f);
      glVertex3f( 4.0f, 0.0, 4.0f);
      glTexCoord2f(1.0f, 1.0f);
      glVertex3f( 4.0, 0.0, 0.0);

      glNormal3f(0.0, 1.0, 0.0);
      glTexCoord2f(0.0f, 1.0f);
      glVertex3f(0.0, 0.0, -4.0);
      glTexCoord2f(0.0f, 0.0f);
      glVertex3f(0.0, 0.0, 0.0);
      glTexCoord2f(1.0f, 0.0f);
      glVertex3f( 4.0f, 0.0, 0.0f);
      glTexCoord2f(1.0f, 1.0f);
      glVertex3f( 4.0, 0.0, -4.0);

      glNormal3f(0.0, 1.0, 0.0);
      glTexCoord2f(0.0f, 1.0f);
      glVertex3f(-4.0, 0.0, -4.0);
      glTexCoord2f(0.0f, 0.0f);
      glVertex3f(-4.0, 0.0, 0.0);
      glTexCoord2f(1.0f, 0.0f);
      glVertex3f( 0.0f, 0.0, 0.0f);
      glTexCoord2f(1.0f, 1.0f);
      glVertex3f(0.0, 0.0, -4.0);

    glEnd();

    glMatrixMode(GL_MODELVIEW);
  glPopMatrix();

  // Water
  glTranslatef(2.0,0.5,-2.0);

  glEnable(GL_BLEND);
    glPushMatrix();
      glMatrixMode(GL_TEXTURE);

      glBindTexture(GL_TEXTURE_2D, texture[3]);

      glBegin(GL_QUADS);
        glNormal3f(0.0, 1.0, 0.0);
        glTexCoord2f(0.0f, 1.0f);
        glVertex3f(-4.0, 0.0, 0.0);
        glTexCoord2f(0.0f, 0.0f);
        glVertex3f(-4.0, 0.0, 4.0);
        glTexCoord2f(1.0f, 0.0f);
        glVertex3f( 0.0f, 0.0, 4.0f);
        glTexCoord2f(1.0f, 1.0f);
        glVertex3f( 0.0, 0.0, 0.0);
      glEnd();

      glMatrixMode(GL_MODELVIEW);

    glPopMatrix();
  glDisable(GL_BLEND);

  r+=duration/90.0f;

  SDL_GL_SwapBuffers();
}

int initAudio()
{
  int audio_rate = 22050;
  Uint16 audio_format = AUDIO_S16;
  int audio_channels = 2;
  int audio_buffers = 4096;

  if(Mix_OpenAudio(audio_rate, audio_format, audio_channels, audio_buffers) != 0)
    return 0;

  Mix_QuerySpec(&audio_rate, &audio_format, &audio_channels);

  music = Mix_LoadMUS("fountain3.ogg");

  return 1;
}

int initVideo()
{
  SDL_Surface *screen;

  screen = SDL_SetVideoMode(800, 600, 0, SDL_OPENGL | SDL_FULLSCREEN);
  SDL_ShowCursor(SDL_DISABLE);
	if (screen == NULL) 
		return 0;

  SDL_GL_SetAttribute(SDL_GL_RED_SIZE,    8);
  SDL_GL_SetAttribute(SDL_GL_GREEN_SIZE,  8);
  SDL_GL_SetAttribute(SDL_GL_BLUE_SIZE,   8);
  SDL_GL_SetAttribute(SDL_GL_DEPTH_SIZE,  16);
  SDL_GL_SetAttribute(SDL_GL_DOUBLEBUFFER, 1);

  glShadeModel(GL_SMOOTH);
  glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
  glClearDepth(1.0f);
  glEnable(GL_DEPTH_TEST);
  glDepthFunc(GL_LEQUAL);

  glViewport(0,0,800,600);
  glMatrixMode(GL_PROJECTION);
  glLoadIdentity();
  gluPerspective(45.0f,800.0f/600.0f,1.0f,500.0f);
  glMatrixMode(GL_MODELVIEW);

  glEnable(GL_TEXTURE_2D);
  glEnable(GL_BLEND);


  glColor4f(1.0f,1.0f,1.0f,0.5f);
  glBlendFunc(GL_SRC_ALPHA,GL_ONE);

  return 1;
}

void initLights()
{
  GLfloat ambient[]= { 1.0f, 1.0f, 1.0f, 1.0f }; 
  GLfloat diffuse[]= { 1.0f, 1.0f, 1.0f, 1.0f };	
  GLfloat pos[]= { 2.0f, 3.0f, 2.0f, 1.0f };

  glEnable(GL_LIGHTING);

  glLightfv(GL_LIGHT1, GL_AMBIENT, ambient);	
  glLightfv(GL_LIGHT1, GL_DIFFUSE, diffuse);
  glLightfv(GL_LIGHT1, GL_POSITION, pos);

  glEnable(GL_LIGHT1);
}

int loadTextures()
{
  SDL_Surface* floor = SDL_LoadBMP("floor.bmp");
  SDL_Surface* stone = SDL_LoadBMP("stone.bmp");
  SDL_Surface* drop = SDL_LoadBMP("drop.bmp");
  SDL_Surface* water = SDL_LoadBMP("water.bmp");
  SDL_Surface* title = SDL_LoadBMP("title.bmp");

  MySDL_glTexImage2D(stone, 0);
  MySDL_glTexImage2D(floor, 1);
  MySDL_glTexImage2D(drop, 2);
  MySDL_glTexImage2D(water, 3);
  MySDL_glTexImage2D(title, 4);

  SDL_FreeSurface(floor);
  SDL_FreeSurface(stone);
  SDL_FreeSurface(drop);
  SDL_FreeSurface(water);
  SDL_FreeSurface(title);
}
  
int main(void) 
{
  if (SDL_Init(SDL_INIT_AUDIO | SDL_OPENGL) != 0)
    return 0;

  if (initAudio() == 0)
    return 0;

  if (initVideo() == 0)
    return 0;

  initLights();

  loadTextures();


  effect_running = START_EFFECT;

  for (int i = 0; i<WATER_DROPLETS ; i++) 
    particles[i].init(i);

  Mix_FadeInMusic(music, 0, 1000);

  while (doEvents() == 0 && effect_running < MAX_EFFECTS + 1) {
    getDt();
    draw();
  }

  Mix_HaltMusic();
  Mix_CloseAudio();
  music = NULL;


  glDeleteTextures( 1, &texture[0] );
  glDeleteTextures( 1, &texture[1] );
  glDeleteTextures( 1, &texture[2] );
  glDeleteTextures( 1, &texture[3] );
  glDeleteTextures( 1, &texture[4] );

  SDL_ShowCursor(SDL_ENABLE);
  SDL_Quit();


  return 0;
}
