#version 330 core

uniform mat4 TextureMatrix;
uniform vec2 viewport;
uniform vec2 shadowTexelSize;

uniform sampler2D normal_depth;
uniform sampler2D shadow;

layout (location = 0) out vec4 frag_color;


#include <gbuffer_include.frag>

/*
float rand(in vec2 co)
{
        return 0.5 + (fract(sin(dot(co.xy, vec2(12.9898, 78.233))) * 43758.5453))*0.5;
}
*/

float apply_shadow(in vec4 pos)
{
	const float samples = 8.0;
	const float filterWidth = samples/(1024.0*2.0);
	const float stepSize = 2.0*filterWidth / samples;
	float dist = (pos.z / pos.w);
	float count = 0.0;

	for (float i=-filterWidth; i < filterWidth; i+=stepSize)
	{
		for (float j=-filterWidth; j < filterWidth; j+=stepSize)
		{
#if 1
			vec4 offset = vec4(i*pos.w, j*pos.w, 0.05, 0.0);
			count += float( textureProj(shadow, pos + offset).x > dist );
#else
			vec4 offset = vec4(i*pos.w, j*pos.w, 0.05, 0.0);
			count += textureProj(shadow, pos + offset);
#endif
		}
	}
	return count / (samples*samples);
}


void main()
{
	vec2 uv_pos = gl_FragCoord.xy * viewport;
	vec4 nd = texture2D(normal_depth, uv_pos);
	vec3 pos = calc_position(uv_pos, nd.w);

	vec4 lpos = TextureMatrix * vec4(pos, 1.0);
	float shadow_term = 1.0;
	if ( lpos.z > 0.0 )
	{
		shadow_term = apply_shadow(lpos);
	}

	vec3 shad = vec3(1.0 - (1.0 - shadow_term)*0.25);
	//vec3 shad = vec3(1.0 - (1.0 - shadow_term)*0.85);
	frag_color = vec4(shad, 1.0);
}
