#version 330 core

uniform float time;
uniform sampler2D diffuse;

in vec3 normal;
in vec2 uv;

layout (location = 0) out vec4 frag_color;

void main()
{
	vec4 color = texture(diffuse, uv);

	if ( time < uv.y || color.a < 0.05 ) discard;
	
	float alpha = smoothstep(0.0, 1.0, (time - uv.y)*0.5);

	frag_color.rgb = color.rgb*color.a*alpha*0.5;
	frag_color.a = color.a*alpha;
}
